/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.BLOB;

public class OracleBlobOutputStream
extends OutputStream {
    long lob_offset;
    BLOB blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;

    public OracleBlobOutputStream(BLOB bLOB) throws SQLException {
        this(bLOB, bLOB.getConnection().db_access.getDefaultStreamChunkSize());
    }

    public OracleBlobOutputStream(BLOB bLOB, int n2) throws SQLException {
        this(bLOB, n2, 1L);
    }

    public OracleBlobOutputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (bLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = bLOB;
        this.lob_offset = l2;
        this.buf = new byte[n2];
        this.count = 0;
        this.bufSize = n2;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                if (this.count < this.buf.length) {
                    byte[] byArray = new byte[this.count];
                    System.arraycopy(this.buf, 0, byArray, 0, this.count);
                    this.lob_offset += (long)this.blob.putBytes((int)this.lob_offset, byArray);
                } else {
                    this.lob_offset += (long)this.blob.putBytes((int)this.lob_offset, this.buf);
                }
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void write(int n2) throws IOException {
        this.ensureOpen();
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n2;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        int n4 = n2;
        int n5 = n4 + Math.min(n3, byArray.length - n2);
        while (n4 < n5) {
            int n6 = Math.min(this.bufSize - this.count, n5 - n4);
            System.arraycopy(byArray, n4, this.buf, this.count, n6);
            n4 += n6;
            this.count += n6;
            if (this.count < this.bufSize) continue;
            this.flushBuffer();
        }
    }
}

