/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleBlobInputStream
extends OracleBufferedStream {
    static final boolean DEBUG = false;
    long lob_offset;
    Datum lob;
    long markedByte;
    boolean endOfStream = false;

    public OracleBlobInputStream(BFILE bFILE) throws SQLException {
        this(bFILE, bFILE.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n2) throws SQLException {
        this(bFILE, n2, 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        super(n2);
        if (bFILE == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bFILE;
        this.markedByte = -1L;
        this.lob_offset = l2;
    }

    public OracleBlobInputStream(BLOB bLOB) throws SQLException {
        this(bLOB, bLOB.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n2) throws SQLException {
        this(bLOB, n2, 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (bLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bLOB;
        this.markedByte = -1L;
        this.lob_offset = l2;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public synchronized void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.lob instanceof BLOB ? ((BLOB)this.lob).getBytes(this.lob_offset, this.chunkSize, this.buf) : ((BFILE)this.lob).getBytes(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l2) throws IOException {
        long l3;
        block5: {
            this.ensureOpen();
            l3 = 0L;
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
                l3 += l2;
            } else {
                l3 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long l4 = 0L;
                    l4 = this.lob instanceof BLOB ? ((BLOB)this.lob).length() - this.lob_offset + 1L : ((BFILE)this.lob).length() - this.lob_offset + 1L;
                    if (l4 >= l2 - l3) {
                        this.lob_offset += l2 - l3;
                        l3 += l2 - l3;
                        break block5;
                    }
                    this.lob_offset += l4;
                    l3 += l4;
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
        }
        return l3;
    }
}

