/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public abstract class BaseResultSet
extends OracleResultSet {
    SQLWarning m_warning = null;
    boolean m_autoRefetch = true;
    public boolean close_statement_on_close = false;

    public boolean absolute(int n2) throws SQLException {
        DBError.throwSqlException(75, "absolute");
        return false;
    }

    public void afterLast() throws SQLException {
        DBError.throwSqlException(75, "afterLast");
    }

    public void beforeFirst() throws SQLException {
        DBError.throwSqlException(75, "beforeFirst");
    }

    public void cancelRowUpdates() throws SQLException {
        DBError.throwSqlException(76, "cancelRowUpdates");
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void closeStatementOnClose() {
        this.close_statement_on_close = true;
    }

    public void deleteRow() throws SQLException {
        DBError.throwSqlException(76, "deleteRow");
    }

    public boolean first() throws SQLException {
        DBError.throwSqlException(75, "first");
        return false;
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.m_autoRefetch;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public synchronized String getCursorName() throws SQLException {
        DBError.check_error(23, "getCursorName");
        return null;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public void insertRow() throws SQLException {
        DBError.throwSqlException(76, "insertRow");
    }

    public boolean last() throws SQLException {
        DBError.throwSqlException(75, "last");
        return false;
    }

    public void moveToCurrentRow() throws SQLException {
        DBError.throwSqlException(76, "moveToCurrentRow");
    }

    public void moveToInsertRow() throws SQLException {
        DBError.throwSqlException(76, "moveToInsertRow");
    }

    public boolean previous() throws SQLException {
        DBError.throwSqlException(75, "previous");
        return false;
    }

    public void refreshRow() throws SQLException {
        DBError.check_error(23, null);
    }

    public boolean relative(int n2) throws SQLException {
        DBError.throwSqlException(75, "relative");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setAutoRefetch(boolean bl) throws SQLException {
        this.m_autoRefetch = bl;
    }

    public void setFetchDirection(int n2) throws SQLException {
        if (n2 == 1000) {
            return;
        }
        if (n2 == 1001 || n2 == 1002) {
            DBError.throwSqlException(75, "setFetchDirection(FETCH_REVERSE, FETCH_UNKNOWN)");
        } else {
            DBError.throwSqlException(68, "setFetchDirection");
        }
    }

    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        DBError.throwSqlException(76, "updateARRAY");
    }

    public void updateArray(int n2, Array array) throws SQLException {
        DBError.throwSqlException(76, "updateArray");
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        DBError.throwSqlException(76, "updateAsciiStream");
    }

    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        DBError.throwSqlException(76, "updateBFILE");
    }

    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        DBError.throwSqlException(76, "updateBLOB");
    }

    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        DBError.throwSqlException(76, "updateBfile");
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        DBError.throwSqlException(76, "updateBigDecimal");
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        DBError.throwSqlException(76, "updateBinaryStream");
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        DBError.throwSqlException(76, "updateBlob");
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        DBError.throwSqlException(76, "updateBoolean");
    }

    public void updateByte(int n2, byte by) throws SQLException {
        DBError.throwSqlException(76, "updateByte");
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        DBError.throwSqlException(76, "updateBytes");
    }

    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        DBError.throwSqlException(76, "updateCHAR");
    }

    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        DBError.throwSqlException(76, "updateCLOB");
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        DBError.throwSqlException(76, "updateCharacterStream");
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        DBError.throwSqlException(76, "updateClob");
    }

    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        DBError.throwSqlException(76, "updateCustomDatum");
    }

    public void updateDATE(int n2, DATE dATE) throws SQLException {
        DBError.throwSqlException(76, "updateDATE");
    }

    public void updateDate(int n2, Date date) throws SQLException {
        DBError.throwSqlException(76, "updateDate");
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        DBError.throwSqlException(76, "updateDouble");
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        DBError.throwSqlException(76, "updateFloat");
    }

    public void updateInt(int n2, int n3) throws SQLException {
        DBError.throwSqlException(76, "updateInt");
    }

    public void updateLong(int n2, long l2) throws SQLException {
        DBError.throwSqlException(76, "updateLong");
    }

    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        DBError.throwSqlException(76, "updateNUMBER");
    }

    public void updateNull(int n2) throws SQLException {
        DBError.throwSqlException(76, "updateNull");
    }

    public void updateOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        DBError.throwSqlException(76, "updateOPAQUE");
    }

    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        DBError.throwSqlException(76, "updateORAData");
    }

    public void updateObject(int n2, Object object) throws SQLException {
        DBError.throwSqlException(76, "updateObject");
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        DBError.throwSqlException(76, "updateObject");
    }

    public void updateOracleObject(int n2, Datum datum) throws SQLException {
        DBError.throwSqlException(76, "updateOracleObject");
    }

    public void updateRAW(int n2, RAW rAW) throws SQLException {
        DBError.throwSqlException(76, "updateRAW");
    }

    public void updateREF(int n2, REF rEF) throws SQLException {
        DBError.throwSqlException(76, "updateREF");
    }

    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        DBError.throwSqlException(76, "updateROWID");
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        DBError.throwSqlException(76, "updateRef");
    }

    public void updateRow() throws SQLException {
        DBError.throwSqlException(76, "updateRow");
    }

    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        DBError.throwSqlException(76, "updateSTRUCT");
    }

    public void updateShort(int n2, short s2) throws SQLException {
        DBError.throwSqlException(76, "updateShort");
    }

    public void updateString(int n2, String string) throws SQLException {
        DBError.throwSqlException(76, "updateString");
    }

    public void updateTime(int n2, Time time) throws SQLException {
        DBError.throwSqlException(76, "updateTime");
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        DBError.throwSqlException(76, "updateTimestamp");
    }
}

