/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.jdbc.dbaccess.Message;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.util.SQLStateMapping;
import oracle.jdbc.util.SQLStateRange;

public class DBError {
    private static boolean m_loadedMessages = false;
    private static Message m_message = null;
    private static String m_msgClassName = "oracle.jdbc.dbaccess.Message11";
    static final SQLStateMapping[] mappings = new SQLStateMapping[]{new SQLStateMapping(0, "00000"), new SQLStateMapping(1, "23000"), new SQLStateMapping(22, "42000"), new SQLStateMapping(100, "02000"), new SQLStateMapping(251, "42000"), new SQLStateMapping(1025, "22023"), new SQLStateMapping(1031, "42000"), new SQLStateMapping(1095, "02000"), new SQLStateMapping(1402, "44000"), new SQLStateMapping(1403, "02000"), new SQLStateMapping(1405, "22002"), new SQLStateMapping(1406, "22001"), new SQLStateMapping(1410, "24000"), new SQLStateMapping(1411, "22022"), new SQLStateMapping(1422, "21000"), new SQLStateMapping(1424, "22025"), new SQLStateMapping(1425, "22019"), new SQLStateMapping(1426, "22003"), new SQLStateMapping(1427, "21000"), new SQLStateMapping(1438, "22003"), new SQLStateMapping(1455, "22003"), new SQLStateMapping(1457, "22003"), new SQLStateMapping(1476, "22012"), new SQLStateMapping(1488, "22023"), new SQLStateMapping(8006, "24000")};
    static final SQLStateRange[] ranges = new SQLStateRange[]{new SQLStateRange(17, 21, "61000"), new SQLStateRange(23, 35, "61000"), new SQLStateRange(49, 68, "61000"), new SQLStateRange(100, 120, "62000"), new SQLStateRange(149, 159, "63000"), new SQLStateRange(199, 369, "64000"), new SQLStateRange(369, 429, "60000"), new SQLStateRange(429, 439, "67000"), new SQLStateRange(439, 569, "62000"), new SQLStateRange(569, 599, "69000"), new SQLStateRange(599, 899, "60000"), new SQLStateRange(899, 999, "42000"), new SQLStateRange(999, 1099, "72000"), new SQLStateRange(1000, 1003, "24000"), new SQLStateRange(1099, 1250, "64000"), new SQLStateRange(1399, 1401, "23000"), new SQLStateRange(1401, 1478, "72000"), new SQLStateRange(1478, 1480, "22024"), new SQLStateRange(1480, 1489, "72000"), new SQLStateRange(1489, 1493, "42000"), new SQLStateRange(1493, 1499, "72000"), new SQLStateRange(1499, 1699, "72000"), new SQLStateRange(1699, 1799, "42000"), new SQLStateRange(1799, 1899, "22008"), new SQLStateRange(1899, 2099, "42000"), new SQLStateRange(2090, 2092, "40000"), new SQLStateRange(2139, 2289, "42000"), new SQLStateRange(2289, 2299, "23000"), new SQLStateRange(2375, 2399, "61000"), new SQLStateRange(2399, 2419, "72000"), new SQLStateRange(2419, 2424, "42000"), new SQLStateRange(2424, 2449, "72000"), new SQLStateRange(2449, 2499, "42000"), new SQLStateRange(2699, 2899, "63000"), new SQLStateRange(2999, 3099, "0A000"), new SQLStateRange(3099, 3199, "63000"), new SQLStateRange(3275, 3299, "42000"), new SQLStateRange(3999, 4019, "22023"), new SQLStateRange(4019, 4039, "61000"), new SQLStateRange(4039, 4059, "42000"), new SQLStateRange(4059, 4069, "72000"), new SQLStateRange(4069, 4099, "42000"), new SQLStateRange(5999, 6149, "66000"), new SQLStateRange(6199, 6249, "63000"), new SQLStateRange(6249, 6429, "66000"), new SQLStateRange(6429, 6449, "60000"), new SQLStateRange(6499, 6599, "65000"), new SQLStateRange(6510, 6511, "24000"), new SQLStateRange(6599, 6999, "66000"), new SQLStateRange(6999, 7199, "69000"), new SQLStateRange(7199, 7999, "60000"), new SQLStateRange(7999, 8190, "72000"), new SQLStateRange(9699, 9999, "60000"), new SQLStateRange(9999, 10999, "90000"), new SQLStateRange(11999, 12019, "72000"), new SQLStateRange(12299, 12499, "72000"), new SQLStateRange(12699, 21999, "72000"), new SQLStateRange(12099, 12299, "66000"), new SQLStateRange(12499, 12599, "66000")};
    public static final int JDBC_ERROR_BASE = 17000;
    public static final int JDBC_MAX_ERRORS = 500;
    public static final int EOJ_SUCCESS = 0;
    public static final int EOJ_ERROR = 1;
    public static final int EOJ_IOEXCEPTION = 2;
    public static final int EOJ_INVALID_COLUMN_INDEX = 3;
    public static final int EOJ_INVALID_COLUMN_TYPE = 4;
    public static final int EOJ_UNSUPPORTED_COLUMN_TYPE = 5;
    public static final int EOJ_INVALID_COLUMN_NAME = 6;
    public static final int EOJ_INVALID_DYNAMIC_COLUMN = 7;
    public static final int EOJ_CLOSED_CONNECTION = 8;
    public static final int EOJ_CLOSED_STATEMENT = 9;
    public static final int EOJ_CLOSED_RESULTSET = 10;
    public static final int EOJ_EXHAUSTED_RESULTSET = 11;
    public static final int EOJ_TYPE_CONFLICT = 12;
    public static final int EOJ_WAS_NULL = 13;
    public static final int EOJ_RESULTSET_BEFORE_FIRST_ROW = 14;
    public static final int EOJ_STATEMENT_WAS_CANCELLED = 15;
    public static final int EOJ_STATEMENT_TIMED_OUT = 16;
    public static final int EOJ_CURSOR_ALREADY_INITIALIZED = 17;
    public static final int EOJ_INVALID_CURSOR = 18;
    public static final int EOJ_CAN_ONLY_DESCRIBE_A_QUERY = 19;
    public static final int EOJ_INVALID_ROW_PREFETCH = 20;
    public static final int EOJ_MISSING_DEFINES = 21;
    public static final int EOJ_MISSING_DEFINES_AT_INDEX = 22;
    public static final int EOJ_UNSUPPORTED_FEATURE = 23;
    public static final int EOJ_NO_DATA_READ = 24;
    public static final int EOJ_IS_DEFINES_NULL_ERROR = 25;
    public static final int EOJ_NUMERIC_OVERFLOW = 26;
    public static final int EOJ_STREAM_CLOSED = 27;
    public static final int EOJ_NO_NEW_DEFINE_IF_RESULT_SET_NOT_CLOSED = 28;
    public static final int EOJ_READ_ONLY = 29;
    public static final int EOJ_INVALID_TRANSLEVEL = 30;
    public static final int EOJ_AUTO_CLOSE_ONLY = 31;
    public static final int EOJ_ROW_PREFETCH_NOT_ZERO = 32;
    public static final int EOJ_MALFORMED_SQL92 = 33;
    public static final int EOJ_NON_SUPPORTED_SQL92_TOKEN = 34;
    public static final int EOJ_NON_SUPPORTED_CHAR_SET = 35;
    public static final int EOJ_ORACLE_NUMBER_EXCEPTION = 36;
    public static final int EOJ_FAIL_CONVERSION_UTF8_TO_UCS2 = 37;
    public static final int EOJ_CONVERSION_BYTE_ARRAY_ERROR = 38;
    public static final int EOJ_CONVERSION_CHAR_ARRAY_ERROR = 39;
    public static final int EOJ_SUB_SUB_PROTOCOL_ERROR = 40;
    public static final int EOJ_INVALID_IN_OUT_BINDS = 41;
    public static final int EOJ_INVALID_BATCH_VALUE = 42;
    public static final int EOJ_INVALID_STREAM_SIZE = 43;
    public static final int EOJ_DATASET_ITEMS_NOT_ALLOCATED = 44;
    public static final int EOJ_BEYOND_BINDS_BATCH = 45;
    public static final int EOJ_INVALID_RANK = 46;
    public static final int EOJ_TDS_FORMAT_ERROR = 47;
    public static final int EOJ_UNDEFINED_TYPE = 48;
    public static final int EOJ_INCONSISTENT_ADT = 49;
    public static final int EOJ_NOSUCHELEMENT = 50;
    public static final int EOJ_NOT_AN_OBJECT_TYPE = 51;
    public static final int EOJ_INVALID_REF = 52;
    public static final int EOJ_INVALID_SIZE = 53;
    public static final int EOJ_INVALID_LOB_LOCATOR = 54;
    public static final int EOJ_FAIL_CONVERSION_CHARACTER = 55;
    public static final int EOJ_UNSUPPORTED_CHARSET = 56;
    public static final int EOJ_CLOSED_LOB = 57;
    public static final int EOJ_INVALID_NLS_RATIO = 58;
    public static final int EOJ_CONVERSION_JAVA_ERROR = 59;
    public static final int EOJ_FAIL_CREATE_DESC = 60;
    public static final int EOJ_NO_DESCRIPTOR = 61;
    public static final int EOJ_INVALID_REF_CURSOR = 62;
    public static final int EOJ_NOT_IN_A_TRANSACTION = 63;
    public static final int EOJ_DATABASE_IS_NULL = 64;
    public static final int EOJ_CONV_WAS_NULL = 65;
    public static final int EOJ_ACCESS_SPECIFIC_IMPL = 66;
    public static final int EOJ_INVALID_URL = 67;
    public static final int EOJ_INVALID_ARGUMENTS = 68;
    public static final int EOJ_USE_XA_EXPLICIT = 69;
    public static final int EOJ_INVALID_DATASIZE_LENGTH = 70;
    public static final int EOJ_EXCEEDED_VARRAY_LENGTH = 71;
    public static final int EOJ_VALUE_TOO_BIG = 72;
    public static final int EOJ_LOGICAL_CONN_CLOSED = 73;
    public static final int EOJ_INVALID_NAME_PATTERN = 74;
    public static final int EOJ_INVALID_FORWARD_RSET_OP = 75;
    public static final int EOJ_INVALID_READONLY_RSET_OP = 76;
    public static final int EOJ_FAIL_REF_SETVALUE = 77;
    public static final int EOJ_CONNECTIONS_ALREADY_EXIST = 78;
    public static final int EOJ_USER_CREDENTIALS_FAIL = 79;
    public static final int EOJ_INVALID_BATCH_COMMAND = 80;
    public static final int EOJ_BATCH_ERROR = 81;
    public static final int EOJ_NO_CURRENT_ROW = 82;
    public static final int EOJ_NOT_ON_INSERT_ROW = 83;
    public static final int EOJ_ON_INSERT_ROW = 84;
    public static final int EOJ_UPDATE_CONFLICTS = 85;
    public static final int EOJ_NULL_INSERET_ROW_VALUE = 86;
    public static final int WARN_IGNORE_FETCH_DIRECTION = 87;
    public static final int EOJ_UNSUPPORTED_SYNTAX = 88;
    public static final int EOJ_INTERNAL_ERROR = 89;
    public static final int EOJ_OPER_NOT_ALLOWED = 90;
    public static final int WARN_ALTERNATE_RSET_TYPE = 91;
    public static final int EOJ_NO_JDBC_AT_END_OF_CALL = 92;
    public static final int WARN_SUCCESS_WITH_INFO = 93;
    public static final int EOJ_VERSION_MISMATCH = 94;
    public static final int EOJ_ENABLE_STMT_CACHE = 95;
    public static final int EOJ_STMT_CACHE_POOLC = 96;
    public static final int EOJ_INVALID_ELEMENT_TYPE = 97;
    public static final int EOJ_INVALID_EMPTYLOB_OP = 98;
    public static final int EOJ_INVALID_INDEXTABLE_ARRAY_LENGTH = 99;
    public static final int EOJ_INVALID_JAVA_OBJECT = 100;
    public static final int EOJ_CONNECTIONPOOL_INVALID_PROPERTIES = 101;
    public static final int EOJ_BFILE_IS_READONLY = 102;
    public static final int EOJ_WRONG_CONNECTION_TYPE_FOR_METHOD = 103;
    public static final int EOJ_NULL_SQL_STRING = 104;
    public static final int EOJ_SESSION_TZ_NOT_SET = 105;
    public static final int EOJ_CONNECTIONPOOL_INVALID_CONFIG = 106;
    public static final int EOJ_CONNECTIONPOOL_INVALID_PROXY_TYPE = 107;
    public static final int EOJ_HETEROXA_GET_UTF_OPENSTR = 200;
    public static final int EOJ_HETEROXA_GET_UTF_CLOSESTR = 201;
    public static final int EOJ_HETEROXA_GET_UTF_RMNAME = 202;
    public static final int EOJ_HETEROXA_JHANDLE_SIZE = 203;
    public static final int EOJ_HETEROXA_ARRAY_TOO_SHORT = 204;
    public static final int EOJ_HETEROXA_SVCCTX_HANDLE = 205;
    public static final int EOJ_HETEROXA_ENV_HANDLE = 206;
    public static final int EOJ_HETEROXA_NULL_TNSENTRY = 207;
    public static final int EOJ_HETEROXA_OPEN_RMERR = 213;
    public static final int EOJ_HETEROXA_OPEN_INVAL = 215;
    public static final int EOJ_HETEROXA_OPEN_PROTO = 216;
    public static final int EOJ_HETEROXA_CLOSE_RMERR = 233;
    public static final int EOJ_HETEROXA_CLOSE_INVAL = 235;
    public static final int EOJ_HETEROXA_CLOSE_PROTO = 236;
    public static final int TTC_ERR_BASE = 400;
    public static final int TTC0000 = 401;
    public static final int TTC0001 = 402;
    public static final int TTC0002 = 403;
    public static final int TTC0003 = 404;
    public static final int TTC0004 = 405;
    public static final int TTC0005 = 406;
    public static final int TTC0100 = 407;
    public static final int TTC0101 = 408;
    public static final int TTC0102 = 409;
    public static final int TTC0103 = 410;
    public static final int TTC0104 = 411;
    public static final int TTC0105 = 412;
    public static final int TTC0106 = 413;
    public static final int TTC0107 = 414;
    public static final int TTC0108 = 415;
    public static final int TTC0109 = 416;
    public static final int TTC0110 = 417;
    public static final int TTC0111 = 418;
    public static final int TTC0112 = 419;
    public static final int TTC0113 = 420;
    public static final int TTC0114 = 421;
    public static final int TTC0115 = 422;
    public static final int TTC0116 = 423;
    public static final int TTC0117 = 424;
    public static final int TTC0118 = 425;
    public static final int TTC0119 = 426;
    public static final int TTC0120 = 427;
    public static final int TTC0200 = 428;
    public static final int TTC0201 = 429;
    public static final int TTC0202 = 430;
    public static final int TTC0203 = 431;
    public static final int TTC0204 = 432;
    public static final int TTC0205 = 433;
    public static final int TTC0206 = 434;
    public static final int TTC0207 = 435;
    public static final int TTC0208 = 436;
    public static final int TTC0209 = 437;
    public static final int TTC0210 = 438;
    public static final int TTC0211 = 439;
    public static final int TTC0212 = 440;
    public static final int TTC0213 = 441;
    public static final int TTC0214 = 442;
    public static final int TTC0216 = 443;
    public static final int TTC0217 = 444;

    public static String ErrorToSQLState(int n2) {
        int n3 = 0;
        while (n3 < mappings.length) {
            if (n2 == DBError.mappings[n3].err) {
                return DBError.mappings[n3].SQLState;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < ranges.length) {
            if (n2 > DBError.ranges[n4].low && n2 <= DBError.ranges[n4].high) {
                return DBError.ranges[n4].SQLState;
            }
            ++n4;
        }
        return "99999";
    }

    public static void SQLToIOException(SQLException sQLException) throws IOException {
        throw new IOException(sQLException.getMessage());
    }

    public static void addSqlException(SQLException sQLException, String string, String string2, int n2) {
        SQLException sQLException2 = new SQLException(string, string2, n2);
        sQLException.setNextException(sQLException2);
    }

    public static SQLWarning addSqlWarning(SQLWarning sQLWarning, int n2) throws SQLException {
        return DBError.addSqlWarning(sQLWarning, n2, null);
    }

    public static SQLWarning addSqlWarning(SQLWarning sQLWarning, int n2, Object object) throws SQLException {
        if (n2 == 0 || n2 == 13) {
            return sQLWarning;
        }
        String string = DBError.findMessage(n2, object);
        int n3 = DBError.getVendorCode(n2);
        return DBError.addSqlWarning(sQLWarning, "Warning: " + string, null, n3);
    }

    public static SQLWarning addSqlWarning(SQLWarning sQLWarning, String string, String string2, int n2) throws SQLException {
        SQLWarning sQLWarning2 = new SQLWarning(string, string2, n2);
        if (sQLWarning != null) {
            sQLWarning.setNextWarning(sQLWarning2);
            return sQLWarning;
        }
        return sQLWarning2;
    }

    public static void check_error(int n2) throws SQLException {
        DBError.throwSqlException(n2, null);
    }

    public static void check_error(int n2, Object object) throws SQLException {
        DBError.throwSqlException(n2, object);
    }

    public static void check_error(IOException iOException) throws SQLException {
        DBError.throwSqlException(iOException);
    }

    static String findMessage(int n2, Object object) {
        String string = null;
        String string2 = null;
        if (!m_loadedMessages) {
            try {
                try {
                    m_message = (Message)Class.forName(m_msgClassName).newInstance();
                    m_loadedMessages = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        string = DBError.getMsgKey(n2);
        string2 = m_message == null ? (object == null ? String.valueOf(string) + ": (no message for error)" : String.valueOf(string) + ": (no message for error) " + object) : m_message.msg(string, object);
        return string2;
    }

    static String getMsgKey(int n2) {
        int n3 = DBError.getVendorCode(n2);
        String string = "ORA-" + Integer.toString(n3);
        return string;
    }

    static int getVendorCode(int n2) {
        return 17000 + n2;
    }

    public static SQLException newSqlException(int n2) {
        return DBError.newSqlException(n2, null);
    }

    public static SQLException newSqlException(int n2, Object object) {
        String string = DBError.findMessage(n2, object);
        int n3 = DBError.getVendorCode(n2);
        return new SQLException(string, null, n3);
    }

    public static SQLWarning newSqlWarning(int n2) throws SQLException {
        return DBError.addSqlWarning(null, n2);
    }

    public static SQLWarning newSqlWarning(int n2, Object object) throws SQLException {
        return DBError.addSqlWarning(null, n2, object);
    }

    public static SQLWarning newSqlWarning(String string, String string2, int n2) throws SQLException {
        return DBError.addSqlWarning(null, string, string2, n2);
    }

    public static void printSqlException(SQLException sQLException) {
        OracleLog.print(1, 4, 32, "SQLException:");
        OracleLog.print(1, 4, 32, "  message  = \"" + sQLException.getMessage() + "\"");
        OracleLog.print(1, 4, 32, "  SQLState = \"" + sQLException.getSQLState() + "\"");
        OracleLog.print(1, 4, 32, "  errCode  = " + sQLException.getErrorCode());
    }

    public static void test() {
        IOException iOException;
        OracleLog.config(0, 1, 32);
        OracleLog.setSubmodMask(1, 4);
        OracleLog.setLogStream(System.out);
        try {
            DBError.throwSqlException("exception_message_1", "sql_state_1", 25);
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
        try {
            DBError.throwSqlException(412, new String("object_string"));
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
        try {
            DBError.throwSqlException(6);
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
        try {
            DBError.throwSqlException(999);
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
        try {
            DBError.throwSqlException(13);
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
        try {
            iOException = new IOException("ORA-00601: cleanup lock conflict");
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
        try {
            iOException = new IOException("some unknown io exception");
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            DBError.printSqlException(sQLException);
        }
    }

    public static void throwBatchUpdateException(int n2, int n3, int[] nArray) throws BatchUpdateException {
        DBError.throwBatchUpdateException(n2, null, n3, nArray);
    }

    public static void throwBatchUpdateException(int n2, Object object, int n3, int[] nArray) throws BatchUpdateException {
        if (n2 == 0) {
            return;
        }
        String string = DBError.findMessage(n2, object);
        int n4 = DBError.getVendorCode(n2);
        DBError.throwBatchUpdateException(string, null, n4, n3, nArray);
    }

    public static void throwBatchUpdateException(String string, String string2, int n2, int n3, int[] nArray) throws BatchUpdateException {
        int n4 = 0;
        int[] nArray2 = null;
        if (n3 < 0) {
            n3 = 0;
        }
        if (nArray == null) {
            nArray2 = new int[]{};
        } else if (n3 >= nArray.length) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n3];
            n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
        }
        throw new BatchUpdateException(string, string2, n2, nArray2);
    }

    public static void throwBatchUpdateException(SQLException sQLException, int n2, int[] nArray) throws BatchUpdateException {
        int n3 = 0;
        int[] nArray2 = null;
        if (n2 < 0) {
            n2 = 0;
        }
        if (nArray == null) {
            nArray2 = new int[]{};
        } else if (n2 >= nArray.length) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n2];
            n3 = 0;
            while (n3 < n2) {
                nArray2[n3] = nArray[n3];
                ++n3;
            }
        }
        BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
        batchUpdateException.setNextException(sQLException);
        throw batchUpdateException;
    }

    public static void throwSqlException(int n2) throws SQLException {
        DBError.throwSqlException(n2, null);
    }

    public static void throwSqlException(int n2, Object object) throws SQLException {
        if (n2 == 0 || n2 == 13) {
            return;
        }
        String string = DBError.findMessage(n2, object);
        int n3 = DBError.getVendorCode(n2);
        DBError.throwSqlException(string, null, n3);
    }

    public static void throwSqlException(IOException iOException) throws SQLException {
        int n2;
        String string = iOException.getMessage();
        int n3 = 0;
        int n4 = string.indexOf("ORA-");
        if (n4 != -1 && (n2 = string.indexOf(":")) != -1) {
            n4 += 4;
            try {
                n3 = Integer.parseInt(string.substring(n4, n2));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            DBError.throwSqlException(2, string);
        }
        DBError.throwSqlException(string, null, n3);
    }

    public static void throwSqlException(String string, String string2, int n2) throws SQLException {
        throw new SQLException(string, string2, n2);
    }

    public static void throwSqlException(SQLException sQLException, int n2, Object object) throws SQLException {
        if (n2 == 0 || n2 == 13) {
            return;
        }
        String string = DBError.findMessage(n2, object);
        int n3 = DBError.getVendorCode(n2);
        SQLException sQLException2 = new SQLException(string, null, n3);
        sQLException2.setNextException(sQLException);
        throw sQLException2;
    }
}

