/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import oracle.sql.ConverterArchive;

public class JNLS {
    private static String[] m_allLanguage = null;
    private static String[] m_allTerritory = null;
    private static String[] m_allCharset = null;
    private static String[] m_asciiCharset = null;
    private static String[] m_ebcdicCharset = null;
    private static String[] m_fixedCharset = null;
    private static String[] m_nationalCharset = null;
    private static String[] m_storageCharset = null;
    private static Hashtable m_idToCharset = null;
    private static Hashtable m_charsetToID = null;
    private static Hashtable m_defTerritory = null;
    private static Hashtable m_defCharset = null;
    private static Hashtable m_langGroup = null;
    private static Hashtable m_commonCharsetsUnix = null;
    private static Hashtable m_commonCharsetsWin = null;
    private static Hashtable m_commonCharsetsEbc = null;
    private static Hashtable m_langToID = null;
    private static Hashtable m_langDir = null;
    private static String BOOTFILE = "/oracle/gss/util/data/lx0boot.glb";
    private static String CUSTOMBOOTFILE = "/oracle/gss/util/data/lx1boot.glb";

    public static String[] getAllCharset() {
        if (m_allCharset == null) {
            m_allCharset = new String[]{"US7ASCII", "WE8DEC", "WE8HP", "US8PC437", "WE8EBCDIC37", "WE8EBCDIC500", "WE8EBCDIC1140", "WE8EBCDIC285", "WE8EBCDIC1146", "WE8PC850", "D7DEC", "F7DEC", "S7DEC", "E7DEC", "SF7ASCII", "NDK7DEC", "I7DEC", "NL7DEC", "CH7DEC", "YUG7ASCII", "SF7DEC", "TR7DEC", "IW7IS960", "IN8ISCII", "WE8EBCDIC1148", "WE8PC858", "WE8ISO8859P1", "EE8ISO8859P2", "SE8ISO8859P3", "NEE8ISO8859P4", "CL8ISO8859P5", "AR8ISO8859P6", "EL8ISO8859P7", "IW8ISO8859P8", "WE8ISO8859P9", "NE8ISO8859P10", "TH8TISASCII", "TH8TISEBCDIC", "BN8BSCII", "VN8VN3", "VN8MSWIN1258", "WE8ISO8859P15", "WE8NEXTSTEP", "AR8ASMO708PLUS", "AR8EBCDICX", "AR8XBASIC", "EL8DEC", "TR8DEC", "WE8EBCDIC37C", "WE8EBCDIC500C", "IW8EBCDIC424", "TR8EBCDIC1026", "WE8EBCDIC871", "WE8EBCDIC284", "WE8EBCDIC1047", "WE8EBCDIC1140C", "WE8EBCDIC1145", "WE8EBCDIC1148C", "EEC8EUROASCI", "EEC8EUROPA3", "LA8PASSPORT", "BG8PC437S", "EE8PC852", "RU8PC866", "RU8BESTA", "IW8PC1507", "RU8PC855", "TR8PC857", "CL8MACCYRILLIC", "CL8MACCYRILLICS", "WE8PC860", "IS8PC861", "EE8MACCES", "EE8MACCROATIANS", "TR8MACTURKISHS", "IS8MACICELANDICS", "EL8MACGREEKS", "IW8MACHEBREWS", "EE8MSWIN1250", "CL8MSWIN1251", "ET8MSWIN923", "BG8MSWIN", "EL8MSWIN1253", "IW8MSWIN1255", "LT8MSWIN921", "TR8MSWIN1254", "WE8MSWIN1252", "BLT8MSWIN1257", "D8EBCDIC273", "I8EBCDIC280", "DK8EBCDIC277", "S8EBCDIC278", "EE8EBCDIC870", "CL8EBCDIC1025", "F8EBCDIC297", "IW8EBCDIC1086", "CL8EBCDIC1025X", "D8EBCDIC1141", "N8PC865", "BLT8CP921", "LV8PC1117", "LV8PC8LR", "BLT8EBCDIC1112", "LV8RST104090", "CL8KOI8R", "BLT8PC775", "DK8EBCDIC1142", "S8EBCDIC1143", "I8EBCDIC1144", "F7SIEMENS9780X", "E7SIEMENS9780X", "S7SIEMENS9780X", "DK7SIEMENS9780X", "N7SIEMENS9780X", "I7SIEMENS9780X", "D7SIEMENS9780X", "F8EBCDIC1147", "WE8GCOS7", "EL8GCOS7", "US8BS2000", "D8BS2000", "F8BS2000", "E8BS2000", "DK8BS2000", "S8BS2000", "WE8BS2000", "CL8BS2000", "WE8BS2000L5", "WE8DG", "WE8NCR4970", "WE8ROMAN8", "EE8MACCE", "EE8MACCROATIAN", "TR8MACTURKISH", "IS8MACICELANDIC", "EL8MACGREEK", "IW8MACHEBREW", "US8ICL", "WE8ICL", "WE8ISOICLUK", "EE8EBCDIC870C", "EL8EBCDIC875S", "TR8EBCDIC1026S", "BLT8EBCDIC1112S", "IW8EBCDIC424S", "EE8EBCDIC870S", "CL8EBCDIC1025S", "TH8TISEBCDICS", "AR8EBCDIC420S", "CL8EBCDIC1025C", "WE8MACROMAN8", "WE8MACROMAN8S", "TH8MACTHAI", "TH8MACTHAIS", "HU8CWI2", "EL8PC437S", "EL8EBCDIC875", "EL8PC737", "LT8PC772", "LT8PC774", "EL8PC869", "EL8PC851", "CDN8PC863", "HU8ABMOD", "AR8ASMO8X", "AR8NAFITHA711T", "AR8SAKHR707T", "AR8MUSSAD768T", "AR8ADOS710T", "AR8ADOS720T", "AR8APTEC715T", "AR8NAFITHA721T", "AR8HPARABIC8T", "AR8NAFITHA711", "AR8SAKHR707", "AR8MUSSAD768", "AR8ADOS710", "AR8ADOS720", "AR8APTEC715", "AR8MSWIN1256", "AR8MSAWIN", "AR8NAFITHA721", "AR8SAKHR706", "AR8ARABICMAC", "AR8ARABICMACS", "AR8ARABICMACT", "LA8ISO6937", "WE8DECTST", "JA16VMS", "JA16EUC", "JA16EUCYEN", "JA16SJIS", "JA16DBCS", "JA16SJISYEN", "JA16EBCDIC930", "JA16MACSJIS", "KO16KSC5601", "KO16DBCS", "KO16KSCCS", "KO16MSWIN949", "ZHS16CGB231280", "ZHS16MACCGB231280", "ZHS16GBK", "ZHS16DBCS", "ZHT32EUC", "ZHT32SOPS", "ZHT16DBT", "ZHT32TRIS", "ZHT16DBCS", "ZHT16BIG5", "ZHT16CCDC", "ZHT16MSWIN950", "ZHT16HKSCS", "AL24UTFFSS", "UTF8", "AL32UTF8", "UTFE", "WE16DECTST2", "WE16DECTST", "KO16TSTSET", "JA16TSTSET2", "JA16TSTSET", "US16TSTFIXED", "JA16EUCFIXED", "JA16SJISFIXED", "JA16DBCSFIXED", "KO16KSC5601FIXED", "KO16DBCSFIXED", "ZHS16CGB231280FIXED", "ZHS16GBKFIXED", "ZHS16DBCSFIXED", "ZHT32EUCFIXED", "ZHT32TRISFIXED", "ZHT16DBCSFIXED", "ZHT16BIG5FIXED", "AL16UTF16", "ZHS32GB18030", "HZ-GB-2312", "ISO2022-KR", "ISO2022-CN", "ISO2022-JP", "BLT8ISO8859P13", "CEL8ISO8859P14", "CL8ISOIR111", "CL8KOI8U", "WE8BS2000E", "EE8BS2000", "CE8BS2000", "CL8EBCDIC1025R", "EL8EBCDIC875R", "WE8EBCDIC1047E", "WE8EBCDIC924"};
        }
        return m_allCharset;
    }

    public static String[] getAllLanguage() {
        if (m_allLanguage == null) {
            m_allLanguage = new String[]{"AMERICAN", "GERMAN", "FRENCH", "CANADIAN FRENCH", "SPANISH", "ITALIAN", "DUTCH", "SWEDISH", "NORWEGIAN", "DANISH", "FINNISH", "ICELANDIC", "GREEK", "PORTUGUESE", "TURKISH", "BRAZILIAN PORTUGUESE", "MEXICAN SPANISH", "RUSSIAN", "POLISH", "HUNGARIAN", "CZECH", "LITHUANIAN", "SLOVAK", "CATALAN", "BULGARIAN", "ROMANIAN", "SLOVENIAN", "HEBREW", "EGYPTIAN", "CROATIAN", "ARABIC", "THAI", "JAPANESE", "KOREAN", "SIMPLIFIED CHINESE", "TRADITIONAL CHINESE", "ENGLISH", "LATIN AMERICAN SPANISH", "UKRAINIAN", "ESTONIAN", "GERMAN DIN", "MALAY", "VIETNAMESE", "BENGALI", "LATVIAN", "INDONESIAN", "HINDI", "TAMIL", "KANNADA", "TELUGU", "ORIYA", "MALAYALAM", "ASSAMESE", "GUJARATI", "MARATHI", "PUNJABI", "BANGLA", "NUMERIC DATE LANGUAGE"};
        }
        return m_allLanguage;
    }

    public static String[] getAllTerritory() {
        if (m_allTerritory == null) {
            m_allTerritory = new String[]{"AMERICA", "UNITED KINGDOM", "GERMANY", "FRANCE", "CANADA", "SPAIN", "ITALY", "THE NETHERLANDS", "SWEDEN", "NORWAY", "DENMARK", "FINLAND", "ICELAND", "GREECE", "PORTUGAL", "TURKEY", "BRAZIL", "MEXICO", "CIS", "CROATIA", "POLAND", "HUNGARY", "CZECHOSLOVAKIA", "LITHUANIA", "ISRAEL", "BULGARIA", "ALGERIA", "BAHRAIN", "CATALONIA", "EGYPT", "IRAQ", "JORDAN", "KUWAIT", "LEBANON", "LIBYA", "MOROCCO", "MAURITANIA", "OMAN", "QATAR", "ROMANIA", "SAUDI ARABIA", "SOMALIA", "SYRIA", "DJIBOUTI", "SLOVENIA", "TUNISIA", "YEMEN", "SUDAN", "SWITZERLAND", "AUSTRIA", "UNITED ARAB EMIRATES", "THAILAND", "CHINA", "HONG KONG", "JAPAN", "KOREA", "TAIWAN", "CZECH REPUBLIC", "SLOVAKIA", "UKRAINE", "ESTONIA", "MALAYSIA", "BANGLADESH", "LATVIA", "VIETNAM", "INDONESIA", "CYPRUS", "AUSTRALIA", "KAZAKHSTAN", "UZBEKISTAN", "SINGAPORE", "SOUTH AFRICA", "IRELAND", "BELGIUM", "LUXEMBOURG", "NEW ZEALAND", "INDIA", "CHILE", "COLOMBIA", "COSTA RICA", "EL SALVADOR", "GUATEMALA", "NICARAGUA", "PANAMA", "PERU", "PUERTO RICO", "VENEZUELA", "YUGOSLAVIA", "MACEDONIA"};
        }
        return m_allTerritory;
    }

    public static String[] getAsciiCharset() {
        if (m_asciiCharset == null) {
            m_asciiCharset = new String[]{"AL16UTF16", "AL24UTFFSS", "AL32UTF8", "AR8ADOS710", "AR8ADOS710T", "AR8ADOS720", "AR8ADOS720T", "AR8APTEC715", "AR8APTEC715T", "AR8ARABICMAC", "AR8ARABICMACS", "AR8ARABICMACT", "AR8ASMO708PLUS", "AR8ASMO8X", "AR8EBCDIC420S", "AR8EBCDICX", "AR8HPARABIC8T", "AR8ISO8859P6", "AR8MSAWIN", "AR8MSWIN1256", "AR8MUSSAD768", "AR8MUSSAD768T", "AR8NAFITHA711", "AR8NAFITHA711T", "AR8NAFITHA721", "AR8NAFITHA721T", "AR8SAKHR706", "AR8SAKHR707", "AR8SAKHR707T", "AR8XBASIC", "BG8MSWIN", "BG8PC437S", "BLT8CP921", "BLT8EBCDIC1112", "BLT8EBCDIC1112S", "BLT8ISO8859P13", "BLT8MSWIN1257", "BLT8PC775", "BN8BSCII", "CDN8PC863", "CE8BS2000", "CEL8ISO8859P14", "CH7DEC", "CL8BS2000", "CL8EBCDIC1025", "CL8EBCDIC1025C", "CL8EBCDIC1025R", "CL8EBCDIC1025S", "CL8EBCDIC1025X", "CL8ISO8859P5", "CL8ISOIR111", "CL8KOI8R", "CL8KOI8U", "CL8MACCYRILLIC", "CL8MACCYRILLICS", "CL8MSWIN1251", "D7DEC", "D7SIEMENS9780X", "D8BS2000", "D8EBCDIC1141", "D8EBCDIC273", "DK7SIEMENS9780X", "DK8BS2000", "DK8EBCDIC1142", "DK8EBCDIC277", "E7DEC", "E7SIEMENS9780X", "E8BS2000", "EE8BS2000", "EE8EBCDIC870", "EE8EBCDIC870C", "EE8EBCDIC870S", "EE8ISO8859P2", "EE8MACCE", "EE8MACCES", "EE8MACCROATIAN", "EE8MACCROATIANS", "EE8MSWIN1250", "EE8PC852", "EEC8EUROASCI", "EEC8EUROPA3", "EL8DEC", "EL8EBCDIC875", "EL8EBCDIC875R", "EL8EBCDIC875S", "EL8GCOS7", "EL8ISO8859P7", "EL8MACGREEK", "EL8MACGREEKS", "EL8MSWIN1253", "EL8PC437S", "EL8PC737", "EL8PC851", "EL8PC869", "ET8MSWIN923", "F7DEC", "F7SIEMENS9780X", "F8BS2000", "F8EBCDIC1147", "F8EBCDIC297", "HU8ABMOD", "HU8CWI2", "HZ-GB-2312", "I7DEC", "I7SIEMENS9780X", "I8EBCDIC1144", "I8EBCDIC280", "IN8ISCII", "IS8MACICELANDIC", "IS8MACICELANDICS", "IS8PC861", "ISO2022-CN", "ISO2022-JP", "ISO2022-KR", "IW7IS960", "IW8EBCDIC1086", "IW8EBCDIC424", "IW8EBCDIC424S", "IW8ISO8859P8", "IW8MACHEBREW", "IW8MACHEBREWS", "IW8MSWIN1255", "IW8PC1507", "JA16DBCS", "JA16DBCSFIXED", "JA16EBCDIC930", "JA16EUC", "JA16EUCFIXED", "JA16EUCYEN", "JA16MACSJIS", "JA16SJIS", "JA16SJISFIXED", "JA16SJISYEN", "JA16TSTSET", "JA16TSTSET2", "JA16VMS", "KO16DBCS", "KO16DBCSFIXED", "KO16KSC5601", "KO16KSC5601FIXED", "KO16KSCCS", "KO16MSWIN949", "KO16TSTSET", "LA8ISO6937", "LA8PASSPORT", "LT8MSWIN921", "LT8PC772", "LT8PC774", "LV8PC1117", "LV8PC8LR", "LV8RST104090", "N7SIEMENS9780X", "N8PC865", "NDK7DEC", "NE8ISO8859P10", "NEE8ISO8859P4", "NL7DEC", "RU8BESTA", "RU8PC855", "RU8PC866", "S7DEC", "S7SIEMENS9780X", "S8BS2000", "S8EBCDIC1143", "S8EBCDIC278", "SE8ISO8859P3", "SF7ASCII", "SF7DEC", "TH8MACTHAI", "TH8MACTHAIS", "TH8TISASCII", "TH8TISEBCDIC", "TH8TISEBCDICS", "TR7DEC", "TR8DEC", "TR8EBCDIC1026", "TR8EBCDIC1026S", "TR8MACTURKISH", "TR8MACTURKISHS", "TR8MSWIN1254", "TR8PC857", "US16TSTFIXED", "US7ASCII", "US8BS2000", "US8ICL", "US8PC437", "UTF8", "UTFE", "VN8MSWIN1258", "VN8VN3", "WE16DECTST", "WE16DECTST2", "WE8BS2000", "WE8BS2000E", "WE8BS2000L5", "WE8DEC", "WE8DECTST", "WE8DG", "WE8EBCDIC1047", "WE8EBCDIC1047E", "WE8EBCDIC1140", "WE8EBCDIC1140C", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148", "WE8EBCDIC1148C", "WE8EBCDIC284", "WE8EBCDIC285", "WE8EBCDIC37", "WE8EBCDIC37C", "WE8EBCDIC500", "WE8EBCDIC500C", "WE8EBCDIC871", "WE8EBCDIC924", "WE8GCOS7", "WE8HP", "WE8ICL", "WE8ISO8859P1", "WE8ISO8859P15", "WE8ISO8859P9", "WE8ISOICLUK", "WE8MACROMAN8", "WE8MACROMAN8S", "WE8MSWIN1252", "WE8NCR4970", "WE8NEXTSTEP", "WE8PC850", "WE8PC858", "WE8PC860", "WE8ROMAN8", "YUG7ASCII", "ZHS16CGB231280", "ZHS16CGB231280FIXED", "ZHS16DBCS", "ZHS16DBCSFIXED", "ZHS16GBK", "ZHS16GBKFIXED", "ZHS16MACCGB231280", "ZHS32GB18030", "ZHT16BIG5", "ZHT16BIG5FIXED", "ZHT16CCDC", "ZHT16DBCS", "ZHT16DBCSFIXED", "ZHT16DBT", "ZHT16HKSCS", "ZHT16MSWIN950", "ZHT32EUC", "ZHT32EUCFIXED", "ZHT32SOPS", "ZHT32TRIS", "ZHT32TRISFIXED"};
        }
        return m_asciiCharset;
    }

    public static String getCharset(int n2) {
        if (m_idToCharset == null) {
            if (m_charsetToID == null) {
                JNLS.getCharsetID("US7ASCII");
            }
            if (m_charsetToID != null) {
                Enumeration enumeration = m_charsetToID.keys();
                m_idToCharset = new Hashtable();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)m_charsetToID.get(string);
                    m_idToCharset.put(string2, string);
                }
            } else {
                return null;
            }
        }
        return (String)m_idToCharset.get(Integer.toString(n2));
    }

    public static String getCharset(String string) {
        if (m_defCharset == null) {
            m_defCharset = new Hashtable();
            m_defCharset.put("AMERICAN", "US7ASCII");
            m_defCharset.put("GERMAN", "WE8ISO8859P1");
            m_defCharset.put("FRENCH", "WE8ISO8859P1");
            m_defCharset.put("CANADIAN FRENCH", "WE8ISO8859P1");
            m_defCharset.put("SPANISH", "WE8ISO8859P1");
            m_defCharset.put("ITALIAN", "WE8ISO8859P1");
            m_defCharset.put("DUTCH", "WE8ISO8859P1");
            m_defCharset.put("SWEDISH", "WE8ISO8859P1");
            m_defCharset.put("NORWEGIAN", "WE8ISO8859P1");
            m_defCharset.put("DANISH", "WE8ISO8859P1");
            m_defCharset.put("FINNISH", "WE8ISO8859P1");
            m_defCharset.put("ICELANDIC", "WE8ISO8859P1");
            m_defCharset.put("GREEK", "EL8ISO8859P7");
            m_defCharset.put("PORTUGUESE", "WE8ISO8859P1");
            m_defCharset.put("TURKISH", "WE8ISO8859P9");
            m_defCharset.put("BRAZILIAN PORTUGUESE", "WE8ISO8859P1");
            m_defCharset.put("MEXICAN SPANISH", "WE8ISO8859P1");
            m_defCharset.put("RUSSIAN", "CL8ISO8859P5");
            m_defCharset.put("POLISH", "EE8ISO8859P2");
            m_defCharset.put("HUNGARIAN", "EE8ISO8859P2");
            m_defCharset.put("CZECH", "EE8ISO8859P2");
            m_defCharset.put("LITHUANIAN", "NEE8ISO8859P4");
            m_defCharset.put("SLOVAK", "EE8ISO8859P2");
            m_defCharset.put("CATALAN", "WE8ISO8859P1");
            m_defCharset.put("BULGARIAN", "CL8ISO8859P5");
            m_defCharset.put("ROMANIAN", "EE8ISO8859P2");
            m_defCharset.put("SLOVENIAN", "EE8ISO8859P2");
            m_defCharset.put("HEBREW", "IW8ISO8859P8");
            m_defCharset.put("EGYPTIAN", "AR8ISO8859P6");
            m_defCharset.put("CROATIAN", "EE8ISO8859P2");
            m_defCharset.put("ARABIC", "AR8ISO8859P6");
            m_defCharset.put("THAI", "TH8TISASCII");
            m_defCharset.put("JAPANESE", "JA16EUC");
            m_defCharset.put("KOREAN", "KO16KSC5601");
            m_defCharset.put("SIMPLIFIED CHINESE", "ZHS16CGB231280");
            m_defCharset.put("TRADITIONAL CHINESE", "ZHT32EUC");
            m_defCharset.put("ENGLISH", "WE8ISO8859P1");
            m_defCharset.put("LATIN AMERICAN SPANISH", "WE8ISO8859P1");
            m_defCharset.put("UKRAINIAN", "CL8ISO8859P5");
            m_defCharset.put("ESTONIAN", "NEE8ISO8859P4");
            m_defCharset.put("GERMAN DIN", "WE8ISO8859P1");
            m_defCharset.put("MALAY", "WE8ISO8859P1");
            m_defCharset.put("VIETNAMESE", "VN8MSWIN1258");
            m_defCharset.put("BENGALI", "BN8BSCII");
            m_defCharset.put("LATVIAN", "NEE8ISO8859P4");
            m_defCharset.put("INDONESIAN", "WE8ISO8859P1");
            m_defCharset.put("HINDI", "UTF8");
            m_defCharset.put("TAMIL", "UTF8");
            m_defCharset.put("KANNADA", "UTF8");
            m_defCharset.put("TELUGU", "UTF8");
            m_defCharset.put("ORIYA", "UTF8");
            m_defCharset.put("MALAYALAM", "UTF8");
            m_defCharset.put("ASSAMESE", "UTF8");
            m_defCharset.put("GUJARATI", "UTF8");
            m_defCharset.put("MARATHI", "UTF8");
            m_defCharset.put("PUNJABI", "UTF8");
            m_defCharset.put("BANGLA", "UTF8");
            m_defCharset.put("NUMERIC DATE LANGUAGE", "US7ASCII");
        }
        return (String)m_defCharset.get(string.toUpperCase(Locale.US));
    }

    public static int getCharsetID(String string) {
        Object object;
        if (m_charsetToID == null) {
            Object k2;
            Enumeration enumeration;
            m_charsetToID = new Hashtable();
            m_charsetToID.put("US7ASCII", "1");
            m_charsetToID.put("WE8DEC", "2");
            m_charsetToID.put("WE8HP", "3");
            m_charsetToID.put("US8PC437", "4");
            m_charsetToID.put("WE8EBCDIC37", "5");
            m_charsetToID.put("WE8EBCDIC500", "6");
            m_charsetToID.put("WE8EBCDIC1140", "7");
            m_charsetToID.put("WE8EBCDIC285", "8");
            m_charsetToID.put("WE8EBCDIC1146", "9");
            m_charsetToID.put("WE8PC850", "10");
            m_charsetToID.put("D7DEC", "11");
            m_charsetToID.put("F7DEC", "12");
            m_charsetToID.put("S7DEC", "13");
            m_charsetToID.put("E7DEC", "14");
            m_charsetToID.put("SF7ASCII", "15");
            m_charsetToID.put("NDK7DEC", "16");
            m_charsetToID.put("I7DEC", "17");
            m_charsetToID.put("NL7DEC", "18");
            m_charsetToID.put("CH7DEC", "19");
            m_charsetToID.put("YUG7ASCII", "20");
            m_charsetToID.put("SF7DEC", "21");
            m_charsetToID.put("TR7DEC", "22");
            m_charsetToID.put("IW7IS960", "23");
            m_charsetToID.put("IN8ISCII", "25");
            m_charsetToID.put("WE8EBCDIC1148", "27");
            m_charsetToID.put("WE8PC858", "28");
            m_charsetToID.put("WE8ISO8859P1", "31");
            m_charsetToID.put("EE8ISO8859P2", "32");
            m_charsetToID.put("SE8ISO8859P3", "33");
            m_charsetToID.put("NEE8ISO8859P4", "34");
            m_charsetToID.put("CL8ISO8859P5", "35");
            m_charsetToID.put("AR8ISO8859P6", "36");
            m_charsetToID.put("EL8ISO8859P7", "37");
            m_charsetToID.put("IW8ISO8859P8", "38");
            m_charsetToID.put("WE8ISO8859P9", "39");
            m_charsetToID.put("NE8ISO8859P10", "40");
            m_charsetToID.put("TH8TISASCII", "41");
            m_charsetToID.put("TH8TISEBCDIC", "42");
            m_charsetToID.put("BN8BSCII", "43");
            m_charsetToID.put("VN8VN3", "44");
            m_charsetToID.put("VN8MSWIN1258", "45");
            m_charsetToID.put("WE8ISO8859P15", "46");
            m_charsetToID.put("BLT8ISO8859P13", "47");
            m_charsetToID.put("CEL8ISO8859P14", "48");
            m_charsetToID.put("CL8ISOIR111", "49");
            m_charsetToID.put("WE8NEXTSTEP", "50");
            m_charsetToID.put("CL8KOI8U", "51");
            m_charsetToID.put("AR8ASMO708PLUS", "61");
            m_charsetToID.put("AR8EBCDICX", "70");
            m_charsetToID.put("AR8XBASIC", "72");
            m_charsetToID.put("EL8DEC", "81");
            m_charsetToID.put("TR8DEC", "82");
            m_charsetToID.put("WE8EBCDIC37C", "90");
            m_charsetToID.put("WE8EBCDIC500C", "91");
            m_charsetToID.put("IW8EBCDIC424", "92");
            m_charsetToID.put("TR8EBCDIC1026", "93");
            m_charsetToID.put("WE8EBCDIC871", "94");
            m_charsetToID.put("WE8EBCDIC284", "95");
            m_charsetToID.put("WE8EBCDIC1047", "96");
            m_charsetToID.put("WE8EBCDIC1140C", "97");
            m_charsetToID.put("WE8EBCDIC1145", "98");
            m_charsetToID.put("WE8EBCDIC1148C", "99");
            m_charsetToID.put("WE8EBCDIC1047E", "100");
            m_charsetToID.put("WE8EBCDIC924", "101");
            m_charsetToID.put("EEC8EUROASCI", "110");
            m_charsetToID.put("EEC8EUROPA3", "113");
            m_charsetToID.put("LA8PASSPORT", "114");
            m_charsetToID.put("BG8PC437S", "140");
            m_charsetToID.put("EE8PC852", "150");
            m_charsetToID.put("RU8PC866", "152");
            m_charsetToID.put("RU8BESTA", "153");
            m_charsetToID.put("IW8PC1507", "154");
            m_charsetToID.put("RU8PC855", "155");
            m_charsetToID.put("TR8PC857", "156");
            m_charsetToID.put("CL8MACCYRILLIC", "158");
            m_charsetToID.put("CL8MACCYRILLICS", "159");
            m_charsetToID.put("WE8PC860", "160");
            m_charsetToID.put("IS8PC861", "161");
            m_charsetToID.put("EE8MACCES", "162");
            m_charsetToID.put("EE8MACCROATIANS", "163");
            m_charsetToID.put("TR8MACTURKISHS", "164");
            m_charsetToID.put("IS8MACICELANDICS", "165");
            m_charsetToID.put("EL8MACGREEKS", "166");
            m_charsetToID.put("IW8MACHEBREWS", "167");
            m_charsetToID.put("EE8MSWIN1250", "170");
            m_charsetToID.put("CL8MSWIN1251", "171");
            m_charsetToID.put("ET8MSWIN923", "172");
            m_charsetToID.put("BG8MSWIN", "173");
            m_charsetToID.put("EL8MSWIN1253", "174");
            m_charsetToID.put("IW8MSWIN1255", "175");
            m_charsetToID.put("LT8MSWIN921", "176");
            m_charsetToID.put("TR8MSWIN1254", "177");
            m_charsetToID.put("WE8MSWIN1252", "178");
            m_charsetToID.put("BLT8MSWIN1257", "179");
            m_charsetToID.put("D8EBCDIC273", "180");
            m_charsetToID.put("I8EBCDIC280", "181");
            m_charsetToID.put("DK8EBCDIC277", "182");
            m_charsetToID.put("S8EBCDIC278", "183");
            m_charsetToID.put("EE8EBCDIC870", "184");
            m_charsetToID.put("CL8EBCDIC1025", "185");
            m_charsetToID.put("F8EBCDIC297", "186");
            m_charsetToID.put("IW8EBCDIC1086", "187");
            m_charsetToID.put("CL8EBCDIC1025X", "188");
            m_charsetToID.put("D8EBCDIC1141", "189");
            m_charsetToID.put("N8PC865", "190");
            m_charsetToID.put("BLT8CP921", "191");
            m_charsetToID.put("LV8PC1117", "192");
            m_charsetToID.put("LV8PC8LR", "193");
            m_charsetToID.put("BLT8EBCDIC1112", "194");
            m_charsetToID.put("LV8RST104090", "195");
            m_charsetToID.put("CL8KOI8R", "196");
            m_charsetToID.put("BLT8PC775", "197");
            m_charsetToID.put("DK8EBCDIC1142", "198");
            m_charsetToID.put("S8EBCDIC1143", "199");
            m_charsetToID.put("I8EBCDIC1144", "200");
            m_charsetToID.put("F7SIEMENS9780X", "201");
            m_charsetToID.put("E7SIEMENS9780X", "202");
            m_charsetToID.put("S7SIEMENS9780X", "203");
            m_charsetToID.put("DK7SIEMENS9780X", "204");
            m_charsetToID.put("N7SIEMENS9780X", "205");
            m_charsetToID.put("I7SIEMENS9780X", "206");
            m_charsetToID.put("D7SIEMENS9780X", "207");
            m_charsetToID.put("F8EBCDIC1147", "208");
            m_charsetToID.put("WE8GCOS7", "210");
            m_charsetToID.put("EL8GCOS7", "211");
            m_charsetToID.put("US8BS2000", "221");
            m_charsetToID.put("D8BS2000", "222");
            m_charsetToID.put("F8BS2000", "223");
            m_charsetToID.put("E8BS2000", "224");
            m_charsetToID.put("DK8BS2000", "225");
            m_charsetToID.put("S8BS2000", "226");
            m_charsetToID.put("WE8BS2000E", "230");
            m_charsetToID.put("WE8BS2000", "231");
            m_charsetToID.put("EE8BS2000", "232");
            m_charsetToID.put("CE8BS2000", "233");
            m_charsetToID.put("CL8BS2000", "235");
            m_charsetToID.put("WE8BS2000L5", "239");
            m_charsetToID.put("WE8DG", "241");
            m_charsetToID.put("WE8NCR4970", "251");
            m_charsetToID.put("WE8ROMAN8", "261");
            m_charsetToID.put("EE8MACCE", "262");
            m_charsetToID.put("EE8MACCROATIAN", "263");
            m_charsetToID.put("TR8MACTURKISH", "264");
            m_charsetToID.put("IS8MACICELANDIC", "265");
            m_charsetToID.put("EL8MACGREEK", "266");
            m_charsetToID.put("IW8MACHEBREW", "267");
            m_charsetToID.put("US8ICL", "277");
            m_charsetToID.put("WE8ICL", "278");
            m_charsetToID.put("WE8ISOICLUK", "279");
            m_charsetToID.put("EE8EBCDIC870C", "301");
            m_charsetToID.put("EL8EBCDIC875S", "311");
            m_charsetToID.put("TR8EBCDIC1026S", "312");
            m_charsetToID.put("BLT8EBCDIC1112S", "314");
            m_charsetToID.put("IW8EBCDIC424S", "315");
            m_charsetToID.put("EE8EBCDIC870S", "316");
            m_charsetToID.put("CL8EBCDIC1025S", "317");
            m_charsetToID.put("TH8TISEBCDICS", "319");
            m_charsetToID.put("AR8EBCDIC420S", "320");
            m_charsetToID.put("CL8EBCDIC1025C", "322");
            m_charsetToID.put("CL8EBCDIC1025R", "323");
            m_charsetToID.put("EL8EBCDIC875R", "324");
            m_charsetToID.put("WE8MACROMAN8", "351");
            m_charsetToID.put("WE8MACROMAN8S", "352");
            m_charsetToID.put("TH8MACTHAI", "353");
            m_charsetToID.put("TH8MACTHAIS", "354");
            m_charsetToID.put("HU8CWI2", "368");
            m_charsetToID.put("EL8PC437S", "380");
            m_charsetToID.put("EL8EBCDIC875", "381");
            m_charsetToID.put("EL8PC737", "382");
            m_charsetToID.put("LT8PC772", "383");
            m_charsetToID.put("LT8PC774", "384");
            m_charsetToID.put("EL8PC869", "385");
            m_charsetToID.put("EL8PC851", "386");
            m_charsetToID.put("CDN8PC863", "390");
            m_charsetToID.put("HU8ABMOD", "401");
            m_charsetToID.put("AR8ASMO8X", "500");
            m_charsetToID.put("AR8NAFITHA711T", "504");
            m_charsetToID.put("AR8SAKHR707T", "505");
            m_charsetToID.put("AR8MUSSAD768T", "506");
            m_charsetToID.put("AR8ADOS710T", "507");
            m_charsetToID.put("AR8ADOS720T", "508");
            m_charsetToID.put("AR8APTEC715T", "509");
            m_charsetToID.put("AR8NAFITHA721T", "511");
            m_charsetToID.put("AR8HPARABIC8T", "514");
            m_charsetToID.put("AR8NAFITHA711", "554");
            m_charsetToID.put("AR8SAKHR707", "555");
            m_charsetToID.put("AR8MUSSAD768", "556");
            m_charsetToID.put("AR8ADOS710", "557");
            m_charsetToID.put("AR8ADOS720", "558");
            m_charsetToID.put("AR8APTEC715", "559");
            m_charsetToID.put("AR8MSAWIN", "560");
            m_charsetToID.put("AR8MSWIN1256", "560");
            m_charsetToID.put("AR8NAFITHA721", "561");
            m_charsetToID.put("AR8SAKHR706", "563");
            m_charsetToID.put("AR8ARABICMAC", "565");
            m_charsetToID.put("AR8ARABICMACS", "566");
            m_charsetToID.put("AR8ARABICMACT", "567");
            m_charsetToID.put("LA8ISO6937", "590");
            m_charsetToID.put("WE8DECTST", "798");
            m_charsetToID.put("JA16VMS", "829");
            m_charsetToID.put("JA16EUC", "830");
            m_charsetToID.put("JA16EUCYEN", "831");
            m_charsetToID.put("JA16SJIS", "832");
            m_charsetToID.put("JA16DBCS", "833");
            m_charsetToID.put("JA16SJISYEN", "834");
            m_charsetToID.put("JA16EBCDIC930", "835");
            m_charsetToID.put("JA16MACSJIS", "836");
            m_charsetToID.put("KO16KSC5601", "840");
            m_charsetToID.put("KO16DBCS", "842");
            m_charsetToID.put("KO16KSCCS", "845");
            m_charsetToID.put("KO16MSWIN949", "846");
            m_charsetToID.put("ZHS16CGB231280", "850");
            m_charsetToID.put("ZHS16MACCGB231280", "851");
            m_charsetToID.put("ZHS16GBK", "852");
            m_charsetToID.put("ZHS16DBCS", "853");
            m_charsetToID.put("ZHS32GB18030", "854");
            m_charsetToID.put("ZHT32EUC", "860");
            m_charsetToID.put("ZHT32SOPS", "861");
            m_charsetToID.put("ZHT16DBT", "862");
            m_charsetToID.put("ZHT32TRIS", "863");
            m_charsetToID.put("ZHT16DBCS", "864");
            m_charsetToID.put("ZHT16BIG5", "865");
            m_charsetToID.put("ZHT16CCDC", "866");
            m_charsetToID.put("ZHT16MSWIN950", "867");
            m_charsetToID.put("ZHT16HKSCS", "868");
            m_charsetToID.put("AL24UTFFSS", "870");
            m_charsetToID.put("UTF8", "871");
            m_charsetToID.put("UTFE", "872");
            m_charsetToID.put("AL32UTF8", "873");
            m_charsetToID.put("WE16DECTST2", "994");
            m_charsetToID.put("WE16DECTST", "995");
            m_charsetToID.put("KO16TSTSET", "996");
            m_charsetToID.put("JA16TSTSET2", "997");
            m_charsetToID.put("JA16TSTSET", "998");
            m_charsetToID.put("US16TSTFIXED", "1001");
            m_charsetToID.put("JA16EUCFIXED", "1830");
            m_charsetToID.put("JA16SJISFIXED", "1832");
            m_charsetToID.put("JA16DBCSFIXED", "1833");
            m_charsetToID.put("KO16KSC5601FIXED", "1840");
            m_charsetToID.put("KO16DBCSFIXED", "1842");
            m_charsetToID.put("ZHS16CGB231280FIXED", "1850");
            m_charsetToID.put("ZHS16GBKFIXED", "1852");
            m_charsetToID.put("ZHS16DBCSFIXED", "1853");
            m_charsetToID.put("ZHT32EUCFIXED", "1860");
            m_charsetToID.put("ZHT32TRISFIXED", "1863");
            m_charsetToID.put("ZHT16DBCSFIXED", "1864");
            m_charsetToID.put("ZHT16BIG5FIXED", "1865");
            m_charsetToID.put("AL16UTF16", "2000");
            m_charsetToID.put("AL16UTF16LE", "2002");
            m_charsetToID.put("HZ-GB-2312", "9996");
            m_charsetToID.put("ISO2022-KR", "9997");
            m_charsetToID.put("ISO2022-CN", "9998");
            m_charsetToID.put("ISO2022-JP", "9999");
            object = new ConverterArchive();
            Hashtable hashtable = (Hashtable)((ConverterArchive)object).readObj(BOOTFILE);
            if (hashtable != null) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    k2 = enumeration.nextElement();
                    m_charsetToID.put(k2, hashtable.get(k2));
                }
            }
            if ((hashtable = (Hashtable)((ConverterArchive)(object = new ConverterArchive())).readObj(CUSTOMBOOTFILE)) != null) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    k2 = enumeration.nextElement();
                    m_charsetToID.put(k2, hashtable.get(k2));
                }
            }
        }
        if ((object = (String)m_charsetToID.get(string.toUpperCase(Locale.US))) == null) {
            return -1;
        }
        return Integer.parseInt((String)object);
    }

    public static String[][] getCommonCharsets(String[] stringArray, String string) {
        String[][] stringArrayArray;
        String[][] stringArrayArray2;
        String[][] stringArrayArray3;
        String[][] stringArrayArray4;
        String[][] stringArrayArray5;
        String[][] stringArrayArray6;
        String[][] stringArrayArray7;
        String[][] stringArrayArray8;
        String[][] stringArrayArray9;
        String[][] stringArrayArray10;
        String[][] stringArrayArray11;
        String[][] stringArrayArray12;
        String[][] stringArrayArray13;
        Object object;
        String[][] stringArrayArray14;
        String[][] stringArrayArray15;
        if (m_langGroup == null) {
            m_langGroup = new Hashtable();
            m_langGroup.put("AMERICAN", "ENGLISH");
            m_langGroup.put("GERMAN", "LATIN-1");
            m_langGroup.put("FRENCH", "LATIN-1");
            m_langGroup.put("CANADIAN FRENCH", "LATIN-1");
            m_langGroup.put("SPANISH", "LATIN-1");
            m_langGroup.put("ITALIAN", "LATIN-1");
            m_langGroup.put("DUTCH", "LATIN-1");
            m_langGroup.put("SWEDISH", "LATIN-1");
            m_langGroup.put("NORWEGIAN", "LATIN-1");
            m_langGroup.put("DANISH", "LATIN-1");
            m_langGroup.put("FINNISH", "LATIN-1");
            m_langGroup.put("ICELANDIC", "LATIN-1");
            m_langGroup.put("GREEK", "GREEK");
            m_langGroup.put("PORTUGUESE", "LATIN-1");
            m_langGroup.put("TURKISH", "TURKISH");
            m_langGroup.put("BRAZILIAN PORTUGUESE", "LATIN-1");
            m_langGroup.put("MEXICAN SPANISH", "LATIN-1");
            m_langGroup.put("RUSSIAN", "CYRILLIC");
            m_langGroup.put("POLISH", "LATIN-2");
            m_langGroup.put("HUNGARIAN", "LATIN-2");
            m_langGroup.put("CZECH", "LATIN-2");
            m_langGroup.put("LITHUANIAN", "BALTIC");
            m_langGroup.put("SLOVAK", "LATIN-2");
            m_langGroup.put("CATALAN", "LATIN-1");
            m_langGroup.put("BULGARIAN", "CYRILLIC");
            m_langGroup.put("ROMANIAN", "LATIN-2");
            m_langGroup.put("SLOVENIAN", "LATIN-2");
            m_langGroup.put("HEBREW", "HEBREW");
            m_langGroup.put("EGYPTIAN", "ARABIC");
            m_langGroup.put("CROATIAN", "LATIN-2");
            m_langGroup.put("ARABIC", "ARABIC");
            m_langGroup.put("THAI", "THAI");
            m_langGroup.put("JAPANESE", "JAPANESE");
            m_langGroup.put("KOREAN", "KOREAN");
            m_langGroup.put("SIMPLIFIED CHINESE", "SCHINESE");
            m_langGroup.put("TRADITIONAL CHINESE", "TCHINESE");
            m_langGroup.put("ENGLISH", "ENGLISH");
            m_langGroup.put("LATIN AMERICAN SPANISH", "LATIN-1");
            m_langGroup.put("UKRAINIAN", "CYRILLIC");
            m_langGroup.put("ESTONIAN", "BALTIC");
            m_langGroup.put("GERMAN DIN", "LATIN-1");
            m_langGroup.put("MALAY", "LATIN-1");
            m_langGroup.put("VIETNAMESE", "VIETNAM");
            m_langGroup.put("BENGALI", "UNICODE");
            m_langGroup.put("LATVIAN", "BALTIC");
            m_langGroup.put("INDONESIAN", "LATIN-1");
            m_langGroup.put("HINDI", "UNICODE");
            m_langGroup.put("TAMIL", "UNICODE");
            m_langGroup.put("KANNADA", "UNICODE");
            m_langGroup.put("TELUGU", "UNICODE");
            m_langGroup.put("ORIYA", "UNICODE");
            m_langGroup.put("MALAYALAM", "UNICODE");
            m_langGroup.put("ASSAMESE", "UNICODE");
            m_langGroup.put("GUJARATI", "UNICODE");
            m_langGroup.put("MARATHI", "UNICODE");
            m_langGroup.put("PUNJABI", "UNICODE");
            m_langGroup.put("BANGLA", "UNICODE");
        }
        if (m_commonCharsetsUnix == null) {
            m_commonCharsetsUnix = new Hashtable();
            stringArrayArray15 = new String[][]{{"WE8ISO8859P1", "US7ASCII", "WE8MSWIN1252", "UTF8", "AL32UTF8", "WE8ISO8859P15"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("ENGLISH", stringArrayArray15);
            stringArrayArray14 = new String[][]{{"WE8ISO8859P1", "WE8MSWIN1252", "UTF8", "AL32UTF8", "WE8ISO8859P15"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("LATIN-1", stringArrayArray14);
            object = new String[][]{{"EE8ISO8859P2", "EE8MSWIN1250", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("LATIN-2", object);
            stringArrayArray13 = new String[][]{{"NEE8ISO8859P4", "BLT8MSWIN1257", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("BALTIC", stringArrayArray13);
            stringArrayArray12 = new String[][]{{"CL8ISO8859P5", "CL8MSWIN1251", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("CYRILLIC", stringArrayArray12);
            stringArrayArray11 = new String[][]{{"AR8ISO8859P6", "AR8MSWIN1256", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("ARABIC", stringArrayArray11);
            stringArrayArray10 = new String[][]{{"EL8ISO8859P7", "EL8MSWIN1253", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("GREEK", stringArrayArray10);
            stringArrayArray9 = new String[][]{{"IW8ISO8859P8", "IW8MSWIN1255", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("HEBREW", stringArrayArray9);
            stringArrayArray8 = new String[][]{{"JA16EUC", "JA16SJIS", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("JAPANESE", stringArrayArray8);
            stringArrayArray7 = new String[][]{{"KO16KSC5601", "KO16MSWIN949", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("KOREAN", stringArrayArray7);
            stringArrayArray6 = new String[][]{{"ZHS16GBK", "ZHS16CGB231280", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("SCHINESE", stringArrayArray6);
            stringArrayArray5 = new String[][]{{"TH8TISASCII", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("THAI", stringArrayArray5);
            stringArrayArray4 = new String[][]{{"ZHT32EUC", "ZHT16MSWIN950", "ZHT16HKSCS", "ZHT16BIG5", "UTF8", "AL32UTF8", "ZHT32SOPS", "ZHT32TRIS"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("TCHINESE", stringArrayArray4);
            stringArrayArray3 = new String[][]{{"WE8ISO8859P9", "TR8MSWIN1254", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("TURKISH", stringArrayArray3);
            stringArrayArray2 = new String[][]{{"UTF8", "VN8MSWIN1258", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("VIETNAM", stringArrayArray2);
            stringArrayArray = new String[][]{{"UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsUnix.put("UNICODE", stringArrayArray);
        }
        if (m_commonCharsetsWin == null) {
            m_commonCharsetsWin = new Hashtable();
            stringArrayArray15 = new String[][]{{"WE8MSWIN1252", "WE8ISO8859P1", "US7ASCII", "UTF8", "AL32UTF8", "WE8ISO8859P15"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("ENGLISH", stringArrayArray15);
            stringArrayArray14 = new String[][]{{"WE8MSWIN1252", "WE8ISO8859P1", "UTF8", "AL32UTF8", "WE8ISO8859P15"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("LATIN-1", stringArrayArray14);
            object = new String[][]{{"EE8MSWIN1250", "EE8ISO8859P2", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("LATIN-2", object);
            stringArrayArray13 = new String[][]{{"BLT8MSWIN1257", "NEE8ISO8859P4", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("BALTIC", stringArrayArray13);
            stringArrayArray12 = new String[][]{{"CL8MSWIN1251", "CL8ISO8859P5", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("CYRILLIC", stringArrayArray12);
            stringArrayArray11 = new String[][]{{"AR8MSWIN1256", "AR8ISO8859P6", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("ARABIC", stringArrayArray11);
            stringArrayArray10 = new String[][]{{"EL8MSWIN1253", "EL8ISO8859P7", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("GREEK", stringArrayArray10);
            stringArrayArray9 = new String[][]{{"IW8MSWIN1255", "IW8ISO8859P8", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("HEBREW", stringArrayArray9);
            stringArrayArray8 = new String[][]{{"JA16SJIS", "JA16EUC", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("JAPANESE", stringArrayArray8);
            stringArrayArray7 = new String[][]{{"KO16MSWIN949", "KO16KSC5601", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("KOREAN", stringArrayArray7);
            stringArrayArray6 = new String[][]{{"ZHS16GBK", "ZHS16CGB231280", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("SCHINESE", stringArrayArray6);
            stringArrayArray5 = new String[][]{{"TH8TISASCII", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("THAI", stringArrayArray5);
            stringArrayArray4 = new String[][]{{"ZHT16MSWIN950", "ZHT16HKSCS", "ZHT16BIG5", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("TCHINESE", stringArrayArray4);
            stringArrayArray3 = new String[][]{{"TR8MSWIN1254", "WE8ISO8859P9", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("TURKISH", stringArrayArray3);
            stringArrayArray2 = new String[][]{{"VN8MSWIN1258", "UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("VIETNAM", stringArrayArray2);
            stringArrayArray = new String[][]{{"UTF8", "AL32UTF8"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsWin.put("UNICODE", stringArrayArray);
        }
        if (m_commonCharsetsEbc == null) {
            m_commonCharsetsEbc = new Hashtable();
            stringArrayArray15 = new String[][]{{"WE8EBCDIC37", "WE8EBCDIC284", "WE8EBCDIC285", "WE8EBCDIC500", "WE8EBCDIC871", "WE8EBCDIC1047", "WE8EBCDIC1140", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("ENGLISH", stringArrayArray15);
            stringArrayArray14 = new String[][]{{"WE8EBCDIC1140", "WE8EBCDIC37", "WE8EBCDIC284", "WE8EBCDIC285", "WE8EBCDIC500", "WE8EBCDIC871", "WE8EBCDIC1047", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("LATIN-1", stringArrayArray14);
            object = new String[][]{{"EE8EBCDIC870", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("LATIN-2", object);
            stringArrayArray13 = new String[][]{{"BLT8EBCDIC1112", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("BALTIC", stringArrayArray13);
            stringArrayArray12 = new String[][]{{"CL8EBCDIC1025", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("CYRILLIC", stringArrayArray12);
            stringArrayArray11 = new String[][]{{"AR8EBCDICX", "AR8EBCDIC420S", "AR8XBASIC", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("ARABIC", stringArrayArray11);
            stringArrayArray10 = new String[][]{{"EL8EBCDIC875", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("GREEK", stringArrayArray10);
            stringArrayArray9 = new String[][]{{"IW8EBCDIC424", "IW8EBCDIC1086", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("HEBREW", stringArrayArray9);
            stringArrayArray8 = new String[][]{{"JA16DBCS", "JA16EBCDIC930", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("JAPANESE", stringArrayArray8);
            stringArrayArray7 = new String[][]{{"KO16DBCS", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("KOREAN", stringArrayArray7);
            stringArrayArray6 = new String[][]{{"ZHS16DBCS", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("SCHINESE", stringArrayArray6);
            stringArrayArray5 = new String[][]{{"TH8TISEBCDIC", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("THAI", stringArrayArray5);
            stringArrayArray4 = new String[][]{{"ZHT16DBCS", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("TCHINESE", stringArrayArray4);
            stringArrayArray3 = new String[][]{{"TR8EBCDIC1026", "UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("TURKISH", stringArrayArray3);
            stringArrayArray2 = new String[][]{{"UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("VIETNAM", stringArrayArray2);
            stringArrayArray = new String[][]{{"UTFE"}, {"AL16UTF16", "UTFE"}};
            m_commonCharsetsEbc.put("UNICODE", stringArrayArray);
        }
        stringArrayArray15 = new Hashtable();
        if (stringArray == null || stringArray.length == 0) {
            stringArrayArray15.put("UNICODE", "1");
        } else {
            int n2 = 0;
            while (n2 < stringArray.length) {
                object = stringArray[n2] == null ? null : (String)m_langGroup.get(stringArray[n2].toUpperCase(Locale.US));
                if (object == null) {
                    object = "UNICODE";
                }
                if (!stringArrayArray15.containsKey(object)) {
                    stringArrayArray15.put(object, "1");
                }
                ++n2;
            }
        }
        String string2 = null;
        if (stringArrayArray15.containsKey("UNICODE")) {
            string2 = "UNICODE";
        } else if (stringArrayArray15.size() >= 3) {
            string2 = "UNICODE";
        } else if (stringArrayArray15.size() == 2) {
            if (stringArrayArray15.containsKey("ENGLISH")) {
                stringArrayArray15.remove("ENGLISH");
                string2 = (String)stringArrayArray15.keys().nextElement();
            } else {
                string2 = "UNICODE";
            }
        } else {
            string2 = (String)stringArrayArray15.keys().nextElement();
        }
        object = null;
        object = string == null || string.equals("") ? ((stringArrayArray13 = System.getProperty("os.name")).startsWith("Windows") ? "WINDOWS" : "UNIX") : (string.toUpperCase(Locale.US).equals("WINDOWS") ? "WINDOWS" : (string.toUpperCase(Locale.US).equals("EBCDIC") ? "EBCDIC" : "UNIX"));
        if (object.equals("WINDOWS")) {
            return (String[][])m_commonCharsetsWin.get(string2);
        }
        if (object.equals("EBCDIC")) {
            return (String[][])m_commonCharsetsEbc.get(string2);
        }
        return (String[][])m_commonCharsetsUnix.get(string2);
    }

    public static String[] getEbcdicCharset() {
        if (m_ebcdicCharset == null) {
            m_ebcdicCharset = new String[]{"WE8EBCDIC37", "WE8EBCDIC500", "WE8EBCDIC285", "WE8EBCDIC1146", "WE8EBCDIC1148", "TH8TISEBCDIC", "AR8EBCDICX", "AR8XBASIC", "WE8EBCDIC37C", "WE8EBCDIC500C", "IW8EBCDIC424", "TR8EBCDIC1026", "WE8EBCDIC871", "WE8EBCDIC284", "WE8EBCDIC1047", "WE8EBCDIC1145", "WE8EBCDIC1148C", "D8EBCDIC273", "I8EBCDIC280", "DK8EBCDIC277", "S8EBCDIC278", "EE8EBCDIC870", "CL8EBCDIC1025", "F8EBCDIC297", "IW8EBCDIC1086", "CL8EBCDIC1025X", "D8EBCDIC1141", "BLT8EBCDIC1112", "DK8EBCDIC1142", "S8EBCDIC1143", "I8EBCDIC1144", "F8EBCDIC1147", "WE8GCOS7", "EL8GCOS7", "US8BS2000", "D8BS2000", "F8BS2000", "E8BS2000", "DK8BS2000", "S8BS2000", "WE8BS2000", "CL8BS2000", "WE8BS2000L5", "US8ICL", "WE8ICL", "EE8EBCDIC870C", "EL8EBCDIC875S", "TR8EBCDIC1026S", "BLT8EBCDIC1112S", "IW8EBCDIC424S", "EE8EBCDIC870S", "CL8EBCDIC1025S", "TH8TISEBCDICS", "AR8EBCDIC420S", "CL8EBCDIC1025C", "EL8EBCDIC875", "JA16DBCS", "JA16EBCDIC930", "KO16DBCS", "ZHS16DBCS", "ZHT16DBCS", "UTFE", "WE8BS2000E", "EE8BS2000", "CE8BS2000", "CL8EBCDIC1025R", "EL8EBCDIC875R", "WE8EBCDIC1047E", "WE8EBCDIC924", "CE8BS2000", "CL8EBCDIC1025R", "EE8BS2000", "EL8EBCDIC875R", "WE8BS2000E", "WE8EBCDIC1047E", "WE8EBCDIC924"};
        }
        return m_ebcdicCharset;
    }

    public static String[] getFixedCharset() {
        if (m_fixedCharset == null) {
            m_fixedCharset = new String[]{"US16TSTFIXED", "JA16EUCFIXED", "JA16SJISFIXED", "JA16DBCSFIXED", "KO16KSC5601FIXED", "KO16DBCSFIXED", "ZHS16CGB231280FIXED", "ZHS16GBKFIXED", "ZHS16DBCSFIXED", "ZHT32EUCFIXED", "ZHT32TRISFIXED", "ZHT16DBCSFIXED", "ZHT16BIG5FIXED", "AL16UTF16"};
        }
        return m_fixedCharset;
    }

    public static int getLangDirection(int n2) {
        String string;
        if (m_langDir == null) {
            m_langDir = new Hashtable();
            m_langDir.put("1", "0");
            m_langDir.put("2", "0");
            m_langDir.put("3", "0");
            m_langDir.put("4", "0");
            m_langDir.put("5", "0");
            m_langDir.put("6", "0");
            m_langDir.put("7", "0");
            m_langDir.put("8", "0");
            m_langDir.put("9", "0");
            m_langDir.put("10", "0");
            m_langDir.put("11", "0");
            m_langDir.put("12", "0");
            m_langDir.put("13", "0");
            m_langDir.put("14", "0");
            m_langDir.put("15", "0");
            m_langDir.put("16", "0");
            m_langDir.put("17", "0");
            m_langDir.put("18", "0");
            m_langDir.put("19", "0");
            m_langDir.put("20", "0");
            m_langDir.put("21", "0");
            m_langDir.put("22", "0");
            m_langDir.put("23", "0");
            m_langDir.put("24", "0");
            m_langDir.put("25", "0");
            m_langDir.put("26", "0");
            m_langDir.put("27", "0");
            m_langDir.put("28", "1");
            m_langDir.put("29", "1");
            m_langDir.put("30", "0");
            m_langDir.put("31", "1");
            m_langDir.put("32", "0");
            m_langDir.put("33", "0");
            m_langDir.put("34", "0");
            m_langDir.put("35", "0");
            m_langDir.put("36", "0");
            m_langDir.put("37", "0");
            m_langDir.put("38", "0");
            m_langDir.put("39", "0");
            m_langDir.put("40", "0");
            m_langDir.put("41", "0");
            m_langDir.put("42", "0");
            m_langDir.put("43", "0");
            m_langDir.put("44", "0");
            m_langDir.put("45", "0");
            m_langDir.put("46", "0");
            m_langDir.put("48", "0");
            m_langDir.put("49", "0");
            m_langDir.put("50", "0");
            m_langDir.put("51", "0");
            m_langDir.put("52", "0");
            m_langDir.put("53", "0");
            m_langDir.put("54", "0");
            m_langDir.put("55", "0");
            m_langDir.put("56", "0");
            m_langDir.put("57", "0");
            m_langDir.put("58", "0");
            m_langDir.put("59", "0");
        }
        if ((string = (String)m_langDir.get(String.valueOf(n2))) == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static int getLangID(String string) {
        String string2;
        if (m_langToID == null) {
            m_langToID = new Hashtable();
            m_langToID.put("AMERICAN", "1");
            m_langToID.put("GERMAN", "2");
            m_langToID.put("FRENCH", "3");
            m_langToID.put("CANADIAN FRENCH", "4");
            m_langToID.put("SPANISH", "5");
            m_langToID.put("ITALIAN", "6");
            m_langToID.put("DUTCH", "7");
            m_langToID.put("SWEDISH", "8");
            m_langToID.put("NORWEGIAN", "9");
            m_langToID.put("DANISH", "10");
            m_langToID.put("FINNISH", "11");
            m_langToID.put("ICELANDIC", "12");
            m_langToID.put("GREEK", "13");
            m_langToID.put("PORTUGUESE", "14");
            m_langToID.put("TURKISH", "15");
            m_langToID.put("BRAZILIAN PORTUGUESE", "16");
            m_langToID.put("MEXICAN SPANISH", "17");
            m_langToID.put("RUSSIAN", "18");
            m_langToID.put("POLISH", "19");
            m_langToID.put("HUNGARIAN", "20");
            m_langToID.put("CZECH", "21");
            m_langToID.put("LITHUANIAN", "22");
            m_langToID.put("SLOVAK", "23");
            m_langToID.put("CATALAN", "24");
            m_langToID.put("BULGARIAN", "25");
            m_langToID.put("ROMANIAN", "26");
            m_langToID.put("SLOVENIAN", "27");
            m_langToID.put("HEBREW", "28");
            m_langToID.put("EGYPTIAN", "29");
            m_langToID.put("CROATIAN", "30");
            m_langToID.put("ARABIC", "31");
            m_langToID.put("THAI", "32");
            m_langToID.put("JAPANESE", "33");
            m_langToID.put("KOREAN", "34");
            m_langToID.put("SIMPLIFIED CHINESE", "35");
            m_langToID.put("TRADITIONAL CHINESE", "36");
            m_langToID.put("ENGLISH", "37");
            m_langToID.put("LATIN AMERICAN SPANISH", "38");
            m_langToID.put("UKRAINIAN", "39");
            m_langToID.put("ESTONIAN", "40");
            m_langToID.put("GERMAN DIN", "41");
            m_langToID.put("MALAY", "42");
            m_langToID.put("VIETNAMESE", "43");
            m_langToID.put("BENGALI", "44");
            m_langToID.put("LATVIAN", "45");
            m_langToID.put("INDONESIAN", "46");
            m_langToID.put("NUMERIC DATE LANGUAGE", "48");
            m_langToID.put("HINDI", "49");
            m_langToID.put("TAMIL", "50");
            m_langToID.put("KANNADA", "51");
            m_langToID.put("TELUGU", "52");
            m_langToID.put("ORIYA", "53");
            m_langToID.put("MALAYALAM", "54");
            m_langToID.put("ASSAMESE", "55");
            m_langToID.put("GUJARATI", "56");
            m_langToID.put("MARATHI", "57");
            m_langToID.put("PUNJABI", "58");
            m_langToID.put("BANGLA", "59");
        }
        if ((string2 = (String)m_langToID.get(string.toUpperCase(Locale.US))) == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static String[] getNationalCharset() {
        if (m_nationalCharset == null) {
            m_nationalCharset = new String[]{"UTF8", "AL16UTF16"};
        }
        return m_nationalCharset;
    }

    public static String[] getStorageCharset() {
        if (m_storageCharset == null) {
            m_storageCharset = new String[]{"US7ASCII", "WE8DEC", "WE8HP", "US8PC437", "WE8EBCDIC37", "WE8EBCDIC500", "WE8EBCDIC1140", "WE8EBCDIC285", "WE8EBCDIC1146", "WE8PC850", "D7DEC", "F7DEC", "S7DEC", "E7DEC", "SF7ASCII", "NDK7DEC", "I7DEC", "NL7DEC", "CH7DEC", "YUG7ASCII", "SF7DEC", "TR7DEC", "IW7IS960", "IN8ISCII", "WE8EBCDIC1148", "WE8PC858", "WE8ISO8859P1", "EE8ISO8859P2", "SE8ISO8859P3", "NEE8ISO8859P4", "CL8ISO8859P5", "AR8ISO8859P6", "EL8ISO8859P7", "IW8ISO8859P8", "WE8ISO8859P9", "NE8ISO8859P10", "TH8TISASCII", "TH8TISEBCDIC", "BN8BSCII", "VN8VN3", "VN8MSWIN1258", "WE8ISO8859P15", "WE8NEXTSTEP", "AR8ASMO708PLUS", "AR8EBCDICX", "AR8XBASIC", "EL8DEC", "TR8DEC", "WE8EBCDIC37C", "WE8EBCDIC500C", "IW8EBCDIC424", "TR8EBCDIC1026", "WE8EBCDIC871", "WE8EBCDIC284", "WE8EBCDIC1047", "WE8EBCDIC1140C", "WE8EBCDIC1145", "WE8EBCDIC1148C", "EEC8EUROASCI", "EEC8EUROPA3", "LA8PASSPORT", "BG8PC437S", "EE8PC852", "RU8PC866", "RU8BESTA", "IW8PC1507", "RU8PC855", "TR8PC857", "CL8MACCYRILLIC", "CL8MACCYRILLICS", "WE8PC860", "IS8PC861", "EE8MACCES", "EE8MACCROATIANS", "TR8MACTURKISHS", "IS8MACICELANDICS", "EL8MACGREEKS", "IW8MACHEBREWS", "EE8MSWIN1250", "CL8MSWIN1251", "ET8MSWIN923", "BG8MSWIN", "EL8MSWIN1253", "IW8MSWIN1255", "LT8MSWIN921", "TR8MSWIN1254", "WE8MSWIN1252", "BLT8MSWIN1257", "D8EBCDIC273", "I8EBCDIC280", "DK8EBCDIC277", "S8EBCDIC278", "EE8EBCDIC870", "CL8EBCDIC1025", "F8EBCDIC297", "IW8EBCDIC1086", "CL8EBCDIC1025X", "D8EBCDIC1141", "N8PC865", "BLT8CP921", "LV8PC1117", "LV8PC8LR", "BLT8EBCDIC1112", "LV8RST104090", "CL8KOI8R", "BLT8PC775", "DK8EBCDIC1142", "S8EBCDIC1143", "I8EBCDIC1144", "F7SIEMENS9780X", "E7SIEMENS9780X", "S7SIEMENS9780X", "DK7SIEMENS9780X", "N7SIEMENS9780X", "I7SIEMENS9780X", "D7SIEMENS9780X", "F8EBCDIC1147", "WE8GCOS7", "EL8GCOS7", "US8BS2000", "D8BS2000", "F8BS2000", "E8BS2000", "DK8BS2000", "S8BS2000", "WE8BS2000", "CL8BS2000", "WE8BS2000L5", "WE8DG", "WE8NCR4970", "WE8ROMAN8", "EE8MACCE", "EE8MACCROATIAN", "TR8MACTURKISH", "IS8MACICELANDIC", "EL8MACGREEK", "IW8MACHEBREW", "US8ICL", "WE8ICL", "WE8ISOICLUK", "EE8EBCDIC870C", "EL8EBCDIC875S", "TR8EBCDIC1026S", "BLT8EBCDIC1112S", "IW8EBCDIC424S", "EE8EBCDIC870S", "CL8EBCDIC1025S", "TH8TISEBCDICS", "AR8EBCDIC420S", "CL8EBCDIC1025C", "WE8MACROMAN8", "WE8MACROMAN8S", "TH8MACTHAI", "TH8MACTHAIS", "HU8CWI2", "EL8PC437S", "EL8EBCDIC875", "EL8PC737", "LT8PC772", "LT8PC774", "EL8PC869", "EL8PC851", "CDN8PC863", "HU8ABMOD", "AR8ASMO8X", "AR8NAFITHA711T", "AR8SAKHR707T", "AR8MUSSAD768T", "AR8ADOS710T", "AR8ADOS720T", "AR8APTEC715T", "AR8NAFITHA721T", "AR8HPARABIC8T", "AR8NAFITHA711", "AR8SAKHR707", "AR8MUSSAD768", "AR8ADOS710", "AR8ADOS720", "AR8APTEC715", "AR8MSWIN1256", "AR8MSAWIN", "AR8NAFITHA721", "AR8SAKHR706", "AR8ARABICMAC", "AR8ARABICMACS", "AR8ARABICMACT", "LA8ISO6937", "WE8DECTST", "JA16VMS", "JA16EUC", "JA16EUCYEN", "JA16SJIS", "JA16DBCS", "JA16SJISYEN", "JA16EBCDIC930", "JA16MACSJIS", "KO16KSC5601", "KO16DBCS", "KO16KSCCS", "KO16MSWIN949", "ZHS16CGB231280", "ZHS16MACCGB231280", "ZHS16GBK", "ZHS16DBCS", "ZHT32EUC", "ZHT32SOPS", "ZHT16DBT", "ZHT32TRIS", "ZHT16DBCS", "ZHT16BIG5", "ZHT16CCDC", "ZHT16MSWIN950", "ZHT16HKSCS", "AL24UTFFSS", "UTF8", "AL32UTF8", "UTFE", "WE16DECTST2", "WE16DECTST", "KO16TSTSET", "JA16TSTSET2", "JA16TSTSET", "ZHS32GB18030", "WE8EBCDIC1047E", "WE8EBCDIC924"};
        }
        return m_storageCharset;
    }

    public static String getTerritory(String string) {
        if (m_defTerritory == null) {
            m_defTerritory = new Hashtable();
            m_defTerritory.put("AMERICAN", "AMERICA");
            m_defTerritory.put("GERMAN", "GERMANY");
            m_defTerritory.put("FRENCH", "FRANCE");
            m_defTerritory.put("CANADIAN FRENCH", "CANADA");
            m_defTerritory.put("SPANISH", "SPAIN");
            m_defTerritory.put("ITALIAN", "ITALY");
            m_defTerritory.put("DUTCH", "THE NETHERLANDS");
            m_defTerritory.put("SWEDISH", "SWEDEN");
            m_defTerritory.put("NORWEGIAN", "NORWAY");
            m_defTerritory.put("DANISH", "DENMARK");
            m_defTerritory.put("FINNISH", "FINLAND");
            m_defTerritory.put("ICELANDIC", "ICELAND");
            m_defTerritory.put("GREEK", "GREECE");
            m_defTerritory.put("PORTUGUESE", "PORTUGAL");
            m_defTerritory.put("TURKISH", "TURKEY");
            m_defTerritory.put("BRAZILIAN PORTUGUESE", "BRAZIL");
            m_defTerritory.put("MEXICAN SPANISH", "MEXICO");
            m_defTerritory.put("RUSSIAN", "CIS");
            m_defTerritory.put("POLISH", "POLAND");
            m_defTerritory.put("HUNGARIAN", "HUNGARY");
            m_defTerritory.put("CZECH", "CZECH REPUBLIC");
            m_defTerritory.put("LITHUANIAN", "LITHUANIA");
            m_defTerritory.put("SLOVAK", "SLOVAKIA");
            m_defTerritory.put("CATALAN", "CATALONIA");
            m_defTerritory.put("BULGARIAN", "BULGARIA");
            m_defTerritory.put("ROMANIAN", "ROMANIA");
            m_defTerritory.put("SLOVENIAN", "SLOVENIA");
            m_defTerritory.put("HEBREW", "ISRAEL");
            m_defTerritory.put("EGYPTIAN", "EGYPT");
            m_defTerritory.put("CROATIAN", "CROATIA");
            m_defTerritory.put("ARABIC", "UNITED ARAB EMIRATES");
            m_defTerritory.put("THAI", "THAILAND");
            m_defTerritory.put("JAPANESE", "JAPAN");
            m_defTerritory.put("KOREAN", "KOREA");
            m_defTerritory.put("SIMPLIFIED CHINESE", "CHINA");
            m_defTerritory.put("TRADITIONAL CHINESE", "TAIWAN");
            m_defTerritory.put("ENGLISH", "UNITED KINGDOM");
            m_defTerritory.put("LATIN AMERICAN SPANISH", "AMERICA");
            m_defTerritory.put("UKRAINIAN", "UKRAINE");
            m_defTerritory.put("ESTONIAN", "ESTONIA");
            m_defTerritory.put("GERMAN DIN", "GERMANY");
            m_defTerritory.put("MALAY", "MALAYSIA");
            m_defTerritory.put("VIETNAMESE", "VIETNAM");
            m_defTerritory.put("BENGALI", "BANGLADESH");
            m_defTerritory.put("LATVIAN", "LATVIA");
            m_defTerritory.put("INDONESIAN", "INDONESIA");
            m_defTerritory.put("HINDI", "INDIA");
            m_defTerritory.put("TAMIL", "INDIA");
            m_defTerritory.put("KANNADA", "INDIA");
            m_defTerritory.put("TELUGU", "INDIA");
            m_defTerritory.put("ORIYA", "INDIA");
            m_defTerritory.put("MALAYALAM", "INDIA");
            m_defTerritory.put("ASSAMESE", "INDIA");
            m_defTerritory.put("GUJARATI", "INDIA");
            m_defTerritory.put("MARATHI", "INDIA");
            m_defTerritory.put("PUNJABI", "INDIA");
            m_defTerritory.put("BANGLA", "INDIA");
            m_defTerritory.put("NUMERIC DATE LANGUAGE", "AMERICA");
        }
        return (String)m_defTerritory.get(string.toUpperCase(Locale.US));
    }
}

