/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverter12Byte;

public class MultiByte12MapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    int m_l1KeyWidth;
    int m_ucsReplacement;
    Vector mapStore;
    CharacterConverter12Byte m_charConv;

    MultiByte12MapSetter(int n2, int n3, int n4) {
        super(n2);
        this.m_l1KeyWidth = n3;
        this.m_ucsReplacement = n4;
        this.mapStore = new Vector();
    }

    MultiByte12MapSetter(CharacterConverter characterConverter, CharacterConverter12Byte characterConverter12Byte, int n2, int n3, int n4) throws IOException {
        super(n2);
        this.m_l1KeyWidth = n3;
        this.m_ucsReplacement = n4;
        this.mapStore = new Vector();
        this.m_charConv = characterConverter12Byte;
        if (characterConverter != null) {
            Vector vector = new Vector(65535, 28671);
            characterConverter.extractCodepoints(vector);
            int n5 = 0;
            while (n5 < vector.size()) {
                int[] nArray = (int[])vector.elementAt(n5);
                this.set(nArray[0], nArray[1]);
                ++n5;
            }
        }
    }

    void buildMapping() {
        int n2;
        int n3;
        int n4;
        char c2;
        char c3;
        char[] cArray;
        int n5 = this.m_l1KeyWidth;
        int n6 = 16 - n5;
        int n7 = (1 << n5) - 1;
        int n8 = (1 << n6) - 1;
        int n9 = 1 << n5;
        char[] cArray2 = new char[n9];
        char[][] cArray3 = new char[n9][2];
        int n10 = 0;
        while (n10 < n9) {
            cArray2[n10] = '\u0000';
            cArray3[n10][0] = (char)n8;
            cArray3[n10][1] = '\u0000';
            ++n10;
        }
        int n11 = this.mapStore.size();
        int n12 = this.m_ucsReplacement;
        n10 = 0;
        while (n10 < n11) {
            cArray = (char[])this.mapStore.elementAt(n10);
            c3 = cArray[1];
            if (c3 != n12) {
                c2 = cArray[0];
                n4 = c2 >> n6 & n7;
                cArray2[n4] = '\u0001';
                n3 = c2 & n8;
                if (n3 < cArray3[n4][0]) {
                    cArray3[n4][0] = (char)n3;
                }
                if (n3 > cArray3[n4][1]) {
                    cArray3[n4][1] = (char)n3;
                }
            }
            ++n10;
        }
        int n13 = n2 = n8 + 1;
        int n14 = 0;
        n10 = 0;
        while (n10 < n9) {
            if (cArray2[n10] != '\u0000') {
                int n15 = cArray3[n10][0];
                cArray2[n10] = (char)(n13 - (n14 < n15 ? n14 : n15));
                n13 = cArray2[n10] + n2;
                n14 = n2 - cArray3[n10][1] - 1;
            }
            ++n10;
        }
        char[] cArray4 = new char[n13];
        n10 = 0;
        while (n10 < n13) {
            cArray4[n10] = (char)n12;
            ++n10;
        }
        n11 = this.mapStore.size();
        n10 = 0;
        while (n10 < n11) {
            cArray = (char[])this.mapStore.elementAt(n10);
            c3 = cArray[1];
            if (c3 != n12) {
                c2 = cArray[0];
                n4 = c2 >> n6 & n7;
                n3 = c2 & n8;
                int n16 = cArray2[n4] + n3;
                cArray4[n16] = c3;
            }
            ++n10;
        }
        this.setArray2(cArray4);
        this.setArray(cArray2);
    }

    void finish() {
        this.buildMapping();
    }

    boolean set(int n2, int n3) throws IOException {
        if (n2 > 65535 || n3 > 65535) {
            if (n2 > 65535) {
                this.printErrorMsg("***** Error: source code point " + MappingSetter.intToHex8(n2) + " is too big for 1-2 byte converter");
            }
            if (n3 > 65535) {
                this.printErrorMsg("***** Error: target code point " + MappingSetter.intToHex8(n3) + " is too big for 1-2 byte converter");
            }
            return false;
        }
        char[] cArray = new char[]{(char)n2, (char)n3};
        this.mapStore.addElement(cArray);
        return true;
    }

    void setArray(char[] cArray) {
        int n2 = cArray.length;
        this.m_charConv.m_ucsCharLevel1 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_charConv.m_ucsCharLevel1[n3] = cArray[n3];
            ++n3;
        }
    }

    void setArray2(char[] cArray) {
        int n2 = cArray.length;
        this.m_charConv.m_ucsCharLevel2 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_charConv.m_ucsCharLevel2[n3] = cArray[n3];
            ++n3;
        }
    }
}

