/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;

abstract class LCMapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    static final int LCWIDTH = 16;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    int m_l1KeyWidth;
    int m_l1BlockSize;
    int m_ucsReplacement;
    char[] m_leadingCode;
    int m_lcCount;
    Vector[] m_mapStores;

    LCMapSetter(int n2, int n3, int n4) {
        super(n2);
        this.m_l1KeyWidth = n3;
        this.m_l1BlockSize = 1 << n3;
        this.m_ucsReplacement = n4;
        this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        this.m_mapStores = new Vector[this.m_leadingCode.length];
        this.m_lcCount = 0;
    }

    void buildMapping() {
        int n2;
        int n3;
        int n4;
        char c2;
        char c3;
        char[] cArray;
        int n5;
        Vector vector;
        int n6;
        int n7 = this.m_l1KeyWidth;
        int n8 = 16 - n7;
        int n9 = (1 << n7) - 1;
        int n10 = (1 << n8) - 1;
        int n11 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray2 = new char[n11];
        char[][] cArray3 = new char[n11][2];
        int n12 = 0;
        while (n12 < n11) {
            cArray2[n12] = '\u0000';
            cArray3[n12][0] = (char)n10;
            cArray3[n12][1] = '\u0000';
            ++n12;
        }
        int n13 = this.m_ucsReplacement;
        int n14 = 0;
        while (n14 < this.m_lcCount) {
            n6 = this.m_l1BlockSize * n14;
            vector = this.m_mapStores[n14];
            n5 = vector.size();
            n12 = 0;
            while (n12 < n5) {
                cArray = (char[])vector.elementAt(n12);
                c3 = cArray[1];
                if (c3 != n13) {
                    c2 = cArray[0];
                    n4 = (c2 >> n8 & n9) + n6;
                    cArray2[n4] = '\u0001';
                    n3 = c2 & n10;
                    if (n3 < cArray3[n4][0]) {
                        cArray3[n4][0] = (char)n3;
                    }
                    if (n3 > cArray3[n4][1]) {
                        cArray3[n4][1] = (char)n3;
                    }
                }
                ++n12;
            }
            ++n14;
        }
        int n15 = n2 = n10 + 1;
        int n16 = 0;
        n12 = 0;
        while (n12 < n11) {
            if (cArray2[n12] != '\u0000') {
                int n17 = cArray3[n12][0];
                cArray2[n12] = (char)(n15 - (n16 < n17 ? n16 : n17));
                n15 = cArray2[n12] + n2;
                n16 = n2 - cArray3[n12][1] - 1;
            }
            ++n12;
        }
        char[] cArray4 = new char[n15];
        n12 = 0;
        while (n12 < n15) {
            cArray4[n12] = (char)n13;
            ++n12;
        }
        n14 = 0;
        while (n14 < this.m_lcCount) {
            n6 = this.m_l1BlockSize * n14;
            vector = this.m_mapStores[n14];
            n5 = vector.size();
            n12 = 0;
            while (n12 < n5) {
                cArray = (char[])vector.elementAt(n12);
                c3 = cArray[1];
                if (c3 != n13) {
                    c2 = cArray[0];
                    n4 = (c2 >> n8 & n9) + n6;
                    n3 = c2 & n10;
                    int n18 = cArray2[n4] + n3;
                    cArray4[n18] = c3;
                }
                ++n12;
            }
            ++n14;
        }
        this.setArray2(cArray4);
        this.setArray(cArray2);
        this.setLCTable();
    }

    void finish() {
        this.buildMapping();
        super.finish();
    }

    boolean set(int n2, int n3) throws IOException {
        Vector<char[]> vector;
        int n4 = n2 >> 16 & 0xFFFF;
        int n5 = -1;
        int n6 = 0;
        while (n6 < this.m_lcCount) {
            if (n4 == this.m_leadingCode[n6]) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n5 == -1) {
            if (n6 < this.m_leadingCode.length) {
                this.m_leadingCode[n6] = (char)n4;
                n5 = n6;
                this.m_lcCount = n6 + 1;
            } else {
                this.printErrorMsg("***** Error: too many leading codes: " + MappingSetter.intToHex8(n4));
                return false;
            }
        }
        if ((vector = this.m_mapStores[n6]) == null) {
            this.m_mapStores[n6] = vector = new Vector<char[]>();
        }
        char[] cArray = new char[]{(char)n2, (char)n3};
        vector.addElement(cArray);
        return true;
    }

    abstract void setArray(char[] var1);

    abstract void setArray2(char[] var1);

    abstract void setLCTable();
}

