/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;

public abstract class TransformerFactory {
    private static String FACTORY_PROPERTY = "javax.xml.transform.TransformerFactory";
    private static String DEFAULT_FACTORY = "com.caucho.xsl.Xsl";
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;

    protected TransformerFactory() {
    }

    public static TransformerFactory newInstance() throws TransformerFactoryConfigurationError {
        String className = TransformerFactory.getFactoryClassName();
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            cl = Class.forName(className, false, loader);
        }
        catch (NoSuchMethodError e2) {
        }
        catch (ClassNotFoundException e3) {
            throw new TransformerFactoryConfigurationError(e3);
        }
        if (cl == null) {
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException e4) {
                throw new TransformerFactoryConfigurationError(e4);
            }
        }
        try {
            return (TransformerFactory)cl.newInstance();
        }
        catch (IllegalAccessException e5) {
            throw new TransformerFactoryConfigurationError(e5);
        }
        catch (InstantiationException e6) {
            throw new TransformerFactoryConfigurationError(e6);
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public abstract boolean getFeature(String var1);

    public abstract ErrorListener getErrorListener();

    public abstract void setErrorListener(ErrorListener var1);

    public abstract URIResolver getURIResolver();

    public abstract void setURIResolver(URIResolver var1);

    public abstract Source getAssociatedStylesheet(Source var1, String var2, String var3, String var4) throws TransformerConfigurationException;

    public abstract Templates newTemplates(Source var1) throws TransformerConfigurationException;

    public abstract Transformer newTransformer() throws TransformerConfigurationException;

    public abstract Transformer newTransformer(Source var1) throws TransformerConfigurationException;

    private static String getFactoryClassName() {
        String className = null;
        try {
            className = System.getProperty(FACTORY_PROPERTY);
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        if (className != null && !className.equals("")) {
            return className;
        }
        try {
            String javaHome = System.getProperty("java.home");
            String sep = File.separator;
            String jaxpFile = javaHome + sep + "lib" + sep + "jaxp.properties";
            FileInputStream is = new FileInputStream(jaxpFile);
            Properties props = new Properties();
            props.load(is);
            is.close();
            className = props.getProperty(FACTORY_PROPERTY);
            if (className != null && !className.equals("")) {
                return className;
            }
        }
        catch (Exception e3) {
            // empty catch block
        }
        String jaxpService = "META-INF/services/" + FACTORY_PROPERTY;
        try {
            ClassLoader loader = (class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = TransformerFactory.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).getClassLoader();
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (NoSuchMethodError e4) {
                // empty catch block
            }
            InputStream is = loader != null ? loader.getResourceAsStream(jaxpService) : ClassLoader.getSystemResourceAsStream(jaxpService);
            StringBuffer sb2 = new StringBuffer();
            int ch = is.read();
            while (ch > 0 && ch != 10 && ch != 13) {
                sb2.append((char)ch);
                ch = is.read();
            }
            is.close();
            className = sb2.toString().trim();
            if (className != null && !className.equals("")) {
                return className;
            }
        }
        catch (Exception e5) {}
        return DEFAULT_FACTORY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

