/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParser {
    public abstract Parser getParser() throws SAXException;

    public abstract Object getProperty(String var1) throws SAXNotRecognizedException;

    public abstract void setProperty(String var1, Object var2) throws SAXNotRecognizedException;

    public abstract XMLReader getXMLReader() throws SAXException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public void parse(File file, DefaultHandler handler) throws SAXException, IOException {
        this.parse(new InputSource(this.normalizeFilename(file)), handler);
    }

    public void parse(File file, HandlerBase base) throws SAXException, IOException {
        this.parse(new InputSource(this.normalizeFilename(file)), base);
    }

    private String normalizeFilename(File file) {
        String path = file.getAbsolutePath();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("file:");
        if (!path.startsWith("/")) {
            sbuf.append('/');
        }
        int i2 = 0;
        while (i2 < path.length()) {
            char ch = path.charAt(i2);
            if (ch == '\\') {
                if (i2 != 0) {
                    sbuf.append('/');
                }
            } else {
                sbuf.append(ch);
            }
            ++i2;
        }
        return sbuf.toString();
    }

    public void parse(InputStream stream, DefaultHandler handler) throws SAXException, IOException {
        this.parse(new InputSource(stream), handler);
    }

    public void parse(InputStream stream, HandlerBase base) throws SAXException, IOException {
        this.parse(new InputSource(stream), base);
    }

    public void parse(InputStream stream, DefaultHandler handler, String systemId) throws SAXException, IllegalArgumentException, IOException {
        InputSource source = new InputSource(stream);
        source.setSystemId(systemId);
        this.parse(source, handler);
    }

    public void parse(InputStream stream, HandlerBase base, String systemId) throws SAXException, IllegalArgumentException, IOException {
        InputSource source = new InputSource(stream);
        source.setSystemId(systemId);
        this.parse(source, base);
    }

    public void parse(String uri, DefaultHandler handler) throws SAXException, IOException {
        this.parse(new InputSource(uri), handler);
    }

    public void parse(String uri, HandlerBase base) throws SAXException, IOException {
        this.parse(new InputSource(uri), base);
    }

    public void parse(InputSource source, DefaultHandler handler) throws SAXException, IOException {
        XMLReader reader = this.getXMLReader();
        reader.setContentHandler(handler);
        reader.setDTDHandler(handler);
        reader.setEntityResolver(handler);
        reader.setErrorHandler(handler);
        reader.parse(source);
    }

    public void parse(InputSource source, HandlerBase base) throws SAXException, IOException {
        Parser parser = this.getParser();
        parser.setDocumentHandler(base);
        parser.setDTDHandler(base);
        parser.setEntityResolver(base);
        parser.setErrorHandler(base);
        parser.parse(source);
    }
}

