/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

public class Cookie
implements Cloneable {
    private String key;
    private String value;
    private String comment;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private String name;
    private String domain;
    private int version = 0;
    private static boolean[] validChar = new boolean[128];

    public Cookie(String name, String value) {
        int length = name.length();
        int i2 = length - 1;
        while (i2 >= 0) {
            char ch = name.charAt(i2);
            if (ch >= '\u007f' || !validChar[ch]) {
                throw new IllegalArgumentException("illegal cookie name: " + name);
            }
            if (ch == '$' && i2 == 0) {
                throw new IllegalArgumentException("cookie can't start with '$'");
            }
            --i2;
        }
        this.name = name;
        this.value = value;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("[Cookie " + this.name + "=" + this.value);
        if (this.path != null) {
            sb2.append(" path=" + this.path);
        }
        if (this.domain != null) {
            sb2.append(" domain=" + this.domain);
        }
        if (this.maxAge > 0) {
            sb2.append(" max-age=" + this.maxAge);
        }
        if (this.secure) {
            sb2.append(" secure");
        }
        sb2.append("]");
        return sb2.toString();
    }

    static {
        int i2 = 33;
        while (i2 < 127) {
            Cookie.validChar[i2] = true;
            ++i2;
        }
        Cookie.validChar[44] = false;
        Cookie.validChar[59] = false;
    }
}

