/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.utils;

import com.sybase.jdbc3.utils.CacheChunk;
import com.sybase.jdbc3.utils.CacheManager;
import java.io.IOException;
import java.io.InputStream;

public class CacheStream
extends InputStream {
    private static final int LOW_BYTE = 255;
    CacheManager _cm;
    InputStream _is;
    boolean _dead = false;
    boolean _rewindable = true;
    private boolean _reset = false;
    CacheChunk _first = null;
    CacheChunk _last = null;
    CacheChunk _current = null;
    int _timeout;
    int _nextByte = 0;

    public CacheStream(CacheManager cacheManager, InputStream inputStream, int n2) {
        this._cm = cacheManager;
        this._is = inputStream;
        this._timeout = n2;
    }

    public synchronized int read() throws IOException {
        int n2;
        this.checkMe();
        if (this._current == null || this._nextByte == this._current._length && this._current._next == null && this._current._length == this._current._buf.length) {
            this.addChunk(1);
        } else if (this._nextByte == this._current._length && this._current._next != null) {
            this._current = this._current._next;
            this._nextByte = 0;
        }
        if (this._nextByte == this._current._length) {
            n2 = this._is.read();
            if (n2 == -1) {
                return -1;
            }
            ++this._current._length;
            this._current._buf[this._nextByte] = (byte)(n2 & 0xFF);
        }
        n2 = this._current._buf[this._nextByte++] & 0xFF;
        return n2;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkMe();
        int n4 = n3;
        while (n4 > 0) {
            int n5;
            if (this._current == null) {
                this.addChunk(n4);
            } else if (this._nextByte == this._current._length) {
                if (this._current._length == this._current._buf.length && this._current._next == null) {
                    this.addChunk(n4);
                } else if (this._current._next != null) {
                    this._current = this._current._next;
                    this._nextByte = 0;
                }
            }
            int n6 = this._current._length - this._nextByte;
            int n7 = n5 = n4 < n6 ? n4 : n6;
            if (n6 == 0) {
                int n8 = this._current._buf.length - this._current._length;
                n5 = n8 > n4 ? n4 : n8;
                n5 = this._is.read(this._current._buf, this._current._length, n5);
                this._current._length += n5;
            }
            System.arraycopy(this._current._buf, this._nextByte, byArray, n2, n5);
            n2 += n5;
            n4 -= n5;
            this._nextByte += n5;
        }
        return n3;
    }

    public synchronized int available() throws IOException {
        this.checkMe();
        if (this._current == null) {
            return 0;
        }
        CacheChunk cacheChunk = this._current;
        int n2 = cacheChunk._buf.length - this._nextByte;
        while (cacheChunk._next != null) {
            cacheChunk = cacheChunk._next;
            n2 += cacheChunk._buf.length;
        }
        return n2;
    }

    public synchronized long skip(long l2) throws IOException {
        this.checkMe();
        int n2 = 0;
        long l3 = l2;
        while (l3 > 0L) {
            if (this._current != null) {
                int n3 = this._current._length - this._nextByte;
                if ((long)n3 <= l3) {
                    this._current = this._current._next;
                    this._nextByte = 0;
                    ++n2;
                    l3 -= (long)n3;
                    continue;
                }
                this._nextByte = (int)((long)this._nextByte + l3);
                break;
            }
            this._rewindable = false;
            l3 -= this._is.skip(l3);
        }
        return l2;
    }

    public synchronized void close() throws IOException {
        this.checkMe();
        this._dead = true;
        this._cm.putChunks(this._first);
        this._first = null;
        this._current = null;
        this._last = null;
        this._is = null;
    }

    public synchronized void reset() throws IOException {
        this.checkMe();
        if (!this._rewindable) {
            CacheManager.raiseIOException("IO_NOT_RESETABLE");
        }
        this._current = this._first;
        this._nextByte = 0;
        this._reset = true;
    }

    public long cacheSize() {
        int n2 = 0;
        CacheChunk cacheChunk = this._first;
        while (cacheChunk != null) {
            n2 += cacheChunk._length;
            cacheChunk = cacheChunk._next;
        }
        return n2;
    }

    private void addChunk(int n2) throws IOException {
        CacheChunk cacheChunk = this._cm.getChunk(n2, this._timeout);
        if (this._last == null) {
            this._first = cacheChunk;
        } else {
            this._last._next = cacheChunk;
        }
        this._last = cacheChunk;
        this._current = cacheChunk;
        this._nextByte = 0;
    }

    private void checkMe() throws IOException {
        if (this._dead) {
            CacheManager.raiseIOException("IO_CLOSED");
        }
    }
}

