/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.timedio;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.timedio.InStreamMgr;
import com.sybase.jdbc3.timedio.StreamContext;
import com.sybase.jdbc3.utils.Queue;
import com.sybase.jdbc3.utils.SyncObj;
import com.sybase.jdbc3.utils.SyncQueue;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

public class OutStreamMgr {
    private Queue _requestList = new Queue(6, 6);
    private SyncQueue _waitList = new SyncQueue(6, 6);
    private InStreamMgr _inMgr;
    private StreamContext _cancelCtx;
    private StreamContext _cancelledCtx;
    private boolean _serialize = false;
    public Tds _tds;
    public boolean _tracing = false;

    public OutStreamMgr(InStreamMgr inStreamMgr) {
        this._inMgr = inStreamMgr;
        this._inMgr.setOutStreamMgr(this);
        this._cancelCtx = null;
        this._cancelledCtx = null;
    }

    protected SyncQueue getWaitQueue() {
        return this._waitList;
    }

    public boolean getSendLock(StreamContext streamContext) throws SQLException {
        boolean bl = false;
        switch (streamContext._request.giveToMe(streamContext._timeout)) {
            case 13: {
                bl = true;
            }
            case 12: {
                break;
            }
            case 14: {
                ErrorMessage.raiseError("JZ0T4", Integer.toString(streamContext._timeout));
            }
            default: {
                ErrorMessage.raiseError("JZ0T4", Integer.toString(streamContext._timeout));
            }
        }
        return bl;
    }

    protected SyncObj dump() {
        SyncObj syncObj = null;
        return syncObj;
    }

    public void beginRequest(StreamContext streamContext) throws SQLException {
        if (this._serialize) {
            try {
                this._inMgr.cacheResponses(streamContext);
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        streamContext.beginRequest();
        this.queueRequest(streamContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCancelRequest(StreamContext streamContext, StreamContext streamContext2, boolean bl) throws SQLException {
        streamContext2.setState(4);
        Object object = this;
        synchronized (object) {
            boolean bl2 = this._serialize;
            try {
                this._serialize = false;
                this.getSendLock(streamContext2);
                this.beginRequest(streamContext2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                this._serialize = bl2;
            }
        }
        if (bl) {
            object = this._requestList;
            synchronized (object) {
                StreamContext streamContext3 = this._inMgr.currentContext();
                if (streamContext3 != null) {
                    streamContext3.cancelled();
                }
                this._cancelCtx = streamContext2;
                this._cancelledCtx = null;
                this._requestList.reset();
                try {
                    while (true) {
                        if ((streamContext3 = (StreamContext)this._requestList.next()) == streamContext2) {
                            continue;
                        }
                        streamContext3.cancelled();
                        this._requestList.removeElement(streamContext3);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        }
        if (!this.cancelBySpec(streamContext, streamContext2)) {
            if (streamContext._state == 6) {
                object = this;
                synchronized (object) {
                    if (this._cancelledCtx != null) {
                        try {
                            this.wait(streamContext2._timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this._cancelledCtx = null;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelBySpec(StreamContext streamContext, StreamContext streamContext2) throws SQLException {
        Object object = this._requestList;
        synchronized (object) {
            int n2 = 0;
            int n3 = -1;
            this._requestList.reset();
            try {
                while (true) {
                    StreamContext streamContext3;
                    if ((streamContext3 = (StreamContext)this._requestList.next()) == streamContext2) {
                        continue;
                    }
                    if (n3 >= 0) {
                        this._requestList.removeElement(streamContext2);
                        streamContext.setState(6);
                        return false;
                    }
                    if (streamContext3 == streamContext) {
                        n3 = n2;
                        streamContext.cancelled();
                        this._cancelledCtx = streamContext;
                    }
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (n3 == 0) {
                    this._cancelCtx = streamContext2;
                    return true;
                }
                if (n3 < 0) {
                    if (this._inMgr.currentContext() == streamContext && n2 == 0) {
                        this._cancelCtx = streamContext2;
                        streamContext.cancelled();
                        this._cancelledCtx = null;
                        return true;
                    }
                    this._requestList.removeElement(streamContext2);
                    this._cancelledCtx = null;
                    return false;
                }
            }
        }
        this._cancelCtx = streamContext2;
        this._cancelledCtx = streamContext;
        object = this;
        synchronized (object) {
            try {
                this.wait(this._cancelCtx._timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._cancelledCtx = null;
        return true;
    }

    public void queueRequest(StreamContext streamContext) {
        this._requestList.push(streamContext);
    }

    public void endRequest(StreamContext streamContext) {
        if (this._cancelCtx != null) {
            this._cancelCtx = null;
            this._cancelledCtx = null;
        }
        streamContext._request.giveToNext();
    }

    public void abortRequest(StreamContext streamContext) {
        streamContext._request.giveToNext();
        this._requestList.removeElement(streamContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamContext getNextContext() {
        StreamContext streamContext = (StreamContext)this._requestList.popNoEx();
        if (this._cancelledCtx == streamContext) {
            OutStreamMgr outStreamMgr = this;
            synchronized (outStreamMgr) {
                this.notify();
                this._cancelledCtx = null;
            }
        }
        return streamContext;
    }

    protected StreamContext peekNextContext() throws EmptyStackException {
        return (StreamContext)this._requestList.peek();
    }

    protected void setSerialize(boolean bl) {
        this._serialize = bl;
    }
}

