/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.JdbcDataObject;
import com.sybase.jdbc3.jdbc.TextPointer;
import com.sybase.jdbc3.tds.TdsDataOutputStream;
import com.sybase.jdbc3.tds.TdsParam;
import com.sybase.jdbc3.utils.CacheManager;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsUpdateParam
extends TdsParam
implements JdbcDataObject {
    public TdsUpdateParam(TdsDataOutputStream tdsDataOutputStream, CacheManager cacheManager) {
        super(tdsDataOutputStream);
    }

    public boolean isNull() throws SQLException {
        if (this._sqlType == -999 || this._sqlType == -998) {
            ErrorMessage.raiseError("JZ0TC");
        }
        return this._sqlType == 0;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToReader(this._inValue);
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public byte[] getBytes() throws SQLException {
        this.checkStream(false);
        return Convert.objectToBytes(this._inValue);
    }

    public DateObject getDateObject(int n2, Calendar calendar) throws SQLException {
        this.checkStream(false);
        return Convert.objectToDateObject(this._inValue, calendar);
    }

    public TextPointer getTextPtr() throws SQLException {
        ErrorMessage.raiseError("JZ0R4");
        return null;
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkStream(false);
        BigDecimal bigDecimal = Convert.objectToBigDecimal(this._inValue);
        return Convert.setScale(bigDecimal, n2);
    }

    public boolean getBoolean() throws SQLException {
        this.checkStream(true);
        return Convert.objectToBoolean(this._inValue);
    }

    public byte getByte() throws SQLException {
        this.checkStream(true);
        long l2 = Convert.objectToLongValue(this._inValue);
        Convert.checkByteOflo(l2);
        return (byte)l2;
    }

    public double getDouble() throws SQLException {
        this.checkStream(true);
        return Convert.objectToDoubleValue(this._inValue);
    }

    public float getFloat() throws SQLException {
        this.checkStream(true);
        return (float)Convert.objectToDoubleValue(this._inValue);
    }

    public int getInt() throws SQLException {
        this.checkStream(true);
        long l2 = Convert.objectToLongValue(this._inValue);
        Convert.checkIntOflo(l2);
        return (int)l2;
    }

    public long getLong() throws SQLException {
        this.checkStream(true);
        return Convert.objectToLongValue(this._inValue);
    }

    public Object getObject() throws SQLException {
        this.checkStream(false);
        return this._inValue;
    }

    public short getShort() throws SQLException {
        this.checkStream(true);
        long l2 = Convert.objectToLongValue(this._inValue);
        Convert.checkShortOflo(l2);
        return (short)l2;
    }

    public String getString() throws SQLException {
        this.checkStream(false);
        return Convert.objectToString(this._inValue);
    }

    private void checkStream(boolean bl) throws SQLException {
        if (this._inValue == null) {
            if (bl) {
                ErrorMessage.raiseError("JZ0TC");
            }
        } else if (this._inValue instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
    }
}

