/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.JdbcDataObject;
import com.sybase.jdbc3.jdbc.ProtocolResultSet;
import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.RowFormatToken;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataObject;
import com.sybase.jdbc3.tds.TdsInt;
import com.sybase.jdbc3.tds.TdsJdbcInputStream;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import com.sybase.jdbc3.tds.TdsReal;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class TdsResultSet
implements ProtocolResultSet {
    protected static final int TYPE_TDSRESULTSET = 1;
    protected static final int TYPE_TDSPARAMSET_EED = 2;
    protected static final int TYPE_TDSPARAMSET_EVENT = 3;
    protected TdsProtocolContext _tpc = null;
    protected int _rowCount = 0;
    protected boolean _needNext = true;
    protected SQLWarning _warning;
    protected TdsDataObject[] _columns;
    protected int _tdsResultSetType = 1;
    protected RowFormatToken _rowfmt;
    protected int _totalColumns = -1;
    protected Vector _cachedRows = null;
    protected int _rowIndex = 0;
    protected boolean _dead = false;
    protected int _type = 1003;
    protected boolean _scrolling = false;
    protected boolean _serverSideScrolling = false;
    protected TdsDataObject[] _savedCols = null;
    protected int _lastFetchSize = 1;

    protected TdsResultSet(TdsProtocolContext tdsProtocolContext) throws SQLException {
        this._tpc = tdsProtocolContext;
        this._rowfmt = tdsProtocolContext.getFormat();
        this._rowfmt.setPc(tdsProtocolContext);
        this._totalColumns = this._rowfmt._numColumns;
        this._columns = new TdsDataObject[this._totalColumns];
        TdsDataObject tdsDataObject = null;
        try {
            for (int i2 = 0; i2 < this._totalColumns; ++i2) {
                DataFormat dataFormat = this._rowfmt.getDataFormat(i2);
                switch (dataFormat._datatype) {
                    case 38: 
                    case 48: 
                    case 52: 
                    case 56: {
                        this._columns[i2] = new TdsInt(tdsProtocolContext);
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        this._columns[i2] = new TdsReal(tdsProtocolContext);
                        break;
                    }
                    default: {
                        this._columns[i2] = new TdsJdbcInputStream(tdsProtocolContext, (Tds)tdsProtocolContext._protocol);
                    }
                }
                this._columns[i2]._dataFmt = dataFormat;
                this._columns[i2].setPrevious(tdsDataObject);
                if (tdsDataObject != null) {
                    tdsDataObject.setNext(this._columns[i2]);
                }
                tdsDataObject = this._columns[i2];
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    protected RowFormatToken getFormat() {
        return this._tpc._paramFmts;
    }

    public void setType(int n2) {
        this._type = n2;
        if (this._type == 1004) {
            this._cachedRows = new Vector();
            this._scrolling = true;
        }
    }

    public int getType() {
        return this._type;
    }

    public void setLastFetchSize(int n2) {
        this._lastFetchSize = n2;
    }

    public int getLastFetchSize() {
        return this._lastFetchSize;
    }

    public boolean previous() throws SQLException {
        --this._rowIndex;
        if (this._rowIndex != 0) {
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
        }
        return false;
    }

    public boolean absolute(int n2) throws SQLException {
        if (this._rowIndex != n2 && n2 != 0) {
            this._rowIndex = n2;
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
        }
        return false;
    }

    public boolean relative(int n2) throws SQLException {
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isResultSetEmpty() throws SQLException {
        return false;
    }

    public int getRowNumber() throws SQLException {
        return -1;
    }

    public int getNumRowsCached() {
        return this._scrolling ? this._cachedRows.size() : 0;
    }

    public boolean next() throws SQLException {
        int n2;
        if (this._scrolling) {
            if (this._rowIndex < this._cachedRows.size()) {
                ++this._rowIndex;
                this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
                return true;
            }
            if (this._dead) {
                ++this._rowIndex;
                return false;
            }
        }
        if (!this._needNext) {
            this._tpc._lastResult = -1;
            try {
                if (this._scrolling) {
                    this._columns = this._savedCols;
                }
                for (n2 = 0; n2 < this._totalColumns; ++n2) {
                    this._columns[n2].clear();
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        n2 = this.nextResult();
        switch (n2) {
            case 209: {
                ++this._rowIndex;
                ++this._rowCount;
                if (this._scrolling) {
                    this.cacheCurrentRow();
                }
                this._needNext = false;
                return true;
            }
            case 5: {
                this._rowCount = this._tpc._protocol.count(this._tpc);
                ++this._rowIndex;
                this.markDead();
                return false;
            }
        }
        this._tpc._protocol.ungetResult(this._tpc, n2);
        this.markDead();
        return false;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rowfmt;
    }

    protected synchronized void markDead() {
        this._dead = true;
    }

    public void close(boolean bl) throws SQLException {
        if (this._dead) {
            if (this._tpc._cursor == null) {
                switch (this._tdsResultSetType) {
                    case 1: {
                        this._tpc._trs = null;
                        break;
                    }
                    case 2: {
                        this._tpc._trsForEed = null;
                        break;
                    }
                    case 3: {
                        this._tpc._trsForEvent = null;
                    }
                }
            }
            return;
        }
        if (this._scrolling) {
            this._scrolling = false;
            this._columns = this._savedCols;
        }
        if (!bl) {
            while (this.next()) {
            }
        }
        if (this._tpc._cursor == null) {
            switch (this._tdsResultSetType) {
                case 1: {
                    this._tpc._trs = null;
                    break;
                }
                case 2: {
                    this._tpc._trsForEed = null;
                    break;
                }
                case 3: {
                    this._tpc._trsForEvent = null;
                }
            }
        }
        this.markDead();
    }

    public int getCount() throws SQLException {
        return this._rowCount;
    }

    public JdbcDataObject getColumn(int n2) throws SQLException {
        int n3 = this._rowfmt.mapColumn(n2);
        return this._columns[n3];
    }

    public int findColumn(String string) throws SQLException {
        int n2 = 0;
        for (int i2 = 0; i2 < this._rowfmt._numColumns; ++i2) {
            if ((this._rowfmt.getStatus(i2) & 1) != 0) continue;
            ++n2;
            if (!this._rowfmt.getName(i2).equalsIgnoreCase(string)) continue;
            return n2;
        }
        ErrorMessage.raiseError("S0022", string);
        return -1;
    }

    public int findColumnByLabel(String string) throws SQLException {
        int n2 = 0;
        for (int i2 = 0; i2 < this._rowfmt._numColumns; ++i2) {
            if ((this._rowfmt.getStatus(i2) & 1) != 0) continue;
            ++n2;
            if (!this._rowfmt.getLabel(i2).equalsIgnoreCase(string)) continue;
            return n2;
        }
        ErrorMessage.raiseError("S0022", string);
        return -1;
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        sQLWarning = !bl ? (SQLWarning)sQLException : SybConnection.getAllTheWarnings(sQLException);
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl) {
            throw sQLException;
        }
    }

    protected int nextResult() throws SQLException {
        int n2;
        while (true) {
            try {
                n2 = this._tpc._protocol.nextResult(this._tpc);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                continue;
            }
            break;
        }
        return n2;
    }

    protected void prepareForNextFetch() {
        this._needNext = true;
        if (this._scrolling) {
            if (this._rowIndex != 0) {
                --this._rowIndex;
            }
            this._dead = false;
        }
    }

    protected void cacheCurrentRow() throws SQLException {
        TdsDataObject[] tdsDataObjectArray = new TdsDataObject[this._totalColumns];
        try {
            for (int i2 = 0; i2 < this._totalColumns; ++i2) {
                tdsDataObjectArray[i2] = this._columns[i2].createCachedCopy();
            }
            this._cachedRows.insertElementAt(tdsDataObjectArray, this._rowIndex - 1);
            this._savedCols = this._columns;
            this._columns = tdsDataObjectArray;
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ006", iOException.getMessage());
        }
    }

    protected void dump() {
    }
}

