/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.jdbc.SybResultSet;
import com.sybase.jdbc3.tds.DoneToken;
import com.sybase.jdbc3.tds.PduInputFormatter;
import com.sybase.jdbc3.tds.RowFormatToken;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsCursor;
import com.sybase.jdbc3.tds.TdsDataInputStream;
import com.sybase.jdbc3.tds.TdsEventContext;
import com.sybase.jdbc3.tds.TdsParamSet;
import com.sybase.jdbc3.tds.TdsResultSet;
import com.sybase.jdbc3.tds.Token;
import com.sybase.jdbc3.timedio.InStreamMgr;
import com.sybase.jdbc3.timedio.OutStreamMgr;
import com.sybase.jdbc3.timedio.StreamContext;
import com.sybase.jdbc3.utils.BufferInterval;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.SyncObj;
import java.io.IOException;
import java.sql.SQLException;

public class TdsProtocolContext
extends StreamContext {
    protected static final int COLUMN_CHUNK_SIZE = 256;
    protected static final int LOW_BYTE = 255;
    protected static final int DONE_PACKET_SIZE = 17;
    protected static final int PDU_TAIL_SIZE = 8;
    protected Token _tdsToken;
    protected boolean _haveDone;
    protected int _lastResult;
    protected int _ungotResult;
    protected int _maxRows;
    protected int _lastTds;
    protected RowFormatToken _paramFmts;
    protected RowFormatToken _paramFmtsForEed;
    protected RowFormatToken _paramFmtsForEvent;
    protected RowFormatToken _dynamicFmts;
    protected boolean _rereadable;
    protected TdsResultSet _trs;
    protected TdsResultSet _trsForEed;
    protected TdsResultSet _trsForEvent;
    protected CacheManager _cm;
    protected PduInputFormatter _inFormat = new PduInputFormatter(this);
    protected TdsDataInputStream _in;
    public SQLException _chainedSqe;
    protected boolean _eed = false;
    protected boolean _event = false;
    protected TdsCursor _cursor;
    boolean _bigEndian = true;
    private byte[] _endOfLastPDU = null;

    public TdsProtocolContext(Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) {
        super(protocol, inStreamMgr, outStreamMgr);
        Tds tds = (Tds)protocol;
        try {
            this._in = new TdsDataInputStream(tds, this._inFormat);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._bigEndian = tds._bigEndian;
        this._in.setBigEndian(this._bigEndian);
        this._is = this._in;
        this.clear(true);
        this._pduState = 0;
    }

    public void drop() {
        this.close(true);
        ((Tds)this._protocol).removeProtocolContext(this);
    }

    protected synchronized boolean isCancelNeeded() {
        if (this._state == 2) {
            return true;
        }
        this.cancelled();
        return false;
    }

    protected synchronized void cancelled() {
        switch (this._state) {
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                this.setState(5);
            }
            case 5: 
            case 6: {
                this._responseQue.release();
            }
        }
    }

    protected void beginRequest() {
        this.close(true);
        this._pduState = 5;
        if (this._state != 4) {
            this.setState(2);
        }
        if (this._timeout > 0) {
            this._requestStartTime = System.currentTimeMillis();
        }
    }

    protected void close(boolean bl) {
        SQLException sQLException = this._chainedSqe;
        this._inFormat.close();
        this.clear(bl);
        this._chainedSqe = sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferInterval queueData(BufferInterval bufferInterval) {
        this._pduState = 1;
        int n2 = bufferInterval._offset;
        int n3 = bufferInterval._length;
        byte[] byArray = bufferInterval._buf;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n3 > 0) {
            int n7 = n2;
            if (this._state == 5) {
                this._pduState = 0;
                this._responseQue.release();
                break;
            }
            if (n3 < 8) {
                this._pduState = 2;
                break;
            }
            n7 = n2;
            n4 = byArray[n7++] & 0xFF;
            n5 = byArray[n7++] & 0xFF;
            if (n3 >= (n6 = ((byArray[n7++] & 0xFF) << 8) + (0xFF & byArray[n7++]))) {
                n3 -= n6;
                n2 += n6;
            } else {
                this._pduState = 2;
                break;
            }
            if (this.checkBufStat(n5)) break;
            boolean bl = (n5 & 1) != 0;
            boolean bl2 = false;
            boolean bl3 = false;
            TdsProtocolContext tdsProtocolContext = this;
            synchronized (tdsProtocolContext) {
                if ((n5 & 2) != 0) {
                    bl = true;
                    bl3 = true;
                    if (this._state != 5 && this._state != 4) {
                        this.cancelled();
                    }
                }
                boolean bl4 = bl3;
                if (bl) {
                    int n8 = DoneToken.getStatusOffset(this._bigEndian);
                    if (n6 >= 9 - n8 && !bl4) {
                        bl4 = (byArray[n2 - 9 + n8] & 0x20) != 0;
                    }
                    Tds tds = (Tds)this._protocol;
                    if (this._state == 4) {
                        if (n6 < 17 && !bl3) {
                            if (this._endOfLastPDU == null) {
                                bl2 = true;
                            } else {
                                int n9 = 8 - (9 - (n6 - 8));
                                if (n9 + n8 < 8 && !bl3) {
                                    boolean bl5 = bl4 = (this._endOfLastPDU[n9 + n8] & 0x20) != 0;
                                }
                                if (bl4) {
                                    BufferInterval bufferInterval2 = this._inMgr.getBI();
                                    n7 = bufferInterval2._offset;
                                    bufferInterval2._buf[n7++] = (byte)(n4 & 0xFF);
                                    bufferInterval2._buf[n7++] = (byte)(n5 & 0xFF);
                                    bufferInterval2._buf[n7++] = 0;
                                    bufferInterval2._buf[n7++] = 17;
                                    bufferInterval2._buf[n7++] = 0;
                                    bufferInterval2._buf[n7++] = 0;
                                    bufferInterval2._buf[n7++] = 0;
                                    bufferInterval2._buf[n7++] = 0;
                                    int n10 = 8 - n9;
                                    System.arraycopy(this._endOfLastPDU, n9, bufferInterval2._buf, n7, n10);
                                    System.arraycopy(bufferInterval._buf, n2 - (9 - n10), bufferInterval2._buf, n7 += n10, 9 - n10);
                                    bufferInterval2._length = 17;
                                    bufferInterval.free();
                                    bufferInterval = bufferInterval2;
                                    n6 = 17;
                                    this._endOfLastPDU = null;
                                }
                            }
                        } else if (n6 > 17 && bl4) {
                            n7 = n2 - 17;
                            byArray[n7++] = (byte)(n4 & 0xFF);
                            byArray[n7++] = (byte)(n5 & 0xFF);
                            byArray[n7++] = 0;
                            byArray[n7++] = 17;
                            BufferInterval bufferInterval3 = bufferInterval.divide(n6 - 17);
                            bufferInterval3.free();
                            n6 = 17;
                        }
                        if (!bl4) {
                            bl2 = true;
                        }
                    } else if (this._state == 6) {
                        this.setState(5);
                        bl2 = true;
                    } else {
                        if (bl4 && tds._gotCancelAck) {
                            BufferInterval bufferInterval4 = null;
                            if (n6 < bufferInterval._length) {
                                bufferInterval4 = bufferInterval.divide(n6);
                            } else {
                                bufferInterval4 = bufferInterval;
                                bufferInterval = null;
                            }
                            bufferInterval4.free();
                            break;
                        }
                        this.setState(3);
                    }
                    if (!(this instanceof TdsEventContext)) {
                        tds._gotCancelAck = bl4;
                    }
                } else {
                    if (this._state == 4) {
                        if (this._endOfLastPDU == null) {
                            this._endOfLastPDU = new byte[8];
                        }
                        System.arraycopy(bufferInterval._buf, bufferInterval._offset + n6 - 8, this._endOfLastPDU, 0, 8);
                    }
                    boolean bl6 = bl2 = this._state == 6 || this._state == 4;
                }
                if (bl && (this._state != 4 || bl4)) {
                    this._pduState = 0;
                    if (!(this instanceof TdsEventContext)) {
                        this._inMgr.setCurrentContextNull();
                    }
                }
                bufferInterval = this.makeChunk(bufferInterval, n6, bl2);
                if (bl) {
                    if (this._state == 4 && bl4) {
                        this._responseQue.release();
                    } else if (bl4) {
                        this._pduState = 0;
                        this._responseQue.release();
                    }
                    break;
                }
            }
        }
        return bufferInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferInterval getChunk() throws IOException {
        switch (this._state) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                while (true) {
                    BufferInterval bufferInterval = null;
                    TdsProtocolContext tdsProtocolContext = this;
                    synchronized (tdsProtocolContext) {
                        bufferInterval = this._responseQue.pop();
                        if (bufferInterval == null) {
                            if (this._state == 5 || this._state == 6) {
                                ErrorMessage.raiseIOException("JZ0PA");
                            }
                            if (this._state == 3) {
                                ErrorMessage.raiseIOException("JZ0EM");
                            }
                        } else if (this._state != 5 && this._state != 6) {
                            return bufferInterval;
                        }
                    }
                    if (bufferInterval == null) {
                        this._inMgr.doRead(this);
                        continue;
                    }
                    bufferInterval.free();
                    ErrorMessage.raiseIOException("JZ0PA");
                }
            }
        }
        return null;
    }

    public boolean isProcDone() {
        return (((DoneToken)this._tdsToken)._status & 8) == 8;
    }

    protected boolean checkBufStat(int n2) {
        if ((n2 & 8) != 0) {
            this._pduState = 3;
            return true;
        }
        return false;
    }

    protected int available() {
        return this._responseQue.available(8);
    }

    protected void chainException(SQLException sQLException) {
        if (this._chainedSqe == null) {
            this._chainedSqe = sQLException;
        } else if ("JZ0F2".equals(sQLException.getSQLState())) {
            sQLException.setNextException(this._chainedSqe);
            this._chainedSqe = sQLException;
        } else {
            this._chainedSqe.setNextException(sQLException);
        }
    }

    private void clear(boolean bl) {
        this._chainedSqe = null;
        this._lastResult = -1;
        this._ungotResult = -1;
        this._tdsToken = null;
        this._haveDone = false;
        this._eed = false;
        this._paramFmts = null;
        this._paramFmtsForEed = null;
        this._paramFmtsForEvent = null;
        this._trs = null;
        this._trsForEed = null;
        this._trsForEvent = null;
        if (this._state != 4) {
            if (bl) {
                BufferInterval bufferInterval;
                while ((bufferInterval = this._responseQue.pop()) != null) {
                    bufferInterval.free();
                }
            }
            this.setState(1);
        }
        if (this._cm != null) {
            this._cm.allDead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SybResultSet getParams() {
        SybResultSet sybResultSet = null;
        int n2 = 0;
        SQLException sQLException = this._chainedSqe;
        this._chainedSqe = null;
        try {
            try {}
            catch (SQLException sQLException2) {
                this.chainException(sQLException2);
                Object var6_7 = null;
                if (this._chainedSqe != null) {
                    if (sQLException != null) {
                        sQLException.setNextException(this._chainedSqe);
                    } else {
                        sQLException = this._chainedSqe;
                    }
                }
                this._chainedSqe = sQLException;
                return sybResultSet;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (this._chainedSqe != null) {
                if (sQLException != null) {
                    sQLException.setNextException(this._chainedSqe);
                } else {
                    sQLException = this._chainedSqe;
                }
            }
            this._chainedSqe = sQLException;
            throw throwable;
        }
        block12: while (true) {
            n2 = this._protocol.nextResult(this);
            switch (n2) {
                case 3: {
                    switch (this._lastTds) {
                        case 32: 
                        case 236: {
                            if (this._eed) {
                                this._trsForEed = new TdsParamSet(this, false, 2);
                                sybResultSet = new SybResultSet(null, this._trsForEed);
                            } else if (this._event) {
                                this._trsForEvent = new TdsParamSet(this, false, 3);
                                sybResultSet = new SybResultSet(null, this._trsForEvent);
                            }
                            sybResultSet.setHoldsParams(true);
                            this._lastResult = -1;
                            continue block12;
                        }
                        case 215: {
                            this._lastResult = -1;
                            Object var6_4 = null;
                            if (this._chainedSqe != null) {
                                if (sQLException != null) {
                                    sQLException.setNextException(this._chainedSqe);
                                } else {
                                    sQLException = this._chainedSqe;
                                }
                            }
                            this._chainedSqe = sQLException;
                            return sybResultSet;
                        }
                    }
                    this._protocol.ungetResult(this, this._lastTds);
                    Object var6_5 = null;
                    if (this._chainedSqe != null) {
                        if (sQLException != null) {
                            sQLException.setNextException(this._chainedSqe);
                        } else {
                            sQLException = this._chainedSqe;
                        }
                    }
                    this._chainedSqe = sQLException;
                    return sybResultSet;
                }
                case 0: {
                    this._protocol.ungetResult(this, n2);
                    Object var6_6 = null;
                    if (this._chainedSqe != null) {
                        if (sQLException != null) {
                            sQLException.setNextException(this._chainedSqe);
                        } else {
                            sQLException = this._chainedSqe;
                        }
                    }
                    this._chainedSqe = sQLException;
                    return sybResultSet;
                }
            }
            this._protocol.ungetResult(this, n2);
        }
    }

    protected SybResultSet makeEmptyParams() {
        SybResultSet sybResultSet = null;
        try {
            if (this._eed) {
                this._paramFmtsForEed = new RowFormatToken();
                this._trsForEed = new TdsParamSet(this, true, 2);
                sybResultSet = new SybResultSet(null, this._trsForEed);
            } else if (this._event) {
                this._paramFmtsForEvent = new RowFormatToken();
                this._trsForEvent = new TdsParamSet(this, true, 3);
                sybResultSet = new SybResultSet(null, this._trsForEvent);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sybResultSet;
    }

    protected void setRereadable() {
        this._cm = new CacheManager(this._in);
        this._cm.setReReadable(true);
        this._cm.setCacheSize(-1);
        this._cm.setChunkSize(256);
        this._cm.setAbortOnCacheOverflow(true);
    }

    protected void setState(int n2) {
        super.setState(n2);
    }

    protected void refreshYourself(Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) {
        super.refreshYourself(protocol, inStreamMgr, outStreamMgr);
        this._inFormat = new PduInputFormatter(this);
        Tds tds = (Tds)protocol;
        try {
            this._in = new TdsDataInputStream(tds, this._inFormat);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._bigEndian = tds._bigEndian;
        this._in.setBigEndian(this._bigEndian);
        this.clear(true);
        this._pduState = 0;
    }

    protected RowFormatToken getFormat() {
        if (this._eed) {
            return this._paramFmtsForEed;
        }
        if (this._event) {
            return this._paramFmtsForEvent;
        }
        return this._paramFmts;
    }

    public int getTimeUntilTimeout() throws IOException {
        if (this._timeout == 0) {
            return this._timeout;
        }
        int n2 = this.getTimeLeft();
        if (n2 <= 0) {
            ErrorMessage.raiseIOException("JZ0T3");
        }
        return n2;
    }

    public int getTimeLeft() {
        long l2 = (long)this._timeout - (System.currentTimeMillis() - this._requestStartTime);
        if (l2 == 0L) {
            l2 = -1L;
        }
        return (int)l2;
    }

    protected void dump(SyncObj syncObj, SyncObj syncObj2) {
    }
}

