/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.Param;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.tds.CapabilitySet;
import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataOutputStream;
import com.sybase.jdbc3.tds.TdsJdbcInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsParam
extends Param {
    private static final String NULL = "null";
    private static final String ZERO = "0";
    private static final String QUOTE = "'";
    private static final String HEX_START = "0x";
    private static final String ASCII_ENCODING = "ISO8859_1";
    private static final int DATE = 1;
    private static final int DATETIME = 2;
    protected DataFormat _inDataFmt;
    byte[] _cvtString = null;
    protected String _parameterAsAString = null;
    protected boolean _paramIsLittleEndian = false;
    protected boolean _parameterHoldsUnicharData = false;
    protected TdsDataOutputStream _tdos = null;

    public TdsParam(TdsDataOutputStream tdsDataOutputStream) {
        this._tdos = tdsDataOutputStream;
    }

    protected TdsParam() {
    }

    protected void clear(boolean bl) throws IOException {
        this._sendAsLiteral = false;
        this._cvtString = null;
        this._parameterAsAString = null;
        if (bl) {
            this._sqlType = -999;
            this._regType = -999;
            this._inValue = null;
            this._scale = -999;
        }
        if (this._outValue != null) {
            ((TdsJdbcInputStream)this._outValue).clear();
            this._outValue = null;
        }
    }

    protected void prepareForSend(Protocol protocol, int n2, boolean bl) throws SQLException {
        Tds tds = (Tds)protocol;
        CapabilitySet capabilitySet = tds._capT._reqCaps;
        if (this._sqlType == -999) {
            this._inValue = null;
            this._sqlType = this._regType;
        }
        if (this._sqlType == -999) {
            ErrorMessage.raiseError("JZ0SA", "" + n2);
        }
        switch (this._regType) {
            case -4: {
                if (tds._sendLongAnyway) {
                    this._sendAsLiteral = false;
                }
            }
            case -1: {
                this._sqlType = this._regType;
                break;
            }
        }
        if (!bl && tds._sendLiterals) {
            this._sendAsLiteral = true;
            return;
        }
        boolean bl2 = false;
        switch (this._sqlType) {
            case -5: {
                if (capabilitySet.get(51)) break;
                if (this._inValue != null) {
                    long l2 = (Long)this._inValue;
                    if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE || bl && this._regType != -999) {
                        this._inValue = new BigDecimal(String.valueOf(l2));
                        this._sqlType = 2;
                        if (capabilitySet.get(24)) break;
                        this._sendAsLiteral = true;
                        break;
                    }
                    this._inValue = new Integer((int)l2);
                } else if (bl && this._regType != -999) {
                    this._sqlType = 2;
                    if (capabilitySet.get(24)) break;
                    this._sendAsLiteral = true;
                    break;
                }
                this._sqlType = 4;
            }
            case 4: {
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -7: {
                if (capabilitySet.get(13)) break;
                if (this._inValue != null) {
                    this._inValue = new Integer((Boolean)this._inValue != false ? 1 : 0);
                }
                this._sqlType = -6;
            }
            case -6: {
                if (this._inValue != null && (Integer)this._inValue >= 0 && capabilitySet.get(10)) break;
                this._sqlType = 5;
            }
            case 5: {
                if (capabilitySet.get(11)) break;
                this._sqlType = 4;
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 1: 
            case 12: {
                int[] nArray = new int[4];
                try {
                    this._tdos.convertString(this, nArray);
                    if (this._parameterHoldsUnicharData) {
                        break;
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                if (nArray[1] <= 255) {
                    if (this._sqlType == 1 && capabilitySet.get(14)) break;
                    if (capabilitySet.get(15)) {
                        this._sqlType = 12;
                        break;
                    }
                }
                bl2 = true;
            }
            case -1: {
                int[] nArray;
                if (!bl2 && (this._inValue == null || this._inValue instanceof String)) {
                    nArray = new int[4];
                    try {
                        this._tdos.convertString(this, nArray);
                        if (this._parameterHoldsUnicharData) {
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        ErrorMessage.raiseErrorCheckDead(iOException);
                    }
                    if (capabilitySet.get(28) && this.sendingLongcharIsOK(protocol)) break;
                    if (nArray[1] <= 255) {
                        if (capabilitySet.get(15)) {
                            this._sqlType = 12;
                            break;
                        }
                        if (capabilitySet.get(14)) {
                            this._sqlType = 1;
                            break;
                        }
                        this._sendAsLiteral = true;
                        break;
                    }
                }
                if (this._inValue instanceof InputStream || this._inValue instanceof Reader) {
                    if (this._scale != -1 && this._scale <= 255 && capabilitySet.get(15)) {
                        this._sqlType = 12;
                        break;
                    }
                    if (capabilitySet.get(55)) {
                        this._sqlType = 9219;
                        break;
                    }
                }
                if (capabilitySet.get(28) && this.sendingLongcharIsOK(protocol)) {
                    this._sqlType = -1;
                    break;
                }
                if (capabilitySet.get(55)) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.stringToUnicodeBytes(this._parameterAsAString));
                    if (!this._tdos.getBigEndian()) {
                        this._paramIsLittleEndian = true;
                    }
                    this._sqlType = 9219;
                    this._inValue = byteArrayInputStream;
                    this._scale = this._parameterAsAString.length();
                    break;
                }
                this._sendAsLiteral = true;
                break;
            }
            case -4: {
                if (tds._sendLongAnyway) break;
                if (this._inValue == null) {
                    if (capabilitySet.get(29) && this.sendingLongbinIsOK(protocol)) break;
                    if (capabilitySet.get(17)) {
                        this._sqlType = -3;
                        break;
                    }
                    if (capabilitySet.get(16)) {
                        this._sqlType = -2;
                        break;
                    }
                    this._sendAsLiteral = true;
                    break;
                }
                if (this._inValue instanceof InputStream && capabilitySet.get(57)) {
                    this._sqlType = 9220;
                    break;
                }
                if (capabilitySet.get(29) && this.sendingLongbinIsOK(protocol)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -2: {
                if (capabilitySet.get(16)) break;
                this._sqlType = -3;
            }
            case -3: {
                if (capabilitySet.get(17)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 3: {
                if (capabilitySet.get(27)) break;
                this._sqlType = 2;
            }
            case 2: {
                if (capabilitySet.get(24)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 7: {
                if (capabilitySet.get(22)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 6: 
            case 8: {
                if (capabilitySet.get(23)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 91: {
                if (capabilitySet.get(71)) {
                    if (this._inValue == null) break;
                    this.checkDateRange(1);
                    break;
                }
            }
            case 93: {
                if (!capabilitySet.get(20)) {
                    this._sendAsLiteral = true;
                    break;
                }
                if (this._inValue == null) break;
                this.checkDateRange(2);
                this._sqlType = 93;
                break;
            }
            case 92: {
                if (capabilitySet.get(72)) break;
                if (!capabilitySet.get(20)) {
                    this._sendAsLiteral = true;
                    break;
                }
                this._sqlType = 93;
                break;
            }
            case 2000: {
                if (capabilitySet.get(54) && !this._sendAsLiteral) break;
                ErrorMessage.raiseError("JZ0ST");
                break;
            }
        }
        if (bl && this._sendAsLiteral) {
            ErrorMessage.raiseError("JZ0SM");
        }
    }

    protected void send(OutputStream outputStream, int n2) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            ((TdsDataOutputStream)outputStream).writeParam(this, n2);
        }
    }

    protected int getLength() {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            return this._inDataFmt.length();
        }
        return 0;
    }

    protected boolean makeFormat(Protocol protocol) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt = new DataFormat(this, ((Tds)protocol)._out);
            return true;
        }
        return false;
    }

    protected void sendFormat(DataOutput dataOutput) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt.send((TdsOutputStream)dataOutput);
        }
    }

    public String literalValue(Protocol protocol, int n2, int n3) throws IOException {
        Tds tds = (Tds)protocol;
        switch (this._sqlType) {
            case -7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return (Boolean)this._inValue != false ? "1" : ZERO;
            }
            case -6: 
            case 4: 
            case 5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Integer)this._inValue).toString();
            }
            case -5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Long)this._inValue).toString();
            }
            case 2: 
            case 3: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((BigDecimal)this._inValue).toString();
            }
            case 7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Float)this._inValue).toString();
            }
            case 6: 
            case 8: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer stringBuffer = new StringBuffer("convert(float(32), ");
                stringBuffer.append(((Double)this._inValue).toString());
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            case 91: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                String string = null;
                string = this._tdos._tds.serverAcceptsDateData() ? QUOTE + ((DateObject)this._inValue).format(false, false) + QUOTE : QUOTE + ((DateObject)this._inValue).format(false, true) + QUOTE;
                return string;
            }
            case 92: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                String string = null;
                string = this._tdos._tds.serverAcceptsTimeData() ? QUOTE + ((DateObject)this._inValue).format(true, false) + QUOTE : QUOTE + ((DateObject)this._inValue).format(true, true) + QUOTE;
                return string;
            }
            case 93: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(true, false) + QUOTE;
            }
            case -1: 
            case 1: 
            case 12: {
                int n4;
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                int[] nArray = new int[4];
                this._tdos.convertString(this, nArray);
                if (this._parameterHoldsUnicharData) {
                    return this.literalizeUnicharData();
                }
                StringBuffer stringBuffer = null;
                if (this._inValue instanceof String) {
                    n4 = ((String)this._inValue).length();
                    stringBuffer = new StringBuffer(n4 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(((String)this._inValue).substring(0, n4));
                } else if (this._inValue instanceof InputStream) {
                    n4 = this.getCharCount();
                    stringBuffer = new StringBuffer(n4 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this._parameterAsAString);
                } else if (this._inValue instanceof Reader) {
                    stringBuffer = new StringBuffer(nArray[1] + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this._parameterAsAString);
                }
                n4 = 1;
                int n5 = stringBuffer.length();
                while ((n4 = stringBuffer.toString().indexOf(39, n4)) != -1) {
                    stringBuffer.insert(n4, '\'');
                    if ((n4 += 2) <= ++n5) continue;
                }
                stringBuffer.append(QUOTE);
                return stringBuffer.toString();
            }
            case -4: {
                if (this._parameterHoldsUnicharData && this._sendAsLiteral) {
                    if (this._inValue == null) {
                        return NULL;
                    }
                    return this.literalizeUnicharData();
                }
            }
            case -3: 
            case -2: {
                int n6;
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                if (this._inValue instanceof byte[]) {
                    if (((byte[])this._inValue).length == 0 && this._tdos._tds.serverAcceptsColumnStatusByte()) {
                        return "''";
                    }
                    return HEX_START + HexConverts.hexConvert((byte[])this._inValue);
                }
                InputStream inputStream = (InputStream)this._inValue;
                int n7 = this._scale;
                if (this._scale == -1) {
                    n7 = inputStream.available();
                }
                if (n7 == 0 && this._tdos._tds.serverAcceptsColumnStatusByte()) {
                    return "''";
                }
                byte[] byArray = new byte[n7];
                for (int i2 = 0; i2 < n7 && (n6 = inputStream.read(byArray, i2, n7 - i2)) != -1; i2 += n6) {
                }
                return HEX_START + HexConverts.hexConvert(byArray);
            }
            case 2000: {
                if (!this._sendAsLiteral) break;
                ErrorMessage.raiseIOException("JZ0ST");
            }
        }
        return "@p" + n2;
    }

    protected int getCharCount() throws IOException {
        InputStream inputStream = (InputStream)this._inValue;
        int n2 = this._scale;
        if (this._scale == -1) {
            n2 = inputStream.available();
            n2 /= 2;
        }
        return n2;
    }

    protected String literalizeUnicharData() throws IOException {
        if (this._cvtString.length == 0 && this._tdos._tds.serverAcceptsColumnStatusByte()) {
            return "''";
        }
        return HEX_START + HexConverts.hexConvert(this._cvtString);
    }

    protected String getStringFromStream(int n2) throws IOException {
        int n3;
        int n4;
        InputStream inputStream = (InputStream)this._inValue;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = this._scale;
        if (n5 != -1 && n5 % 2 != 0) {
            --n5;
        }
        while (n5 != 0 && (n4 = inputStream.read()) != -1 && (n3 = inputStream.read()) != -1) {
            char c2 = (char)(n4 << 8 | n3);
            stringBuffer.append(c2);
            n5 -= 2;
        }
        return stringBuffer.toString();
    }

    private boolean sendingLongcharIsOK(Protocol protocol) throws SQLException {
        boolean bl = true;
        int[] nArray = new int[4];
        try {
            this._tdos.convertString(this, nArray);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        int n2 = ((Tds)protocol).getMaxLongvarcharLength();
        if (nArray[1] > n2) {
            bl = false;
        }
        return bl;
    }

    private boolean sendingLongbinIsOK(Protocol protocol) throws SQLException {
        int n2;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = 0;
        if (this._inValue != null) {
            if (this._inValue instanceof byte[]) {
                n3 = ((byte[])this._inValue).length;
            } else if (this._inValue instanceof InputStream) {
                if (this._scale == -1) {
                    bl2 = true;
                } else {
                    n3 = this._scale;
                }
            }
        }
        if (n3 > (n2 = ((Tds)protocol).getMaxLongvarbinaryLength()) || bl2 && n2 != Integer.MAX_VALUE) {
            bl = false;
        }
        return bl;
    }

    private void checkDateRange(int n2) throws SQLException {
        int n3 = ((DateObject)this._inValue).getCalendar().get(1);
        if (n2 == 1) {
            if (n3 < 1 || n3 > 9999) {
                ErrorMessage.raiseError("JZ0SU", String.valueOf(n3), String.valueOf(1), String.valueOf(9999));
            }
        } else if (n3 < 1753 || n3 > 9999) {
            ErrorMessage.raiseError("JZ0SU", String.valueOf(n3), String.valueOf(1753), String.valueOf(9999));
        }
    }

    protected byte[] stringToUnicodeBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = this._tdos.getBigEndian() ? string.getBytes("UnicodeBigUnmarked") : string.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }
}

