/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.DynamicClassLoader;
import com.sybase.jdbc3.jdbc.DynamicObjectInputStream;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.RawInputStream;
import com.sybase.jdbc3.jdbc.RawToAsciiInputStream;
import com.sybase.jdbc3.jdbc.TextPointer;
import com.sybase.jdbc3.jdbc.UnicharToAsciiInputStream;
import com.sybase.jdbc3.jdbc.UnicharToUniInputStream;
import com.sybase.jdbc3.tds.CachedTdsJdbcInputStream;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataObject;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.CacheStream;
import com.sybase.jdbc3.utils.Cacheable;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsJdbcInputStream
extends TdsDataObject
implements Cacheable {
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_MATH_BIGDECIMAL = "java.math.BigDecimal";
    private static final String JAVA_IO_FILTERINPUTSTREAM = "java.io.FilterInputStream";
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String JAVA_SQL_TIME = "java.sql.Time";
    private static final String JAVA_SQL_DATE = "java.sql.Date";
    private static final int BUFLEN = 512;
    public static final int RAW_TO_ASCII_STREAM = 1;
    public static final int RAW_TO_UNI_STREAM = 2;
    public static final int CHARSET_TO_UNI_STREAM = 3;
    public static final int RAW_STREAM = 4;
    public static final int UNICHAR_TO_UNI_STREAM = 5;
    public static final int UNICHAR_TO_ASCII_STREAM = 6;
    private CacheManager _monitor;
    private RawInputStream _columnInputStream;
    private InputStreamReader _columnInputStreamReader;
    private DynamicClassLoader _classLoader;

    public TdsJdbcInputStream(TdsProtocolContext tdsProtocolContext, Tds tds) throws IOException {
        super(tdsProtocolContext);
        this._classLoader = this._tds.getClassLoader();
    }

    protected TdsDataObject createCachedCopy() throws SQLException, IOException {
        return new CachedTdsJdbcInputStream(this);
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(6) : this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 225: {
                        if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                            this._columnInputStream = this.makeNewRIS(5);
                            String string = null;
                            string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, string);
                        } else {
                            this._columnInputStream = this.makeNewRIS(1);
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        }
                        return this._columnInputStreamReader;
                    }
                }
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return reader;
    }

    public InputStream getUnicodeStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(3);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(5) : this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public InputStream getBinaryStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 4) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            this.beginRead();
            if (this._isNull) return Convert.setScale(bigDecimal, n2);
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    bigDecimal = new BigDecimal((double)this.readUnsignedByte());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 52: {
                    bigDecimal = new BigDecimal((double)this.readShort());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 56: {
                    bigDecimal = new BigDecimal((double)this.readInt());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 38: {
                    bigDecimal = new BigDecimal((double)this.readINTN());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 59: {
                    bigDecimal = new BigDecimal(this.readFloat());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 62: {
                    bigDecimal = new BigDecimal(this.readDouble());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 109: {
                    bigDecimal = new BigDecimal(this.readFLTN());
                    return Convert.setScale(bigDecimal, n2);
                }
                case 106: 
                case 108: {
                    bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    return Convert.setScale(bigDecimal, n2);
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    bigDecimal = new BigDecimal(Convert.numString(this.readString()));
                    return Convert.setScale(bigDecimal, n2);
                }
                case 60: 
                case 110: 
                case 122: {
                    bigDecimal = this.readMONEYN();
                    return Convert.setScale(bigDecimal, n2);
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    return Convert.setScale(bigDecimal, n2);
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return Convert.setScale(bigDecimal, n2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return Convert.setScale(bigDecimal, n2);
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean() throws SQLException {
        boolean bl = false;
        try {
            this.beginRead();
            if (this._isNull) return bl;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    bl = 0 != this.readUnsignedByte();
                    return bl;
                }
                case 52: {
                    bl = 0 != this.readShort();
                    return bl;
                }
                case 56: {
                    bl = 0 != this.readInt();
                    return bl;
                }
                case 38: {
                    bl = 0L != this.readINTN();
                    return bl;
                }
                case 60: 
                case 110: 
                case 122: {
                    BigDecimal bigDecimal = this.readMONEYN();
                    bl = 0 != bigDecimal.signum();
                    return bl;
                }
                case 59: 
                case 62: 
                case 109: {
                    bl = 0.0 != this.readFLTN();
                    return bl;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    bl = 0 != bigDecimal.signum();
                    return bl;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    String string = this.readString();
                    bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                    return bl;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    return bl;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte() throws SQLException {
        long l2 = 0L;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l2 = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l2 = this.readShort();
                        break;
                    }
                    case 56: {
                        l2 = this.readInt();
                        break;
                    }
                    case 38: {
                        l2 = this.readINTN();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l2 = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l2 = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l2 = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l2 = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    }
                }
                Convert.checkByteOflo(l2);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (byte)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes() throws SQLException {
        byte[] byArray = null;
        try {
            this.beginRead();
            if (this._isNull) return byArray;
            switch (this._dataFmt._datatype) {
                case 36: {
                    int n2;
                    if (this._dataFmt._blobType != 4) {
                        ErrorMessage.raiseError("JZ0TE", "Object");
                    }
                    this._columnInputStream = this.makeNewRIS(4);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[512];
                    while ((n2 = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n2);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    this._columnInputStream.close();
                    this._columnInputStream = null;
                    return byArray;
                }
                case 34: 
                case 37: 
                case 45: 
                case 225: {
                    byArray = this.funkyBinaryReader();
                    return byArray;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "varbinay, long binary, binary, image");
                    return byArray;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return byArray;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getRawBytes() throws SQLException {
        byte[] byArray = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                int n2;
                this._columnInputStream = this.makeNewRIS(4);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[512];
                while ((n2 = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                this._columnInputStream.close();
                this._columnInputStream = null;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        finally {
            this.endRead();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TextPointer getTextPtr() throws SQLException {
        byte[] byArray;
        block17: {
            block16: {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 34: 
                        case 35: {
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0R4");
                            break;
                        }
                    }
                    break block16;
                }
                ErrorMessage.raiseError("JZ0R4");
            }
            byArray = null;
            this.endRead();
            try {
                if (this._dataFmt._datatype == 34) {
                    this.funkyBinaryReader();
                    break block17;
                }
                String string = this.readString();
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    byArray = null;
                    this.endRead();
                    try {
                        if (this._dataFmt._datatype == 34) {
                            this.funkyBinaryReader();
                            break block17;
                        }
                        String string = this.readString();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.endRead();
                try {
                    if (this._dataFmt._datatype == 34) {
                        this.funkyBinaryReader();
                    } else {
                        String string = this.readString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        TextPointer textPointer = new TextPointer(this._context);
        byte[] byArray2 = new byte[this._textptrlen];
        byArray = new byte[8];
        System.arraycopy(this._textptr, 0, byArray2, 0, this._textptrlen);
        System.arraycopy(this._textptr, this._textptrlen, byArray, 0, 8);
        textPointer._textPtr = byArray2;
        textPointer._timeStamp = byArray;
        textPointer._tableName = this._dataFmt._tableName;
        textPointer._columnName = this._dataFmt.getName();
        return textPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DateObject getDateObject(int n2, Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        try {
            this.beginRead();
            if (this._isNull) return dateObject;
            switch (this._dataFmt._datatype) {
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    dateObject = Convert.objectToDateObject(this.readString(), n2, calendar);
                    return dateObject;
                }
                case 58: 
                case 61: 
                case 111: {
                    dateObject = this.readDATETIMN().dateObjectValue(calendar);
                    return dateObject;
                }
                case 49: 
                case 123: {
                    if (n2 == 92) {
                        ErrorMessage.raiseError("JZ0TI", "date", "time");
                        return dateObject;
                    } else {
                        dateObject = this.readDATEN().dateObjectValue(calendar);
                        return dateObject;
                    }
                }
                case 51: 
                case 147: {
                    if (n2 == 91) {
                        ErrorMessage.raiseError("JZ0TI", "time", "date");
                        return dateObject;
                    } else {
                        dateObject = this.readTIMEN().dateObjectValue(calendar);
                        return dateObject;
                    }
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "char, varchar, datetime, short datetime, date, time");
                    return dateObject;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return dateObject;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorMessage.raiseError("JZ009", illegalArgumentException.getMessage());
            return dateObject;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble() throws SQLException {
        double d2 = 0.0;
        try {
            this.beginRead();
            if (this._isNull) return d2;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    d2 = this.readUnsignedByte();
                    return d2;
                }
                case 52: {
                    d2 = this.readShort();
                    return d2;
                }
                case 56: {
                    d2 = this.readInt();
                    return d2;
                }
                case 38: {
                    d2 = this.readINTN();
                    return d2;
                }
                case 59: 
                case 62: 
                case 109: {
                    d2 = this.readFLTN();
                    return d2;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    if (bigDecimal == null) return d2;
                    d2 = bigDecimal.doubleValue();
                    return d2;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    d2 = Double.valueOf(Convert.numString(this.readString()));
                    return d2;
                }
                case 60: 
                case 110: 
                case 122: {
                    BigDecimal bigDecimal = this.readMONEYN();
                    if (bigDecimal == null) return d2;
                    d2 = bigDecimal.doubleValue();
                    return d2;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    return d2;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return d2;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat() throws SQLException {
        float f2 = 0.0f;
        try {
            this.beginRead();
            if (this._isNull) return f2;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    f2 = this.readUnsignedByte();
                    return f2;
                }
                case 52: {
                    f2 = this.readShort();
                    return f2;
                }
                case 56: {
                    f2 = this.readInt();
                    return f2;
                }
                case 38: {
                    f2 = this.readINTN();
                    return f2;
                }
                case 59: {
                    f2 = this.readFloat();
                    return f2;
                }
                case 62: {
                    f2 = (float)this.readDouble();
                    return f2;
                }
                case 109: {
                    f2 = (float)this.readFLTN();
                    return f2;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    if (bigDecimal == null) return f2;
                    f2 = bigDecimal.floatValue();
                    return f2;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    f2 = Float.valueOf(Convert.numString(this.readString())).floatValue();
                    return f2;
                }
                case 60: 
                case 110: 
                case 122: {
                    BigDecimal bigDecimal = this.readMONEYN();
                    if (bigDecimal == null) return f2;
                    f2 = bigDecimal.floatValue();
                    return f2;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    return f2;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return f2;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return f2;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt() throws SQLException {
        long l2 = 0L;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l2 = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l2 = this.readShort();
                        break;
                    }
                    case 56: {
                        l2 = this.readInt();
                        break;
                    }
                    case 38: {
                        l2 = this.readINTN();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l2 = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l2 = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l2 = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l2 = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    }
                }
                Convert.checkIntOflo(l2);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (int)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong() throws SQLException {
        long l2 = 0L;
        try {
            this.beginRead();
            if (this._isNull) return l2;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    l2 = this.readUnsignedByte();
                    return l2;
                }
                case 52: {
                    l2 = this.readShort();
                    return l2;
                }
                case 56: {
                    l2 = this.readInt();
                    return l2;
                }
                case 38: {
                    l2 = this.readINTN();
                    return l2;
                }
                case 59: 
                case 62: 
                case 109: {
                    l2 = new Double(this.readFLTN()).longValue();
                    return l2;
                }
                case 106: 
                case 108: {
                    l2 = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                    return l2;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    l2 = new BigDecimal(Convert.numString(this.readString())).longValue();
                    return l2;
                }
                case 60: 
                case 110: 
                case 122: {
                    l2 = this.readMONEYN().longValue();
                    return l2;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    return l2;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return l2;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject() throws SQLException {
        Object object = null;
        try {
            this.beginRead();
            if (this._isNull) return object;
            switch (this._dataFmt._datatype) {
                case 50: {
                    int n2 = this.readUnsignedByte();
                    object = new Boolean(n2 != 0);
                    return object;
                }
                case 48: {
                    object = new Integer((byte)this.readUnsignedByte());
                    return object;
                }
                case 52: {
                    object = new Integer(this.readShort());
                    return object;
                }
                case 56: {
                    object = new Integer(this.readInt());
                    return object;
                }
                case 38: {
                    if (this._dataLength <= 4) {
                        object = new Integer((int)this.readINTN());
                        return object;
                    } else {
                        object = new Long(this.readINTN());
                        return object;
                    }
                }
                case 59: {
                    object = new Float(this.readFloat());
                    return object;
                }
                case 62: 
                case 109: {
                    if (this._dataLength == 4) {
                        object = new Float(this.readFloat());
                        return object;
                    } else {
                        object = new Double(this.readFLTN());
                        return object;
                    }
                }
                case 106: 
                case 108: {
                    object = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    return object;
                }
                case 39: 
                case 47: {
                    object = this.readString();
                    return object;
                }
                case 60: 
                case 110: 
                case 122: {
                    object = this.readMONEYN();
                    return object;
                }
                case 37: 
                case 45: 
                case 225: {
                    if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                        object = this.readUnicodeString();
                        return object;
                    }
                }
                case 34: {
                    object = this.funkyBinaryReader();
                    return object;
                }
                case 35: 
                case 175: {
                    object = this.readString();
                    return object;
                }
                case 58: 
                case 61: 
                case 111: {
                    object = Convert.objectToTimestamp(this.readDATETIMN().dateObjectValue());
                    return object;
                }
                case 49: 
                case 123: {
                    object = Convert.objectToDate(this.readDATEN().dateObjectValue());
                    return object;
                }
                case 51: 
                case 147: {
                    object = Convert.objectToTime(this.readTIMEN().dateObjectValue());
                    return object;
                }
                case 103: 
                case 104: {
                    byte[] byArray = new byte[this._dataLength];
                    this.in.read(byArray, 0, this._dataLength);
                    object = byArray;
                    return object;
                }
                case 36: {
                    switch (this._dataFmt._blobType) {
                        case 1: {
                            object = this.readObject();
                            return object;
                        }
                        case 3: {
                            this._columnInputStream = this.makeNewRIS(3);
                            object = this._columnInputStream;
                            return object;
                        }
                        case 4: {
                            this._columnInputStream = this.makeNewRIS(4);
                            object = this._columnInputStream;
                            return object;
                        }
                    }
                    return object;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return object;
        }
        finally {
            if (this._columnInputStream == null) {
                this.endRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort() throws SQLException {
        long l2 = 0L;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l2 = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l2 = this.readShort();
                        break;
                    }
                    case 56: {
                        l2 = this.readInt();
                        break;
                    }
                    case 38: {
                        l2 = this.readINTN();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l2 = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l2 = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l2 = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l2 = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                    }
                }
                Convert.checkShortOflo(l2);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (short)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString() throws SQLException {
        String string = null;
        try {
            this.beginRead();
            if (this._isNull) return string;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    string = String.valueOf(this.readUnsignedByte());
                    return string;
                }
                case 52: {
                    string = String.valueOf(this.readShort());
                    return string;
                }
                case 56: {
                    string = String.valueOf(this.readInt());
                    return string;
                }
                case 38: {
                    string = String.valueOf(this.readINTN());
                    return string;
                }
                case 59: {
                    string = String.valueOf(this.readFloat());
                    return string;
                }
                case 62: {
                    string = String.valueOf(this.readDouble());
                    return string;
                }
                case 109: {
                    string = String.valueOf(this.readFLTN());
                    return string;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    if (bigDecimal == null) return string;
                    string = bigDecimal.toString();
                    return string;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    string = this.readString();
                    return string;
                }
                case 34: 
                case 37: 
                case 45: 
                case 103: 
                case 104: {
                    if (this._holds0LNN) {
                        string = "";
                        return string;
                    } else {
                        string = HexConverts.hexConvert(this.funkyBinaryReader());
                        return string;
                    }
                }
                case 225: {
                    if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                        string = this.readUnicodeString();
                        return string;
                    } else if (this._holds0LNN) {
                        string = "";
                        return string;
                    } else {
                        string = HexConverts.hexConvert(this.funkyBinaryReader());
                        return string;
                    }
                }
                case 60: 
                case 110: 
                case 122: {
                    BigDecimal bigDecimal = this.readMONEYN();
                    if (bigDecimal == null) return string;
                    string = bigDecimal.toString();
                    return string;
                }
                case 58: 
                case 61: 
                case 111: {
                    string = this.readDATETIMN().stringValue();
                    return string;
                }
                case 49: 
                case 123: {
                    string = this.readDATEN().stringValue();
                    return string;
                }
                case 51: 
                case 147: {
                    string = this.readTIMEN().stringValue();
                    return string;
                }
                case 36: {
                    switch (this._dataFmt._blobType) {
                        case 1: {
                            Object object = this.readObject();
                            if (object == null) {
                                string = null;
                                return string;
                            } else {
                                string = object.toString();
                                return string;
                            }
                        }
                        case 3: {
                            int n2;
                            this._columnInputStream = this.makeNewRIS(4);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                            char[] cArray = new char[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n2 = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                stringBuffer.append(cArray, 0, n2);
                            }
                            string = stringBuffer.toString();
                            inputStreamReader.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            return string;
                        }
                        case 4: {
                            int n3;
                            this._columnInputStream = this.makeNewRIS(4);
                            byte[] byArray = new byte[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n3 = this._columnInputStream.read(byArray, 0, 512)) != -1) {
                                stringBuffer.append(HexConverts.hexConvert(byArray, n3));
                            }
                            string = stringBuffer.toString();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            return string;
                        }
                    }
                    ErrorMessage.raiseError("JZ0TC");
                    return string;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    return string;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return string;
        }
        finally {
            this.endRead();
        }
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    public void open(boolean bl) {
        this._state = bl ? 2 : 1;
        if (this._context._lastResult == 209) {
            this._context._lastResult = -1;
        }
    }

    public int getState() {
        return this._state;
    }

    public void setManager(CacheManager cacheManager) {
        this._monitor = cacheManager;
    }

    public void cache() throws IOException {
        int n2;
        if (this._state == 3) {
            return;
        }
        if (this._monitor == null) {
            this.startRead();
            if (this._context._rereadable && (this._state == 0 || this._columnInputStream == null)) {
                this.openCacheStream();
            }
        }
        this._state = 2;
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
            } else {
                this._columnInputStream.close();
                this._columnInputStream = null;
            }
            this._state = 3;
            return;
        }
        this.getSize();
        if (this._dataLength == -1 && this._columnInputStream == null) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            this._columnInputStream.cache((CacheStream)this.in);
            this._state = 3;
            this.reset();
            this._columnInputStream = null;
            return;
        }
        byte[] byArray = new byte[512];
        for (int i2 = this._dataLength; i2 > 0; i2 -= n2) {
            n2 = i2 < 512 ? i2 : 512;
            this.in.read(byArray, 0, n2);
        }
        if (this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
        if (this._monitor != null) {
            this.in.reset();
        }
    }

    public void clear() throws IOException {
        if (this._columnInputStream != null) {
            this._columnInputStream.close();
            this._columnInputStream = null;
        } else {
            switch (this._state) {
                case 0: {
                    if (this._monitor != null) break;
                    this.skipParam();
                    break;
                }
                case 1: {
                    this.skipParam();
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
                case 2: {
                    this.getSize();
                    this.in.skip(this._dataLength);
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                }
            }
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipParam() throws IOException {
        this.getSize();
        if (this._dataLength == -1) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
                this._columnInputStream.close();
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            finally {
                this._columnInputStream = null;
            }
        } else {
            this.in.skip(this._dataLength);
        }
    }

    public void resetInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this._dataLength != -1 ? this._dataLength : this.in.available();
    }

    public void initialize() {
        super.initialize();
        this._columnInputStream = null;
        if (this.in instanceof CacheStream) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = this._context._in;
        }
    }

    public void reset() throws IOException {
        if (this._state == 3 && !this._isNull) {
            this.in.reset();
            if (this._monitor != null) {
                this._dataLength = -2;
                this.getSize();
            }
        } else {
            ErrorMessage.raiseIOException("JZ0P7");
        }
    }

    protected void beginRead() throws IOException {
        if (this._monitor == null && this._state == 0 && this._prev != null && this._prev._state != 3) {
            this._prev.cache();
        }
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
                this._state = 3;
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        this.getSize();
        if (this._isNull) {
            return;
        }
        if (this._monitor == null) {
            if (this._state == 0) {
                if (this._context._rereadable) {
                    this.openCacheStream();
                }
                this._state = 1;
            }
        } else if (this._state == 0) {
            ErrorMessage.raiseIOException("JZ0R3");
        }
        if (this._state == 3) {
            if (this._context._rereadable) {
                this.reset();
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
    }

    protected void endRead() throws SQLException {
        if (this._state != 3 && this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawInputStream makeNewRIS(int n2) throws SQLException {
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                try {
                    this._columnInputStream.close();
                    this._state = 3;
                    this.reset();
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                finally {
                    this._columnInputStream = null;
                }
            } else {
                ErrorMessage.raiseError("JZ0R3");
            }
        }
        RawInputStream rawInputStream = null;
        CacheManager cacheManager = null;
        int n3 = this._dataLength;
        if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
            n3 = this._dataFmt._length;
        }
        if (this._context._maxFieldSize > 0) {
            n3 = Math.min(n3, this._context._maxFieldSize);
        }
        if (this._state != 3) {
            cacheManager = this._monitor;
            this._state = 1;
        }
        try {
            switch (n2) {
                case 4: {
                    rawInputStream = new RawInputStream(this, this._dataLength, n3, cacheManager);
                    break;
                }
                case 1: {
                    rawInputStream = new RawToAsciiInputStream(this, this._dataLength, n3, cacheManager);
                    break;
                }
                case 3: {
                    rawInputStream = new CharsetToUniInputStream(this, this._dataLength, n3, cacheManager, this._tds._charsetName);
                    break;
                }
                case 2: {
                    int n4 = this._dataLength == -1 ? -1 : 2 * this._dataLength;
                    int n5 = n3 == -1 ? -1 : 2 * n3;
                    rawInputStream = new CharsetToUniInputStream(new RawToAsciiInputStream(this, this._dataLength, n3, cacheManager), n4, n5, null, "ISO8859_1");
                    break;
                }
                case 5: {
                    if (this.getBigEndian()) {
                        rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n3, cacheManager, false);
                        break;
                    }
                    rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n3, cacheManager, true);
                    break;
                }
                case 6: {
                    if (n3 != this._dataLength) {
                        n3 = n3 * 2 < this._dataLength ? (n3 *= 2) : this._dataLength;
                    }
                    rawInputStream = new UnicharToAsciiInputStream(this, this._dataLength, n3, this.getBigEndian(), cacheManager);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ0I5", iOException.toString());
        }
        rawInputStream.setCached(this._state == 3);
        return rawInputStream;
    }

    protected static String getObjectClassName(int n2, int n3, int n4) throws SQLException {
        String string = JAVA_LANG_OBJECT;
        switch (n2) {
            case 50: {
                string = JAVA_LANG_BOOLEAN;
                break;
            }
            case 48: 
            case 52: 
            case 56: {
                string = JAVA_LANG_INTEGER;
                break;
            }
            case 38: {
                if (n4 <= 4) {
                    string = JAVA_LANG_INTEGER;
                    break;
                }
                string = JAVA_LANG_LONG;
                break;
            }
            case 59: {
                string = JAVA_LANG_FLOAT;
                break;
            }
            case 62: 
            case 109: {
                if (n4 == 4) {
                    string = JAVA_LANG_FLOAT;
                    break;
                }
                string = JAVA_LANG_DOUBLE;
                break;
            }
            case 35: 
            case 39: 
            case 47: 
            case 175: {
                string = JAVA_LANG_STRING;
                break;
            }
            case 60: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                string = JAVA_MATH_BIGDECIMAL;
                break;
            }
            case 34: 
            case 37: 
            case 45: 
            case 103: 
            case 104: 
            case 225: {
                string = new byte[1].getClass().getName();
                break;
            }
            case 58: 
            case 61: 
            case 111: {
                string = JAVA_SQL_TIMESTAMP;
                break;
            }
            case 49: 
            case 123: {
                string = JAVA_SQL_DATE;
                break;
            }
            case 51: 
            case 147: {
                string = JAVA_SQL_TIME;
                break;
            }
            case 36: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        string = JAVA_LANG_OBJECT;
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = JAVA_IO_FILTERINPUTSTREAM;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return string;
    }

    private void openCacheStream() {
        this.in = new CacheStream(this._context._cm, this.in, this._context._timeout);
    }

    private Object readObject() throws SQLException {
        Object object = null;
        try {
            this._columnInputStream = this.makeNewRIS(4);
            if (this._columnInputStream.available() > 0) {
                ObjectInputStream objectInputStream = this._classLoader == null ? new ObjectInputStream(this._columnInputStream) : new DynamicObjectInputStream((InputStream)this._columnInputStream, this._classLoader);
                object = objectInputStream.readObject();
                objectInputStream.close();
            } else {
                this._isNull = true;
            }
            this._columnInputStream.close();
            this._columnInputStream = null;
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ010", exception.getMessage());
        }
        return object;
    }
}

