/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.DateObject;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsDateTime {
    private static final int BASEBIAS = 693595;
    private static final int BASEYEAR = 1;
    private static final int CENTURY_ADJUST = 52;
    private static final int TIMEMASK = 0x1FFFFFF;
    private static final int C300TH_P_HOUR = 1080000;
    private static final int C300TH_P_MIN = 18000;
    private static final int[] MONTHDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LMONTHDAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECS = 5;
    public static final int DATETIME = 1;
    public static final int SMALLDATETIME = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    int[] _timestamp = new int[]{0, 0, 0, 0, 0, 0};
    long _nano = 0L;
    DateObject _dateObj = null;
    int _type = 0;

    public TdsDateTime(int n2, int n3, int n4) {
        this._type = n4;
        if (n4 == 1) {
            TdsDateTime.numToYearMonthDay(n2, this._timestamp);
            this.convertFourByteTime(n3);
        } else if (n4 == 2) {
            TdsDateTime.numToYearMonthDay(n2, this._timestamp);
            this.convertTwoByteTime(n3);
        } else if (n4 == 3) {
            TdsDateTime.numToYearMonthDay(n2, this._timestamp);
        } else if (n4 == 4) {
            this.convertFourByteTime(n3);
            this._timestamp[0] = 1970;
            this._timestamp[1] = 0;
            this._timestamp[2] = 1;
        }
    }

    private void convertFourByteTime(int n2) {
        this._timestamp[3] = (n2 &= 0x1FFFFFF) / 1080000;
        this._timestamp[4] = n2 / 18000 % 60;
        this._timestamp[5] = n2 / 300 % 60;
        this._nano = (long)n2 % 300L * 10000000L / 3L;
    }

    private void convertTwoByteTime(int n2) {
        this._timestamp[3] = n2 / 60;
        this._timestamp[4] = n2 % 60;
    }

    public static int[] tdsDateTime(DateObject dateObject) {
        int[] nArray = new int[2];
        Calendar calendar = dateObject.getCalendar();
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5) - 1;
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        double d2 = dateObject.getNanos();
        nArray[0] = TdsDateTime.ymdToNum(n2, n3, n4);
        int n8 = (int)Math.round(d2 * 3.0 / 1.0E7);
        nArray[1] = ((n5 * 60 + n6) * 60 + n7) * 300 + n8;
        if (d2 != 0.0 && n8 == 300) {
            nArray[1] = nArray[1] - 1;
        }
        return nArray;
    }

    public DateObject dateObjectValue() throws SQLException {
        return this.dateObjectValue(null);
    }

    public DateObject dateObjectValue(Calendar calendar) throws SQLException {
        if (this._dateObj == null) {
            this._dateObj = this.convertToDateObject(calendar);
        }
        return this._dateObj;
    }

    public String stringValue() {
        StringBuffer stringBuffer = new StringBuffer(26);
        if (this._type != 4) {
            stringBuffer.append(this._timestamp[0]);
            stringBuffer.append('-');
            if (this._timestamp[1] < 9) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[1] + 1);
            stringBuffer.append('-');
            if (this._timestamp[2] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[2]);
        }
        if (this._type != 3) {
            String string;
            double d2 = (double)this._nano / 1.0E9;
            if (d2 == 0.0) {
                string = "0.0";
            } else {
                string = String.valueOf(d2);
                if (string.length() > 5) {
                    string = string.substring(0, 5);
                }
            }
            if (this._type != 4) {
                stringBuffer.append(' ');
            }
            if (this._timestamp[3] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[3]);
            stringBuffer.append(':');
            if (this._timestamp[4] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[4]);
            stringBuffer.append(':');
            if (this._timestamp[5] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[5]);
            stringBuffer.append('.');
            stringBuffer.append(string.substring(2));
        }
        return stringBuffer.toString();
    }

    private static void numToYearMonthDay(int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = (n2 += 693595) / 365;
        while ((n4 = n2 - (n5 * 365 + (n3 = TdsDateTime.leapcnt(n5)))) < 0) {
            --n5;
        }
        int[] nArray2 = MONTHDAYS;
        if (TdsDateTime.leapyear(n5)) {
            nArray2 = LMONTHDAYS;
        }
        ++n5;
        int n6 = n4;
        int n7 = 0;
        while (n6 >= nArray2[n7]) {
            n6 -= nArray2[n7];
            ++n7;
        }
        nArray[0] = n5;
        nArray[1] = n7;
        nArray[2] = n6 + 1;
    }

    private static int ymdToNum(int n2, int n3, int n4) {
        int n5 = --n2 * 365 + TdsDateTime.leapcnt(n2);
        int[] nArray = MONTHDAYS;
        if (TdsDateTime.leapyear(n2)) {
            nArray = LMONTHDAYS;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            n5 += nArray[i2];
        }
        n5 += n4;
        return n5 -= 693595;
    }

    private static boolean leapyear(int n2) {
        boolean bl = ++n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0;
        return bl;
    }

    private static int leapcnt(int n2) {
        int n3 = n2 / 100;
        int n4 = n2 / 4 - n3 + n3 / 4;
        return n4;
    }

    private DateObject convertToDateObject(Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        dateObject = new DateObject(calendar);
        Calendar calendar2 = dateObject.getCalendar();
        calendar2.set(1, this._timestamp[0]);
        calendar2.set(2, this._timestamp[1]);
        calendar2.set(5, this._timestamp[2]);
        calendar2.set(11, this._timestamp[3]);
        calendar2.set(12, this._timestamp[4]);
        calendar2.set(13, this._timestamp[5]);
        calendar2.set(14, (int)this._nano / 1000000);
        dateObject.setNanos((int)this._nano);
        return dateObject;
    }
}

