/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.RawInputStream;
import com.sybase.jdbc3.tds.BlobOutputStream;
import com.sybase.jdbc3.tds.PduOutputFormatter;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataObject;
import com.sybase.jdbc3.tds.TdsDateTime;
import com.sybase.jdbc3.tds.TdsJdbcInputStream;
import com.sybase.jdbc3.tds.TdsNumeric;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.TdsParam;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsDataOutputStream
extends TdsOutputStream {
    Tds _tds;
    protected static final int BUF_SIZE = 2048;
    protected static final int TDS_TYPE = 0;
    protected static final int LENGTH = 1;
    protected static final int PRECISION = 2;
    protected static final int SCALE = 3;
    protected static final int INFO_LENGTH = 4;

    public TdsDataOutputStream(Tds tds, PduOutputFormatter pduOutputFormatter) throws IOException {
        super(pduOutputFormatter);
        this._tds = tds;
    }

    public void writeParam(TdsParam tdsParam, int n2) throws IOException {
        int[] nArray = new int[4];
        this.dataTypeInfo(tdsParam, nArray);
        this.checkColStatus(tdsParam);
        if (tdsParam._inValue == null && tdsParam._inDataFmt._colStatusBytePresent) {
            return;
        }
        if (tdsParam._inValue == null) {
            switch (nArray[0]) {
                case 50: {
                    this.writeByte(0);
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 108: 
                case 109: 
                case 111: 
                case 123: 
                case 147: {
                    this.writeByte(0);
                    break;
                }
                case 175: 
                case 225: {
                    this.writeInt(0);
                    break;
                }
                case 36: 
                case 9217: {
                    this.writeByte(1);
                    this.writeShort(0);
                    this.writeInt(0);
                    break;
                }
                case 9219: 
                case 9220: {
                    this.writeByte(0);
                    this.writeShort(0);
                    this.writeInt(0);
                    break;
                }
            }
            return;
        }
        block7 : switch (nArray[0]) {
            case 50: {
                this.writeByte((Boolean)tdsParam._inValue != false ? 1 : 0);
                break;
            }
            case 38: {
                this.writeByte(nArray[1]);
                switch (nArray[1]) {
                    case 0: {
                        break block7;
                    }
                    case 1: {
                        this.writeByte((Integer)tdsParam._inValue);
                        break block7;
                    }
                    case 2: {
                        this.writeShort((Integer)tdsParam._inValue);
                        break block7;
                    }
                    case 4: {
                        this.writeInt((Integer)tdsParam._inValue);
                        break block7;
                    }
                    case 8: {
                        this.writeLong((Long)tdsParam._inValue);
                        break block7;
                    }
                }
                break;
            }
            case 109: {
                this.writeByte(nArray[1]);
                switch (nArray[1]) {
                    case 0: {
                        break block7;
                    }
                    case 4: {
                        this.writeFloat(((Float)tdsParam._inValue).floatValue());
                        break block7;
                    }
                    case 8: {
                        this.writeDouble((Double)tdsParam._inValue);
                        break block7;
                    }
                }
                break;
            }
            case 39: 
            case 175: {
                int n3 = nArray[1];
                if (nArray[0] == 39) {
                    this.writeByte(n3);
                } else {
                    this.writeInt(n3);
                }
                if (n3 <= 0) break;
                this.write(tdsParam._cvtString, 0, n3);
                break;
            }
            case 37: {
                int n4 = nArray[1];
                this.writeByte(n4);
                if (n4 <= 0) break;
                this.write((byte[])tdsParam._inValue, 0, n4);
                break;
            }
            case 225: {
                int n5;
                int n6;
                this.writeInt(n6);
                if (n6 <= 0) break;
                if (tdsParam._inValue instanceof byte[]) {
                    this.write((byte[])tdsParam._inValue, 0, n6);
                    break;
                }
                if (!(tdsParam._inValue instanceof InputStream)) break;
                InputStream inputStream = (InputStream)tdsParam._inValue;
                int n7 = n6 < 2048 ? n6 : 2048;
                byte[] byArray = new byte[n7];
                for (n6 = nArray[1]; n6 > 0 && (n5 = inputStream.read(byArray, 0, n6 > n7 ? n7 : n6)) >= 0; n6 -= n5) {
                    this.write(byArray, 0, n5);
                }
                break;
            }
            case 108: {
                byte[] byArray = TdsNumeric.tdsNumeric((BigDecimal)tdsParam._inValue, tdsParam._scale, nArray);
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                this.write(byArray);
                break;
            }
            case 111: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                int[] nArray2 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray2[0]);
                this.writeInt(nArray2[1]);
                break;
            }
            case 123: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                int[] nArray3 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray3[0]);
                break;
            }
            case 147: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                int[] nArray4 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray4[1]);
                break;
            }
            case 9217: {
                this.writeByte(1);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(blobOutputStream);
                objectOutputStream.writeObject(tdsParam._inValue);
                objectOutputStream.close();
                break;
            }
            case 9219: {
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                if (tdsParam._inValue instanceof InputStream) {
                    InputStream inputStream = (InputStream)tdsParam._inValue;
                    byte[] byArray = new byte[2048];
                    int n8 = nArray[1];
                    if (n8 > 0) {
                        n8 *= 2;
                    }
                    char[] cArray = new char[1024];
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, this._tds._charsetName);
                    while (n8 != 0) {
                        int n9;
                        int n10;
                        int n11;
                        int n12 = 2048;
                        if (n8 > 0 && n8 < n12) {
                            n12 = n8;
                        }
                        if ((n11 = inputStream.read(byArray, 0, n12)) < 0) break;
                        if (n11 % 2 != 0) {
                            n10 = inputStream.read();
                            if (n10 == -1) break;
                            byArray[n11++] = (byte)n10;
                        }
                        if (n8 > 0) {
                            n8 -= n11;
                        }
                        n10 = n11 / 2;
                        if (!tdsParam._paramIsLittleEndian) {
                            for (n9 = 0; n9 < n10; ++n9) {
                                cArray[n9] = (char)(byArray[n9 * 2] << 8 | byArray[n9 * 2 + 1] & 0xFF);
                            }
                        } else {
                            for (n9 = 0; n9 < n10; ++n9) {
                                cArray[n9] = (char)(byArray[n9 * 2 + 1] << 8 | byArray[n9 * 2] & 0xFF);
                            }
                        }
                        outputStreamWriter.write(cArray, 0, n10);
                    }
                    outputStreamWriter.flush();
                } else if (tdsParam._inValue instanceof Reader) {
                    Reader reader = (Reader)tdsParam._inValue;
                    int n13 = nArray[1];
                    char[] cArray = new char[2048];
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, this._tds._charsetName);
                    while (n13 != 0) {
                        int n14;
                        int n15 = 2048;
                        if (n13 > 0 && n13 < n15) {
                            n15 = n13;
                        }
                        if ((n14 = reader.read(cArray, 0, n15)) < 0) break;
                        if (n13 > 0) {
                            n13 -= n14;
                        }
                        outputStreamWriter.write(cArray, 0, n14);
                    }
                    outputStreamWriter.flush();
                }
                blobOutputStream.close();
                break;
            }
            case 9220: {
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                InputStream inputStream = (InputStream)tdsParam._inValue;
                byte[] byArray = new byte[2048];
                int n16 = nArray[1];
                while (n16 != 0) {
                    int n17;
                    int n18 = 2048;
                    if (n16 > 0 && n16 < n18) {
                        n18 = n16;
                    }
                    if ((n17 = inputStream.read(byArray, 0, n18)) < 0) break;
                    if (n16 > 0) {
                        n16 -= n17;
                    }
                    blobOutputStream.write(byArray, 0, n17);
                }
                blobOutputStream.close();
                break;
            }
        }
    }

    protected void dataTypeInfo(TdsParam tdsParam, int[] nArray) throws IOException {
        switch (tdsParam._sqlType) {
            case -7: {
                nArray[0] = 50;
                break;
            }
            case -6: {
                nArray[0] = 38;
                nArray[1] = 1;
                break;
            }
            case 5: {
                nArray[0] = 38;
                nArray[1] = 2;
                break;
            }
            case -998: {
                nArray[0] = 56;
                nArray[1] = 4;
                break;
            }
            case 4: {
                nArray[0] = 38;
                nArray[1] = 4;
                break;
            }
            case -5: {
                nArray[0] = 38;
                nArray[1] = 8;
                break;
            }
            case 7: {
                nArray[0] = 109;
                nArray[1] = 4;
                break;
            }
            case 6: 
            case 8: {
                nArray[0] = 109;
                nArray[1] = 8;
                break;
            }
            case 2: 
            case 3: {
                nArray[0] = 108;
                if (tdsParam == null) break;
                TdsNumeric.tdsNumeric((BigDecimal)tdsParam._inValue, tdsParam._scale, nArray);
                break;
            }
            case 9219: 
            case 9220: {
                nArray[0] = tdsParam._sqlType;
                nArray[1] = tdsParam._scale;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                nArray[0] = tdsParam._sqlType == -1 ? 175 : 39;
                this.convertString(tdsParam, nArray);
                if (!tdsParam._parameterHoldsUnicharData) break;
                nArray[0] = 225;
                break;
            }
            case 91: {
                if (this._tds.serverAcceptsDateData()) {
                    nArray[0] = 123;
                    nArray[1] = 4;
                    break;
                }
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case 92: {
                if (this._tds.serverAcceptsTimeData()) {
                    nArray[0] = 147;
                    nArray[1] = 4;
                    break;
                }
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case 93: {
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case -3: 
            case -2: {
                nArray[0] = 37;
                if (tdsParam._inValue == null) break;
                nArray[1] = ((byte[])tdsParam._inValue).length;
                break;
            }
            case -4: {
                nArray[0] = 225;
                if (tdsParam._inValue == null) break;
                if (tdsParam._inValue instanceof byte[]) {
                    nArray[1] = ((byte[])tdsParam._inValue).length;
                    break;
                }
                if (!(tdsParam._inValue instanceof InputStream)) break;
                if (tdsParam._scale == -1) {
                    InputStream inputStream = (InputStream)tdsParam._inValue;
                    nArray[1] = inputStream.available();
                    break;
                }
                nArray[1] = tdsParam._scale;
                break;
            }
            case 2000: {
                nArray[0] = 9217;
                nArray[1] = -1;
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0SL", "" + tdsParam._sqlType);
            }
        }
        if (tdsParam._inValue == null) {
            nArray[1] = 0;
        }
    }

    protected void convertString(TdsParam tdsParam, int[] nArray) throws IOException {
        if (tdsParam._inValue != null) {
            if (tdsParam._inValue instanceof String) {
                if (tdsParam._cvtString == null) {
                    tdsParam._parameterAsAString = (String)tdsParam._inValue;
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte((String)tdsParam._inValue);
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else if (tdsParam._inValue instanceof InputStream) {
                if (tdsParam._cvtString == null) {
                    String string = null;
                    tdsParam._parameterAsAString = string = tdsParam.getStringFromStream(0);
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(string);
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else if (tdsParam._inValue instanceof Reader) {
                if (tdsParam._cvtString == null) {
                    char[] cArray = new char[2048];
                    StringBuffer stringBuffer = new StringBuffer(2048);
                    int n2 = 0;
                    while (true) {
                        int n3;
                        int n4 = 2048;
                        if (tdsParam._scale >= 0 && tdsParam._scale < 2048) {
                            n4 = tdsParam._scale - n2;
                        }
                        if (n4 <= 0 || (n3 = ((Reader)tdsParam._inValue).read(cArray, 0, n4)) <= 0) break;
                        stringBuffer.append(cArray, 0, n3);
                        n2 += n3;
                    }
                    tdsParam._parameterAsAString = stringBuffer.toString();
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(stringBuffer.toString());
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else {
                if (tdsParam._cvtString == null) {
                    tdsParam._parameterAsAString = tdsParam._inValue.toString();
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(tdsParam._inValue.toString());
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            }
        }
    }

    private void setUnicharParameter(TdsParam tdsParam) throws IOException {
        tdsParam._cvtString = this.stringToByte(tdsParam._parameterAsAString);
        String string = this._tds._charsetConverter.toUnicode(tdsParam._cvtString);
        if (!tdsParam._parameterAsAString.equals(string)) {
            tdsParam._cvtString = tdsParam.stringToUnicodeBytes(tdsParam._parameterAsAString);
            tdsParam._inValue = tdsParam._cvtString;
            tdsParam._sqlType = -4;
            tdsParam._parameterHoldsUnicharData = true;
        }
    }

    protected void check0LNNString(TdsParam tdsParam) {
        if (tdsParam._parameterAsAString.length() == 0 && !this._tds.serverAcceptsColumnStatusByte()) {
            tdsParam._inValue = " ";
            tdsParam._parameterAsAString = " ";
        }
    }

    private void checkColStatus(TdsParam tdsParam) throws IOException {
        if (tdsParam._inDataFmt._colStatusBytePresent) {
            int n2 = 0;
            if (tdsParam._inValue == null) {
                n2 = 1;
            }
            this.writeByte(n2);
        }
    }

    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        return this._tds._charsetConverter.fromUnicode(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void send(TdsDataObject tdsDataObject) throws SQLException {
        try {
            tdsDataObject.beginRead();
            if (!tdsDataObject._isNull) {
                int n2 = tdsDataObject._dataLength;
                switch (tdsDataObject._dataFmt._datatype) {
                    case 48: {
                        this.writeByte(tdsDataObject.getByte());
                        return;
                    }
                    case 52: {
                        this.writeShort(tdsDataObject.getShort());
                        return;
                    }
                    case 56: {
                        this.writeInt(tdsDataObject.getInt());
                        return;
                    }
                    case 38: {
                        this.writeByte(n2);
                        long l2 = tdsDataObject.getLong();
                        switch (n2) {
                            case 1: {
                                this.writeByte((byte)l2);
                                return;
                            }
                            case 2: {
                                this.writeShort((short)l2);
                                return;
                            }
                            case 4: {
                                this.writeInt((int)l2);
                                return;
                            }
                            case 8: {
                                this.writeLong(l2);
                                return;
                            }
                        }
                        return;
                    }
                    case 59: {
                        this.writeFloat(tdsDataObject.getFloat());
                        return;
                    }
                    case 62: {
                        this.writeDouble(tdsDataObject.getDouble());
                        return;
                    }
                    case 109: {
                        this.writeByte(n2);
                        double d2 = tdsDataObject.getDouble();
                        switch (n2) {
                            case 4: {
                                this.writeFloat((float)d2);
                                return;
                            }
                            case 8: {
                                this.writeDouble(d2);
                                return;
                            }
                        }
                        return;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 122: {
                        break;
                    }
                    case 37: 
                    case 39: 
                    case 45: 
                    case 47: 
                    case 103: 
                    case 104: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 111: 
                    case 123: 
                    case 147: {
                        this.writeByte(n2);
                        break;
                    }
                    case 34: 
                    case 35: 
                    case 175: 
                    case 225: {
                        this.writeInt(n2);
                        break;
                    }
                    case 36: {
                        tdsDataObject.reset();
                        RawInputStream rawInputStream = ((TdsJdbcInputStream)tdsDataObject).makeNewRIS(4);
                        byte[] byArray = new byte[2048];
                        while (true) {
                            int n3;
                            if ((n3 = rawInputStream.read(byArray)) < 0) {
                                return;
                            }
                            this.write(byArray, 0, n3);
                        }
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TC");
                    }
                }
                byte[] byArray = new byte[n2 < 2048 ? n2 : 2048];
                int n4 = byArray.length;
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = tdsDataObject.read(byArray, 0, n4);
                    if (n6 < 0) {
                        return;
                    }
                    this.write(byArray, 0, n6);
                    n4 = n2 - (n5 += n6) > 2048 ? 2048 : n2 - n5;
                }
                return;
            }
            if ((tdsDataObject._dataFmt._status & 0x20) == 0) return;
            switch (tdsDataObject._dataFmt._datatype) {
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 47: 
                case 103: 
                case 104: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 123: 
                case 147: {
                    this.writeByte(0);
                    return;
                }
                case 34: 
                case 35: 
                case 36: 
                case 175: 
                case 225: {
                    this.writeInt(0);
                    return;
                }
            }
            ErrorMessage.raiseError("JZ0TC");
            return;
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return;
        }
        finally {
            tdsDataObject.endRead();
        }
    }

    public String getCharset() {
        return this._tds._charsetName;
    }
}

