/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.utils.Debug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class PduOutputFormatter
extends FilterOutputStream {
    private int _packetSize;
    private byte[] _netBuf;
    private int _nextOut;
    private int _pduType;
    private int _pduStatus;
    private SybConnection _conn;

    public PduOutputFormatter(OutputStream outputStream, int n2, SybConnection sybConnection) throws SQLException {
        super(outputStream);
        this.setNetBufSize(n2);
        this._nextOut = 8;
        this._pduType = 15;
        this._pduStatus = 0;
        this._conn = sybConnection;
    }

    public void setNetBufSize(int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < this._nextOut; ++n3) {
            byArray[n3] = this._netBuf[n3];
        }
        for (n3 = this._nextOut; n3 < n2; ++n3) {
            byArray[n3] = 0;
        }
        this._netBuf = byArray;
        this._packetSize = n2;
    }

    public void write(int n2) throws IOException {
        if (this._nextOut >= this._packetSize) {
            this.doFlush(true);
        }
        this._netBuf[this._nextOut++] = (byte)n2;
    }

    public void write(byte[] byArray, int n2) throws IOException {
        this.write(byArray, 0, n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Debug.asrt(this, n3 + n2 <= byArray.length, "Offset/Length values are incorrect");
        int n4 = n2;
        while (n3 > 0) {
            int n5;
            if (this._nextOut >= this._packetSize) {
                this.doFlush(true);
            }
            int n6 = (n5 = this._packetSize - this._nextOut) < n3 - n2 ? n5 : n3 - n2;
            System.arraycopy(byArray, n4, this._netBuf, this._nextOut, n6);
            this._nextOut += n6;
            n3 -= n6;
            n4 += n6;
        }
    }

    public void setPDUHeader(int n2, int n3) {
        this._pduType = n2;
        this._pduStatus = n3;
    }

    public void flush() throws IOException {
        this.doFlush(false);
    }

    protected void changeOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(boolean bl) throws IOException {
        try {
            this._netBuf[0] = (byte)this._pduType;
            int n2 = this._packetSize;
            if (bl) {
                this._netBuf[1] = (byte)this._pduStatus;
            } else {
                this._netBuf[1] = (byte)(this._pduStatus | 1);
                n2 = this._nextOut;
            }
            this._netBuf[2] = (byte)((n2 & 0xFF00) >> 8);
            this._netBuf[3] = (byte)(n2 & 0xFF);
            this.out.write(this._netBuf, 0, n2);
            if (!bl) {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this._conn.markDeadTryHA();
        }
        finally {
            this._nextOut = 8;
        }
    }
}

