/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DoneToken;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import com.sybase.jdbc3.utils.BufferInterval;
import java.io.IOException;
import java.io.InputStream;

public class PduInputFormatter
extends InputStream {
    private static final int LOW_BYTE = 255;
    private int _nextIn = 0;
    private int _packetEnd = 0;
    private int _status = 1;
    private int _type;
    private BufferInterval _pdu;
    private byte[] _buf = null;
    private TdsProtocolContext _tpc;

    public PduInputFormatter(TdsProtocolContext tdsProtocolContext) {
        this._tpc = tdsProtocolContext;
    }

    public int read() throws IOException {
        while (this._nextIn >= this._packetEnd) {
            if (this.readPacket()) continue;
            return -1;
        }
        int n2 = this._buf[this._nextIn++] & 0xFF;
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = this._packetEnd - this._nextIn;
            while (n5 <= 0) {
                if (!this.readPacket()) {
                    if (n4 == n3) {
                        return -1;
                    }
                    return n3 - n4;
                }
                n5 = this._packetEnd - this._nextIn;
            }
            int n6 = n5 > n4 ? n4 : n5;
            System.arraycopy(this._buf, this._nextIn, byArray, n2, n6);
            n4 -= n6;
            n2 += n6;
            this._nextIn += n6;
        }
        return n3;
    }

    public long skip(long l2) throws IOException {
        int n2 = this._packetEnd - this._nextIn;
        int n3 = (int)l2;
        while (n2 < n3) {
            n3 -= n2;
            this._nextIn += n2;
            if (!this.readPacket()) {
                return l2;
            }
            n2 = this._packetEnd - this._nextIn;
        }
        this._nextIn += n3;
        return l2;
    }

    public int available() throws IOException {
        int n2 = this._tpc.available();
        return n2 += this._packetEnd - this._nextIn;
    }

    public void close() {
        while ((this._status & 1) == 0) {
            try {
                this.readPacket();
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        this._nextIn = 0;
        this._packetEnd = 0;
        if (this._pdu != null) {
            this._pdu.free();
            this._pdu = null;
        }
    }

    private boolean readPacket() throws IOException {
        if (this._pdu != null) {
            this._pdu.free();
            this._pdu = null;
        }
        this._pdu = this._tpc.getChunk();
        if (this._pdu == null) {
            this._nextIn = 0;
            this._packetEnd = 0;
            return false;
        }
        this._buf = this._pdu._buf;
        this._nextIn = this._pdu._offset;
        this._type = this._buf[this._nextIn++] & 0xFF;
        this._status = this._buf[this._nextIn++] & 0xFF;
        int n2 = ((this._buf[this._nextIn++] & 0xFF) << 8) + (0xFF & this._buf[this._nextIn++]);
        this._nextIn += 4;
        this._packetEnd = this._nextIn + n2 - 8;
        if ((this._status & 2) != 0) {
            this._pdu.free();
            this._pdu = null;
            this._nextIn = 0;
            this._packetEnd = 0;
            this._tpc._tdsToken = new DoneToken(32, 0, 0);
            return false;
        }
        return true;
    }
}

