/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.ParamManager;
import com.sybase.jdbc3.tds.MsgToken;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataOutputStream;
import com.sybase.jdbc3.tds.TdsJdbcInputStream;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import java.io.IOException;
import java.sql.SQLException;

public class HASessionContext {
    private byte[] _haSessionID = new byte[6];
    private int _haLogin = 0;
    private boolean _haRequested = false;
    private boolean _failover = false;
    private Tds _protocol = null;

    protected HASessionContext(boolean bl, Tds tds) {
        this._haRequested = bl;
        this._protocol = tds;
        this._failover = false;
        if (this._haRequested) {
            this._haLogin = 1;
        }
    }

    public boolean wasHARequested() {
        return this._haRequested;
    }

    public boolean isInFailoverMode() {
        return this._failover;
    }

    public byte[] getSessionID() {
        return this._haSessionID;
    }

    public int getLogin() {
        return this._haLogin;
    }

    protected void setFailoverMode(boolean bl) {
        this._failover = bl;
    }

    protected void setHALogin(int n2) {
        this._haLogin = n2;
    }

    protected void readSessionID(TdsProtocolContext tdsProtocolContext) throws IOException, SQLException {
        int n2;
        block3: {
            byte[] byArray;
            block2: {
                n2 = this._protocol.nextResult(tdsProtocolContext);
                MsgToken msgToken = new MsgToken(tdsProtocolContext._in);
                n2 = this._protocol.nextResult(tdsProtocolContext);
                n2 = tdsProtocolContext._in.readUnsignedByte();
                TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(tdsProtocolContext, this._protocol);
                tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(0);
                byArray = tdsJdbcInputStream.getBytes();
                if (this.getLogin() != 7) break block2;
                if (this.getLogin() != 1 || this.isInFailoverMode()) break block3;
            }
            System.arraycopy(byArray, 0, this._haSessionID, 0, 6);
        }
        tdsProtocolContext._lastResult = -1;
        n2 = this._protocol.nextResult(tdsProtocolContext);
    }

    protected void acknowledgeSessionID(TdsDataOutputStream tdsDataOutputStream, TdsProtocolContext tdsProtocolContext) throws SQLException, IOException {
        MsgToken msgToken = new MsgToken(1, 12);
        ParamManager paramManager = new ParamManager(1, tdsProtocolContext);
        paramManager.setParam(1, -3, new byte[0], 0);
        msgToken.send(tdsDataOutputStream);
        this._protocol.sendParamStream(paramManager, tdsDataOutputStream);
        tdsDataOutputStream.flush();
    }
}

