/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.RawInputStream;
import com.sybase.jdbc3.utils.CacheManager;
import java.io.IOException;
import java.io.InputStream;

public class UnicharToAsciiInputStream
extends RawInputStream {
    private int _bytesRemainingInStream;
    private int[] _bytes;
    private int _returnVal;
    private boolean _isBigEndian;

    public UnicharToAsciiInputStream(InputStream inputStream, int n2, int n3, boolean bl, CacheManager cacheManager) throws IOException {
        super(inputStream, n2, n3, cacheManager);
        this._bytesRemainingInStream = n3;
        this._bytes = new int[2];
        this._isBigEndian = bl;
    }

    public int read() throws IOException {
        if (this._bytesRemainingInStream == 0) {
            return -1;
        }
        if (this._isBigEndian) {
            this._bytes[0] = super.read();
            this._bytes[1] = super.read();
            this._returnVal = this._bytes[1];
        } else {
            this._bytes[0] = super.read();
            this._bytes[1] = super.read();
            this._returnVal = this._bytes[0];
        }
        this._bytesRemainingInStream -= 2;
        return this._returnVal;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._bytesRemainingInStream == 0) {
            return -1;
        }
        n3 = n3 < this._bytesRemainingInStream / 2 ? n3 : this._bytesRemainingInStream / 2;
        for (int i2 = n2; i2 < n3; ++i2) {
            byArray[i2] = (byte)this.read();
        }
        return n3;
    }

    public int available() throws IOException {
        int n2 = super.available() / 2;
        return n2;
    }

    public long skip(long l2) throws IOException {
        l2 = l2 < (long)(this._bytesRemainingInStream / 2) ? l2 : (long)(this._bytesRemainingInStream / 2);
        int n2 = 0;
        while ((long)n2 < l2) {
            this.read();
            ++n2;
        }
        return l2;
    }
}

