/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.JdbcDataObject;
import com.sybase.jdbc3.jdbc.ProtocolResultSet;
import com.sybase.jdbc3.jdbc.SybStatement;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.Cacheable;
import com.sybase.jdbc3.utils.Debug;
import com.sybase.jdbcx.TextPointer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class SybResultSet
implements com.sybase.jdbcx.SybResultSet,
Cacheable {
    protected static final int BEFORE_FIRST = -1;
    protected static final int AFTER_LAST = -2;
    protected static final int INSERT_ROW = -3;
    protected static final int UNDEFINED = -4;
    protected ProtocolResultSet _prs;
    protected JdbcDataObject _currentColumn;
    protected SybStatement _statement;
    protected int _state = 2;
    private Hashtable _nameToColumn = null;
    private Hashtable _labelToColumn = null;
    protected CacheManager _cm;
    protected int _rowIndex;
    protected int _lastRowIndex = -4;
    protected int _concurType = 1007;
    protected String _concurTypeString = "CONCUR_READ_ONLY";
    protected int _scrollType = 1003;
    protected int _fetchSize = 0;
    protected int _fetchDirection = 1000;
    protected boolean _usedForParams = false;
    protected SQLWarning _savedWarnings = null;

    public SybResultSet(SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        this._statement = sybStatement;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
    }

    public boolean next() throws SQLException {
        this.checkResultSet();
        this.moveToCurrentRow();
        if (this.checkRowIndexBeforeProtocolNext()) {
            return false;
        }
        boolean bl = this._prs.next();
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            this.adjustRowIndexesAfterProtocolNext();
        }
        this._currentColumn = null;
        return bl;
    }

    protected boolean checkRowIndexBeforeProtocolNext() {
        boolean bl = false;
        switch (this._rowIndex) {
            case -2: {
                bl = true;
                break;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex <= 0) break;
                ++this._rowIndex;
            }
        }
        return bl;
    }

    protected void adjustRowIndexesAfterProtocolNext() {
        if (this._rowIndex == 1) {
            this._lastRowIndex = 0;
            this._rowIndex = -1;
        } else {
            this._lastRowIndex = this._rowIndex - 1;
            this._rowIndex = -2;
        }
    }

    public void close() throws SQLException {
        this.close(false);
    }

    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        if (this._currentColumn == null) {
            ErrorMessage.raiseError("JZ0NC");
        }
        return this._currentColumn.isNull();
    }

    public String getString(int n2) throws SQLException {
        return this.getColumn(n2).getString();
    }

    public boolean getBoolean(int n2) throws SQLException {
        return this.getColumn(n2).getBoolean();
    }

    public byte getByte(int n2) throws SQLException {
        return this.getColumn(n2).getByte();
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this.getColumn(n2).getBytes();
    }

    public TextPointer getSybTextPointer(int n2) throws SQLException {
        return this.getColumn(n2).getTextPtr();
    }

    public short getShort(int n2) throws SQLException {
        return this.getColumn(n2).getShort();
    }

    public int getInt(int n2) throws SQLException {
        return this.getColumn(n2).getInt();
    }

    public long getLong(int n2) throws SQLException {
        return this.getColumn(n2).getLong();
    }

    public float getFloat(int n2) throws SQLException {
        return this.getColumn(n2).getFloat();
    }

    public double getDouble(int n2) throws SQLException {
        return this.getColumn(n2).getDouble();
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getColumn(n2).getBigDecimal(n3);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, -1);
    }

    public Date getDate(int n2) throws SQLException {
        return Convert.objectToDate(this.getColumn(n2).getDateObject(91, null));
    }

    public Time getTime(int n2) throws SQLException {
        return Convert.objectToTime(this.getColumn(n2).getDateObject(92, null));
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(n2).getDateObject(93, null));
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.getColumn(n2).getAsciiStream();
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.getColumn(n2).getUnicodeStream();
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.getColumn(n2).getBinaryStream();
    }

    public Object getObject(int n2) throws SQLException {
        return this.getColumn(n2).getObject();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(string, -1);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public TextPointer getSybTextPointer(String string) throws SQLException {
        return this.getSybTextPointer(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public URL getURL(int n2) throws SQLException {
        Debug.notImplemented(this, "getURL(int)");
        return null;
    }

    public URL getURL(String string) throws SQLException {
        Debug.notImplemented(this, "getURL(String)");
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        if (this._prs != null) {
            if (this._savedWarnings != null) {
                this._savedWarnings.setNextWarning(this._prs.getWarnings());
                this._prs.clearWarnings();
                sQLWarning = this._savedWarnings;
            } else {
                sQLWarning = this._prs.getWarnings();
            }
        } else if (this._savedWarnings != null) {
            sQLWarning = this._savedWarnings;
        }
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        if (this._prs != null) {
            this._prs.clearWarnings();
        }
        this._savedWarnings = null;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return this._prs.getMetaData();
    }

    public int findColumn(String string) throws SQLException {
        Integer n2;
        if (this._statement._context._conn._props.getBoolean(40)) {
            Integer n3;
            if (this._labelToColumn == null) {
                this._labelToColumn = new Hashtable();
            }
            if ((n3 = (Integer)this._labelToColumn.get(string)) != null) {
                return n3;
            }
            int n4 = this._prs.findColumnByLabel(string);
            this._labelToColumn.put(string, new Integer(n4));
            return n4;
        }
        if (this._nameToColumn == null) {
            this._nameToColumn = new Hashtable();
        }
        if ((n2 = (Integer)this._nameToColumn.get(string)) != null) {
            return n2;
        }
        int n5 = this._prs.findColumn(string);
        this._nameToColumn.put(string, new Integer(n5));
        return n5;
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        return this.getColumn(n2).getCharacterStream();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public int getRow() throws SQLException {
        if (this._rowIndex <= 0) {
            return 0;
        }
        return this._rowIndex;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this._rowIndex == -1;
    }

    public boolean isAfterLast() throws SQLException {
        return this._rowIndex == -2;
    }

    public boolean isFirst() throws SQLException {
        return this._rowIndex == 1;
    }

    public boolean isLast() throws SQLException {
        if (this._lastRowIndex != -4) {
            return this._rowIndex == this._lastRowIndex;
        }
        Debug.notImplemented(this, "isLast()");
        return false;
    }

    public boolean previous() throws SQLException {
        this.checkForScrollability("previous()");
        boolean bl = true;
        switch (this._rowIndex) {
            case -1: {
                return false;
            }
            case 1: {
                this._rowIndex = -1;
                bl = false;
                break;
            }
            case -2: {
                this._rowIndex = this._lastRowIndex;
                break;
            }
            default: {
                --this._rowIndex;
            }
        }
        this._prs.previous();
        return bl;
    }

    public boolean absolute(int n2) throws SQLException {
        int n3;
        this.checkForScrollability("absolute(int)");
        if (this._lastRowIndex == 0) {
            return false;
        }
        if (n2 == 0) {
            ErrorMessage.raiseError("JZ0I3", String.valueOf(n2), "absolute(int)");
        }
        if (n2 < 0) {
            if (this._lastRowIndex == -4 && !this.last()) {
                return false;
            }
            if ((n2 += this._lastRowIndex + 1) <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n2 <= (n3 = this._prs.getNumRowsCached())) {
            this._rowIndex = n2;
            this._prs.absolute(n2);
            return true;
        }
        if (n3 > 0) {
            this._rowIndex = n3;
            this._prs.absolute(this._rowIndex);
        }
        while (this._rowIndex < n2 && this.next()) {
        }
        return this._rowIndex == n2;
    }

    public void afterLast() throws SQLException {
        this.checkForScrollability("afterLast()");
        if (this.last()) {
            this.next();
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkForScrollability("beforeFirst()");
        if (this.first()) {
            this.previous();
        }
    }

    public boolean first() throws SQLException {
        this.checkForScrollability("first()");
        this.moveToCurrentRow();
        if (this._rowIndex == 1) {
            return true;
        }
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        this.checkForScrollability("last()");
        this.moveToCurrentRow();
        if (this._lastRowIndex == -4) {
            if (this._prs.getNumRowsCached() > 0) {
                this._rowIndex = this._prs.getNumRowsCached();
                this._prs.absolute(this._rowIndex);
            }
            while (this.next()) {
            }
            this.previous();
        } else if (this._lastRowIndex != 0) {
            this._rowIndex = this._lastRowIndex;
            this._prs.absolute(this._rowIndex);
        }
        return this._lastRowIndex != 0;
    }

    public boolean relative(int n2) throws SQLException {
        this.checkForScrollability("relative(int)");
        this.moveToCurrentRow();
        boolean bl = false;
        if (this._rowIndex != -1 && this._rowIndex != -2) {
            int n3 = this._rowIndex + n2;
            if (n3 <= 0) {
                this.beforeFirst();
            } else {
                bl = this.absolute(n3);
            }
        }
        return bl;
    }

    public void refreshRow() throws SQLException {
        switch (this._scrollType) {
            case 1003: 
            case 1004: {
                break;
            }
            case 1005: {
                Debug.notImplemented(this, "refreshRow() FOR TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
    }

    public void setFetchDirection(int n2) throws SQLException {
        block0 : switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", "setFetchDirection(int)", "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: 
            case 1005: {
                switch (n2) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this._fetchDirection = n2;
                        break block0;
                    }
                }
                ErrorMessage.raiseError("JZ0I3", String.valueOf(n2), "setFetchDirection(int)");
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return this._fetchDirection;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (n2 == 0) {
            return;
        }
        int n3 = this._statement.getMaxRows();
        if (n2 < 0 || n3 > 0 && n2 > n3) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._fetchSize = n2;
    }

    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    public int getType() throws SQLException {
        return this._scrollType;
    }

    public int getConcurrency() throws SQLException {
        return this._concurType;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(int)", this._concurTypeString);
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(int, boolean)", this._concurTypeString);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(int, byte)", this._concurTypeString);
    }

    public void updateShort(int n2, short s2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(int, short)", this._concurTypeString);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(int, int)", this._concurTypeString);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(int, long)", this._concurTypeString);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(int, float)", this._concurTypeString);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(int, double)", this._concurTypeString);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(int, BigDecimal)", this._concurTypeString);
    }

    public void updateString(int n2, String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(int, String)", this._concurTypeString);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(int, byte[])", this._concurTypeString);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(int, java.sql.Date)", this._concurTypeString);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(int, java.sql.Time)", this._concurTypeString);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(int, java.sql.Timestamp)", this._concurTypeString);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(int, java.io.Reader, int)", this._concurTypeString);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object, int)", this._concurTypeString);
    }

    public void updateObject(int n2, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object)", this._concurTypeString);
    }

    public void updateNull(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(String)", this._concurTypeString);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(String, boolean)", this._concurTypeString);
    }

    public void updateByte(String string, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(String, byte)", this._concurTypeString);
    }

    public void updateShort(String string, short s2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(String, short)", this._concurTypeString);
    }

    public void updateInt(String string, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(String, int)", this._concurTypeString);
    }

    public void updateLong(String string, long l2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(String, long)", this._concurTypeString);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(String, float)", this._concurTypeString);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(String, double)", this._concurTypeString);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(String, BigDecimal)", this._concurTypeString);
    }

    public void updateString(String string, String string2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(String, String)", this._concurTypeString);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(String, byte[])", this._concurTypeString);
    }

    public void updateDate(String string, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(String, java.sql.Date)", this._concurTypeString);
    }

    public void updateTime(String string, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(String, java.sql.Time)", this._concurTypeString);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(String, java.sql.Timestamp)", this._concurTypeString);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(String, java.io.Reader, int)", this._concurTypeString);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object, int)", this._concurTypeString);
    }

    public void updateObject(String string, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object)", this._concurTypeString);
    }

    public void insertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "insertRow()", this._concurTypeString);
    }

    public void updateRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateRow()", this._concurTypeString);
    }

    public void deleteRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "deleteRow()", this._concurTypeString);
    }

    public void cancelRowUpdates() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "cancelRowUpdates()", this._concurTypeString);
    }

    public Statement getStatement() throws SQLException {
        return this._statement;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int, java.util.Map)");
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        Debug.notSupported(this, "updateBlob(int, Blob)");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        Debug.notSupported(this, "updateBlob(String, Blob)");
    }

    public Clob getClob(int n2) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        Debug.notSupported(this, "updateClob(int, Clob)");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        Debug.notSupported(this, "updateClob(String, Clob)");
    }

    public Array getArray(int n2) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    public void updateArray(int n2, Array array) throws SQLException {
        Debug.notSupported(this, "updateArray(int, Array)");
    }

    public void updateArray(String string, Array array) throws SQLException {
        Debug.notSupported(this, "updateArray(String, Array)");
    }

    public Object getObject(String string, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(String, java.util.Map)");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        Debug.notSupported(this, "updateRef(int, Ref)");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        Debug.notSupported(this, "updateRef(String, Ref)");
    }

    public Blob getBlob(String string) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    public Array getArray(String string) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this.getColumn(n2).getDateObject(91, calendar));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this.getColumn(n2).getDateObject(92, calendar));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(n2).getDateObject(93, calendar));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public void clear() throws IOException {
        try {
            this.close(false);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
    }

    public void setManager(CacheManager cacheManager) {
        this._cm = cacheManager;
    }

    public void reset() throws IOException {
        Debug.notSupported(this, "reset()");
    }

    public void resetInputStream(InputStream inputStream) {
        Debug.notSupported(this, "resetInputStream(InputStream is)");
    }

    public void cache() throws IOException {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
    }

    public void open(boolean bl) {
    }

    public int getState() {
        if (this._state == 4) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void markDead(boolean bl) throws SQLException {
        if (this._state == 4) {
            return;
        }
        this._state = 4;
        try {
            if (this._prs != null) {
                this._prs.close(bl);
                if (this._statement != null) {
                    try {
                        SQLWarning sQLWarning = this._prs.getWarnings();
                        if (sQLWarning != null) {
                            this._statement.handleSQLE(sQLWarning);
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this._statement.setRowCount(this._prs.getCount());
                }
            }
            Object var4_4 = null;
            if (this._cm != null) {
                this._cm.doneReading();
                this._cm.dead(this);
                this._cm = null;
            }
            if (this._statement != null) {
                this._statement._currentRS = null;
                this._statement = null;
            }
            this._nameToColumn = null;
            this._prs = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this._cm != null) {
                this._cm.doneReading();
                this._cm.dead(this);
                this._cm = null;
            }
            if (this._statement != null) {
                this._statement._currentRS = null;
                this._statement = null;
            }
            this._nameToColumn = null;
            this._prs = null;
            throw throwable;
        }
    }

    protected void checkResultSet() throws SQLException {
        if (this._state != 2) {
            ErrorMessage.raiseError("JZ0R0");
        }
    }

    protected void close(boolean bl) throws SQLException {
        this.markDead(bl);
    }

    protected JdbcDataObject getColumn(int n2) throws SQLException {
        this.checkResultSet();
        this.checkIfReadableRow();
        this._currentColumn = this._prs.getColumn(n2);
        return this._currentColumn;
    }

    protected void checkIfReadableRow() throws SQLException {
        if (this._rowIndex == -1 && !this._usedForParams) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    public void setHoldsParams(boolean bl) {
        this._usedForParams = bl;
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal, int n3, int n4) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                Debug.notImplemented(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }
}

