/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.jdbc.SybConnectionProxy;
import com.sybase.jdbc3.jdbc.SybUrlProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SybPooledConnection
extends SybConnection
implements PooledConnection {
    private Vector _listeners = new Vector(5);
    private SybConnectionProxy _currentProxy = null;

    protected SybPooledConnection(SybUrlProvider sybUrlProvider, int n2) throws SQLException {
        super(sybUrlProvider, null, n2);
    }

    public Connection getConnection() throws SQLException {
        this.reAssignProxy(this);
        return this._currentProxy;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._listeners.remove(connectionEventListener);
    }

    public void close() throws SQLException {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            this._currentProxy.close();
        }
        this._listeners.clear();
        super.close();
    }

    protected void notifyListeners(SQLException sQLException) {
        ConnectionEvent connectionEvent = sQLException == null ? new ConnectionEvent(this) : new ConnectionEvent(this, sQLException);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            if (sQLException != null) {
                connectionEventListener.connectionErrorOccurred(connectionEvent);
                continue;
            }
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    private final void reAssignProxy(SybPooledConnection sybPooledConnection) {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            try {
                this._currentProxy.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._currentProxy = new SybConnectionProxy(sybPooledConnection);
    }
}

