/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.MdaManager;
import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.utils.Debug;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class SybDatabaseMetaData
implements DatabaseMetaData {
    private SybConnection _conn;
    private MdaManager _mda;
    private int _outerJoinEscapeSupport;
    private int _isCaseSensitive;
    protected static final int UNKNOWN = -1;
    protected static final int NO = 0;
    protected static final int YES = 1;
    private static final String JAVA_OBJECT_NAME = "JAVA_OBJECT";
    private static final String STRUCT_NAME = "STRUCT";
    private static final String DISTINCT_NAME = "DISTINCT";
    private static final String TABLES = "TABLES";
    private static final String COLUMNS = "COLUMNS";
    private static final String ALLPROCSCALLABLE = "ALLPROCSCALLABLE";
    private static final String ALLTABLESSELECTABLE = "ALLTABLESSELECTABLE";
    private static final String ISREADONLY = "ISREADONLY";
    private static final String NULLSORTING = "NULLSORTING";
    private static final String USERNAME = "USERNAME";
    private static final String PRODUCTNAME = "PRODUCTNAME";
    private static final String PRODUCTVERSION = "PRODUCTVERSION";
    private static final String FILEUSAGE = "FILEUSAGE";
    private static final String IDENTIFIERCASES = "IDENTIFIERCASES";
    private static final String IDENTIFIERQUOTE = "IDENTIFIERQUOTE";
    private static final String SQLKEYWORDS = "SQLKEYWORDS";
    private static final String NUMERICFUNCTIONLIST = "NUMERICFUNCTIONLIST";
    private static final String STRINGFUNCTIONLIST = "STRINGFUNCTIONLIST";
    private static final String SYSTEMFUNCTIONLIST = "SYSTEMFUNCTIONLIST";
    private static final String TIMEDATEFUNCTIONLIST = "TIMEDATEFUNCTIONLIST";
    private static final String SEARCHSTRING = "SEARCHSTRING";
    private static final String EXTRANAMECHARS = "EXTRANAMECHARS";
    private static final String ALTERTABLESUPPORT = "ALTERTABLESUPPORT";
    private static final String COLUMNALIASING = "COLUMNALIASING";
    private static final String NULLPLUSNONNULL = "NULLPLUSNONNULL";
    private static final String CONVERTSUPPORT = "CONVERTSUPPORT";
    private static final String CONVERTMAP = "CONVERTMAP";
    private static final String CORRELATIONNAMES = "CORRELATIONNAMES";
    private static final String ORDERBYSUPPORT = "ORDERBYSUPPORT";
    private static final String GROUPBYSUPPORT = "GROUPBYSUPPORT";
    private static final String LIKEESCAPECLAUSE = "LIKEESCAPECLAUSE";
    private static final String MULTIPLERESULTSETS = "MULTIPLERESULTSETS";
    private static final String MULTIPLETRANSACTIONS = "MULTIPLETRANSACTIONS";
    private static final String NONNULLABLECOLUMNS = "NONNULLABLECOLUMNS";
    private static final String SQLGRAMMAR = "SQLGRAMMAR";
    private static final String ANSI92LEVEL = "ANSI92LEVEL";
    private static final String INTEGRITYENHANCEMENT = "INTEGRITYENHANCEMENT";
    private static final String OUTERJOINS = "OUTERJOINS";
    private static final String SCHEMATERM = "SCHEMATERM";
    private static final String PROCEDURETERM = "PROCEDURETERM";
    private static final String CATALOGTERM = "CATALOGTERM";
    private static final String CATALOGSEPARATOR = "CATALOGSEPARATOR";
    private static final String CATALOGATSTART = "CATALOGATSTART";
    private static final String SCHEMASUPPORT = "SCHEMASUPPORT";
    private static final String CATALOGSUPPORT = "CATALOGSUPPORT";
    private static final String POSITIONEDDELETE = "POSITIONEDDELETE";
    private static final String POSITIONEDUPDATE = "POSITIONEDUPDATE";
    private static final String SELECTFORUPDATE = "SELECTFORUPDATE";
    private static final String STOREDPROCEDURES = "STOREDPROCEDURES";
    private static final String SUBQUERIES = "SUBQUERIES";
    private static final String UNIONSUPPORT = "UNIONSUPPORT";
    private static final String CURSORTRANSACTIONS = "CURSORTRANSACTIONS";
    private static final String STATEMENTTRANSACTIONS = "STATEMENTTRANSACTIONS";
    private static final String MAXBINARYLITERALLENGTH = "MAXBINARYLITERALLENGTH";
    private static final String MAXCHARLITERALLENGTH = "MAXCHARLITERALLENGTH";
    private static final String COLUMNINFO = "COLUMNINFO";
    private static final String MAXCONNECTIONS = "MAXCONNECTIONS";
    private static final String MAXINDEXLENGTH = "MAXINDEXLENGTH";
    private static final String MAXNAMELENGTHS = "MAXNAMELENGTHS";
    private static final String ROWINFO = "ROWINFO";
    private static final String STATEMENTINFO = "STATEMENTINFO";
    private static final String TABLEINFO = "TABLEINFO";
    private static final String TRANSACTIONSUPPORT = "TRANSACTIONSUPPORT";
    private static final String TRANSACTIONLEVELDEFAULT = "TRANSACTIONLEVELDEFAULT";
    private static final String TRANSACTIONLEVELS = "TRANSACTIONLEVELS";
    private static final String TRANSACTIONDATADEFINFO = "TRANSACTIONDATADEFINFO";
    private static final String PROCEDURES = "PROCEDURES";
    private static final String PROCEDURECOLUMNS = "PROCEDURECOLUMNS";
    private static final String SCHEMAS = "SCHEMAS";
    private static final String CATALOGS = "CATALOGS";
    private static final String TABLETYPES = "TABLETYPES";
    private static final String COLUMNPRIVILEGES = "COLUMNPRIVILEGES";
    private static final String TABLEPRIVILEGES = "TABLEPRIVILEGES";
    private static final String ROWIDENTIFIERS = "ROWIDENTIFIERS";
    private static final String VERSIONCOLUMNS = "VERSIONCOLUMNS";
    private static final String PRIMARYKEYS = "PRIMARYKEYS";
    private static final String IMPORTEDKEYS = "IMPORTEDKEYS";
    private static final String EXPORTEDKEYS = "EXPORTEDKEYS";
    private static final String KEYCROSSREFERENCE = "KEYCROSSREFERENCE";
    private static final String TYPEINFO = "TYPEINFO";
    private static final String INDEXINFO = "INDEXINFO";
    private static final String OWNUPDATESAREVISIBLE = "OWNUPDATESAREVISIBLE";
    private static final String OWNDELETESAREVISIBLE = "OWNDELETESAREVISIBLE";
    private static final String OWNINSERTSAREVISIBLE = "OWNINSERTSAREVISIBLE";
    private static final String OTHERSUPDATESAREVISIBLE = "OTHERSUPDATESAREVISIBLE";
    private static final String OTHERSDELETESAREVISIBLE = "OTHERSDELETESAREVISIBLE";
    private static final String OTHERSINSERTSAREVISIBLE = "OTHERSINSERTSAREVISIBLE";
    private static final String UPDATESAREDETECTED = "UPDATESAREDETECTED";
    private static final String DELETESAREDETECTED = "DELETESAREDETECTED";
    private static final String INSERTSAREDETECTED = "INSERTSAREDETECTED";
    private static final String SUPPORTSBATCHUPDATES = "SUPPORTSBATCHUPDATES";
    private static final String SUPPORTSRESULTSETTYPE = "SUPPORTSRESULTSETTYPE";
    private static final String READONLYCONCURRENCY = "READONLYCONCURRENCY";
    private static final String UPDATABLECONCURRENCY = "UPDATABLECONCURRENCY";
    private static final String UDTS = "UDTS";
    private static final String EXECBATCHUPDATESINLOOP = "EXECBATCHUPDATESINLOOP";
    private static final String EXECPARAMETERIZEDBATCHINLOOP = "EXECPARAMETERIZEDBATCHINLOOP";
    private static final String MAXBATCHPARAMS = "MAXBATCHPARAMS";
    private static final String ISCASESENSITIVE = "ISCASESENSITIVE";
    private static final String CLASSFORNAME = "CLASSFORNAME";
    private static final String JARFORCLASS = "JARFORCLASS";
    private static final String JARBYNAME = "JARBYNAME";
    private static final String CLASSESINJAR = "CLASSESINJAR";
    private static final String CANRETURNJARS = "CANRETURNJARS";
    private static final String XACOORDINATORTYPE = "XACOORDINATORTYPE";
    protected int _execBatchInLoop = -1;
    private int _execParameterizedBatchInLoop = -1;
    protected int _batchSupport = -1;
    private int _maxParamsPerBatch = -1;

    SybDatabaseMetaData(SybConnection sybConnection) throws SQLException {
        this._conn = sybConnection;
        this._mda = sybConnection.getMDA(null);
        this._outerJoinEscapeSupport = -1;
        this._isCaseSensitive = -1;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLPROCSCALLABLE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLTABLESSELECTABLE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public String getURL() throws SQLException {
        return this._conn._url;
    }

    public String getUserName() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(USERNAME);
        return this.returnString(preparedStatement);
    }

    public boolean isReadOnly() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ISREADONLY);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 4);
    }

    public String getDatabaseProductName() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRODUCTNAME);
        return this.returnString(preparedStatement);
    }

    public String getDatabaseProductVersion() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRODUCTVERSION);
        return this.returnString(preparedStatement);
    }

    public String getDriverName() throws SQLException {
        return "jConnect (TM) for JDBC (TM)";
    }

    public String getDriverVersion() throws SQLException {
        return "jConnect (TM) for JDBC(TM)/6.0(Build 25308)/P/EBF11817/JDK14/Fri Feb 27 20:57:29 2004";
    }

    public int getDriverMajorVersion() {
        return 6;
    }

    public boolean execBatchUpdatesInLoop() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECBATCHUPDATESINLOOP);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean execParameterizedBatchUpdatesInLoop() throws SQLException {
        if (this._execParameterizedBatchInLoop == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECPARAMETERIZEDBATCHINLOOP);
                boolean bl = this.returnBoolean(preparedStatement, 1);
                this._execParameterizedBatchInLoop = bl ? 1 : 0;
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._execParameterizedBatchInLoop = 0;
            }
        }
        return this._execParameterizedBatchInLoop == 1;
    }

    public int getMaxParamsPerBatch() throws SQLException {
        if (this._maxParamsPerBatch == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBATCHPARAMS);
                this._maxParamsPerBatch = this.returnInt(preparedStatement, 1);
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._maxParamsPerBatch = 255;
            }
        }
        return this._maxParamsPerBatch;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 6);
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 7);
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 8);
    }

    public String getIdentifierQuoteString() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERQUOTE);
        return this.returnString(preparedStatement);
    }

    public String getSQLKeywords() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLKEYWORDS);
        return this.returnString(preparedStatement);
    }

    public String getNumericFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NUMERICFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public String getStringFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STRINGFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public String getSystemFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SYSTEMFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public String getTimeDateFunctions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TIMEDATEFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    public String getSearchStringEscape() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SEARCHSTRING);
        return this.returnString(preparedStatement);
    }

    public String getExtraNameCharacters() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXTRANAMECHARS);
        return this.returnString(preparedStatement);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNALIASING);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLPLUSNONNULL);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsConvert() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsConvert(int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTMAP);
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n3);
        ResultSet resultSet = preparedStatement.executeQuery();
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsGroupBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(LIKEESCAPECLAUSE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLERESULTSETS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLETRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NONNULLABLECOLUMNS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(INTEGRITYENHANCEMENT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOuterJoins() throws SQLException {
        if (this._outerJoinEscapeSupport == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
            this._outerJoinEscapeSupport = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._outerJoinEscapeSupport == 1;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 3);
    }

    protected boolean supportsOuterJoinEscapeSyntax() throws SQLException {
        if (this._mda._version < 1) {
            return this.getDatabaseProductName().equals("Sybase SQL Anywhere");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 4);
    }

    public String getSchemaTerm() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMATERM);
        return this.returnString(preparedStatement);
    }

    public String getProcedureTerm() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURETERM);
        return this.returnString(preparedStatement);
    }

    public String getCatalogTerm() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGTERM);
        return this.returnString(preparedStatement);
    }

    public boolean isCatalogAtStart() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGATSTART);
        return this.returnBoolean(preparedStatement, 1);
    }

    public String getCatalogSeparator() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSEPARATOR);
        return this.returnString(preparedStatement);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDDELETE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDUPDATE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SELECTFORUPDATE);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STOREDPROCEDURES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 4);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 5);
    }

    public boolean supportsUnion() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsUnionAll() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 2);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBINARYLITERALLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCHARLITERALLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxColumnNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 2);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 3);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 4);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 5);
    }

    public int getMaxColumnsInTable() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 6);
    }

    public int getMaxConnections() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCONNECTIONS);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxIndexLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXINDEXLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxCursorNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxUserNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 2);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 3);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 4);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 5);
    }

    public int getMaxRowSize() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
        return this.returnBoolean(preparedStatement, 2);
    }

    public int getMaxStatementLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxStatements() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(preparedStatement, 2);
    }

    public int getMaxTableNameLength() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(preparedStatement, 1);
    }

    public int getMaxTablesInSelect() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(preparedStatement, 2);
    }

    public boolean supportsTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELDEFAULT);
        return this.returnInt(preparedStatement, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean supportsTransactionIsolationLevel(int n2) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELS);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        SQLException sQLException = null;
        try {
            try {
                if (resultSet.next()) {
                    int n3 = resultSet.getMetaData().getColumnCount();
                    for (int i2 = 1; i2 <= n3; ++i2) {
                        if (resultSet.getInt(i2) != n2) continue;
                        bl = true;
                    }
                }
                Object var9_9 = null;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                Object var9_10 = null;
                resultSet.close();
                preparedStatement.close();
                if (sQLException == null) return bl;
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            resultSet.close();
            preparedStatement.close();
            if (sQLException == null) throw throwable;
            throw sQLException;
        }
        resultSet.close();
        preparedStatement.close();
        if (sQLException == null) return bl;
        throw sQLException;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 1);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 2);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 3);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 4);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURECOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer;
        if (stringArray == null) {
            stringBuffer = null;
        } else {
            stringBuffer = new StringBuffer("\"");
            for (int i2 = 0; i2 < stringArray.length && stringArray[i2] != null && !stringArray[i2].equals("null"); ++i2) {
                stringBuffer.append("'" + stringArray[i2] + "'");
            }
            stringBuffer = stringBuffer.append("\"");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLES, string);
        this.setStringParam(preparedStatement, string3, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string, 3);
        this.setStringParam(preparedStatement, stringBuffer == null ? null : stringBuffer.toString(), 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getClassForName(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CLASSFORNAME);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getJarForClass(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(JARFORCLASS);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getJarByName(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(JARBYNAME);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getClassesInJar(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CLASSESINJAR);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public boolean canReturnJars() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CANRETURNJARS);
        return this.returnBoolean(preparedStatement, 1);
    }

    public ResultSet getSchemas() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMAS);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getCatalogs() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGS);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getTableTypes() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLETYPES);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNS, string);
        this.setStringParam(preparedStatement, string3, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNPRIVILEGES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEPRIVILEGES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWIDENTIFIERS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        preparedStatement.setInt(4, n2);
        preparedStatement.setBoolean(5, bl);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(VERSIONCOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRIMARYKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IMPORTEDKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXPORTEDKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(KEYCROSSREFERENCE, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        this.setStringParam(preparedStatement, string5, 5);
        this.setStringParam(preparedStatement, string6, 6);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getTypeInfo() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TYPEINFO);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(INDEXINFO, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setBoolean(5, bl2);
        return this.returnResults(preparedStatement);
    }

    public boolean isCaseSensitive() throws SQLException {
        if (this._isCaseSensitive == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ISCASESENSITIVE);
            this._isCaseSensitive = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._isCaseSensitive == 1;
    }

    public boolean supportsSavepoints() throws SQLException {
        Debug.notImplemented(this, "supportsSavepoints()");
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        Debug.notImplemented(this, "supportsNamedParameters()");
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        Debug.notImplemented(this, "supportsMultipleOpenResults()");
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        Debug.notImplemented(this, "supportsGetGeneratedKeys()");
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        Debug.notImplemented(this, "getSuperTypes(String, String, String)");
        return null;
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        Debug.notImplemented(this, "getSuperTables(String, String, String)");
        return null;
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        Debug.notImplemented(this, "getAttributes(String, String, String, String)");
        return null;
    }

    public int getResultSetHoldability() throws SQLException {
        Debug.notImplemented(this, "getResultSetHoldability()");
        return 0;
    }

    public boolean supportsResultSetHoldability(int n2) throws SQLException {
        Debug.notImplemented(this, "supportsResultSetHoldability(int)");
        return false;
    }

    public int getSQLStateType() throws SQLException {
        Debug.notImplemented(this, "getSQLStateType()");
        return 0;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        Debug.notImplemented(this, "getDatabaseMajorVersion()");
        return 0;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        Debug.notImplemented(this, "getDatabaseMinorVersion()");
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        Debug.notImplemented(this, "getJDBCMajorVersion()");
        return 0;
    }

    public int getJDBCMinorVersion() throws SQLException {
        Debug.notImplemented(this, "getJDBCMinorVersion()");
        return 0;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        Debug.notImplemented(this, "locatorsUpdateCopy()");
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        Debug.notImplemented(this, "supportsStatementPooling()");
        return false;
    }

    public boolean supportsResultSetType(int n2) throws SQLException {
        return this.supportForResultSetType(SUPPORTSRESULTSETTYPE, n2);
    }

    public boolean supportsResultSetConcurrency(int n2, int n3) throws SQLException {
        switch (n3) {
            case 1007: {
                return this.supportForResultSetType(READONLYCONCURRENCY, n2);
            }
            case 1008: {
                return this.supportForResultSetType(UPDATABLECONCURRENCY, n2);
            }
        }
        ErrorMessage.raiseError("JZ0SO", "" + n3);
        return false;
    }

    public boolean ownUpdatesAreVisible(int n2) throws SQLException {
        return this.supportForResultSetType(OWNUPDATESAREVISIBLE, n2);
    }

    public boolean ownDeletesAreVisible(int n2) throws SQLException {
        return this.supportForResultSetType(OWNDELETESAREVISIBLE, n2);
    }

    public boolean ownInsertsAreVisible(int n2) throws SQLException {
        return this.supportForResultSetType(OWNINSERTSAREVISIBLE, n2);
    }

    public boolean othersUpdatesAreVisible(int n2) throws SQLException {
        return this.supportForResultSetType(OTHERSUPDATESAREVISIBLE, n2);
    }

    public boolean othersDeletesAreVisible(int n2) throws SQLException {
        return this.supportForResultSetType(OTHERSDELETESAREVISIBLE, n2);
    }

    public boolean othersInsertsAreVisible(int n2) throws SQLException {
        return this.supportForResultSetType(OTHERSINSERTSAREVISIBLE, n2);
    }

    public boolean updatesAreDetected(int n2) throws SQLException {
        return this.supportForResultSetType(UPDATESAREDETECTED, n2);
    }

    public boolean deletesAreDetected(int n2) throws SQLException {
        return this.supportForResultSetType(DELETESAREDETECTED, n2);
    }

    public boolean insertsAreDetected(int n2) throws SQLException {
        return this.supportForResultSetType(INSERTSAREDETECTED, n2);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPPORTSBATCHUPDATES);
        return this.returnBoolean(preparedStatement, 1);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String string4 = null;
        if (nArray != null) {
            string4 = "";
            block5: for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (i2 > 0) {
                    string4 = string4 + ",";
                }
                switch (nArray[i2]) {
                    case 2000: {
                        string4 = string4 + JAVA_OBJECT_NAME;
                        continue block5;
                    }
                    case 2002: {
                        string4 = string4 + STRUCT_NAME;
                        continue block5;
                    }
                    case 2001: {
                        string4 = string4 + DISTINCT_NAME;
                        continue block5;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0SQ", "" + nArray[i2]);
                    }
                }
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UDTS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getXACoordinatorType() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(XACOORDINATORTYPE);
        return this.returnResults(preparedStatement);
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    public PreparedStatement getMetaDataAccessor(String string) throws SQLException {
        return this.getMetaDataAccessor(string, "", null);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2) throws SQLException {
        return this.getMetaDataAccessor(string, "", string2);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, String string3) throws SQLException {
        return this._mda.getMetaDataAccessor(string, string2, string3, null);
    }

    private boolean supportForResultSetType(String string, int n2) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = this.getMetaDataAccessor(string);
        switch (n2) {
            case 1003: {
                bl = this.returnBoolean(preparedStatement, 1);
                break;
            }
            case 1004: {
                bl = this.returnBoolean(preparedStatement, 2);
                break;
            }
            case 1005: {
                bl = this.returnBoolean(preparedStatement, 3);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", "" + n2);
            }
        }
        return bl;
    }

    private void setStringParam(PreparedStatement preparedStatement, String string, int n2) throws SQLException {
        if (string == null) {
            preparedStatement.setNull(n2, 12);
        } else {
            preparedStatement.setString(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet returnResults(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet;
        block6: {
            resultSet = null;
            SQLException sQLException = null;
            SQLWarning sQLWarning = null;
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                sQLWarning = preparedStatement.getWarnings();
                if (sQLWarning != null) {
                    this._conn.handleSQLE(sQLWarning);
                }
                preparedStatement.close();
            }
            finally {
                if (sQLException == null) break block6;
                throw sQLException;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean returnBoolean(PreparedStatement preparedStatement, int n2) throws SQLException {
        ResultSet resultSet = null;
        boolean bl = false;
        SQLException sQLException = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getBoolean(n2);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                Object var8_7 = null;
                preparedStatement.close();
                if (sQLException == null) return bl;
                throw sQLException;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            preparedStatement.close();
            if (sQLException == null) throw throwable;
            throw sQLException;
        }
        preparedStatement.close();
        if (sQLException == null) return bl;
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int returnInt(PreparedStatement preparedStatement, int n2) throws SQLException {
        ResultSet resultSet = null;
        int n3 = -1;
        SQLException sQLException = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                n3 = resultSet.getInt(n2);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                Object var8_7 = null;
                preparedStatement.close();
                if (sQLException == null) return n3;
                throw sQLException;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            preparedStatement.close();
            if (sQLException == null) throw throwable;
            throw sQLException;
        }
        preparedStatement.close();
        if (sQLException == null) return n3;
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String returnString(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = null;
        String string = null;
        SQLException sQLException = null;
        try {
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                string = resultSet.getString(1);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                Object var7_6 = null;
                preparedStatement.close();
                if (sQLException == null) return string;
                throw sQLException;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            preparedStatement.close();
            if (sQLException == null) throw throwable;
            throw sQLException;
        }
        preparedStatement.close();
        if (sQLException == null) return string;
        throw sQLException;
    }
}

