/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.Param;
import com.sybase.jdbc3.jdbc.ParamManager;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.ProtocolResultSet;
import com.sybase.jdbc3.jdbc.SybCursorResultSet;
import com.sybase.jdbc3.jdbc.SybPreparedStatement;
import com.sybase.jdbc3.jdbc.SybScrollCursorResultSet;
import com.sybase.jdbc3.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class SybCallableStatement
extends SybPreparedStatement
implements com.sybase.jdbcx.SybCallableStatement {
    protected boolean _hasOutParam = false;

    SybCallableStatement(ProtocolContext protocolContext, String string) throws SQLException {
        super(protocolContext, string);
        if (this._hasReturn) {
            this._paramMgr.setParam(1, -998, new Integer(0), 0);
            this._paramMgr.registerParam(1, 4, 0);
            this._returnHasBeenRegistered = false;
        }
    }

    SybCallableStatement(ProtocolContext protocolContext, SybCallableStatement sybCallableStatement) throws SQLException {
        super(protocolContext, sybCallableStatement);
        this._allowsOutputParms = sybCallableStatement._allowsOutputParms;
        this._rpcName = sybCallableStatement._rpcName;
        this._hasReturn = sybCallableStatement._hasReturn;
        if (this._hasReturn) {
            this._paramMgr.setParam(1, -998, new Integer(0), 0);
            this._paramMgr.registerParam(1, 4, 0);
            this._returnHasBeenRegistered = false;
        }
    }

    protected void setDoEscapes() {
        this._doEscapes = true;
    }

    public ResultSet executeQuery() throws SQLException {
        this.clearParams();
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.queryLoop();
            }
            return this._currentRS;
        }
        return super.executeQuery(this._query, this._paramMgr);
    }

    public int executeUpdate() throws SQLException {
        this.clearParams();
        int n2 = -1;
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this._cursor != null) {
                ErrorMessage.raiseError("JZ0S3");
            }
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                n2 = this.updateLoop();
            }
        } else {
            n2 = super.executeUpdate(this._query, this._paramMgr);
        }
        return n2;
    }

    public boolean execute() throws SQLException {
        this.clearParams();
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.executeLoop();
            }
            return this._currentRS != null;
        }
        return super.execute(this._query, this._paramMgr);
    }

    public void addBatch() throws SQLException {
        if (this._batchCmdsCount < 1) {
            this._query = this.handleCallBody(this._query);
        }
        super.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        if (this._hasReturn || this._hasOutParam) {
            ErrorMessage.raiseError("JZ0BP");
        }
        return super.executeBatch();
    }

    public void cancel() throws SQLException {
        this.checkStatement(false);
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.cancel();
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.checkOutParamRegistration(n2);
        this._paramMgr.registerParam(n2, n3);
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        Debug.notImplemented(this, "registerOutParameter(String, int)");
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.checkOutParamRegistration(n2);
        this._paramMgr.registerParam(n2, n3, n4);
    }

    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        Debug.notImplemented(this, "registerOutParameter(String, int, int)");
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this._paramMgr.registerParam(n2, n3, string);
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        Debug.notImplemented(this, "registerOutParameter(String, int, String)");
    }

    public boolean wasNull() throws SQLException {
        return this._paramMgr.wasNull();
    }

    public String getString(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getString();
    }

    public String getString(String string) throws SQLException {
        Debug.notImplemented(this, "getString(String)");
        return null;
    }

    public void setString(String string, String string2) throws SQLException {
        Debug.notImplemented(this, "setString(String, String)");
    }

    public boolean getBoolean(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getBoolean();
    }

    public boolean getBoolean(String string) throws SQLException {
        Debug.notImplemented(this, "getBoolean(String)");
        return false;
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        Debug.notImplemented(this, "setBoolean(String, boolean)");
    }

    public byte getByte(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getByte();
    }

    public byte getByte(String string) throws SQLException {
        Debug.notImplemented(this, "getByte(String)");
        return 0;
    }

    public void setByte(String string, byte by) throws SQLException {
        Debug.notImplemented(this, "setByte(String, byte)");
    }

    public short getShort(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getShort();
    }

    public short getShort(String string) throws SQLException {
        Debug.notImplemented(this, "getShort(String)");
        return 0;
    }

    public void setShort(String string, short s2) throws SQLException {
        Debug.notImplemented(this, "setShort(String, short)");
    }

    public int getInt(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getInt();
    }

    public int getInt(String string) throws SQLException {
        Debug.notImplemented(this, "getInt(String)");
        return 0;
    }

    public void setInt(String string, int n2) throws SQLException {
        Debug.notImplemented(this, "setInt(String, int)");
    }

    public long getLong(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getLong();
    }

    public long getLong(String string) throws SQLException {
        Debug.notImplemented(this, "getLong(String)");
        return 0L;
    }

    public void setLong(String string, long l2) throws SQLException {
        Debug.notImplemented(this, "setLong(String, long)");
    }

    public float getFloat(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getFloat();
    }

    public float getFloat(String string) throws SQLException {
        Debug.notImplemented(this, "getFloat(String)");
        return 0.0f;
    }

    public void setFloat(String string, float f2) throws SQLException {
        Debug.notImplemented(this, "setFloat(String, float)");
    }

    public double getDouble(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getDouble();
    }

    public double getDouble(String string) throws SQLException {
        Debug.notImplemented(this, "getDouble(String)");
        return 0.0;
    }

    public void setDouble(String string, double d2) throws SQLException {
        Debug.notImplemented(this, "setDouble(String, double)");
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getBigDecimal(n3);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, -1);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        Debug.notImplemented(this, "getBigDecimal(String)");
        return null;
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        Debug.notImplemented(this, "setBigDecimal(String, BigDecimal)");
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getBytes();
    }

    public byte[] getBytes(String string) throws SQLException {
        Debug.notImplemented(this, "getBytes(String)");
        return null;
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        Debug.notImplemented(this, "setBytes(String, byte[])");
    }

    public Date getDate(int n2) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n2).getDateObject(91, null));
    }

    public Date getDate(String string) throws SQLException {
        Debug.notImplemented(this, "getDate(String)");
        return null;
    }

    public void setDate(String string, Date date) throws SQLException {
        Debug.notImplemented(this, "setDate(String, Date)");
    }

    public Time getTime(int n2) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n2).getDateObject(92, null));
    }

    public Time getTime(String string) throws SQLException {
        Debug.notImplemented(this, "getTime(String)");
        return null;
    }

    public void setTime(String string, Time time) throws SQLException {
        Debug.notImplemented(this, "setTime(String, java.sql.Time)");
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n2).getDateObject(93, null));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Debug.notImplemented(this, "getTimestamp(String)");
        return null;
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        Debug.notImplemented(this, "setTimestamp(String, java.sql.Timestamp)");
    }

    public Object getObject(int n2) throws SQLException {
        return this._paramMgr.getOutObjectAt(n2);
    }

    public Object getObject(String string) throws SQLException {
        Debug.notImplemented(this, "getObject(String)");
        return null;
    }

    public void setObject(String string, Object object) throws SQLException {
        Debug.notImplemented(this, "setObject(String, Object)");
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        Debug.notImplemented(this, "setObject(String, Object, int)");
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        Debug.notImplemented(this, "setObject(String, Object, int, int)");
    }

    public boolean sendRpc(String string, ParamManager paramManager) throws SQLException {
        try {
            if (this._rsConcur == -9) {
                this._rsConcur = 1007;
            }
            if (this._rsConcur == 1008) {
                this.checkCursor(false);
            }
            if (this._cursor != null) {
                ProtocolResultSet protocolResultSet = this._cursor.open(string, paramManager, true);
                protocolResultSet.setType(this._rsType);
                this._currentRS = this._cursor.scrollingAtServer() ? new SybScrollCursorResultSet(this, protocolResultSet) : new SybCursorResultSet(this, protocolResultSet);
                this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
                this._state = 2;
                return false;
            }
            this._protocol.rpc(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return true;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int, java.util.Map)");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(String, java.util.Map)");
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    public Clob getClob(int n2) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    public Array getArray(int n2) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    public Array getArray(String string) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n2).getDateObject(91, calendar));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        Debug.notImplemented(this, "getDate(String, Calendar)");
        return null;
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        Debug.notImplemented(this, "setDate(String, Date, Calendar)");
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n2).getDateObject(92, calendar));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        Debug.notImplemented(this, "getTime(String, Calendar)");
        return null;
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        Debug.notImplemented(this, "setTime(String, java.sql.Time, Calendar)");
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n2).getDateObject(93, calendar));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Debug.notImplemented(this, "getTimestamp(String, Calendar)");
        return null;
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        Debug.notImplemented(this, "setTimestamp(String, java.sql.Timestamp, Calendar)");
    }

    public URL getURL(int n2) throws SQLException {
        Debug.notSupported(this, "getURL(int)");
        return null;
    }

    public URL getURL(String string) throws SQLException {
        Debug.notSupported(this, "getURL(String)");
        return null;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        Debug.notSupported(this, "setURL(String, URL)");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        Debug.notImplemented(this, "setAsciiStream(String, InputStream, int)");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        Debug.notImplemented(this, "setBinaryStream(String, InputStream, int)");
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        Debug.notImplemented(this, "setCharacterStream(String, reader, int)");
    }

    public void setNull(String string, int n2) throws SQLException {
        Debug.notImplemented(this, "setNull(String, int)");
    }

    public void setNull(String string, int n2, String string2) throws SQLException {
        Debug.notImplemented(this, "setNull(String, int, String)");
    }

    public void clearParams() throws SQLException {
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    protected void handleParam(ParamManager paramManager) throws SQLException {
        if (this._batchCmds == null) {
            this._paramMgr.getParameter();
        } else {
            paramManager.getParameter();
        }
    }

    private void checkOutParamRegistration(int n2) throws SQLException {
        if (!this._allowsOutputParms) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n2));
        } else if (this._hasReturn && n2 == 1) {
            this._returnHasBeenRegistered = true;
        }
    }

    public void setParameterName(int n2, String string) {
        Param[] paramArray = this._paramMgr.getParams();
        if (paramArray.length >= n2 && n2 > 0) {
            paramArray[n2 - 1]._name = string;
        }
    }
}

