/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.tds.TdsDataInputStream;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.CacheStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RawInputStream
extends FilterInputStream {
    private static final int HIBIT = Integer.MIN_VALUE;
    private static final int LOBITS = Integer.MAX_VALUE;
    private static final int NOLIMIT = -1;
    private int _visibleLength;
    private boolean _noLimit;
    private int _actualLength;
    private int _resetVisibleLength;
    private int _resetActualLength;
    private boolean _resetLastChunk;
    private int _bytesRead;
    private int _jmark;
    private boolean _markSupported;
    CacheManager _cm;
    TdsDataInputStream _tdis;
    private boolean _dead = false;
    protected boolean _isCached = false;
    private boolean _needReset = false;
    private boolean _lastChunk = true;

    public RawInputStream(InputStream inputStream, int n2, int n3, CacheManager cacheManager) throws IOException {
        super(inputStream);
        this._resetVisibleLength = n3;
        this._visibleLength = n3;
        this._noLimit = n3 == -1;
        this._resetActualLength = n2;
        this._actualLength = n2;
        this._bytesRead = 0;
        this._jmark = -1;
        this._markSupported = false;
        this._cm = cacheManager;
        this._tdis = inputStream instanceof TdsDataInputStream ? (TdsDataInputStream)inputStream : null;
        if (n2 < 0) {
            this._lastChunk = false;
        }
    }

    public void setCached(boolean bl) {
        this._isCached = bl;
    }

    public boolean cache(CacheStream cacheStream) throws IOException {
        if (this._jmark != -1) {
            return true;
        }
        this._jmark = this._bytesRead;
        this._needReset = true;
        this._resetActualLength = this._actualLength;
        this._resetVisibleLength = this._visibleLength;
        this._resetLastChunk = this._lastChunk;
        if (this._actualLength == 0 && this._lastChunk || this._dead) {
            this._isCached = true;
            return true;
        }
        if (this._isCached) {
            return true;
        }
        this.in = cacheStream;
        try {
            byte[] byArray = new byte[512];
            while (this._actualLength > 0 || !this._lastChunk) {
                while (this._actualLength > 0) {
                    int n2 = this._actualLength < 512 ? this._actualLength : 512;
                    if ((n2 = this.in.read(byArray, 0, n2)) > 0) {
                        this._actualLength -= n2;
                        this._bytesRead += n2;
                        continue;
                    }
                    ErrorMessage.raiseIOException("JZ0EM");
                }
                this.nextChunk();
            }
            this._isCached = true;
            this.doneReading();
        }
        catch (IOException iOException) {
            this._dead = true;
            throw iOException;
        }
        return this._isCached;
    }

    public int read() throws IOException {
        this.checkMe();
        if (this._visibleLength == 0) {
            return -1;
        }
        if (!this._noLimit) {
            --this._visibleLength;
        }
        int n2 = 0;
        if (this._actualLength > 0) {
            --this._actualLength;
            ++this._bytesRead;
            n2 = this.in.read();
        }
        this.checkDone();
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.checkMe();
        if (n3 == 0) {
            return 0;
        }
        int n5 = n3;
        if (!this._noLimit && this._visibleLength < n3) {
            n5 = this._visibleLength;
        }
        if (n5 == 0) {
            return -1;
        }
        n3 = n5;
        while (!(n3 <= 0 || this._actualLength <= 0 && this._lastChunk)) {
            int n6 = n4 = n3 < this._actualLength ? n3 : this._actualLength;
            if (n4 > 0) {
                int n7 = this.in.read(byArray, n2, n4);
                n2 += n7;
                n3 -= n7;
                if (this._actualLength > 0) {
                    this._actualLength -= n7;
                }
                this._bytesRead += n7;
            }
            if (this._actualLength != 0) continue;
            this.nextChunk();
        }
        if (this._noLimit) {
            if (n3 == n5) {
                return -1;
            }
            if (n3 > 0) {
                n5 -= n3;
            }
        } else {
            this._visibleLength -= n5;
            if (n3 > 0) {
                for (n4 = 0; n4 < n3; ++n4) {
                    byArray[n2 + n4] = 0;
                }
            }
        }
        this.checkDone();
        return n5;
    }

    public int available() throws IOException {
        this.checkMe();
        if (this.in == null) {
            return 0;
        }
        int n2 = 0;
        if (this._actualLength > 0) {
            n2 = this.in.available();
        }
        if (n2 < this._actualLength && n2 < this._visibleLength && !this._noLimit) {
            return n2;
        }
        return this._noLimit ? this._actualLength : this._visibleLength;
    }

    public long skip(long l2) throws IOException {
        this.checkMe();
        if (this._visibleLength == 0) {
            return 0L;
        }
        long l3 = l2;
        if (!this._noLimit) {
            if ((long)this._visibleLength < l2) {
                l3 = this._visibleLength;
            }
            this._visibleLength = (int)((long)this._visibleLength - l3);
        }
        long l4 = 0L;
        while (!(l3 <= 0L || this._actualLength <= 0 && this._lastChunk)) {
            long l5;
            long l6 = l5 = l3 < (long)this._actualLength ? l3 : (long)this._actualLength;
            if (l5 > 0L) {
                this.in.skip(l5);
                this._actualLength = (int)((long)this._actualLength - l5);
                this._bytesRead = (int)((long)this._bytesRead + l5);
                l3 -= l5;
                l4 += l5;
            }
            if (l3 <= 0L) continue;
            this.nextChunk();
        }
        this.checkDone();
        return l4;
    }

    public void close() throws IOException {
        if (this._dead) {
            return;
        }
        if (this._dead) {
            return;
        }
        this._needReset = false;
        this.checkMe();
        try {
            block8: {
                if (this._isCached) break block8;
                if (this._noLimit) {
                    while (this._actualLength > 0 || !this._lastChunk) {
                        this.skip(this._actualLength);
                    }
                    break block8;
                }
                this._visibleLength = this._actualLength;
                this.skip(this._visibleLength);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.checkDone();
            this._dead = true;
            this.in = null;
            throw throwable;
        }
        this.checkDone();
        this._dead = true;
        this.in = null;
    }

    public boolean markSupported() {
        return this._markSupported;
    }

    private void checkMe() throws IOException {
        if (this._dead) {
            ErrorMessage.raiseIOException("JZ0I9");
        }
        if (this._needReset && this._tdis != null) {
            this._tdis.reset();
            this._needReset = false;
            this.in.reset();
            this._visibleLength = this._resetVisibleLength;
            this._actualLength = this._resetActualLength;
            this._lastChunk = this._resetLastChunk;
            this._bytesRead = 0;
            this.in.skip(this._jmark);
            this._bytesRead = this._jmark;
            this._jmark = -1;
        }
        if (this._actualLength <= 0 && !this._lastChunk) {
            this.nextChunk();
        }
    }

    private void checkDone() throws IOException {
        if (this.in != null && (this._visibleLength == 0 || this._noLimit && this._actualLength == 0 && this._lastChunk)) {
            this.doneReading();
            this._isCached = true;
        }
    }

    private void doneReading() throws IOException {
        if (!this._isCached) {
            if (!this._noLimit) {
                if (this._resetActualLength > this._resetVisibleLength) {
                    this.in.read(new byte[this._actualLength]);
                } else {
                    this.in.skip(this._actualLength);
                }
            } else {
                while (!(this.in == null || this._actualLength <= 0 && this._lastChunk)) {
                    this.skip(this._actualLength);
                }
            }
        }
        if (this._cm != null) {
            this._cm.doneReading();
            this._cm = null;
        }
    }

    private void nextChunk() throws IOException {
        if (this._lastChunk) {
            return;
        }
        int n2 = this._tdis.readInt(this.in);
        this._bytesRead += 4;
        if ((n2 & Integer.MIN_VALUE) == 0) {
            this._lastChunk = true;
        }
        this._actualLength = n2 & Integer.MAX_VALUE;
    }
}

