/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.JdbcDataObject;
import com.sybase.jdbc3.jdbc.Param;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.SybStatement;
import com.sybase.jdbc3.tds.TdsNumeric;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.Cacheable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ParamManager
implements Cacheable {
    protected Param[] _params;
    protected int _next = -1;
    protected int _last = -1;
    private int _maxOutParam = -1;
    protected SybStatement _stmt;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _stmtMgr;
    private CacheManager _mgr;
    private boolean _haveOutParam = false;
    private boolean _ignoreClear = false;
    private boolean _clearingParams = false;
    protected boolean _hasLiteralParam = false;
    protected boolean _paramMarkersHaveBeenParsed = false;
    protected boolean _dontProcessParamMarkers = false;
    protected boolean _setHasBeenCalled = false;
    private String _savedParsedQuery = null;
    private boolean _templateHoldsParsedNoLiteralQuery = false;
    private ParamManager _copiedFrom = null;

    public ParamManager(int n2, int[] nArray, SybStatement sybStatement) throws SQLException {
        int n3;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(this._context, n2);
        for (n3 = 0; n3 < n2; n3 += 1) {
            this._params[n3]._paramMarkerOffset = nArray[n3];
        }
        this._mgr = new CacheManager(this._context._is);
        n3 = this._context._conn._props.getBoolean(14) ? 1 : 0;
        this._mgr.setReReadable(n3 != 0);
        int n4 = this._context._conn._props.getInteger(13);
        if (n3) {
            n4 = -1;
        }
        this._mgr.setCacheSize(n4);
        this._mgr.setChunkSize(256);
        this._mgr.setAbortOnCacheOverflow(true);
    }

    public ParamManager(ParamManager paramManager, SybStatement sybStatement) throws SQLException {
        boolean bl;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        boolean bl2 = paramManager._params.length;
        this._params = this._protocol.paramArray(this._context, bl2 ? 1 : 0);
        for (bl = false; bl < bl2; bl += 1) {
            this._params[bl]._paramMarkerOffset = paramManager._params[bl]._paramMarkerOffset;
        }
        this._mgr = this._context._conn.getSharedCacheManager();
        if (this._mgr == null) {
            this._mgr = new CacheManager(this._context._is);
            bl = this._context._conn._props.getBoolean(14);
            this._mgr.setReReadable(bl);
            int n2 = this._context._conn._props.getInteger(13);
            if (bl) {
                n2 = -1;
            }
            this._mgr.setCacheSize(n2);
            this._mgr.setChunkSize(256);
            this._mgr.setAbortOnCacheOverflow(true);
            this._context._conn.setSharedCacheManager(this._mgr);
        }
        if (paramManager._templateHoldsParsedNoLiteralQuery) {
            this._hasLiteralParam = paramManager._hasLiteralParam;
            this._savedParsedQuery = paramManager._savedParsedQuery;
            this._paramMarkersHaveBeenParsed = true;
        }
        this._copiedFrom = paramManager;
    }

    public ParamManager(int n2, ProtocolContext protocolContext) throws SQLException {
        this._context = protocolContext;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(n2, this._mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        try {
            if (this._haveOutParam) {
                if (this._maxOutParam >= 0 && this._params[this._maxOutParam]._outValue == null) {
                    this.getOutValueAt(this._maxOutParam + 1);
                }
                if (!this._clearingParams) {
                    this.clearParams(false);
                }
            }
            this._mgr.clear();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
        finally {
            this._stmtMgr.dead(this);
        }
    }

    public void setManager(CacheManager cacheManager) {
    }

    public void reset() throws IOException {
    }

    public void resetInputStream(InputStream inputStream) {
    }

    public void cache() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        this._ignoreClear = true;
        this._mgr.register(this);
        this._mgr.open(this);
        this._mgr.doneReading();
        this._mgr.dead(this);
        this._ignoreClear = false;
        this._stmtMgr.doneReading();
    }

    public void open(boolean bl) {
    }

    public int getState() {
        return 1;
    }

    public int getNext() {
        return this._next;
    }

    public Param[] getParams() {
        return this._params;
    }

    public ProtocolContext getContext() {
        return this._context;
    }

    protected synchronized void clearParams(boolean bl) throws IOException {
        if (this._clearingParams) {
            return;
        }
        if (this._haveOutParam) {
            this._clearingParams = true;
            this._stmtMgr.open(this);
            this.cache();
            this._clearingParams = false;
            this._haveOutParam = false;
        }
        this.clearParamArray(bl);
        this._mgr.clear();
        this._mgr.allDead();
    }

    protected synchronized void clearParamArray(boolean bl) throws IOException {
        int n2 = 0;
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            n2 = 1;
            this._params[0].clear(false);
        }
        for (int i2 = n2; i2 < this._params.length; ++i2) {
            this._params[i2].clear(bl);
        }
        this._next = -1;
        this._last = -1;
    }

    private void checkIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this._params.length) {
            ErrorMessage.raiseError("JZ0SB", "" + n2);
        }
    }

    private void checkType(int n2) throws SQLException {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SL", "" + n2);
            }
        }
    }

    public void setParam(int n2, int n3, Object object, int n4) throws SQLException {
        this.checkIndex(n2);
        Param param = this._params[--n2];
        if (param._sqlType == -998) {
            ErrorMessage.raiseError("JZ0SC");
        }
        try {
            param.clear(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        switch (n3) {
            case 2: {
                if (!(object instanceof BigDecimal)) break;
                TdsNumeric.checkRange((BigDecimal)object, n4);
                break;
            }
        }
        param._sqlType = n3;
        param._inValue = object;
        param._scale = n4;
        this._setHasBeenCalled = true;
    }

    public void registerParam(int n2, int n3, int n4) throws SQLException {
        this.registerParam(n2, n3);
        this._params[n2 - 1]._scale = n4;
    }

    public void registerParam(int n2, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkType(n3);
        if (--n2 > this._maxOutParam) {
            this._maxOutParam = n2;
        }
        this._params[n2]._regType = n3;
    }

    public void registerParam(int n2, int n3, String string) throws SQLException {
        this.registerParam(n2, n3);
        this._params[--n2]._outParamClassName = string;
    }

    private void checkReceive() throws SQLException {
        if (this._next < 0) {
            ErrorMessage.raiseError("JZ0SF");
        }
    }

    public JdbcDataObject getOutValueAt(int n2) throws SQLException {
        this.checkReceive();
        this.checkIndex(n2);
        if (this._params[--n2]._regType == -999 || this._stmt._hasReturn && n2 == 0 && !this._stmt._returnHasBeenRegistered) {
            ErrorMessage.raiseError("JZ0SB", "" + n2);
        }
        while (this._params[n2]._outValue == null) {
            this.nextOutParam();
            while (this._params[n2]._outValue == null) {
                this.nextResult();
            }
        }
        this._last = n2;
        return this._params[n2]._outValue;
    }

    public Object getOutObjectAt(int n2) throws SQLException {
        Object object = null;
        JdbcDataObject jdbcDataObject = this.getOutValueAt(n2);
        switch (this._params[--n2]._regType) {
            case -6: 
            case 5: {
                object = Convert.objectToShort(jdbcDataObject.getObject());
                break;
            }
            case -5: {
                Object object2 = jdbcDataObject.getObject();
                if (object2 == null) {
                    object = null;
                    break;
                }
                if (object2 instanceof Integer) {
                    object = new Long(((Integer)object2).longValue());
                    break;
                }
                if (object2 instanceof BigDecimal) {
                    object = new Long(((BigDecimal)object2).longValue());
                    break;
                }
                if (!(object2 instanceof Long)) break;
                object = object2;
                break;
            }
            case 2: 
            case 3: {
                if (this._params[n2]._scale != -999) {
                    object = jdbcDataObject.getBigDecimal(this._params[n2]._scale);
                    break;
                }
                object = jdbcDataObject.getBigDecimal(-1);
                break;
            }
            case 6: {
                object = Convert.objectToFloat(jdbcDataObject.getObject());
                break;
            }
            case 91: {
                object = Convert.objectToDate(jdbcDataObject.getDateObject(91, null));
                break;
            }
            case 92: {
                object = Convert.objectToTime(jdbcDataObject.getDateObject(92, null));
                break;
            }
            case 93: {
                object = Convert.objectToTimestamp(jdbcDataObject.getDateObject(93, null));
                break;
            }
            default: {
                object = jdbcDataObject.getObject();
            }
        }
        return object;
    }

    public boolean hasInParams() {
        if (this._params.length == 0) {
            return false;
        }
        return this._params.length > 1 || this._params[0]._sqlType != -998;
    }

    protected boolean wasNull() throws SQLException {
        this.checkReceive();
        if (this._last < 0 || this._params[this._last]._outValue == null) {
            ErrorMessage.raiseError("JZ0SD");
        }
        return this._params[this._last]._outValue.isNull();
    }

    protected void getParameter() throws SQLException {
        this.checkReceive();
        this._protocol.param(this);
    }

    public int nextOutParam() {
        if (this._next < this._params.length && this._params[this._next]._outValue != null) {
            ++this._next;
        }
        while (this._next < this._params.length && this._params[this._next]._regType == -999) {
            ++this._next;
        }
        return this._next;
    }

    public void registerParam(Cacheable cacheable) throws SQLException {
        this.nextOutParam();
        try {
            this._haveOutParam = true;
            this._mgr.register(cacheable);
            this._mgr.open(cacheable);
            this._stmtMgr.register(this);
            this._stmtMgr.open(this);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void registerStatus(Cacheable cacheable) throws SQLException {
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            this.registerParam(cacheable);
        } else {
            try {
                cacheable.clear();
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    private int nextResult() throws SQLException {
        int n2 = this._next;
        while (true) {
            try {
                while (true) {
                    int n3 = this._stmt.nextResult();
                    switch (n3) {
                        case 3: {
                            return n3;
                        }
                        case 0: {
                            ErrorMessage.raiseError("JZ0SG");
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
                continue;
            }
            break;
        }
    }

    public void checkParams(Protocol protocol, boolean bl) throws SQLException {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2].prepareForSend(protocol, i2, bl);
            bl2 |= this._params[i2]._sendAsLiteral;
        }
        if (this._paramMarkersHaveBeenParsed) {
            if (!this._setHasBeenCalled) {
                this._dontProcessParamMarkers = true;
            } else if (!bl2 && !this._hasLiteralParam) {
                this._dontProcessParamMarkers = true;
            }
        }
        this._hasLiteralParam = bl2;
    }

    public void parseParamsAgain() {
        this._paramMarkersHaveBeenParsed = false;
    }

    public void send(OutputStream outputStream) throws IOException, SQLException {
        this._next = 0;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2].send(outputStream, this._context._maxFieldSize);
        }
    }

    public int getLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            n2 += this._params[i2].getLength();
        }
        return n2;
    }

    public void adjustOffsets(int n2) {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2]._paramMarkerOffset += n2;
        }
    }

    protected void literalizeAll() {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2]._sendAsLiteral = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processParamMarkers(String string) throws SQLException {
        if (this._params.length == 0) {
            return null;
        }
        if (this._dontProcessParamMarkers) {
            this._dontProcessParamMarkers = false;
            this._setHasBeenCalled = false;
            return this._savedParsedQuery;
        }
        int n2 = 0;
        if (this._params[n2]._sqlType == -998) {
            ++n2;
        }
        if (n2 == this._params.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = 0;
        try {
            while (n2 < this._params.length) {
                if (this._params[n2]._sqlType != -998) {
                    stringBuffer.append(string.substring(n3, this._params[n2]._paramMarkerOffset));
                    stringBuffer.append(this._params[n2].literalValue(this._protocol, n2, this._context._maxFieldSize));
                    n3 = this._params[n2]._paramMarkerOffset + 1;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        this._savedParsedQuery = stringBuffer.toString();
        if (!this._hasLiteralParam && this._copiedFrom != null && !this._copiedFrom._templateHoldsParsedNoLiteralQuery) {
            ParamManager paramManager = this._copiedFrom;
            synchronized (paramManager) {
                if (!this._copiedFrom._templateHoldsParsedNoLiteralQuery) {
                    this._copiedFrom._savedParsedQuery = this._savedParsedQuery;
                    this._copiedFrom._hasLiteralParam = this._hasLiteralParam;
                    this._copiedFrom._templateHoldsParsedNoLiteralQuery = true;
                }
            }
        }
        this._dontProcessParamMarkers = false;
        this._setHasBeenCalled = false;
        this._paramMarkersHaveBeenParsed = true;
        return this._savedParsedQuery;
    }

    public int makeFormats() throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            if (!this._params[i2].makeFormat(this._protocol)) continue;
            ++n2;
        }
        return n2;
    }

    public void sendFormats(DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2].sendFormat(dataOutput);
        }
    }
}

