/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import java.io.IOException;
import java.io.InputStream;

public class LimiterInputStream
extends InputStream {
    public static final int NO_LIMIT = -1;
    private int _lengthLimit;
    private InputStream _in;

    public LimiterInputStream(InputStream inputStream, int n2) throws IOException {
        this._lengthLimit = n2;
        this._in = inputStream;
    }

    public int read() throws IOException {
        if (this._lengthLimit == 0) {
            return -1;
        }
        if (this._lengthLimit != -1) {
            --this._lengthLimit;
        }
        return this._in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3;
        if (this._lengthLimit == 0) {
            return -1;
        }
        if (this._lengthLimit != -1 && n4 > this._lengthLimit) {
            n4 = this._lengthLimit;
        }
        int n5 = this._in.read(byArray, n2, n4);
        if (this._lengthLimit != -1) {
            this._lengthLimit -= n5;
        }
        return n5;
    }

    public long skip(long l2) throws IOException {
        long l3 = l2;
        if (this._lengthLimit != -1 && l3 > (long)this._lengthLimit) {
            l3 = this._lengthLimit;
        }
        long l4 = this._in.skip(l3);
        if (this._lengthLimit != -1) {
            this._lengthLimit = (int)((long)this._lengthLimit - l4);
        }
        return l4;
    }

    public int available() throws IOException {
        int n2 = this._in.available();
        if (this._lengthLimit != -1 && n2 > this._lengthLimit) {
            return this._lengthLimit;
        }
        return n2;
    }

    public void close() throws IOException {
        this._lengthLimit = 0;
        this._in.close();
    }
}

