/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.Escape;
import com.sybase.jdbc3.jdbc.SybStatement;
import java.sql.SQLException;

class EscapeTokenizer {
    static final int START = 1;
    static final int IN_SINGLE_QUOTES = 2;
    static final int IN_DOUBLE_QUOTES = 3;
    private StringBuffer _text;
    private char[] _textCharBuf;
    private int _nextIndex;
    private SybStatement _stmt;
    private int _mark;
    private boolean _openCursor = false;
    private static final String SQL_DELIMITERS = " %&'()*+,-./:;<=>?[|\t\n";

    EscapeTokenizer(SybStatement sybStatement, String string) {
        this.updateText(new StringBuffer(string));
        this._stmt = sybStatement;
        this._nextIndex = 0;
        this._stmt._type = 0;
        this._stmt._setEnd = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object next() throws SQLException {
        Object object;
        int n2 = 1;
        if (this._nextIndex == 0) {
            String string = this.nextWord(0);
            if ("exec".equalsIgnoreCase(string)) {
                this._nextIndex = this._text.length();
                this._stmt._type = 1;
                return new Escape(this._text.toString(), 1);
            }
            if ("select".equalsIgnoreCase(string)) {
                this._stmt._type = 2;
            } else if ("delete".equalsIgnoreCase(string)) {
                this._stmt._type = 4;
                string = this.nextWord(-1);
                if (string != null && string.equalsIgnoreCase("from")) {
                    string = this.nextWord(-1);
                }
                this._stmt._table = this.completeTableName(string);
            } else if ("update".equalsIgnoreCase(string)) {
                this._stmt._type = 8;
                string = this.nextWord(-1);
                if ((string = this.completeTableName(string)) != null) {
                    this._stmt._setStart = this._mark - 1;
                }
                this._stmt._table = string;
            }
        }
        if (this._nextIndex >= this._text.length()) {
            object = null;
        } else if (this._text.charAt(this._nextIndex) == '{') {
            int n3 = -1;
            block15: for (int i2 = this._nextIndex + 1; i2 < this._text.length(); ++i2) {
                char c2 = this._text.charAt(i2);
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        n2 = EscapeTokenizer.nextState(n2, c2);
                        break;
                    }
                    case '}': {
                        if (n2 != 1) break;
                        n3 = i2;
                        break block15;
                    }
                    case '{': {
                        if (n2 != 1) break;
                        int n4 = EscapeTokenizer.matchClosingChar(c2, this._text, i2) + 1;
                        if (n4 == 0) {
                            ErrorMessage.raiseError("JZ0S8", this._text.toString());
                        }
                        String string = this._stmt.processEscapes(new String(this._textCharBuf, i2, n4 - i2));
                        int n5 = string.length();
                        int n6 = i2 + n5 + this._textCharBuf.length - n4;
                        StringBuffer stringBuffer = new StringBuffer(n6);
                        stringBuffer.append(this._textCharBuf, 0, i2);
                        stringBuffer.append(string);
                        stringBuffer.append(this._textCharBuf, n4, this._textCharBuf.length - n4);
                        i2 += n5 - 1;
                        this.updateText(stringBuffer);
                    }
                }
            }
            if (n3 == -1) {
                ErrorMessage.raiseError("JZ0S8", this._text.toString());
            }
            String string = new String(this._textCharBuf, this._nextIndex, n3 + 1 - this._nextIndex);
            Escape escape = new Escape(string);
            object = escape;
            this._stmt._setEnd -= string.length() - escape.getBody().length();
            switch (escape.getType()) {
                case 4: {
                    this._stmt._setEnd += "1970-1-1 ".length();
                    break;
                }
                case 3: {
                    this._stmt._setEnd += "00:00:00 ".length();
                    break;
                }
            }
            this._nextIndex = n3 + 1;
        } else {
            int n7 = -1;
            block16: for (int i3 = this._nextIndex; i3 < this._text.length(); ++i3) {
                char c3 = this._text.charAt(i3);
                switch (c3) {
                    case '\"': 
                    case '\'': {
                        n2 = EscapeTokenizer.nextState(n2, c3);
                        break;
                    }
                    case '{': {
                        if (n2 != 1) break;
                        n7 = i3;
                        break block16;
                    }
                    case 'F': 
                    case 'f': {
                        if (n2 != 1 || this._stmt._type != 2) break;
                        String string = this.nextWord(i3);
                        if ("from".equalsIgnoreCase(string)) {
                            string = this.nextWord(-1);
                            this._stmt._table = this.completeTableName(string);
                            if (this._stmt._cursor != null) {
                                this._stmt._cursor.setTable(this._stmt._table);
                            }
                            if (this._stmt._context._conn._props.getBoolean(33) && this._stmt._cursor == null) break;
                            this._stmt._type |= 0x1000;
                            break;
                        }
                        if (!this._stmt._context._conn._props.getBoolean(33) || !"for".equalsIgnoreCase(string)) break;
                        string = this.nextWord(-1);
                        if ("update".equalsIgnoreCase(string)) {
                            this._openCursor = true;
                        }
                        this._stmt._type |= 0x1000;
                        break;
                    }
                    case 'W': 
                    case 'w': {
                        String string;
                        if (n2 != 1) break;
                        if ((this._stmt._type & (4 | 8)) == 0 || !"where".equalsIgnoreCase(string = this.nextWord(i3)) || !"current".equalsIgnoreCase(string = this.nextWord(-1)) || !"of".equalsIgnoreCase(string = this.nextWord(-1))) break;
                        this._stmt._type |= 0x1000;
                        this._stmt._setEnd += i3 - 1;
                    }
                }
            }
            if (n7 == -1) {
                n7 = this._text.length();
            }
            object = new String(this._textCharBuf, this._nextIndex, n7 - this._nextIndex);
            this._nextIndex = n7;
        }
        if (this._openCursor) {
            this._stmt.checkCursor(false);
            this._stmt._cursor.getName();
            this._openCursor = false;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int matchClosingChar(char c2, StringBuffer stringBuffer, int n2) {
        int n3 = 1;
        int n4 = -1;
        int n5 = n2 + 1;
        while (n5 < stringBuffer.length()) {
            char c3 = stringBuffer.charAt(n5);
            switch (c3) {
                case '\"': 
                case '\'': {
                    n3 = EscapeTokenizer.nextState(n3, c3);
                    break;
                }
                case ')': 
                case '}': {
                    if (n3 != 1) break;
                    if (c3 == '}') {
                        if (c2 == '{') return n5;
                    }
                    if (c3 != ')' || c2 != '(') break;
                    return n5;
                }
                case '(': 
                case '{': {
                    if (n3 != 1 || c3 != c2) break;
                    n5 = EscapeTokenizer.matchClosingChar(c3, stringBuffer, n5);
                }
            }
            ++n5;
        }
        return n4;
    }

    protected static int nextState(int n2, char c2) {
        int n3 = n2;
        switch (c2) {
            case '\'': {
                if (n2 == 2) {
                    n3 = 1;
                    break;
                }
                if (n2 != 1) break;
                n3 = 2;
                break;
            }
            case '\"': {
                if (n2 == 3) {
                    n3 = 1;
                    break;
                }
                if (n2 != 1) break;
                n3 = 3;
                break;
            }
        }
        return n3;
    }

    private void updateText(StringBuffer stringBuffer) {
        this._text = stringBuffer;
        int n2 = stringBuffer.length();
        this._textCharBuf = new char[n2];
        if (n2 > 0) {
            this._text.getChars(0, n2, this._textCharBuf, 0);
        }
    }

    private String nextWord(int n2) {
        if (n2 >= 0) {
            this._mark = n2;
        }
        String string = null;
        int n3 = this._text.length();
        while (this._mark < n3 && SQL_DELIMITERS.indexOf(this._text.charAt(this._mark)) != -1) {
            ++this._mark;
        }
        if (this._mark >= n3) {
            string = null;
        } else {
            if (this._mark > 0 && this._text.charAt(this._mark) == '\"') {
                n3 = this._text.toString().indexOf(34, this._mark + 1) + 1;
            } else {
                for (int i2 = this._mark; i2 < n3; ++i2) {
                    if (SQL_DELIMITERS.indexOf(this._text.charAt(i2)) == -1) continue;
                    n3 = i2;
                    break;
                }
            }
            if (n3 > this._mark) {
                string = String.copyValueOf(this._textCharBuf, this._mark, n3 - this._mark);
                this._mark = n3 + 1;
                n3 = this._text.length();
            }
        }
        return string;
    }

    private String completeTableName(String string) {
        String string2 = string;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this._mark >= this._text.length()) continue;
            if (this._text.charAt(this._mark - 1) != '.') break;
            if (this._text.charAt(this._mark) == '.') {
                string2 = string2 + ".";
                ++i2;
            }
            string2 = string2 + "." + this.nextWord(-1);
        }
        return string2;
    }
}

