/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.EscapeTokenizer;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Escape {
    protected static final int CALL = 1;
    protected static final int RETURN_CALL = 2;
    protected static final int DATE = 3;
    protected static final int TIME = 4;
    protected static final int TIMESTAMP = 5;
    protected static final int FUNCTION = 6;
    protected static final int LIKE_ESCAPE = 7;
    protected static final int OUTER_JOIN = 8;
    protected static final int UNKNOWN = -1;
    private static final char LEFT_CURLY = '{';
    private static final char RIGHT_CURLY = '}';
    private static final char COMMA = ',';
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char PERCENT_SIGN = '%';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final int MAX_ARGUMENTS = 4;
    private int _type;
    private String _body;

    Escape(String string) throws SQLException {
        int n2;
        String string2;
        int n3;
        int n4;
        int n5 = string.length();
        for (n4 = 1; n4 < n5 && Character.isWhitespace(string.charAt(n4)); ++n4) {
        }
        if (n4 == n5) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        for (n3 = n4; n3 < n5 && !Character.isWhitespace(string.charAt(n3)); ++n3) {
        }
        if (n3 == n5) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        if ((string2 = string.substring(n4, n3).toLowerCase()).equals("call")) {
            this._type = 1;
        } else if (string2.equals("?") || string2.equals("?=") || string2.equals("?=call")) {
            n3 = string.toLowerCase().indexOf("call") + 4;
            this._type = 2;
        } else if (string2.equals("d")) {
            this._type = 3;
        } else if (string2.equals("t")) {
            this._type = 4;
        } else if (string2.equals("ts")) {
            this._type = 5;
        } else if (string2.equals("fn")) {
            this._type = 6;
        } else if (string2.equals("escape")) {
            this._type = 7;
        } else if (string2.equals("oj")) {
            this._type = 8;
        } else {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        for (n2 = n3; n2 < n5 && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 == n5 - 1) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        int n6 = n5 - 2;
        while (Character.isWhitespace(string.charAt(n6))) {
            --n6;
        }
        this._body = string.substring(n2, n6 + 1);
    }

    Escape(String string, int n2) throws SQLException {
        this._body = string;
        this._type = n2;
    }

    protected int getType() {
        return this._type;
    }

    protected String getBody() {
        return this._body;
    }

    protected String functionName() throws SQLException {
        String string = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this._body, " \t\n\r(");
            string = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        string = string.toLowerCase();
        if (string.equals("convert") || string.equals("timestampadd") || string.equals("timestampdiff")) {
            int n2;
            int n3;
            if (string.equals("convert")) {
                n3 = this._body.lastIndexOf(44) + 1;
                n2 = this._body.lastIndexOf(41) - 1;
            } else {
                n3 = this._body.indexOf(40) + 1;
                n2 = this._body.indexOf(44) - 1;
            }
            int n4 = this._body.length();
            while (n3 <= n4 && Character.isWhitespace(this._body.charAt(n3))) {
                ++n3;
            }
            while (n2 > 0 && Character.isWhitespace(this._body.charAt(n2))) {
                --n2;
            }
            if (n3 < 0 || n2 < 0 || n2 < n3 + 1) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
            string = string + this._body.substring(n3, n2 + 1).toLowerCase();
        }
        return string;
    }

    protected String doMap(String string) throws SQLException {
        int n2;
        String[] stringArray = new String[5];
        int n3 = this._body.indexOf(40);
        int n4 = this._body.lastIndexOf(41);
        if (n3 < 0 || n4 < 0 || n4 < n3 + 1) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        String string2 = this._body.substring(n3 + 1, n4);
        for (int i2 = 1; i2 <= 4 && string2.length() > 0; ++i2) {
            n2 = this.nextComma(string2);
            if (n2 < 0) {
                stringArray[i2] = string2;
                break;
            }
            if (n2 == 0) {
                ErrorMessage.raiseError("JZ0S8", this._body);
                continue;
            }
            stringArray[i2] = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        n2 = string.length();
        for (int i3 = 0; i3 < n2; ++i3) {
            if (string.charAt(i3) == '%') {
                int n5 = 0;
                try {
                    n5 = Integer.parseInt(string.substring(i3 + 1, i3 + 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (stringArray[n5] == null) {
                    ErrorMessage.raiseError("JZ0S8", this._body);
                } else {
                    stringBuffer.append(stringArray[n5]);
                }
                ++i3;
                continue;
            }
            stringBuffer.append(string.charAt(i3));
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextComma(String string) throws SQLException {
        int n2 = string.length();
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            char c2 = string.charAt(n5);
            switch (c2) {
                case '\"': 
                case '\'': {
                    n4 = EscapeTokenizer.nextState(n4, c2);
                    break;
                }
                case '(': {
                    if (n4 != 1 || (n5 = EscapeTokenizer.matchClosingChar(c2, new StringBuffer(string), n5)) >= 0) break;
                    ErrorMessage.raiseError("JZ0S8", this._body);
                    break;
                }
                case ',': {
                    if (n4 != 1) break;
                    return n5;
                }
            }
            ++n5;
        }
        return n3;
    }
}

