/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.RawInputStream;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.CacheStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class CharsetToUniInputStream
extends RawInputStream {
    private int _currentChar;
    protected int _readBytes = 0;
    protected int _lengthLimit = 0;
    private InputStreamReader _isr = null;
    protected RawInputStream _ris = null;
    protected boolean _even;
    protected boolean _closed;

    public CharsetToUniInputStream(InputStream inputStream, int n2, int n3, CacheManager cacheManager) throws IOException {
        super(inputStream, n2, n3, cacheManager);
    }

    public CharsetToUniInputStream(InputStream inputStream, int n2, int n3, CacheManager cacheManager, String string) throws UnsupportedEncodingException, IOException {
        super(inputStream, n2, n3, cacheManager);
        this._lengthLimit = n3 * 2;
        this._ris = new RawInputStream(inputStream, n2, n3, cacheManager);
        this._isr = string == null ? new InputStreamReader(this._ris) : new InputStreamReader((InputStream)this._ris, string);
        this._even = true;
        this._closed = false;
    }

    public boolean cache(CacheStream cacheStream) throws IOException {
        return this._ris.cache(cacheStream);
    }

    public void setCached(boolean bl) {
        this._ris.setCached(bl);
    }

    public int read() throws IOException {
        int n2;
        if (this._closed) {
            return -1;
        }
        if (this._even) {
            this._currentChar = this._isr.read();
            if (this._currentChar == -1) {
                this._closed = true;
                return -1;
            }
            n2 = (this._currentChar & 0xFF00) >> 8;
        } else {
            n2 = this._currentChar & 0xFF;
        }
        this._even = !this._even;
        ++this._readBytes;
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            int n5 = this.read();
            if (n5 == -1) {
                return n4 == 0 ? -1 : n4;
            }
            byArray[n4 + n2] = (byte)(n5 & 0xFF);
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        long l3;
        for (l3 = 0L; l3 < l2 && this.read() >= 0; ++l3) {
        }
        return l3;
    }

    public int available() throws IOException {
        if (this._closed) {
            return 0;
        }
        int n2 = this._lengthLimit - this._readBytes;
        return n2;
    }

    public void close() throws IOException {
        this._ris.close();
    }
}

