/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class UtilTransliteratorUsingSunIO
extends UtilTransliterator {
    private static String footprint = "$Revision:   1.4.1.0  $";
    private String encoding;
    private static final int CHUNK = 256;
    private CharToByteConverter c2b;
    private ByteToCharConverter b2c;
    private int maxBytesPerChar;
    private int maxCharsPerByte;

    public UtilTransliteratorUsingSunIO(String string) throws UtilException {
        try {
            this.encoding = string;
            this.c2b = CharToByteConverter.getConverter((String)string);
            this.b2c = ByteToCharConverter.getConverter((String)string);
            this.maxBytesPerChar = this.c2b.getMaxBytesPerChar();
            this.maxCharsPerByte = this.b2c.getMaxCharsPerByte();
            this.setCacheSize(256);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        int n4 = n3 * this.maxCharsPerByte;
        char[] cArray = this.charsCache.length >= n4 ? this.charsCache : new char[n4];
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n5 = this.b2c.convert(byArray, n2, n3, this.charsCache, 0, n4);
            n5 += this.b2c.flush(this.charsCache, n5, n4);
            return new String(this.charsCache, 0, n5);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw new UtilException(1009);
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw new UtilException(1009);
        }
        catch (MalformedInputException malformedInputException) {
            throw new UtilException(1009);
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, 256);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                int n5 = 0;
                while (n5 < n4) {
                    this.charsCache[n5] = (char)(this.bytesCache[n5] & 0xFF);
                    ++n5;
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new UtilException(1009);
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, 256);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new UtilException(1009);
        }
    }

    public byte[] encode(String string) throws UtilException {
        int n2 = string.length();
        char[] cArray = n2 <= this.charsCache.length ? this.charsCache : new char[n2];
        string.getChars(0, n2, cArray, 0);
        try {
            return this.c2b.convertAll(cArray);
        }
        catch (MalformedInputException malformedInputException) {
            throw new UtilException(1009);
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        int n3 = n2 * this.maxBytesPerChar;
        byte[] byArray = this.bytesCache.length >= n3 ? this.bytesCache : new byte[n3];
        try {
            this.c2b.reset();
            this.c2b.setSubstitutionMode(true);
            char[] cArray = this.charsCache.length >= n2 ? this.charsCache : new char[n2];
            string.getChars(0, n2, cArray, 0);
            int n4 = this.c2b.convert(cArray, 0, n2, byArray, 0, n3);
            nArray[0] = n4 += this.c2b.flush(byArray, this.c2b.nextByteIndex(), n3);
            return byArray;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw new UtilException(1009);
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw new UtilException(1009);
        }
        catch (MalformedInputException malformedInputException) {
            throw new UtilException(1009);
        }
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public int getMaxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public boolean isFixedBytesPerChar() {
        return this.c2b.getMaxBytesPerChar() == 1;
    }
}

