/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTempBuffer;
import com.microsoft.util.UtilTempBufferBlock;
import com.microsoft.util.UtilTempBufferInputStream;
import com.microsoft.util.UtilTempBufferOutputStream;
import com.microsoft.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class UtilPagedTempBuffer
implements UtilTempBuffer {
    private static String footprint = "$Revision:   1.9.1.0  $";
    private UtilTempBufferBlock[] blocks;
    protected byte[] staticByteArray;
    private int blockSize;
    private int blockShift;
    private File tmpFileInfo;
    private RandomAccessFile tmpFile;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    long nextAvail;
    static final int DEFAULT_NUM_BLOCKS = 128;
    static final int DEFAULT_BLOCK_SIZE = 16;
    static final int DEFAULT_BLOCK_SHIFT = 14;
    static final String TEMP_FILE_PREFIX = "ddtb";

    public UtilPagedTempBuffer() {
        this(128, 16);
    }

    public UtilPagedTempBuffer(int n2) {
        this(n2, 16);
    }

    public UtilPagedTempBuffer(int n2, int n3) {
        this.blocks = new UtilTempBufferBlock[n2];
        this.setBlockSize(n3);
        this.tmpFileInfo = null;
        this.tmpFile = null;
        this.nextAvail = 0L;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.staticByteArray = new byte[256];
    }

    private void closeInputStream() {
        block2: {
            if (this.lastInputStream == null) break block2;
            try {
                this.lastInputStream.close();
                this.lastInputStream = null;
            }
            catch (IOException iOException) {}
        }
    }

    private void closeOutputStream() {
        block2: {
            if (this.lastOutputStream == null) break block2;
            try {
                this.lastOutputStream.close();
                this.lastOutputStream = null;
            }
            catch (IOException iOException) {}
        }
    }

    private void compressBlockList() {
        UtilTempBufferBlock[] utilTempBufferBlockArray = this.blocks;
        UtilTempBufferBlock[] utilTempBufferBlockArray2 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < utilTempBufferBlockArray.length) {
            if (utilTempBufferBlockArray[n3] != null) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            throw new OutOfMemoryError();
        }
        utilTempBufferBlockArray2 = new UtilTempBufferBlock[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < utilTempBufferBlockArray.length) {
            if (utilTempBufferBlockArray[n5] != null) {
                utilTempBufferBlockArray2[n4] = utilTempBufferBlockArray[n5];
                utilTempBufferBlockArray[n5] = null;
                if (++n4 == n2) break;
            }
            ++n5;
        }
        this.blocks = utilTempBufferBlockArray2;
    }

    protected void finalize() throws Throwable {
        this.truncate(true);
    }

    private UtilTempBufferBlock getBlock(int n2, boolean bl) throws UtilException {
        int n3 = n2 % this.blocks.length;
        if (this.blocks[n3] == null) {
            try {
                this.blocks[n3] = new UtilTempBufferBlock(this.blockSize);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.compressBlockList();
                n3 = n2 % this.blocks.length;
            }
        }
        UtilTempBufferBlock utilTempBufferBlock = this.blocks[n3];
        if (utilTempBufferBlock.blockNum != n2) {
            if (utilTempBufferBlock.blockDirty) {
                this.writeTmpFile(utilTempBufferBlock);
            }
            utilTempBufferBlock.blockNum = n2;
            utilTempBufferBlock.blockDirty = false;
            if (bl) {
                this.readTmpFile(utilTempBufferBlock);
                utilTempBufferBlock.blockDirty = false;
            }
        }
        return this.blocks[n3];
    }

    public InputStream getInputStream() {
        this.closeInputStream();
        this.lastInputStream = new UtilTempBufferInputStream(this);
        return this.lastInputStream;
    }

    public OutputStream getOutputStream() {
        this.closeOutputStream();
        this.lastOutputStream = new UtilTempBufferOutputStream(this);
        return this.lastOutputStream;
    }

    public long getSize() {
        return this.nextAvail;
    }

    private RandomAccessFile getTempFile() throws UtilException {
        if (this.tmpFile == null) {
            try {
                this.tmpFileInfo = UtilTempFile.createTempFile(TEMP_FILE_PREFIX);
                this.tmpFile = new RandomAccessFile(this.tmpFileInfo, "rw");
            }
            catch (IOException iOException) {
                throw new UtilException(1012, iOException.getMessage());
            }
        }
        return this.tmpFile;
    }

    public byte read(long l2) throws UtilException {
        byte[] byArray = new byte[1];
        int n2 = this.read(l2, byArray, 0, 1);
        if (n2 != 1) {
            throw new UtilException(1016);
        }
        return byArray[0];
    }

    public byte[] read(long l2, int n2) throws UtilException {
        byte[] byArray;
        int n3;
        if (l2 + (long)n2 > this.nextAvail) {
            n2 = (int)(this.nextAvail - l2);
        }
        if ((n3 = this.read(l2, byArray = new byte[n2], 0, n2)) != n2) {
            throw new UtilException(1016);
        }
        return byArray;
    }

    public int read(long l2, UtilDataConsumer utilDataConsumer, int n2) throws UtilException {
        UtilDebug.assert("offset can not be negative", l2 >= 0L);
        UtilDebug.assert("dataConsumer can not be null", utilDataConsumer != null);
        UtilDebug.assert("length can not be negative", n2 >= 0);
        UtilDebug.assert("Attempting to read past end of file", l2 + (long)n2 <= this.nextAvail);
        if (l2 + (long)n2 > this.nextAvail) {
            n2 = (int)(this.nextAvail - l2);
        }
        int n3 = (int)(l2 >> this.blockShift);
        int n4 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l2 & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            utilTempBufferBlock = this.getBlock(n3, true);
            utilDataConsumer.putArrayOfBytes(utilTempBufferBlock.data, n5, n6);
            n4 += n6;
            if ((n2 -= n6) == 0) break;
            l2 += (long)n6;
            ++n3;
        }
        return n4;
    }

    public int read(long l2, byte[] byArray, int n2, int n3) throws UtilException {
        UtilDebug.assert("offset can not be negative", l2 >= 0L);
        UtilDebug.assert("buffer can not be null", byArray != null);
        UtilDebug.assert("bufferOffset can not be negative", n2 >= 0);
        UtilDebug.assert("length can not be negative", n3 >= 0);
        if (l2 + (long)n3 > this.nextAvail) {
            n3 = (int)(this.nextAvail - l2);
        }
        int n4 = (int)(l2 >> this.blockShift);
        int n5 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n6;
            int n7;
            if ((n7 = this.blockSize - (n6 = (int)(l2 & (long)(this.blockSize - 1)))) > n3) {
                n7 = n3;
            }
            utilTempBufferBlock = this.getBlock(n4, true);
            System.arraycopy(utilTempBufferBlock.data, n6, byArray, n2, n7);
            n5 += n7;
            if ((n3 -= n7) == 0) break;
            n2 += n7;
            l2 += (long)n7;
            ++n4;
        }
        return n5;
    }

    public int readInt(long l2) throws UtilException {
        this.read(l2, this.staticByteArray, 0, 4);
        int n2 = ((this.staticByteArray[0] & 0xFF) << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + (this.staticByteArray[3] & 0xFF);
        return n2;
    }

    public long readLong(long l2) throws UtilException {
        this.read(l2, this.staticByteArray, 0, 8);
        long l3 = (((long)this.staticByteArray[0] & 0xFFL) << 56) + (((long)this.staticByteArray[1] & 0xFFL) << 48) + (((long)this.staticByteArray[2] & 0xFFL) << 40) + (((long)this.staticByteArray[3] & 0xFFL) << 32) + (((long)this.staticByteArray[4] & 0xFFL) << 24) + (((long)this.staticByteArray[5] & 0xFFL) << 16) + (((long)this.staticByteArray[6] & 0xFFL) << 8) + ((long)this.staticByteArray[7] & 0xFFL);
        return l3;
    }

    private void readTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n2 = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n2);
            randomAccessFile.read(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1014, iOException.getMessage());
        }
    }

    private void setBlockSize(int n2) {
        if (n2 == 16) {
            this.blockSize = 16384;
            this.blockShift = 14;
        } else {
            int n3 = 1;
            while (n3 < 22) {
                int n4 = n2 >> n3;
                if (n2 >> n3 == 0) {
                    this.blockShift = n3 - 1 + 10;
                    break;
                }
                ++n3;
            }
            if (n3 == 22) {
                UtilDebug.assert("Invalid block size specified.  Block size is in KBytes and must be a power of 2", false);
                this.blockShift = 14;
            }
            this.blockSize = 1 << this.blockShift;
            UtilDebug.assert("Blocksize should be a power of two", this.blockSize == n2 * 1024);
        }
    }

    public void truncate() throws UtilException {
        this.nextAvail = 0L;
        this.closeInputStream();
        this.closeOutputStream();
        int n2 = 0;
        while (n2 < this.blocks.length) {
            UtilTempBufferBlock utilTempBufferBlock = this.blocks[n2];
            if (utilTempBufferBlock != null) {
                utilTempBufferBlock.reset();
            }
            ++n2;
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.setLength(0L);
            }
            catch (IOException iOException) {
                throw new UtilException(1015, iOException.getMessage());
            }
        }
    }

    public void truncate(boolean bl) throws UtilException {
        if (!bl) {
            this.truncate();
        } else {
            this.nextAvail = 0L;
            this.closeInputStream();
            this.closeOutputStream();
            if (this.tmpFile != null) {
                try {
                    this.tmpFile.close();
                    this.tmpFile = null;
                    this.tmpFileInfo.delete();
                    this.tmpFile = null;
                }
                catch (IOException iOException) {}
            }
            if (this.blocks != null) {
                int n2 = 0;
                while (n2 < this.blocks.length) {
                    this.blocks[n2] = null;
                    ++n2;
                }
            }
        }
    }

    public void write(long l2, byte by) throws UtilException {
        byte[] byArray = new byte[]{by};
        this.write(l2, byArray, 0, 1);
    }

    public int write(long l2, UtilDataProvider utilDataProvider, int n2) throws UtilException {
        UtilDebug.assert("offset can not be negative", l2 >= 0L);
        UtilDebug.assert("dataProvider can not be null", utilDataProvider != null);
        UtilDebug.assert("length can not be negative", n2 >= 0);
        UtilDebug.assert("Holes in temp file", l2 <= (this.nextAvail + 3L & 0xFFFFFFFFFFFFFFFCL));
        int n3 = (int)(l2 >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l2 & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            boolean bl = true;
            if (n6 == this.blockSize || l2 >= this.nextAvail) {
                bl = false;
            }
            utilTempBufferBlock = this.getBlock(n3, bl);
            utilTempBufferBlock.blockDirty = true;
            int n7 = n6;
            while (n7 > 0) {
                try {
                    int n8 = utilDataProvider.getArrayOfBytes(utilTempBufferBlock.data, n5, n7);
                    n7 -= n8;
                    n5 += n8;
                    n4 += n8;
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() == 1001) {
                        if ((l2 += (long)(n6 - n7)) > this.nextAvail) {
                            this.nextAvail = l2;
                        }
                        return n4;
                    }
                    throw utilException;
                }
            }
            l2 += (long)n6;
            if ((n2 -= n6) == 0) break;
            ++n3;
        }
        if (l2 > this.nextAvail) {
            this.nextAvail = l2;
        }
        return n4;
    }

    public void write(long l2, byte[] byArray) throws UtilException {
        this.write(l2, byArray, 0, byArray.length);
    }

    public void write(long l2, byte[] byArray, int n2, int n3) throws UtilException {
        UtilDebug.assert("offset can not be negative", l2 >= 0L);
        UtilDebug.assert("buffer can not be null", byArray != null);
        UtilDebug.assert("bufferOffset can not be negative", n2 >= 0);
        UtilDebug.assert("length can not be negative", n3 >= 0);
        UtilDebug.assert("Holes in temp file", l2 <= (this.nextAvail + 3L & 0xFFFFFFFFFFFFFFFCL));
        int n4 = (int)(l2 >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l2 & (long)(this.blockSize - 1)))) > n3) {
                n6 = n3;
            }
            boolean bl = true;
            if (n6 == this.blockSize || l2 >= this.nextAvail) {
                bl = false;
            }
            utilTempBufferBlock = this.getBlock(n4, bl);
            utilTempBufferBlock.blockDirty = true;
            System.arraycopy(byArray, n2, utilTempBufferBlock.data, n5, n6);
            l2 += (long)n6;
            if ((n3 -= n6) == 0) break;
            n2 += n6;
            ++n4;
        }
        if (l2 > this.nextAvail) {
            this.nextAvail = l2;
        }
    }

    public int write(UtilDataProvider utilDataProvider) throws UtilException {
        return this.write(0L, utilDataProvider, Integer.MAX_VALUE);
    }

    public void writeInt(int n2) throws UtilException {
        this.staticByteArray[0] = (byte)(n2 >>> 24 & 0xFF);
        this.staticByteArray[1] = (byte)(n2 >>> 16 & 0xFF);
        this.staticByteArray[2] = (byte)(n2 >>> 8 & 0xFF);
        this.staticByteArray[3] = (byte)(n2 & 0xFF);
        this.write(this.nextAvail, this.staticByteArray, 0, 4);
    }

    public void writeLong(long l2) throws UtilException {
        this.staticByteArray[0] = (byte)(l2 >>> 56 & 0xFFL);
        this.staticByteArray[1] = (byte)(l2 >>> 48 & 0xFFL);
        this.staticByteArray[2] = (byte)(l2 >>> 40 & 0xFFL);
        this.staticByteArray[3] = (byte)(l2 >>> 32 & 0xFFL);
        this.staticByteArray[4] = (byte)(l2 >>> 24 & 0xFFL);
        this.staticByteArray[5] = (byte)(l2 >>> 16 & 0xFFL);
        this.staticByteArray[6] = (byte)(l2 >>> 8 & 0xFFL);
        this.staticByteArray[7] = (byte)(l2 & 0xFFL);
        this.write(this.nextAvail, this.staticByteArray, 0, 8);
    }

    private void writeTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n2 = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n2);
            randomAccessFile.write(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1013, iOException.getMessage());
        }
    }
}

