/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilException;

public abstract class UtilPacketizingDataConsumer
implements UtilDataConsumer {
    private static String footprint = "$Revision:   1.5.1.0  $";
    protected UtilDataConsumer dataConsumerObject;
    protected int numBytesInCurrentPacket;
    protected int numPacketsCreatedSinceSend;
    protected boolean sendPacketWhenFull;
    protected int packetSize;

    public UtilPacketizingDataConsumer(UtilDataConsumer utilDataConsumer, int n2) {
        this.dataConsumerObject = utilDataConsumer;
        this.setPacketSize(n2);
        this.numBytesInCurrentPacket = 0;
        this.numPacketsCreatedSinceSend = 0;
        this.sendPacketWhenFull = true;
    }

    private void checkForStartOfPacket() throws UtilException {
        if (this.numBytesInCurrentPacket == 0) {
            this.signalStartOfPacket();
        } else if (this.numBytesInCurrentPacket == this.packetSize) {
            this.signalEndOfPacket(false);
            if (this.sendPacketWhenFull) {
                this.dataConsumerObject.send();
            }
            ++this.numPacketsCreatedSinceSend;
            this.numBytesInCurrentPacket = 0;
            this.signalStartOfPacket();
        }
    }

    public void putArrayOfBytes(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 <= 0) {
            return;
        }
        int n4 = n3;
        while (n4 != 0) {
            this.checkForStartOfPacket();
            int n5 = n4 <= this.packetSize - this.numBytesInCurrentPacket ? n4 : this.packetSize - this.numBytesInCurrentPacket;
            this.dataConsumerObject.putArrayOfBytes(byArray, n2 + (n3 - n4), n5);
            n4 -= n5;
            this.numBytesInCurrentPacket += n5;
        }
    }

    public void putByte(byte by) throws UtilException {
        this.checkForStartOfPacket();
        this.dataConsumerObject.putByte(by);
        ++this.numBytesInCurrentPacket;
    }

    public void send() throws UtilException {
        if (this.numBytesInCurrentPacket > 0) {
            this.signalEndOfPacket(true);
        }
        this.dataConsumerObject.send();
        this.numPacketsCreatedSinceSend = 0;
        this.numBytesInCurrentPacket = 0;
    }

    public void setPacketSize(int n2) {
        if (n2 > 0) {
            this.packetSize = n2;
        }
    }

    public void setSendPacketWhenFull(boolean bl) {
        this.sendPacketWhenFull = bl;
    }

    protected void signalEndOfPacket(boolean bl) throws UtilException {
    }

    protected void signalStartOfPacket() throws UtilException {
    }

    protected void writeInt16(int n2) throws UtilException {
        this.dataConsumerObject.putByte((byte)(n2 >> 8 & 0xFF));
        this.dataConsumerObject.putByte((byte)(n2 & 0xFF));
    }

    protected void writeInt8(int n2) throws UtilException {
        this.dataConsumerObject.putByte((byte)n2);
    }
}

