/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilException;

public abstract class UtilDepacketizingDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   1.3.1.0  $";
    protected UtilDataProvider dataProvider;
    protected int numBytesReadFromCurrentPacket;
    protected boolean noMoreDataToRead;
    protected int packetSize;

    public UtilDepacketizingDataProvider(UtilDataProvider utilDataProvider) {
        this.dataProvider = utilDataProvider;
        this.numBytesReadFromCurrentPacket = 0;
        this.packetSize = 1024;
        this.noMoreDataToRead = true;
    }

    public void empty() throws UtilException {
        if (!this.noMoreDataToRead) {
            byte[] byArray = new byte[this.packetSize];
            while (!this.noMoreDataToRead) {
                this.getArrayOfBytes(byArray, 0, this.packetSize);
            }
        }
    }

    public int getArrayOfBytes(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 <= 0) {
            return 0;
        }
        if (this.noMoreDataToRead) {
            throw new UtilException(1001);
        }
        try {
            int n4 = n3;
            int n5 = 0;
            while (n4 != 0 && !this.noMoreDataToRead) {
                if (this.numBytesReadFromCurrentPacket == 0) {
                    this.signalStartOfPacket();
                }
                int n6 = n4 <= this.packetSize - this.numBytesReadFromCurrentPacket ? n4 : this.packetSize - this.numBytesReadFromCurrentPacket;
                int n7 = this.dataProvider.getArrayOfBytes(byArray, n2 + n5, n6);
                n4 -= n7;
                this.numBytesReadFromCurrentPacket += n7;
                n5 += n7;
                if (this.numBytesReadFromCurrentPacket != this.packetSize) continue;
                this.signalEndOfPacket();
            }
            return n5;
        }
        catch (UtilException utilException) {
            this.signalEndOfPacket();
            throw utilException;
        }
    }

    public byte getByte() throws UtilException {
        if (this.noMoreDataToRead) {
            throw new UtilException(1001);
        }
        try {
            if (this.numBytesReadFromCurrentPacket == 0) {
                this.signalStartOfPacket();
            }
            if (this.numBytesReadFromCurrentPacket < this.packetSize) {
                byte by = this.dataProvider.getByte();
                ++this.numBytesReadFromCurrentPacket;
                if (this.numBytesReadFromCurrentPacket == this.packetSize) {
                    this.signalEndOfPacket();
                }
                return by;
            }
            throw new UtilException(1001);
        }
        catch (UtilException utilException) {
            this.signalEndOfPacket();
            throw utilException;
        }
    }

    public void receive() throws UtilException {
        this.dataProvider.receive();
        this.numBytesReadFromCurrentPacket = 0;
        this.noMoreDataToRead = false;
    }

    public void setPacketSize(int n2) {
        if (n2 > 0) {
            this.packetSize = n2;
        }
    }

    protected void signalEndOfPacket() throws UtilException {
        this.numBytesReadFromCurrentPacket = 0;
    }

    protected void signalStartOfPacket() throws UtilException {
    }
}

