/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilPacketizingDataConsumer;
import com.microsoft.util.UtilPagedTempBuffer;
import com.microsoft.util.UtilTempBuffer;
import com.microsoft.util.UtilTransliterator;
import com.microsoft.util.UtilTransliteratorForASCII;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class UtilByteOrderedDataWriter {
    private static String footprint = "$Revision:   1.26.1.2  $";
    protected UtilDataConsumer dataConsumerObject;
    private boolean encodeInBigEndian;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int[] returnedLength;
    private UtilTempBuffer tempBuffer;
    private int _lenBytes;

    public UtilByteOrderedDataWriter(UtilDataConsumer utilDataConsumer) {
        this(utilDataConsumer, new UtilTransliteratorForASCII());
    }

    public UtilByteOrderedDataWriter(UtilDataConsumer utilDataConsumer, UtilTransliterator utilTransliterator) {
        this.dataConsumerObject = utilDataConsumer;
        this.encodeInBigEndian = true;
        this.transliterator = utilTransliterator;
        this.staticByteArray = new byte[256];
        this.returnedLength = new int[1];
    }

    public OutputStream getOutputStream(int n2) throws UtilException {
        this._lenBytes = n2;
        return new OutputStream(){
            private int totalLen;
            private int writtenSoFar;
            {
                this.totalLen = UtilByteOrderedDataWriter.this._lenBytes;
            }

            public void write(int n2) throws IOException {
                if (this.writtenSoFar >= this.totalLen) {
                    throw new IOException();
                }
                try {
                    UtilByteOrderedDataWriter.this.writeInt8(n2);
                    ++this.writtenSoFar;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }

            public void write(byte[] byArray, int n2, int n3) throws IOException {
                int n4 = this.totalLen - this.writtenSoFar;
                try {
                    if (n3 > n4) {
                        UtilByteOrderedDataWriter.this.writeBytes(byArray, n2, n4);
                        this.writtenSoFar = this.totalLen;
                        throw new IOException();
                    }
                    UtilByteOrderedDataWriter.this.writeBytes(byArray, n2, n3);
                    this.writtenSoFar += n3;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }
        };
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public boolean isInBigEndian() {
        return this.encodeInBigEndian;
    }

    public void send() throws UtilException {
        this.dataConsumerObject.send();
    }

    private void setStreamWrites(boolean bl) {
        if (this.dataConsumerObject instanceof UtilPacketizingDataConsumer) {
            ((UtilPacketizingDataConsumer)this.dataConsumerObject).setSendPacketWhenFull(bl);
        }
    }

    public void setToBigEndian() {
        this.encodeInBigEndian = true;
    }

    public void setToLittleEndian() {
        this.encodeInBigEndian = false;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public int writeAsciiStreamWithLength16(InputStream inputStream, int n2) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(inputStream, n2, this.tempBuffer.getOutputStream());
            int n3 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n3;
        }
        int n4 = n2 * this.transliterator.getMaxBytesPerChar();
        this.writeInt16(n4);
        this.transliterator.encode(inputStream, n2, this.getOutputStream(n4));
        this.setStreamWrites(false);
        return n4 + 2;
    }

    public int writeAsciiStreamWithLength32(InputStream inputStream, int n2) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(inputStream, n2, this.tempBuffer.getOutputStream());
            int n3 = this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n3;
        }
        int n4 = n2 * this.transliterator.getMaxBytesPerChar();
        this.writeInt32(n4);
        this.transliterator.encode(inputStream, n2, this.getOutputStream(n4));
        this.setStreamWrites(false);
        return n4 + 4;
    }

    public int writeBytes(byte[] byArray) throws UtilException {
        if (byArray == null) {
            return 0;
        }
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, byArray.length);
        return byArray.length;
    }

    public int writeBytes(byte[] byArray, int n2, int n3) throws UtilException {
        if (byArray == null || n3 <= 0) {
            return 0;
        }
        this.dataConsumerObject.putArrayOfBytes(byArray, n2, n3);
        return n3;
    }

    public int writeFillerBytes(byte by, int n2) throws UtilException {
        int n3 = n2 > this.staticByteArray.length ? this.staticByteArray.length : n2;
        int n4 = 0;
        while (n4 < n3) {
            this.staticByteArray[n4] = by;
            ++n4;
        }
        int n5 = n2;
        while (n5 > 0) {
            n3 = Math.min(n5, this.staticByteArray.length);
            this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n3);
            n5 -= n3;
        }
        return n2;
    }

    public int writeIEEE32BitFloat(float f2) throws UtilException {
        this.writeInt32(Float.floatToIntBits(f2));
        return 4;
    }

    public int writeIEEE64BitDouble(double d2) throws UtilException {
        this.writeInt64(Double.doubleToLongBits(d2));
        return 8;
    }

    public int writeInt16(int n2) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(n2 >>> 8 & 0xFF);
            this.staticByteArray[1] = (byte)(n2 & 0xFF);
        } else {
            this.staticByteArray[0] = (byte)(n2 & 0xFF);
            this.staticByteArray[1] = (byte)(n2 >>> 8 & 0xFF);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 2);
        return 2;
    }

    public int writeInt32(int n2) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(n2 >>> 24 & 0xFF);
            this.staticByteArray[1] = (byte)(n2 >>> 16 & 0xFF);
            this.staticByteArray[2] = (byte)(n2 >>> 8 & 0xFF);
            this.staticByteArray[3] = (byte)(n2 & 0xFF);
        } else {
            this.staticByteArray[0] = (byte)(n2 & 0xFF);
            this.staticByteArray[1] = (byte)(n2 >>> 8 & 0xFF);
            this.staticByteArray[2] = (byte)(n2 >>> 16 & 0xFF);
            this.staticByteArray[3] = (byte)(n2 >>> 24 & 0xFF);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 4);
        return 4;
    }

    public int writeInt64(long l2) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(l2 >>> 56 & 0xFFL);
            this.staticByteArray[1] = (byte)(l2 >>> 48 & 0xFFL);
            this.staticByteArray[2] = (byte)(l2 >>> 40 & 0xFFL);
            this.staticByteArray[3] = (byte)(l2 >>> 32 & 0xFFL);
            this.staticByteArray[4] = (byte)(l2 >>> 24 & 0xFFL);
            this.staticByteArray[5] = (byte)(l2 >>> 16 & 0xFFL);
            this.staticByteArray[6] = (byte)(l2 >>> 8 & 0xFFL);
            this.staticByteArray[7] = (byte)(l2 & 0xFFL);
        } else {
            this.staticByteArray[0] = (byte)(l2 & 0xFFL);
            this.staticByteArray[1] = (byte)(l2 >>> 8 & 0xFFL);
            this.staticByteArray[2] = (byte)(l2 >>> 16 & 0xFFL);
            this.staticByteArray[3] = (byte)(l2 >>> 24 & 0xFFL);
            this.staticByteArray[4] = (byte)(l2 >>> 32 & 0xFFL);
            this.staticByteArray[5] = (byte)(l2 >>> 40 & 0xFFL);
            this.staticByteArray[6] = (byte)(l2 >>> 48 & 0xFFL);
            this.staticByteArray[7] = (byte)(l2 >>> 56 & 0xFFL);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 8);
        return 8;
    }

    public int writeInt8(int n2) throws UtilException {
        this.dataConsumerObject.putByte((byte)n2);
        return 1;
    }

    public int writeReaderWithLength16(Reader reader, int n2) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(reader, n2, this.tempBuffer.getOutputStream());
            int n3 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n3;
        }
        int n4 = n2 * this.transliterator.getMaxBytesPerChar();
        this.writeInt16(n4);
        this.transliterator.encode(reader, n2, this.getOutputStream(n4));
        this.setStreamWrites(false);
        return n4 + 2;
    }

    public int writeReaderWithLength32(Reader reader, int n2) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(reader, n2, this.tempBuffer.getOutputStream());
            int n3 = this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n3;
        }
        int n4 = n2 * this.transliterator.getMaxBytesPerChar();
        this.writeInt32(n4);
        this.transliterator.encode(reader, n2, this.getOutputStream(n4));
        this.setStreamWrites(false);
        return n4 + 4;
    }

    public int writeStreamWithLength16(InputStream inputStream, int n2) throws UtilException {
        this.setStreamWrites(true);
        this.writeInt16(n2);
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = Math.min(n3, this.staticByteArray.length);
                int n5 = inputStream.read(this.staticByteArray, 0, n4);
                if (n5 == -1) {
                    throw new UtilException(1002);
                }
                this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n5);
                n3 -= n5;
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        this.setStreamWrites(false);
        return n2 + 2;
    }

    public int writeStreamWithLength32(InputStream inputStream, int n2) throws UtilException {
        this.setStreamWrites(true);
        this.writeInt32(n2);
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = Math.min(n3, this.staticByteArray.length);
                int n5 = inputStream.read(this.staticByteArray, 0, n4);
                if (n5 == -1) {
                    throw new UtilException(1002);
                }
                this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n5);
                n3 -= n5;
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        this.setStreamWrites(false);
        return n2 + 4;
    }

    public int writeString(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n2 = this.returnedLength[0];
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n2);
        return n2;
    }

    public int writeStringWithLength16(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n2 = this.returnedLength[0];
        this.writeInt16(n2);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n2);
        return n2 + 2;
    }

    public int writeStringWithLength32(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n2 = this.returnedLength[0];
        this.writeInt32(n2);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n2);
        return n2 + 4;
    }

    public int writeStringWithLength8(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n2 = this.returnedLength[0];
        this.writeInt8(n2);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n2);
        return n2 + 1;
    }
}

