/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTransliterator;
import com.microsoft.util.UtilTransliteratorForASCII;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UtilByteOrderedDataReader {
    private static String footprint = "$Revision:   1.23.1.0  $";
    protected UtilDataProvider dataProviderObject;
    private boolean interpretAsBigEndian;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int _lenBytes;

    public UtilByteOrderedDataReader(UtilDataProvider utilDataProvider) {
        this(utilDataProvider, new UtilTransliteratorForASCII());
    }

    public UtilByteOrderedDataReader(UtilDataProvider utilDataProvider, UtilTransliterator utilTransliterator) {
        this.dataProviderObject = utilDataProvider;
        this.interpretAsBigEndian = true;
        this.staticByteArray = new byte[256];
        this.transliterator = utilTransliterator;
    }

    public void empty() throws UtilException {
        this.dataProviderObject.empty();
    }

    public InputStream getAsciiStream(int n2) throws UtilException {
        return this.transliterator.decodeAsAsciiStream(this.getInputStream(n2));
    }

    public InputStream getInputStream(int n2) throws UtilException {
        this._lenBytes = n2;
        return new InputStream(){
            private int readSoFar;
            private int totalLen;
            private boolean atEnd;
            {
                this.totalLen = UtilByteOrderedDataReader.this._lenBytes;
            }

            public void close() throws IOException {
                int n2 = this.totalLen - this.readSoFar;
                if (n2 > 0) {
                    try {
                        UtilByteOrderedDataReader.this.readAndDiscardBytes(n2);
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                this.readSoFar = this.totalLen;
                this.atEnd = true;
            }

            public int read() throws IOException {
                if (this.readSoFar < this.totalLen) {
                    try {
                        byte by = UtilByteOrderedDataReader.this.dataProviderObject.getByte();
                        ++this.readSoFar;
                        return by & 0xFF;
                    }
                    catch (UtilException utilException) {
                        return -1;
                    }
                }
                if (this.atEnd) {
                    return -1;
                }
                this.atEnd = true;
                return -1;
            }

            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4 = this.totalLen - this.readSoFar;
                if (n4 >= n3) {
                    try {
                        UtilByteOrderedDataReader.this.readBytes(byArray, n2, n3);
                        this.readSoFar += n3;
                        return n3;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                if (n4 > 0) {
                    try {
                        UtilByteOrderedDataReader.this.readBytes(byArray, n2, n4);
                        this.readSoFar = this.totalLen;
                        this.atEnd = true;
                        return n4;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                if (this.atEnd) {
                    return -1;
                }
                this.atEnd = true;
                return 0;
            }
        };
    }

    public Reader getReader(int n2) throws UtilException {
        return this.transliterator.decodeAsReader(this.getInputStream(n2));
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public boolean isInBigEndian() {
        return this.interpretAsBigEndian;
    }

    public void readAndDiscardBytes(int n2) throws UtilException {
        while (n2 > 0) {
            int n3 = Math.min(n2, this.staticByteArray.length);
            this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, n3);
            n2 -= n3;
        }
    }

    public int readBytes(byte[] byArray, int n2, int n3) throws UtilException {
        return this.dataProviderObject.getArrayOfBytes(byArray, n2, n3);
    }

    public float readIEEE32BitFloat() throws UtilException {
        return Float.intBitsToFloat(this.readInt32());
    }

    public double readIEEE64BitDouble() throws UtilException {
        return Double.longBitsToDouble(this.readInt64());
    }

    public short readInt16() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 2);
        short s2 = this.interpretAsBigEndian ? (short)(((this.staticByteArray[0] & 0xFF) << 8) + (this.staticByteArray[1] & 0xFF)) : (short)((this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8));
        return s2;
    }

    public int readInt32() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 4);
        int n2 = this.interpretAsBigEndian ? ((this.staticByteArray[0] & 0xFF) << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + (this.staticByteArray[3] & 0xFF) : (this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + ((this.staticByteArray[3] & 0xFF) << 24);
        return n2;
    }

    public long readInt64() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 8);
        long l2 = this.interpretAsBigEndian ? (((long)this.staticByteArray[0] & 0xFFL) << 56) + (((long)this.staticByteArray[1] & 0xFFL) << 48) + (((long)this.staticByteArray[2] & 0xFFL) << 40) + (((long)this.staticByteArray[3] & 0xFFL) << 32) + (((long)this.staticByteArray[4] & 0xFFL) << 24) + (((long)this.staticByteArray[5] & 0xFFL) << 16) + (((long)this.staticByteArray[6] & 0xFFL) << 8) + ((long)this.staticByteArray[7] & 0xFFL) : ((long)this.staticByteArray[0] & 0xFFL) + (((long)this.staticByteArray[1] & 0xFFL) << 8) + (((long)this.staticByteArray[2] & 0xFFL) << 16) + (((long)this.staticByteArray[3] & 0xFFL) << 24) + (((long)this.staticByteArray[4] & 0xFFL) << 32) + (((long)this.staticByteArray[5] & 0xFFL) << 40) + (((long)this.staticByteArray[6] & 0xFFL) << 48) + (((long)this.staticByteArray[7] & 0xFFL) << 56);
        return l2;
    }

    public byte readInt8() throws UtilException {
        return this.dataProviderObject.getByte();
    }

    public String readString(int n2) throws UtilException {
        byte[] byArray = this.transliterator.getBytesCache();
        byte[] byArray2 = n2 > byArray.length ? new byte[n2] : byArray;
        int n3 = this.dataProviderObject.getArrayOfBytes(byArray2, 0, n2);
        return this.transliterator.decode(byArray2, 0, n3);
    }

    public int readUnsignedInt16() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 2);
        int n2 = this.interpretAsBigEndian ? ((this.staticByteArray[0] & 0xFF) << 8) + (this.staticByteArray[1] & 0xFF) : (this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8);
        return n2;
    }

    public long readUnsignedInt32() throws UtilException {
        this.dataProviderObject.getArrayOfBytes(this.staticByteArray, 0, 4);
        long l2 = this.interpretAsBigEndian ? (((long)this.staticByteArray[0] & 0xFFL) << 24) + (((long)this.staticByteArray[1] & 0xFFL) << 16) + (((long)this.staticByteArray[2] & 0xFFL) << 8) + ((long)this.staticByteArray[3] & 0xFFL) : ((long)this.staticByteArray[0] & 0xFFL) + (((long)this.staticByteArray[1] & 0xFFL) << 8) + (((long)this.staticByteArray[2] & 0xFFL) << 16) + (((long)this.staticByteArray[3] & 0xFFL) << 24);
        return l2;
    }

    public short readUnsignedInt8() throws UtilException {
        byte by = this.dataProviderObject.getByte();
        return (short)(by & 0xFF);
    }

    public void receive() throws UtilException {
        this.dataProviderObject.receive();
    }

    public void setToBigEndian() {
        this.interpretAsBigEndian = true;
    }

    public void setToLittleEndian() {
        this.interpretAsBigEndian = false;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }
}

