/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilPagedTempBuffer;
import com.microsoft.util.UtilTempBuffer;

public class UtilByteArrayDataProvider
implements UtilDataProvider {
    static String footprint = "$Revision:   1.2.1.0  $";
    byte[] byteArray;
    int readPosition;
    int length;
    UtilDataProvider provider;
    UtilTempBuffer tempBuffer;

    public UtilByteArrayDataProvider(UtilDataProvider utilDataProvider) {
        this(null, 0);
        this.provider = utilDataProvider;
        this.readPosition = 0;
        this.length = 0;
        this.tempBuffer = new UtilPagedTempBuffer();
    }

    public UtilByteArrayDataProvider(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public UtilByteArrayDataProvider(byte[] byArray, int n2) {
        this.byteArray = byArray;
        this.readPosition = 0;
        this.length = n2;
        this.provider = null;
    }

    public void empty() throws UtilException {
        this.readPosition = this.length;
        this.tempBuffer.truncate();
    }

    public int getArrayOfBytes(byte[] byArray, int n2, int n3) throws UtilException {
        if (this.readPosition == this.length) {
            throw new UtilException(1001);
        }
        int n4 = Math.min(n3, this.length - this.readPosition);
        if (this.provider == null) {
            System.arraycopy(this.byteArray, this.readPosition, byArray, n2, n4);
        } else {
            n4 = this.tempBuffer.read(this.readPosition, byArray, n2, n4);
        }
        this.readPosition += n4;
        return n4;
    }

    public byte getByte() throws UtilException {
        if (this.readPosition == this.length) {
            throw new UtilException(1001);
        }
        byte by = this.provider == null ? this.byteArray[this.readPosition] : this.tempBuffer.read(this.readPosition);
        ++this.readPosition;
        return by;
    }

    public void receive() throws UtilException {
        if (this.provider == null) {
            return;
        }
        this.readPosition = 0;
        this.tempBuffer.truncate();
        this.provider.receive();
        this.length = this.tempBuffer.write(this.provider);
    }
}

