/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilException;

public class UtilBufferedDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   1.5.1.0  $";
    private static int blockSizeForRead = 1024;
    private byte[] buffer;
    private int numBytesReturnedFromBuffer;
    private int numBytesInBuffer;
    private UtilDataProvider dataProviderObject;
    private boolean cacheMoreData = true;
    private int lastNumBytesWriten = 0;

    public UtilBufferedDataProvider(UtilDataProvider utilDataProvider) {
        this.dataProviderObject = utilDataProvider;
        this.buffer = null;
        this.numBytesReturnedFromBuffer = 0;
        this.numBytesInBuffer = 0;
    }

    public void cacheAdditionalData(boolean bl) {
        this.cacheMoreData = bl;
    }

    private void cacheNextBlock() throws UtilException {
        if (this.buffer == null) {
            this.buffer = new byte[blockSizeForRead];
        }
        this.numBytesInBuffer = this.dataProviderObject.getArrayOfBytes(this.buffer, 0, blockSizeForRead);
        this.numBytesReturnedFromBuffer = 0;
    }

    public void empty() throws UtilException {
        this.numBytesInBuffer = 0;
        this.dataProviderObject.empty();
    }

    public int getArrayOfBytes(byte[] byArray, int n2, int n3) throws UtilException {
        int n4 = this.numBytesInBuffer - this.numBytesReturnedFromBuffer;
        if (n3 > 0) {
            if (n3 <= n4) {
                System.arraycopy(this.buffer, this.numBytesReturnedFromBuffer, byArray, n2, n3);
                this.numBytesReturnedFromBuffer += n3;
                this.lastNumBytesWriten = n2 + n3;
            } else {
                int n5 = n3;
                if (n4 > 0) {
                    System.arraycopy(this.buffer, this.numBytesReturnedFromBuffer, byArray, n2, n4);
                    n5 -= n4;
                    this.numBytesReturnedFromBuffer = this.numBytesInBuffer;
                    this.lastNumBytesWriten = n2 + n4;
                }
                if (n5 > 0) {
                    this.cacheNextBlock();
                    if (!this.cacheMoreData) {
                        if (this.numBytesInBuffer > 0) {
                            if (this.numBytesInBuffer < blockSizeForRead && n5 >= this.numBytesInBuffer) {
                                n5 = this.numBytesInBuffer;
                            }
                        } else {
                            n5 = -1;
                        }
                    }
                    this.getArrayOfBytes(byArray, n2 + n4, n5);
                }
            }
        }
        if (!this.cacheMoreData && this.lastNumBytesWriten < n3) {
            n3 = this.lastNumBytesWriten;
        }
        return n3;
    }

    public byte getByte() throws UtilException {
        if (this.numBytesReturnedFromBuffer == this.numBytesInBuffer) {
            this.cacheNextBlock();
        }
        return this.buffer[this.numBytesReturnedFromBuffer++];
    }

    public boolean isCacheEmpty() {
        return this.numBytesReturnedFromBuffer == this.numBytesInBuffer;
    }

    public void receive() throws UtilException {
        this.dataProviderObject.receive();
    }
}

