/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbcx.base.BaseConnectionWrapper;
import com.microsoft.jdbcx.base.BaseDependent;
import com.microsoft.jdbcx.base.BaseResultSetWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class BaseStatementWrapper
implements Statement,
BaseDependent {
    private static String footprint = "$Revision:   1.0.1.1  $";
    protected Statement realStatement;
    protected BaseConnectionWrapper connectionWrapper;

    BaseStatementWrapper(BaseConnectionWrapper baseConnectionWrapper, Statement statement) {
        this.connectionWrapper = baseConnectionWrapper;
        this.realStatement = statement;
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.realStatement.addBatch(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void cancel() throws SQLException {
        try {
            this.realStatement.cancel();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.realStatement.clearBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.realStatement.clearWarnings();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        try {
            this.realStatement.close();
            this.connectionWrapper.removeFromDependents(this);
            this.realStatement = null;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    protected SQLException closedException() {
        return this.connectionWrapper.exceptions.getException(6010);
    }

    public void doClose() {
        this.realStatement = null;
    }

    public boolean execute(String string) throws SQLException {
        try {
            return this.realStatement.execute(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.realStatement.executeBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            ResultSet resultSet = this.realStatement.executeQuery(string);
            BaseResultSetWrapper baseResultSetWrapper = new BaseResultSetWrapper(this, resultSet, this.connectionWrapper);
            return baseResultSetWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            return this.realStatement.executeUpdate(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    protected void finalize() throws Throwable {
        if (this.realStatement != null) {
            this.connectionWrapper.notifyStatementGarbage();
        }
        super.finalize();
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.connectionWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.realStatement.getFetchDirection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.realStatement.getFetchSize();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.realStatement.getMaxFieldSize();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.realStatement.getMaxRows();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.realStatement.getMoreResults();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.realStatement.getQueryTimeout();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            ResultSet resultSet = this.realStatement.getResultSet();
            BaseResultSetWrapper baseResultSetWrapper = null;
            if (resultSet != null) {
                baseResultSetWrapper = new BaseResultSetWrapper(this, resultSet, this.connectionWrapper);
            }
            return baseResultSetWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.realStatement.getResultSetConcurrency();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.realStatement.getResultSetType();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.realStatement.getUpdateCount();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.realStatement.getWarnings();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object realObject() {
        return this.realStatement;
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.realStatement.setCursorName(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.realStatement.setEscapeProcessing(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFetchDirection(int n2) throws SQLException {
        try {
            this.realStatement.setFetchDirection(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        try {
            this.realStatement.setFetchSize(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        try {
            this.realStatement.setMaxFieldSize(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setMaxRows(int n2) throws SQLException {
        try {
            this.realStatement.setMaxRows(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setQueryTimeout(int n2) throws SQLException {
        try {
            this.realStatement.setQueryTimeout(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }
}

