/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.vprt;

import com.microsoft.jdbc.vprt.SSLexCharacterClass;
import com.microsoft.jdbc.vprt.SSLexDfaTableHeader;
import com.microsoft.jdbc.vprt.SSLexFinalState;
import com.microsoft.jdbc.vprt.SSLexKeyTable;
import com.microsoft.jdbc.vprt.SSLexLexeme;
import com.microsoft.jdbc.vprt.SSLexSubtable;
import com.microsoft.jdbc.vprt.SSLexTableHeader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Stack;

public class SSLexTable {
    private static String footprint = "$Revision:   1.2.1.0  $";
    public int SSLexTableHeaderSize = 36;
    public int SSLexDfaTableHeaderSize = 40;
    public int SSLexDfaKeywordTableHeaderSize = 40;
    public int SSLexDfaClassTableHeaderSize = 12;
    public int SSLexDfaClassTableEntryHeaderSize = 8;
    public Stack m_stack;
    public int m_classes;
    public int m_classMin;
    public int m_classMax;
    public SSLexFinalState[] m_final;
    public SSLexSubtable[] m_subTables;
    public SSLexKeyTable[] m_keyTables;
    public SSLexCharacterClass[] m_charClassTables;
    public final int SSLexStateInvalid = -1;

    public SSLexTable() {
        this.m_stack = new Stack();
    }

    public SSLexTable(String string) throws FileNotFoundException, IOException {
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        int n5;
        int n6;
        int n7;
        int n8;
        this.m_classMin = Integer.MAX_VALUE;
        this.m_classMax = -134217726;
        this.m_stack = new Stack();
        byte[] byArray = new byte[512];
        FileInputStream fileInputStream = new FileInputStream(string);
        int n9 = fileInputStream.read(byArray, 0, this.SSLexTableHeaderSize);
        SSLexTableHeader sSLexTableHeader = new SSLexTableHeader();
        sSLexTableHeader.size = this.convertInt(byArray, 0);
        sSLexTableHeader.type = this.convertInt(byArray, 4);
        int n10 = 0;
        while (n10 < sSLexTableHeader.reserved.length) {
            sSLexTableHeader.reserved[n10] = this.convertInt(byArray, n10 * 4 + 8);
            ++n10;
        }
        this.m_subTables = new SSLexSubtable[sSLexTableHeader.size];
        int n11 = 0;
        while (n11 < sSLexTableHeader.size) {
            int n12;
            int n13;
            SSLexDfaTableHeader sSLexDfaTableHeader = new SSLexDfaTableHeader();
            n9 = fileInputStream.read(byArray, 0, this.SSLexDfaTableHeaderSize);
            sSLexDfaTableHeader.type = this.convertInt(byArray, 0);
            sSLexDfaTableHeader.size = this.convertInt(byArray, 4);
            n8 = 0;
            while (n8 < sSLexDfaTableHeader.reserved.length) {
                sSLexDfaTableHeader.reserved[n8] = this.convertInt(byArray, n8 * 4 + 8);
                ++n8;
            }
            byte[] byArray2 = new byte[sSLexDfaTableHeader.size];
            fileInputStream.read(byArray2, 0, sSLexDfaTableHeader.size - this.SSLexDfaTableHeaderSize);
            n7 = this.convertInt(byArray2, 0);
            n6 = this.convertInt(byArray2, 4);
            n5 = this.convertInt(byArray2, 8);
            int n14 = this.convertInt(byArray2, 12);
            n14 -= this.SSLexDfaTableHeaderSize;
            objectArray = new int[n7 * 3];
            n4 = 0;
            n3 = n5 -= this.SSLexDfaTableHeaderSize;
            n2 = 0;
            while (n2 < n7) {
                int n15 = this.convertInt(byArray2, n3);
                n4 += this.convertInt(byArray2, n15 -= this.SSLexDfaTableHeaderSize) * 3 + 1;
                n3 += 4;
                ++n2;
            }
            int[] nArray = new int[n4];
            n3 = n5;
            int n16 = 0;
            int n17 = 0;
            while (n17 < n7) {
                n13 = this.convertInt(byArray2, n3);
                n4 = this.convertInt(byArray2, n13 -= this.SSLexDfaTableHeaderSize);
                n13 += 4;
                nArray[n16++] = n4;
                n12 = 0;
                while (n12 < n4) {
                    nArray[n16++] = this.convertInt(byArray2, n13);
                    nArray[n16++] = this.convertInt(byArray2, n13 += 4);
                    nArray[n16++] = this.convertInt(byArray2, n13 += 4);
                    n13 += 4;
                    ++n12;
                }
                n3 += 4;
                ++n17;
            }
            n13 = n14;
            n12 = 0;
            int n18 = 0;
            while (n18 < n7) {
                int n19 = n13;
                objectArray[n12++] = (String)this.convertInt(byArray2, n19);
                objectArray[n12++] = (String)this.convertInt(byArray2, n19 += 4);
                objectArray[n12++] = (String)this.convertInt(byArray2, n19 += 4);
                n13 += 28;
                ++n18;
            }
            this.m_subTables[n11] = new SSLexSubtable(n7, nArray, (int[])objectArray);
            ++n11;
        }
        int n20 = sSLexTableHeader.reserved[0];
        if (n20 != 0) {
            this.m_keyTables = new SSLexKeyTable[n20];
        }
        n8 = 0;
        while (n8 < n20) {
            n9 = fileInputStream.read(byArray, 0, this.SSLexDfaKeywordTableHeaderSize);
            int n21 = this.convertInt(byArray, 0);
            n7 = this.convertInt(byArray, 4);
            byte[] byArray3 = new byte[n21];
            n9 = fileInputStream.read(byArray3, 0, n21 - this.SSLexDfaKeywordTableHeaderSize);
            n5 = 0;
            int[] nArray = new int[n7 * 3];
            objectArray = new String[n7];
            n4 = 0;
            while (n4 < n7) {
                String string2;
                n3 = 3 * n4;
                nArray[n3] = this.convertInt(byArray3, n5);
                nArray[n3 + 1] = byArray3[n5 + 4] == 0 ? 0 : 1;
                nArray[n3 + 2] = this.convertInt(byArray3, n5 + 13);
                n2 = this.convertInt(byArray3, n5 + 5) - this.SSLexDfaKeywordTableHeaderSize;
                n9 = 0;
                int n22 = n2;
                while (byArray3[n22] != 0) {
                    ++n9;
                    ++n22;
                }
                objectArray[n4] = string2 = new String(byArray3, n2, n9);
                n5 += 41;
                ++n4;
            }
            this.m_keyTables[n8] = new SSLexKeyTable(nArray, (String[])objectArray);
            ++n8;
        }
        this.m_classes = sSLexTableHeader.reserved[1];
        if (this.m_classes != 0) {
            this.m_charClassTables = new SSLexCharacterClass[this.m_classes];
        }
        int n23 = 0;
        while (n23 < this.m_classes) {
            n9 = fileInputStream.read(byArray, 0, this.SSLexDfaClassTableHeaderSize);
            n7 = this.convertInt(byArray, 0);
            n6 = this.convertInt(byArray, 4);
            n5 = this.convertInt(byArray, 8);
            int n24 = n5 * this.SSLexDfaClassTableEntryHeaderSize;
            int n25 = n5 * 2;
            byte[] byArray4 = new byte[n24];
            n9 = fileInputStream.read(byArray4, 0, n24);
            int[] nArray = new int[n25];
            n2 = 0;
            while (n2 < n25) {
                nArray[n2] = this.convertInt(byArray4, n2 * 4);
                ++n2;
            }
            this.m_charClassTables[n23] = new SSLexCharacterClass(n5, n7, n6, nArray);
            if (n7 < this.m_classMin) {
                this.m_classMin = n7;
            }
            if (n7 > this.m_classMax) {
                this.m_classMax = n7;
            }
            if (n6 < this.m_classMin) {
                this.m_classMax = n6;
            }
            if (n6 > this.m_classMax) {
                this.m_classMax = n6;
            }
            ++n23;
        }
        this.pushSubtable(0);
    }

    public int convertInt(byte[] byArray, int n2) {
        return byArray[n2 + 3] << 24 & 0xFF000000 | byArray[n2 + 2] << 16 & 0xFF0000 | byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2] & 0xFF;
    }

    public void findKeyword(SSLexLexeme sSLexLexeme) {
        int n2 = 0;
        int n3 = 0;
        n2 = this.m_keyTables[0].m_keys.length;
        while (n2 > n3) {
            int n4 = n3 + (n2 - n3) / 2;
            String string = this.m_keyTables[0].m_keys[n4];
            String string2 = new String(sSLexLexeme.lexeme());
            int n5 = this.m_keyTables[0].m_index[n4 * 3 + 1] == 1 ? string2.toLowerCase().compareTo(string) : string2.compareTo(string);
            if (n5 < 0) {
                if (n3 == n4) break;
                n2 = n4;
                continue;
            }
            if (n5 == 0) {
                sSLexLexeme.setToken(this.m_keyTables[0].m_index[n4 * 3]);
                return;
            }
            if (n2 == n4 + 1) break;
            n3 = n4;
        }
    }

    public void gotoSubtable(int n2) {
        this.m_stack.pop();
        this.m_stack.push(this.m_subTables[n2]);
    }

    public int lookup(int n2, int n3) {
        SSLexSubtable sSLexSubtable = (SSLexSubtable)this.m_stack.peek();
        return sSLexSubtable.lookup(n2, n3);
    }

    public SSLexFinalState lookupFinal(int n2) {
        SSLexSubtable sSLexSubtable = (SSLexSubtable)this.m_stack.peek();
        return sSLexSubtable.lookupFinal(n2);
    }

    public void popSubtable() {
        this.m_stack.pop();
    }

    public void pushSubtable(int n2) {
        this.m_stack.push(this.m_subTables[n2]);
    }

    boolean translateClass(char[] cArray) {
        char c2 = cArray[0];
        if (c2 < this.m_classMin || c2 > this.m_classMax) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_classes) {
            if (this.m_charClassTables[n2].translate(cArray)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

