/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.util.UtilDateAndTimeFunctions;
import java.sql.SQLException;
import java.sql.Timestamp;

public class TDSDateTime {
    private static String footprint = "$Revision:   1.4.1.0  $";
    public static final int NUM_300TH_SECONDS_IN_ONE_MINUTE = 18000;
    public static final int NUM_NANOSECONDS_IN_A_300TH_OF_A_SECOND = 3333333;
    private static int BASEYEAR = 1753;
    private static int MAXYEAR = 9999;
    private static int BASEBIAS = 53690;
    public int numDaysSince_1_1_1900;
    public int num300thSecondsSinceMidnight;
    public Timestamp timestamp;

    public TDSDateTime(int n2, int n3) {
        int n4 = n3 / 18000;
        float f2 = n3 % 18000;
        int n5 = (int)(f2 / 300.0f);
        int n6 = (int)((f2 -= (float)(n5 * 300)) / 300.0f * 1.0E9f);
        int n7 = n6 % 1000000;
        if (n7 > 0) {
            n6 = n6 / 1000000 * 1000000;
            if (n7 > 500000) {
                n6 += 1000000;
            }
        }
        this.timestamp = new Timestamp(0, 0, ++n2, 0, n4, n5, n6);
        this.numDaysSince_1_1_1900 = n2;
        this.num300thSecondsSinceMidnight = n3;
    }

    public TDSDateTime(BaseExceptions baseExceptions, Timestamp timestamp) throws SQLException {
        int n2 = timestamp.getYear() + 1900;
        int n3 = timestamp.getDate();
        int n4 = timestamp.getMonth() + 1;
        int n5 = timestamp.getHours();
        int n6 = timestamp.getMinutes();
        int n7 = timestamp.getSeconds();
        int n8 = timestamp.getNanos();
        if (n2 < BASEYEAR || n2 > MAXYEAR) {
            String[] stringArray = new String[]{String.valueOf(n2)};
            throw baseExceptions.getException(11014, stringArray);
        }
        int n9 = (n2 -= BASEYEAR) * 365 + UtilDateAndTimeFunctions.leapCount(n2) + UtilDateAndTimeFunctions.JulianDays[n4] + n3;
        if (n4 > 2 && UtilDateAndTimeFunctions.isLeapYear(n2 + BASEYEAR)) {
            ++n9;
        }
        this.numDaysSince_1_1_1900 = n9 - BASEBIAS - 1;
        this.num300thSecondsSinceMidnight = n5 * 60 * 18000 + n6 * 18000 + n7 * 300 + n8 / 3333333;
        int n10 = n8 % 3333333;
        if (n10 > 1666666) {
            ++this.num300thSecondsSinceMidnight;
        }
        this.timestamp = timestamp;
    }
}

