/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilException;
import java.io.InputStream;

public class SQLServerLongDataStream
extends InputStream {
    private static String footprint = "$Revision:   1.4.1.0  $";
    private UtilByteOrderedDataReader reader;
    private long totalDataSize;
    private long numBytesReturned;
    boolean isUCS2Stream;
    int savedByteValue;

    public SQLServerLongDataStream(UtilByteOrderedDataReader utilByteOrderedDataReader, boolean bl, long l2) {
        this.totalDataSize = l2;
        this.reader = utilByteOrderedDataReader;
        this.numBytesReturned = 0L;
        this.isUCS2Stream = bl;
        this.savedByteValue = -1;
    }

    public void close() {
        try {
            if (this.numBytesReturned < this.totalDataSize) {
                this.reader.readAndDiscardBytes((int)(this.totalDataSize - this.numBytesReturned));
            }
            this.numBytesReturned = this.totalDataSize;
        }
        catch (UtilException utilException) {}
    }

    public int read() {
        if (this.numBytesReturned >= this.totalDataSize) {
            return -1;
        }
        try {
            int n2;
            if (this.isUCS2Stream) {
                if (this.savedByteValue == -1) {
                    this.savedByteValue = this.reader.readUnsignedInt8();
                    n2 = this.reader.readUnsignedInt8();
                } else {
                    n2 = this.savedByteValue;
                    this.savedByteValue = -1;
                }
            } else {
                n2 = this.reader.readUnsignedInt8();
            }
            ++this.numBytesReturned;
            return n2;
        }
        catch (UtilException utilException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.numBytesReturned >= this.totalDataSize) {
            return -1;
        }
        try {
            if ((long)n3 > this.totalDataSize - this.numBytesReturned) {
                n3 = (int)this.totalDataSize - (int)this.numBytesReturned;
            }
            if (this.isUCS2Stream) {
                int n4 = 0;
                while (n4 < n3) {
                    byte by = (byte)this.read();
                    if (by != -1) {
                        byArray[n2 + n4] = by;
                    }
                    ++n4;
                }
            } else {
                this.reader.readBytes(byArray, n2, n3);
            }
            this.numBytesReturned += (long)n3;
            return n3;
        }
        catch (UtilException utilException) {
            return -1;
        }
    }
}

