/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplResultSet;
import com.microsoft.jdbc.base.BaseImplStatement;
import com.microsoft.jdbc.base.BaseParameter;
import com.microsoft.jdbc.base.BaseParameters;
import com.microsoft.jdbc.base.BaseSQL;
import com.microsoft.jdbc.sqlserver.SQLServerConnection;
import com.microsoft.jdbc.sqlserver.SQLServerImplConnection;
import com.microsoft.jdbc.sqlserver.SQLServerImplResultSet;
import com.microsoft.jdbc.sqlserver.SQLServerImplResultSetServerSideCursor;
import com.microsoft.jdbc.sqlserver.tds.TDSCancelRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSCursorRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSRPCParameter;
import com.microsoft.jdbc.sqlserver.tds.TDSRPCRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSRequest;
import com.microsoft.util.UtilByteArrayDataProvider;
import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilByteOrderedDataWriter;
import com.microsoft.util.UtilStringFunctions;
import java.sql.SQLException;

public class SQLServerImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   1.59.1.0  $";
    TDSRequest request;
    TDSConnection conn;
    public UtilByteOrderedDataWriter writer;
    public UtilByteOrderedDataReader reader;
    SQLServerImplResultSet resultSet;
    int resultSetScrollType;
    int resultSetConcurrency;
    public BaseExceptions exceptions;
    boolean hasProcReturnParam;
    boolean isCursorSelect;

    public SQLServerImplStatement(TDSConnection tDSConnection, int n2, int n3, BaseExceptions baseExceptions) {
        this.conn = tDSConnection;
        this.exceptions = baseExceptions;
        this.request = null;
        this.resultSet = null;
        this.isCursorSelect = false;
        this.resultSetScrollType = n2;
        this.resultSetConcurrency = n3;
    }

    private void addUserParametersToRPC() throws SQLException {
        BaseParameters baseParameters = null;
        if (this.parameterSets != null) {
            baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        }
        if (baseParameters != null && baseParameters.count() > 0) {
            String string = new String();
            TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), this.getConnection().maxPrecision, this.exceptions);
            ((TDSRPCRequest)this.request).addParameter(tDSRPCParameter);
            int n2 = 1;
            while (n2 <= baseParameters.count()) {
                BaseParameter baseParameter = baseParameters.get(n2, 1);
                BaseParameter baseParameter2 = baseParameters.get(n2, 2);
                TDSRPCParameter tDSRPCParameter2 = new TDSRPCParameter(this.conn.getTDSVersion(), this.getConnection().maxPrecision, this.exceptions);
                boolean bl = true;
                if (baseParameter2 == null && !this.getConnection().sendStringParametersAsUnicode.booleanValue()) {
                    bl = false;
                }
                tDSRPCParameter2.initializeUserParam(this.getParameterName(n2, false), baseParameter, baseParameter2, bl);
                if (n2 != 1) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + tDSRPCParameter2.paramName + " " + tDSRPCParameter2.nativeTypeName + " ";
                ((TDSRPCRequest)this.request).addParameter(tDSRPCParameter2);
                ++n2;
            }
            tDSRPCParameter.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, new String(string));
        }
    }

    private void cacheMaxPrecision() {
        if (this.getConnection().maxPrecision != -1) {
            return;
        }
        try {
            TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "select @@MAX_PRECISION", true);
            tDSExecuteRequest.submitRequest();
            tDSExecuteRequest.processReply(null);
            tDSExecuteRequest.getRow(null);
            tDSExecuteRequest.getColumnDataForRow(1, 1019);
            this.getConnection().maxPrecision = (Integer)tDSExecuteRequest.getColumn(1).getData();
            tDSExecuteRequest.discardReplyBytes();
        }
        catch (SQLException sQLException) {}
    }

    public void cancel() throws SQLException {
        TDSCancelRequest tDSCancelRequest = new TDSCancelRequest(this.conn, this.reader, this.writer);
        tDSCancelRequest.submitRequest();
    }

    private void changeParameterMarkers(BaseSQL baseSQL) {
        int n2 = 1;
        while (n2 <= baseSQL.getParameterCount()) {
            boolean bl = false;
            String string = baseSQL.getStringPreceedingParameter(n2 - 1);
            if (string != null && (string.endsWith("EXEC") || string.endsWith("EXECUTE"))) {
                bl = true;
            }
            if (bl) {
                baseSQL.setParameter(n2 - 1, this.getParameterName(n2, false).toString());
            } else {
                baseSQL.setParameter(n2 - 1, this.getParameterName(n2, true).toString());
            }
            ++n2;
        }
    }

    public void close() throws SQLException {
        if (this.request != null) {
            this.request.discardReplyBytes();
        }
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.databaseMetaDataResultSet == 3 || this.databaseMetaDataResultSet == 4) {
            return baseColumns;
        }
        BaseColumns baseColumns2 = this.request == null ? this.getColumnInfoBeforeExecute() : this.request.getColumnDescriptions();
        if (baseColumns == null) {
            return baseColumns2;
        }
        if (this.databaseMetaDataResultSet == 8) {
            BaseColumn baseColumn = baseColumns.get(1);
            BaseColumn baseColumn2 = baseColumns2.get(1);
            baseColumn.displaySize = baseColumn2.displaySize;
        } else {
            int n2 = 1;
            while (n2 <= baseColumns.count(1)) {
                BaseColumn baseColumn = baseColumns.get(n2);
                BaseColumn baseColumn3 = baseColumns2.get(n2);
                baseColumn.displaySize = baseColumn3.displaySize;
                ++n2;
            }
        }
        return baseColumns;
    }

    public void execute() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest;
        if (this.maxRows != ((SQLServerImplConnection)this.implConnection).maxRows) {
            tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "SET ROWCOUNT " + this.maxRows, false);
            tDSExecuteRequest.submitRequest();
            tDSExecuteRequest.processReply(this.warnings);
            ((SQLServerImplConnection)this.implConnection).maxRows = this.maxRows;
        }
        if (this.maxFieldSize == 0) {
            SQLServerImplConnection cfr_ignored_0 = (SQLServerImplConnection)this.implConnection;
            this.maxFieldSize = SQLServerImplConnection.defaultMaxFieldSize;
        }
        if (this.maxFieldSize != ((SQLServerImplConnection)this.implConnection).maxFieldSize) {
            tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "SET TEXTSIZE " + this.maxFieldSize, false);
            tDSExecuteRequest.submitRequest();
            tDSExecuteRequest.processReply(this.warnings);
            ((SQLServerImplConnection)this.implConnection).maxFieldSize = this.maxFieldSize;
        }
        this.isCursorSelect = this.isSimpleSelect() && (this.useServerSideCursor() || this.supportsScrolling(this.resultSetScrollType));
        int n2 = this.sql.getParameterCount();
        if (this.isCursorSelect) {
            UtilByteOrderedDataReader utilByteOrderedDataReader = this.reader;
            if (!this.getImplConnection().useServerSideCursor) {
                utilByteOrderedDataReader = new UtilByteOrderedDataReader(new UtilByteArrayDataProvider(this.conn.getDepacketizer()), this.reader.getTransliterator());
                utilByteOrderedDataReader.setToLittleEndian();
            }
            if (n2 == 0) {
                this.request = new TDSCursorRequest(this.conn, utilByteOrderedDataReader, this.writer, this.sql.getFormatted(), this.resultSetScrollType, this.resultSetConcurrency, false);
            } else {
                this.changeParameterMarkers(this.sql);
                this.request = new TDSCursorRequest(this.conn, utilByteOrderedDataReader, this.writer, this.sql.getFormatted(), this.resultSetScrollType, this.resultSetConcurrency, true);
                this.addUserParametersToRPC();
            }
            ((TDSCursorRequest)this.request).setFetchSize(this.fetchSize);
        } else if (n2 == 0) {
            this.request = new TDSExecuteRequest(this.conn, this.reader, this.writer, this.sql.getFormatted(), true);
        } else {
            this.changeParameterMarkers(this.sql);
            this.request = new TDSRPCRequest(this.conn, this.reader, this.writer, "sp_executesql");
            String string = this.sql.getFormatted();
            TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.exceptions);
            tDSRPCParameter.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
            ((TDSRPCRequest)this.request).addParameter(tDSRPCParameter);
            this.addUserParametersToRPC();
        }
        if (this.isCursorSelect) {
            ((TDSCursorRequest)this.request).openCursor(this.warnings);
        } else {
            this.request.submitRequest();
        }
    }

    private BaseColumns getColumnInfoBeforeExecute() {
        BaseColumns baseColumns;
        block2: {
            int n2;
            baseColumns = null;
            if (!this.isSimpleSelect()) break block2;
            String string = this.sql.getFormatted();
            String string2 = "SET FMTONLY ON ";
            string2 = this.sql.getParameterCount() > 0 ? ((n2 = UtilStringFunctions.searchStringCi(string, "where")) != -1 ? String.valueOf(string2) + string.substring(0, n2) : String.valueOf(string2) + string) : String.valueOf(string2) + string;
            string2 = String.valueOf(string2) + " SET FMTONLY OFF";
            try {
                TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, string2, false);
                tDSExecuteRequest.submitRequest();
                tDSExecuteRequest.processReply(this.warnings);
                baseColumns = tDSExecuteRequest.getColumnDescriptions();
            }
            catch (Exception exception) {}
        }
        return baseColumns;
    }

    protected SQLServerConnection getConnection() {
        return this.getImplConnection().connection;
    }

    protected SQLServerImplConnection getImplConnection() {
        return (SQLServerImplConnection)this.implConnection;
    }

    public BaseImplResultSet getNextResultSet() {
        this.resultSet = this.request instanceof TDSCursorRequest ? new SQLServerImplResultSetServerSideCursor((TDSCursorRequest)this.request) : new SQLServerImplResultSet(this.request);
        return this.resultSet;
    }

    public int getNextResultType() throws SQLException {
        int n2 = this.request.getResultType();
        if (this.request instanceof TDSCursorRequest && !((TDSCursorRequest)this.request).getExecutingSQLDirectly()) {
            return n2;
        }
        if (n2 == 2 && this.resultSet == null) {
            this.resultSet = new SQLServerImplResultSet(this.request);
            this.resultSet.close();
        }
        switch (n2) {
            case 0: {
                this.request.processReply(this.warnings);
                break;
            }
            case 2: 
            case 3: {
                this.resultSet = null;
                this.request.processReply(this.warnings);
                break;
            }
        }
        if (this.request.getResultType() == 1 && n2 != this.request.getResultType()) {
            this.returnOutputParams();
        }
        return this.request.getResultType();
    }

    public int getNextRowsAffectedCount() throws SQLException {
        if (this.request != null) {
            return this.request.getNumRowsAffected();
        }
        return 0;
    }

    private String getParameterName(int n2, boolean bl) {
        String string = new String("@P" + n2);
        if (bl) {
            BaseParameter baseParameter;
            BaseParameters baseParameters = null;
            if (this.parameterSets != null) {
                baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
            }
            if (baseParameters != null && baseParameters.count() > 0 && (baseParameter = baseParameters.get(n2, 2)) != null) {
                string = String.valueOf(string) + " OUTPUT";
            }
        }
        return string;
    }

    public int getRequiredSQLProcessing(String string) {
        return 3;
    }

    public boolean isSimpleSelect() {
        return this.sql.getType() == 1;
    }

    public void prepare() throws SQLException {
        this.cacheMaxPrecision();
    }

    public void returnOutputParams() {
        int n2 = this.sql.getParameterCount();
        BaseParameters baseParameters = null;
        if (this.parameterSets == null) {
            return;
        }
        baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        int n3 = 0;
        int n4 = 1;
        while (n4 <= n2) {
            BaseParameter baseParameter = baseParameters.get(n4, 2);
            if (baseParameter != null) {
                if (n4 == 1 && this.hasProcReturnParam) {
                    baseParameter.setData(new Long(this.request.returnValue));
                } else {
                    TDSRPCParameter tDSRPCParameter = ((TDSRPCRequest)this.request).getOutputParam(++n3);
                    baseParameter.setData(tDSRPCParameter.baseDataType, tDSRPCParameter.value);
                }
            }
            ++n4;
        }
    }

    public void setReader(UtilByteOrderedDataReader utilByteOrderedDataReader) {
        this.reader = utilByteOrderedDataReader;
    }

    public void setWriter(UtilByteOrderedDataWriter utilByteOrderedDataWriter) {
        this.writer = utilByteOrderedDataWriter;
    }

    public boolean supportsScrolling(int n2) {
        return n2 == 1004 && this.resultSetConcurrency == 1007;
    }

    public boolean useServerSideCursor() {
        return ((SQLServerImplConnection)this.implConnection).useServerSideCursor;
    }
}

