/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseImplResultSet;
import com.microsoft.jdbc.sqlserver.SQLServerColumn;
import com.microsoft.jdbc.sqlserver.SQLServerImplDatabaseMetaData;
import com.microsoft.jdbc.sqlserver.tds.TDSCursorRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSRequest;
import java.sql.SQLException;

public class SQLServerImplResultSet
extends BaseImplResultSet {
    private static String footprint = "$Revision:   1.24.1.0  $";
    TDSRequest tdsRequest;
    boolean isClosed;

    public SQLServerImplResultSet(TDSRequest tDSRequest) {
        this.tdsRequest = tDSRequest;
        this.isClosed = false;
    }

    public void close() throws SQLException {
        if (!this.isClosed) {
            this.tdsRequest.completeRowProcessing(this.warnings);
            this.isClosed = true;
        }
    }

    public int getColumnAccess() {
        if (this.tdsRequest.hasLongColumns()) {
            return 1;
        }
        return 2;
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        Object object;
        this.tdsRequest.getColumnDataForRow(n2, n3);
        switch (this.implStatement.databaseMetaDataResultSet) {
            case 2: {
                if (n2 != 5) break;
                Integer n4 = (Integer)this.tdsRequest.getColumn(n2).getData();
                short s2 = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(n4.shortValue());
                return new BaseData(new Integer(s2));
            }
            case 5: {
                if (n2 != 3) break;
                String string = (String)this.tdsRequest.getColumn(n2).getData();
                int n5 = string.indexOf(";");
                return new BaseData(string.substring(0, n5));
            }
            case 6: {
                if (n2 == 3) {
                    String string = (String)this.tdsRequest.getColumn(n2).getData();
                    int n6 = string.indexOf(";");
                    return new BaseData(string.substring(0, n6));
                }
                if (n2 != 6) break;
                Integer n7 = (Integer)this.tdsRequest.getColumn(n2).getData();
                short s3 = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(n7.shortValue());
                return new BaseData(new Integer(s3));
            }
            case 7: 
            case 18: {
                if (n2 != 3) break;
                Integer n8 = (Integer)this.tdsRequest.getColumn(n2).getData();
                short s4 = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(n8.shortValue());
                return new BaseData(new Integer(s4));
            }
            case 13: {
                if (n2 == 4) {
                    object = this.tdsRequest.getColumn(n2).getData();
                    if (object != null) break;
                    return new BaseData(new Boolean(false));
                }
                if (n2 != 8 || (object = this.tdsRequest.getColumn(n2).getData()) != null) break;
                return new BaseData(new Integer(0));
            }
        }
        object = this.tdsRequest.getColumn(n2);
        Object object2 = ((SQLServerColumn)object).getData();
        return new BaseData(((SQLServerColumn)object).baseDataType, object2);
    }

    public boolean positionCursor(int n2) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        if (this.tdsRequest.getRow(this.warnings)) {
            return true;
        }
        this.close();
        return false;
    }

    public void setFetchSize(int n2) {
        if (this.tdsRequest instanceof TDSCursorRequest) {
            ((TDSCursorRequest)this.tdsRequest).setFetchSize(n2);
        }
    }
}

