/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseBatchUpdateException;
import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseEscapeTranslator;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplConnection;
import com.microsoft.jdbc.base.BaseImplEmptyResultSet;
import com.microsoft.jdbc.base.BaseImplFilterCursorResultSet;
import com.microsoft.jdbc.base.BaseImplResultSet;
import com.microsoft.jdbc.base.BaseImplSortCursorResultSet;
import com.microsoft.jdbc.base.BaseImplStatement;
import com.microsoft.jdbc.base.BaseImplStaticCursorResultSet;
import com.microsoft.jdbc.base.BaseImplUpdatableResultSet;
import com.microsoft.jdbc.base.BaseQueryTimeoutEnforcer;
import com.microsoft.jdbc.base.BaseResultSet;
import com.microsoft.jdbc.base.BaseResultSetFilterDescriptor;
import com.microsoft.jdbc.base.BaseResultSetSortDescriptor;
import com.microsoft.jdbc.base.BaseSQL;
import com.microsoft.jdbc.base.BaseTableTypes;
import com.microsoft.jdbc.base.BaseTableTypesImplResultSet;
import com.microsoft.jdbc.base.BaseTypeInfoImplResultSet;
import com.microsoft.jdbc.base.BaseTypeInfos;
import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.util.UtilDebug;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class BaseStatement
implements Statement {
    private static final String footprint = "$Revision:   1.88.1.10.1.3  $";
    protected BaseConnection connection;
    protected BaseImplConnection implConnection;
    protected BaseSQL batchSQL;
    protected BaseImplStatement implStatement;
    protected BaseEscapeTranslator escapeTranslator;
    protected static final int STATE_UNPREPARED = 1;
    protected static final int STATE_PREPARED = 2;
    protected static final int STATE_EXECUTED = 3;
    protected static final int STATE_CLOSED = 4;
    protected int state = 1;
    protected static final int EXECUTE_STATE_IDLE = 1;
    protected static final int EXECUTE_STATE_EXECUTING = 2;
    protected int executeState = 1;
    protected static final int CS_NOT_SET = 0;
    protected static final int CS_READONLY = 1;
    protected static final int CS_NATIVE = 2;
    protected static final int CS_ROWID = 3;
    protected static final int CS_ALL_COLUMNS = 4;
    protected int concurrencyStrategy = 0;
    protected static final int SS_NOT_SET = 0;
    protected static final int SS_FORWARD_ONLY = 1;
    protected static final int SS_FRWK_INSENSITIVE = 2;
    protected static final int SS_NATIVE_INSENSITIVE = 3;
    protected static final int SS_FRWK_SENSITIVE = 4;
    protected static final int SS_NATIVE_SENSITIVE = 5;
    protected int scrollingStrategy = 0;
    private int firstUpdateKeyColumnIndex;
    private String tableSpecification;
    int resultSetScrollType;
    int resultSetConcurrency;
    int resultSetFetchSize = 0;
    int fetchDirection = 1002;
    int maxRows = 0;
    private boolean exhaustResultsAtResultSetClose;
    int currentResultType = 1;
    int currentRowsAffectedCount = -2;
    BaseResultSet currentResultSet;
    BaseColumns currentColumns;
    private int databaseMetaDataResultSet = 0;
    private boolean generateEmptyDatabaseMetaDataResultSet = false;
    private Object databaseMetaDataResultSetInfo;
    private int maxFieldSize = 0;
    protected BaseResultSetFilterDescriptor filterDescriptor;
    protected BaseResultSetSortDescriptor sortDescriptor;
    private int queryTimeout = 0;
    BaseQueryTimeoutEnforcer queryTimeoutEnforcer;
    boolean timeoutEnforcerCanceledExecution = false;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;

    public BaseStatement(BaseConnection baseConnection, int n2, int n3) throws SQLException {
        this.connection = baseConnection;
        if (n2 == 1005) {
            n2 = 1004;
        }
        if (n3 == 1008 && !baseConnection.getAutoCommit() && baseConnection.performsConnectionCloning()) {
            n3 = 1007;
        }
        this.resultSetScrollType = n2;
        this.resultSetConcurrency = n3;
        this.exceptions = baseConnection.exceptions;
        this.warnings = new BaseWarnings(baseConnection.driverName);
        this.setupImplConnection();
        this.setupImplStatement();
    }

    public void addBatch(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.batchSQL == null) {
                this.batchSQL = new BaseSQL(this.implConnection.quotingChar, this.getEscapeTranslator(string), this.exceptions);
            }
            this.commonValidateSQL(string);
            this.batchSQL.addToBatch(string, this.implStatement.getRequiredSQLProcessing(string));
        }
    }

    private final boolean addRowIdToSelectList(BaseSQL baseSQL) throws SQLException {
        boolean bl = true;
        if (this.firstUpdateKeyColumnIndex == -1) {
            String string = this.implStatement.getRowIdColumnName();
            int n2 = baseSQL.getSelectColumnSpecificationCount() - 1;
            Vector vector = baseSQL.getSelectColumnSpecification(n2);
            if (n2 == 0 && !this.implConnection.supportsSelectStarCommaColumn() && baseSQL.selectColumnSpecificationContainsValue(vector, "*") && (bl = this.expandSelectStar(baseSQL))) {
                return this.addRowIdToSelectList(baseSQL);
            }
            if (bl) {
                this.firstUpdateKeyColumnIndex = n2 + 1;
                int n3 = vector.size();
                String string2 = "";
                int n4 = 0;
                while (n4 < n3) {
                    string2 = String.valueOf(string2) + (String)vector.elementAt(n4);
                    ++n4;
                }
                string2 = String.valueOf(string2) + ", " + string;
                baseSQL.setSelectColumnSpecification(n2, string2);
            }
        }
        return bl;
    }

    private final boolean addStarToSelectList(BaseSQL baseSQL) throws SQLException {
        boolean bl = true;
        int n2 = baseSQL.getSelectColumnSpecificationCount() - 1;
        Vector vector = baseSQL.getSelectColumnSpecification(n2);
        if (!baseSQL.selectColumnSpecificationContainsValue(vector, "*")) {
            this.firstUpdateKeyColumnIndex = n2 + 1;
            int n3 = vector.size();
            String string = "";
            int n4 = 0;
            while (n4 < n3) {
                string = String.valueOf(string) + (String)vector.elementAt(n4);
                ++n4;
            }
            string = String.valueOf(string) + ", * ";
            baseSQL.setSelectColumnSpecification(n2, string);
        }
        return bl;
    }

    public void cancel() throws SQLException {
        if (this.state == 4 || this.connection.isClosedUnSync()) {
            throw this.exceptions.getException(6010);
        }
        if (this.executeState == 2) {
            this.implStatement.cancel();
        }
    }

    BaseImplResultSet chainInServiceImplResultSets(BaseImplResultSet baseImplResultSet) throws SQLException {
        BaseImplResultSet baseImplResultSet2 = baseImplResultSet;
        BaseImplFilterCursorResultSet baseImplFilterCursorResultSet = null;
        BaseImplStaticCursorResultSet baseImplStaticCursorResultSet = null;
        BaseImplSortCursorResultSet baseImplSortCursorResultSet = null;
        if (baseImplResultSet2 instanceof BaseImplEmptyResultSet) {
            return baseImplResultSet2;
        }
        if (this.filterDescriptor != null && !this.filterDescriptor.allRestrictionsSatified()) {
            baseImplFilterCursorResultSet = new BaseImplFilterCursorResultSet();
            baseImplFilterCursorResultSet.setImplStatement(this.implStatement);
            baseImplFilterCursorResultSet.setSubResultSet(baseImplResultSet2);
            baseImplFilterCursorResultSet.setColumns(this.currentColumns);
            baseImplFilterCursorResultSet.setFilterCriteria(this.filterDescriptor);
            baseImplResultSet2 = baseImplFilterCursorResultSet;
        }
        if (this.sortDescriptor != null && !this.sortDescriptor.getSatisfied()) {
            baseImplStaticCursorResultSet = new BaseImplStaticCursorResultSet();
            baseImplStaticCursorResultSet.setImplStatement(this.implStatement);
            baseImplStaticCursorResultSet.setSubResultSet(baseImplResultSet2);
            baseImplStaticCursorResultSet.setColumns(this.currentColumns);
            baseImplResultSet2 = baseImplStaticCursorResultSet;
            baseImplSortCursorResultSet = new BaseImplSortCursorResultSet();
            baseImplSortCursorResultSet.setImplStatement(this.implStatement);
            baseImplSortCursorResultSet.setSubResultSet(baseImplResultSet2);
            baseImplSortCursorResultSet.setColumns(this.currentColumns);
            baseImplSortCursorResultSet.setSortCriteria(this.sortDescriptor);
            baseImplResultSet2 = baseImplSortCursorResultSet;
        }
        if (this.resultSetScrollType == 1004 && baseImplResultSet.getScrollType() != 1004 && baseImplStaticCursorResultSet == null) {
            baseImplStaticCursorResultSet = new BaseImplStaticCursorResultSet();
            baseImplStaticCursorResultSet.setImplStatement(this.implStatement);
            baseImplStaticCursorResultSet.setSubResultSet(baseImplResultSet2);
            baseImplStaticCursorResultSet.setColumns(this.currentColumns);
            baseImplResultSet2 = baseImplStaticCursorResultSet;
        }
        if (this.tableSpecification != null && baseImplResultSet.getConcurrency() == 1007) {
            BaseImplUpdatableResultSet baseImplUpdatableResultSet = new BaseImplUpdatableResultSet(this.connection, this.tableSpecification, this.currentColumns, this.connection.getMetaData().getIdentifierQuoteString());
            baseImplUpdatableResultSet.setImplStatement(this.implStatement);
            baseImplUpdatableResultSet.setSubResultSet(baseImplResultSet2);
            baseImplResultSet2 = baseImplUpdatableResultSet;
        }
        return baseImplResultSet2;
    }

    public void clearBatch() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.batchSQL != null) {
                this.batchSQL.clearBatch();
            }
        }
    }

    public void clearWarnings() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.warnings.clear();
        }
    }

    public void close() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            if (this.queryTimeoutEnforcer != null) {
                this.queryTimeoutEnforcer.exit();
                this.queryTimeoutEnforcer = null;
            }
            this.commonTransitionToState(4);
        }
    }

    protected void closeCurrentResults() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        this.currentColumns = null;
        this.currentRowsAffectedCount = -2;
    }

    void commonExecute() throws SQLException {
        this.warnings.clear();
        if (this.emulatedDatabaseMetaDataResultSet()) {
            this.currentResultType = 2;
        } else if (this.implStatement.sql == null) {
            this.generateEmptyDatabaseMetaDataResultSet = true;
            this.currentResultType = 2;
        } else {
            try {
                this.preImplExecute();
                this.implStatement.execute();
                this.postImplExecute(true);
            }
            catch (SQLException sQLException) {
                if (this.databaseMetaDataResultSet == 0) {
                    throw sQLException;
                }
                this.generateEmptyDatabaseMetaDataResultSet = true;
                this.currentResultType = 2;
            }
        }
    }

    private BaseResultSet commonGetNextResultSet() throws SQLException {
        BaseResultSet baseResultSet = null;
        if (this.currentResultType == 2) {
            BaseImplResultSet baseImplResultSet;
            if (this.generateEmptyDatabaseMetaDataResultSet) {
                baseImplResultSet = new BaseImplEmptyResultSet();
            } else {
                baseImplResultSet = this.getNextImplResultSet();
                if (baseImplResultSet != null) {
                    this.describeColumns();
                }
            }
            baseImplResultSet = this.chainInServiceImplResultSets(baseImplResultSet);
            this.currentResultSet = new BaseResultSet(this, this.currentColumns, baseImplResultSet);
            this.currentResultSet.setMaxFieldSize(this.maxFieldSize);
            baseResultSet = this.currentResultSet;
        }
        return baseResultSet;
    }

    private int commonGetUpdateCount() throws SQLException {
        int n2 = -1;
        switch (this.currentResultType) {
            case 1: 
            case 2: {
                n2 = -1;
                break;
            }
            case 3: {
                n2 = this.implStatement.getNextRowsAffectedCount();
                break;
            }
        }
        return n2;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void commonTransitionToState(int var1_1) throws SQLException {
        block0 : switch (var1_1) {
            case 1: {
                switch (this.state) {
                    case 3: {
                        this.closeCurrentResults();
                        this.currentResultType = 0;
                    }
                    case 2: {
                        this.currentColumns = null;
                    }
                    case 1: {
                        this.concurrencyStrategy = 0;
                        this.scrollingStrategy = 0;
                        this.exhaustResultsAtResultSetClose = false;
                        this.timeoutEnforcerCanceledExecution = false;
                        ** break;
                    }
                    default: {
                        break block0;
                    }
                }
            }
            case 2: {
                switch (this.state) {
                    case 3: {
                        this.closeCurrentResults();
                        this.timeoutEnforcerCanceledExecution = false;
                        ** break;
                    }
                    default: {
                        break block0;
                    }
                }
            }
            case 3: {
                switch (this.state) {
                    case 1: {
                        if (this.databaseMetaDataResultSet == 0) {
                            this.currentColumns = null;
                        }
                    }
                    case 2: {
                        if (this.resultSetConcurrency == 1008 && this.concurrencyStrategy == 1) {
                            this.warnings.add(6048);
                        }
                        this.currentResultType = this.implStatement.getNextResultType();
                        ** break;
                    }
                    default: {
                        break block0;
                    }
                }
            }
            case 4: {
                switch (this.state) {
                    case 3: {
                        if (this.currentResultSet != null) {
                            this.currentResultSet.close();
                            this.currentResultSet = null;
                        }
                    }
                    case 1: 
                    case 2: {
                        this.exhaustResultsAtResultSetClose = false;
                        if (this.implStatement != null) {
                            this.implStatement.close();
                            this.implStatement = null;
                        }
                        if (this.implConnection != null) {
                            this.implConnection.removeReference();
                            this.implConnection = null;
                        }
                        break block0;
                    }
                    default: {
                        break block0;
                    }
                }
            }
lbl55:
            // 3 sources

            break;
        }
        this.state = var1_1;
    }

    protected final void commonValidateSQL(String string) throws SQLException {
        if (string == null) {
            if (this.databaseMetaDataResultSet == 0) {
                throw this.exceptions.getException(6019);
            }
        } else if (string.equals("")) {
            String[] stringArray = new String[]{"0", "0", "0"};
            throw this.exceptions.getException(6037, stringArray, "42000");
        }
    }

    protected BaseColumns describeColumns() throws SQLException {
        if (this.currentColumns == null) {
            this.currentColumns = this.implStatement.describeColumns(null);
        } else if (this.databaseMetaDataResultSet != 0) {
            this.currentColumns = this.implStatement.describeColumns(this.currentColumns);
        }
        if (this.tableSpecification != null) {
            if (this.concurrencyStrategy == 3) {
                this.currentColumns.markColumnsAsKeyStartingAt(this.currentColumns.count(0), true);
            } else if (this.concurrencyStrategy == 4) {
                this.currentColumns.markColumnsAsKeyStartingAt(this.firstUpdateKeyColumnIndex == -1 ? 1 : this.firstUpdateKeyColumnIndex + 1, this.firstUpdateKeyColumnIndex != -1);
            }
        }
        return this.currentColumns;
    }

    private final void determineConcurrencyStrategy() throws SQLException {
        boolean bl = true;
        if (this.concurrencyStrategy == 0) {
            if (this.resultSetConcurrency == 1007) {
                this.concurrencyStrategy = 1;
                bl = false;
            } else {
                this.concurrencyStrategy = 2;
            }
        }
        while (bl) {
            switch (this.concurrencyStrategy) {
                case 2: {
                    if (this.implStatement.supportsUpdates()) {
                        bl = false;
                        break;
                    }
                    this.concurrencyStrategy = 3;
                    break;
                }
                case 3: {
                    if (this.implStatement.getRowIdColumnName() != null) {
                        bl = false;
                        break;
                    }
                    this.concurrencyStrategy = 4;
                    break;
                }
                case 4: {
                    bl = false;
                    break;
                }
            }
        }
    }

    private final void determineScrollingStrategy() throws SQLException {
        boolean bl = true;
        if (this.scrollingStrategy == 0) {
            if (this.resultSetScrollType == 1003) {
                this.scrollingStrategy = 1;
                bl = false;
            } else if (this.resultSetScrollType == 1004) {
                this.scrollingStrategy = 3;
            } else if (this.resultSetScrollType == 1005) {
                this.scrollingStrategy = 5;
            }
        }
        while (bl) {
            switch (this.scrollingStrategy) {
                case 5: {
                    if (!this.implStatement.supportsScrolling(1005)) break;
                    bl = false;
                    break;
                }
                case 3: {
                    if (!this.implStatement.supportsScrolling(1004)) break;
                    bl = false;
                    break;
                }
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            this.downgradeScrolling();
        }
    }

    protected boolean downgrade() {
        boolean bl = false;
        switch (this.concurrencyStrategy) {
            case 3: {
                this.concurrencyStrategy = 4;
                bl = true;
                break;
            }
            case 4: {
                this.concurrencyStrategy = 1;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Object[] downgradeAndRetryExecute(SQLException sQLException, int n2) throws SQLException {
        if (this.executeState != 2) {
            throw sQLException;
        }
        if (!this.downgrade()) {
            throw sQLException;
        }
        String string = this.implStatement.sql.getOriginal();
        Object[] objectArray = new Object[1];
        this.preProcessSQL(string);
        switch (n2) {
            case 0: {
                objectArray[0] = new Boolean(this.executeInternal());
                break;
            }
            case 1: {
                objectArray[0] = this.executeQueryInternal();
                break;
            }
        }
        return objectArray;
    }

    private void downgradeScrolling() {
        switch (this.scrollingStrategy) {
            case 5: {
                this.scrollingStrategy = 3;
                break;
            }
            case 4: {
                this.scrollingStrategy = 3;
                break;
            }
            case 3: {
                this.scrollingStrategy = 2;
                break;
            }
        }
    }

    private boolean emulatedDatabaseMetaDataResultSet() {
        return this.databaseMetaDataResultSetInfo != null;
    }

    public boolean execute(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.commonTransitionToState(1);
            this.preProcessSQL(string);
            boolean bl = this.executeInternal();
            Object var4_4 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block9: {
                int[] nArray2;
                block8: {
                    try {
                        this.validateClosedState();
                        this.commonTransitionToState(1);
                        if (this.batchSQL == null) {
                            nArray2 = new int[]{};
                            Object var6_4 = null;
                            break block8;
                        }
                        if (this.implStatement.supportsBatchStatements() && !this.overrideNativeBatchSupport()) {
                            this.implStatement.setSQL(this.batchSQL);
                            this.commonExecute();
                            nArray = this.implStatement.getBatchRowsAffectedCount();
                            break block9;
                        } else {
                            nArray = this.executeBatchEmulation();
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.clearBatch();
                        throw throwable;
                    }
                }
                this.clearBatch();
                return nArray2;
            }
            Object var6_5 = null;
            this.clearBatch();
            return nArray;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int[] executeBatchEmulation() throws SQLException {
        block9: {
            var1_1 = this.batchSQL.batchSize();
            var2_2 = new int[var1_1];
            var3_3 = 0;
            try {
                while (var3_3 < var1_1) {
                    this.batchSQL.nextBatchStatement();
                    this.implStatement.setSQL(this.batchSQL);
                    this.commonTransitionToState(1);
                    this.commonExecute();
                    switch (this.currentResultType) {
                        case 3: {
                            var2_2[var3_3] = this.implStatement.getNextRowsAffectedCount();
                            break;
                        }
                        case 0: {
                            var2_2[var3_3] = -2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            throw this.exceptions.getException(6054);
                        }
                    }
                    ++var3_3;
                }
                break block9;
            }
            catch (SQLException var4_4) {
                var5_5 = null;
                var5_5 = new int[var3_3];
                var6_6 = 0;
                ** while (var6_6 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                var5_5[var6_6] = var2_2[var6_6];
                ++var6_6;
                continue;
            }
lbl31:
            // 1 sources

            throw new BaseBatchUpdateException(var4_4, var5_5);
        }
        return var2_2;
    }

    protected boolean executeInternal() throws SQLException {
        this.clearBatch();
        try {
            this.commonExecute();
        }
        catch (SQLException sQLException) {
            this.preprocessExceptionFromCommonExecute(sQLException);
            Object[] objectArray = this.downgradeAndRetryExecute(sQLException, 0);
            return (Boolean)objectArray[0];
        }
        return this.currentResultType == 2;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.commonTransitionToState(1);
            this.preProcessSQL(string);
            ResultSet resultSet = this.executeQueryInternal();
            Object var4_4 = null;
            return resultSet;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ResultSet executeQueryInternal() throws SQLException {
        this.clearBatch();
        try {
            this.commonExecute();
            if (true) ** GOTO lbl13
        }
        catch (SQLException var1_1) {
            this.preprocessExceptionFromCommonExecute(var1_1);
            var2_2 = this.downgradeAndRetryExecute(var1_1, 1);
            return (ResultSet)var2_2[0];
        }
        do {
            this.warnings.add(6082);
            this.getNextResultType();
lbl13:
            // 2 sources

        } while (this.currentResultType == 3);
        switch (this.currentResultType) {
            case 1: {
                throw this.exceptions.getException(6013);
            }
            case 2: {
                this.currentResultSet = this.commonGetNextResultSet();
                break;
            }
        }
        if (this.currentResultSet != null) {
            if (this.databaseMetaDataResultSet != 0) {
                this.currentResultSet.databaseMetaDataResultSet = true;
            } else {
                this.exhaustResultsAtResultSetClose = true;
            }
        }
        return this.currentResultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.commonTransitionToState(1);
            this.preProcessSQL(string);
            int n2 = this.executeUpdateInternal();
            Object var4_4 = null;
            return n2;
        }
    }

    protected int executeUpdateInternal() throws SQLException {
        int n2 = -1;
        this.clearBatch();
        try {
            this.commonExecute();
        }
        catch (SQLException sQLException) {
            this.preprocessExceptionFromCommonExecute(sQLException);
            throw sQLException;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (this.currentResultType != 1) {
            if (this.currentResultType == 3) {
                if (bl) {
                    this.warnings.add(6082);
                } else {
                    bl = true;
                    n2 = this.commonGetUpdateCount();
                }
            } else {
                bl2 = true;
                this.warnings.add(6081);
            }
            this.getNextResultType();
        }
        if (!bl) {
            if (bl2) {
                throw this.exceptions.getException(6014);
            }
            n2 = this.commonGetUpdateCount();
        }
        if (n2 == -1) {
            n2 = 0;
        }
        return n2;
    }

    private final boolean expandSelectStar(BaseSQL baseSQL) throws SQLException {
        try {
            this.implStatement.setSQL(baseSQL);
            this.implStatement.prepare();
            BaseColumns baseColumns = this.implStatement.describeColumns(null);
            int n2 = baseColumns.count(1);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 1;
            while (n3 <= n2) {
                if (n3 != 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(baseColumns.get((int)n3).name);
                ++n3;
            }
            baseSQL.setSelectColumnSpecification(0, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.implConnection != null) {
                this.implConnection.removeReference();
            }
            if (this.queryTimeoutEnforcer != null) {
                this.queryTimeoutEnforcer.exit();
            }
        }
        catch (Throwable throwable) {}
    }

    public Connection getConnection() {
        return this.connection;
    }

    BaseImplResultSet getEmulatatedDatabaseMetaDataImplResultSet() throws SQLException {
        BaseImplResultSet baseImplResultSet = null;
        switch (this.databaseMetaDataResultSet) {
            case 3: {
                baseImplResultSet = new BaseTypeInfoImplResultSet((BaseTypeInfos)this.databaseMetaDataResultSetInfo);
                break;
            }
            case 4: {
                baseImplResultSet = new BaseTableTypesImplResultSet((BaseTableTypes)this.databaseMetaDataResultSetInfo);
                break;
            }
        }
        baseImplResultSet.setImplStatement(this.implStatement);
        return baseImplResultSet;
    }

    private final BaseEscapeTranslator getEscapeTranslator(String string) throws SQLException {
        if (this.escapeTranslator == null && string.indexOf(123) != -1) {
            this.escapeTranslator = this.connection.getEscapeTranslator();
            if (this.escapeTranslator != null) {
                this.escapeTranslator.setWarnings(this.warnings);
            }
            this.implStatement.setEscapeTranslator(this.escapeTranslator);
        }
        if (this.escapeTranslator != null) {
            this.escapeTranslator.setImplStatement(this.implStatement);
        }
        return this.escapeTranslator;
    }

    public int getFetchDirection() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.fetchDirection;
            Object var3_3 = null;
            return n2;
        }
    }

    public int getFetchSize() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.resultSetFetchSize;
            Object var3_3 = null;
            return n2;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.maxFieldSize;
            Object var3_3 = null;
            return n2;
        }
    }

    public int getMaxRows() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.maxRows;
            Object var3_3 = null;
            return n2;
        }
    }

    public boolean getMoreResults() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateInExecutedState();
            this.closeCurrentResults();
            boolean bl = this.getNextResultType();
            Object var3_3 = null;
            return bl;
        }
    }

    public BaseImplResultSet getNextImplResultSet() throws SQLException {
        BaseImplResultSet baseImplResultSet = null;
        baseImplResultSet = this.emulatedDatabaseMetaDataResultSet() ? this.getEmulatatedDatabaseMetaDataImplResultSet() : this.implStatement.getNextResultSet();
        if (baseImplResultSet != null) {
            baseImplResultSet.setImplStatement(this.implStatement);
        }
        return baseImplResultSet;
    }

    boolean getNextResultType() throws SQLException {
        boolean bl = false;
        this.currentResultType = this.implStatement.getNextResultType();
        switch (this.currentResultType) {
            case 1: {
                this.currentRowsAffectedCount = -1;
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int getQueryTimeout() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.queryTimeout;
            Object var3_3 = null;
            return n2;
        }
    }

    private final int getRequiredSQLProcessing(String string) throws SQLException {
        int n2;
        switch (this.concurrencyStrategy) {
            case 3: 
            case 4: {
                n2 = 4;
                break;
            }
            default: {
                n2 = this.implStatement.getRequiredSQLProcessing(string);
            }
        }
        if (n2 != 4) {
            switch (this.concurrencyStrategy) {
                case 4: {
                    n2 = 4;
                }
            }
        }
        return n2;
    }

    public ResultSet getResultSet() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateInExecutedState();
            if (this.currentResultSet == null) {
                this.currentResultSet = this.commonGetNextResultSet();
            }
            BaseResultSet baseResultSet = this.currentResultSet;
            Object var3_3 = null;
            return baseResultSet;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.resultSetConcurrency;
            Object var3_3 = null;
            return n2;
        }
    }

    public int getResultSetType() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n2 = this.resultSetScrollType;
            Object var3_3 = null;
            return n2;
        }
    }

    public int getUpdateCount() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateInExecutedState();
            switch (this.currentResultType) {
                case 1: 
                case 2: {
                    this.currentRowsAffectedCount = -1;
                    break;
                }
                case 3: {
                    if (this.currentRowsAffectedCount != -2) break;
                    this.currentRowsAffectedCount = this.commonGetUpdateCount();
                    break;
                }
            }
            int n2 = this.currentRowsAffectedCount;
            Object var3_3 = null;
            return n2;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            SQLWarning sQLWarning = this.warnings.get();
            Object var3_3 = null;
            return sQLWarning;
        }
    }

    protected boolean overrideNativeBatchSupport() {
        String string;
        boolean bl = false;
        if (!this.connection.getBatchIsJDBCCompliant() && (string = this.connection.connectProps.get("batchPerformanceWorkaround")) != null && string.equalsIgnoreCase("false")) {
            bl = true;
        }
        return bl;
    }

    void postImplExecute(boolean bl) throws SQLException {
        if (bl) {
            this.commonTransitionToState(3);
        }
        this.executeState = 1;
        if (this.queryTimeout != 0 && this.queryTimeoutEnforcer != null) {
            this.queryTimeoutEnforcer.resetTimeoutPeriod();
        }
    }

    void preImplExecute() throws SQLException {
        this.executeState = 2;
        if (this.queryTimeout != 0) {
            this.queryTimeoutEnforcer.startTimeoutPeriod(this, this.queryTimeout);
        }
    }

    protected final void preProcessSQL(String string) throws SQLException {
        this.commonValidateSQL(string);
        if (string != null) {
            this.firstUpdateKeyColumnIndex = -1;
            this.tableSpecification = null;
            this.determineConcurrencyStrategy();
            this.determineScrollingStrategy();
            BaseSQL baseSQL = new BaseSQL(string, this.getRequiredSQLProcessing(string), this.implConnection.quotingChar, this.getEscapeTranslator(string), this.exceptions);
            this.setupConcurrency(baseSQL);
            this.setupScrolling(baseSQL);
            this.implStatement.setSQL(baseSQL);
        }
    }

    private void preprocessExceptionFromCommonExecute(SQLException sQLException) throws SQLException {
        try {
            if (sQLException.getSQLState().equals("HYT00")) {
                throw sQLException;
            }
            if (sQLException.getSQLState().equals("HY008")) {
                if (this.timeoutEnforcerCanceledExecution) {
                    sQLException = this.connection.exceptions.getException(6083, "HYT00");
                }
                throw sQLException;
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postImplExecute(false);
            throw throwable;
        }
        this.postImplExecute(false);
    }

    protected void resultSetClosed(BaseResultSet baseResultSet) {
        block4: {
            if (baseResultSet == this.currentResultSet) {
                this.currentResultSet = null;
                this.currentColumns = null;
            } else {
                UtilDebug.assert("Bug in BaseStatement.resultSetClosed", baseResultSet.isClosed());
            }
            if (this.databaseMetaDataResultSet == 0) break block4;
            try {
                this.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void setCursorName(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String[] stringArray = new String[]{"Statement.setCursorName"};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
        }
    }

    public void setFetchDirection(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            switch (n2) {
                default: {
                    String[] stringArray = new String[]{"setFetchDirection"};
                    throw this.exceptions.getException(6003, stringArray);
                }
                case 1000: 
                case 1001: 
                case 1002: 
            }
            this.fetchDirection = n2;
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateNotNegativeParameter("Statement.setFetchSize", n2);
            this.implStatement.setFetchSize(n2);
            this.resultSetFetchSize = n2;
        }
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateNotNegativeParameter("Statement.setMaxFieldSize", n2);
            this.implStatement.setMaxFieldSize(n2);
            this.maxFieldSize = n2;
        }
    }

    public void setMaxRows(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateNotNegativeParameter("Statement.setMaxRows", n2);
            this.implStatement.setMaxRows(n2);
            this.maxRows = n2;
        }
    }

    public void setQueryTimeout(int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            if (!this.implConnection.enableCancelBasedQueryTimeout()) {
                String[] stringArray = new String[]{"Statement.setQueryTimeout"};
                throw this.connection.exceptions.getException(6004, stringArray);
            }
            this.validateNotNegativeParameter("Statement.setQueryTimeout", n2);
            this.queryTimeout = n2;
            if (this.queryTimeoutEnforcer == null) {
                this.queryTimeoutEnforcer = new BaseQueryTimeoutEnforcer();
            }
        }
    }

    private final void setupConcurrency(BaseSQL baseSQL) throws SQLException {
        if (this.concurrencyStrategy == 3 || this.concurrencyStrategy == 4) {
            this.tableSpecification = baseSQL.getSingleTableFromSpecification();
            if (this.tableSpecification == null || baseSQL.hasGroupBy() || baseSQL.hasHaving() || baseSQL.hasSetOperation()) {
                this.concurrencyStrategy = 1;
            } else if (this.concurrencyStrategy == 3) {
                this.addRowIdToSelectList(baseSQL);
            } else if (this.concurrencyStrategy == 4) {
                this.addStarToSelectList(baseSQL);
            }
        }
    }

    protected void setupForDatabaseMetaData(BaseColumns baseColumns, int n2, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor, Object object) {
        this.currentColumns = baseColumns;
        this.databaseMetaDataResultSet = n2;
        this.filterDescriptor = baseResultSetFilterDescriptor;
        this.sortDescriptor = baseResultSetSortDescriptor;
        this.databaseMetaDataResultSetInfo = object;
        this.implStatement.setupDatabaseMetaDataResultSet(n2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
    }

    private final void setupImplConnection() throws SQLException {
        this.implConnection = this.connection.getImplConnection(this.emulatedDatabaseMetaDataResultSet() ^ true);
    }

    private final void setupImplStatement() throws SQLException {
        this.implStatement = this.implConnection.createImplStatement(this.resultSetScrollType, this.resultSetConcurrency);
        this.implStatement.setup(this.implConnection, this.warnings);
        this.implStatement.setFetchSize(this.resultSetFetchSize);
        this.implStatement.setMaxFieldSize(this.maxFieldSize);
        this.implStatement.setMaxRows(this.maxRows);
    }

    private final void setupScrolling(BaseSQL baseSQL) throws SQLException {
        if (this.scrollingStrategy == 4) {
            this.tableSpecification = baseSQL.getSingleTableFromSpecification();
            if (this.tableSpecification == null || !this.addRowIdToSelectList(baseSQL)) {
                this.downgradeScrolling();
                this.determineScrollingStrategy();
                this.setupScrolling(baseSQL);
            }
        }
    }

    void validateClosedState() throws SQLException {
        this.connection.validateClosedState();
        if (this.state == 4) {
            throw this.exceptions.getException(6010);
        }
    }

    void validateInExecutedState() throws SQLException {
        if (this.state != 3) {
            throw this.exceptions.getException(6015);
        }
    }

    void validateNotNegativeParameter(String string, int n2) throws SQLException {
        if (n2 < 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6003, stringArray);
        }
    }
}

