/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BasePreparedStatement;
import com.microsoft.jdbc.base.BaseResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class BaseResultSetMetaData
implements ResultSetMetaData {
    private static String footprint = "$Revision:   1.6.1.0  $";
    protected Object associate;
    protected BaseColumns columns;
    BaseExceptions exceptions;

    protected BaseResultSetMetaData(Object object, BaseExceptions baseExceptions) {
        this.associate = object;
        this.exceptions = baseExceptions;
        this.setupColumns();
    }

    public String getCatalogName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).catalogName;
    }

    public String getColumnClassName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return BaseData.mapJDBCTypeToJavaObjectTypeName(this.columns.get((int)n2).type);
    }

    public int getColumnCount() throws SQLException {
        this.validateClosedState();
        return this.columns.count(1);
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).displaySize;
    }

    public String getColumnLabel(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).label;
    }

    public String getColumnName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).name;
    }

    public int getColumnType(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).type;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).typeName;
    }

    public int getPrecision(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).precision;
    }

    public int getScale(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).scale;
    }

    public String getSchemaName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).schemaName;
    }

    public String getTableName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).tableName;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isAutoIncrement;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isCaseSensitive;
    }

    public boolean isCurrency(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isCurrency;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isDefinitelyWritable;
    }

    public int isNullable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isNullable;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isReadOnly;
    }

    public boolean isSearchable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isSearchable;
    }

    public boolean isSigned(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isSigned;
    }

    public boolean isWritable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isWritable;
    }

    private void setupColumns() {
        this.columns = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).columns : ((BasePreparedStatement)this.associate).currentColumns;
    }

    private void validateClosedState() throws SQLException {
        if (this.associate instanceof BaseResultSet) {
            ((BaseResultSet)this.associate).validateClosedState();
        } else {
            ((BasePreparedStatement)this.associate).validateClosedState();
        }
    }

    private void validateColumnIndex(int n2) throws SQLException {
        if (!this.columns.isValidColumnOrdinal(n2)) {
            Integer n3 = new Integer(n2);
            String[] stringArray = new String[]{n3.toString()};
            throw this.exceptions.getException(6007, stringArray);
        }
    }
}

