/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

public final class BaseResultSetFilterDescriptor {
    private static String footprint = "$Revision:   1.8.1.0  $";
    private int[] filterColumns;
    private Object[] filterValues;
    private boolean[] patterns;

    public BaseResultSetFilterDescriptor(int[] nArray, Object[] objectArray, boolean[] blArray) {
        this.filterColumns = nArray;
        this.filterValues = objectArray;
        this.patterns = blArray;
        this.stripDoubleQuotesFromValues();
    }

    public boolean allRestrictionsSatified() {
        int n2 = this.getRestrictionCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.filterValues[n3] != null) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private int getIndex(int n2) {
        int n3 = this.getRestrictionCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.filterColumns[n4] == n2) {
                return n4;
            }
            ++n4;
        }
        return 0;
    }

    public Object getRestriction(int n2) {
        int n3 = this.getRestrictionCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.filterColumns[n4] == n2) {
                return this.filterValues[n4];
            }
            ++n4;
        }
        return null;
    }

    public Object getRestrictionByIndex(int n2) {
        return this.filterValues[n2];
    }

    public int getRestrictionColumnByIndex(int n2) {
        return this.filterColumns[n2];
    }

    public int getRestrictionCount() {
        int n2 = 0;
        if (this.filterColumns != null) {
            n2 = this.filterColumns.length;
        }
        return n2;
    }

    public boolean isPattern(int n2) {
        return this.patterns[this.getIndex(n2)];
    }

    public boolean isPatternByIndex(int n2) {
        return this.patterns[n2];
    }

    public void removeAllRestrictions() {
        int n2 = this.getRestrictionCount();
        int n3 = 0;
        while (n3 < n2) {
            this.filterValues[n3] = null;
            ++n3;
        }
    }

    public void removeRestriction(int n2) {
        this.filterValues[this.getIndex((int)n2)] = null;
    }

    public void setPattern(int n2, boolean bl) {
        this.patterns[this.getIndex((int)n2)] = bl;
    }

    private void stripDoubleQuotesFromValues() {
        int n2 = this.filterValues.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = this.filterValues[n3];
            if (object instanceof String && object != null && ((String)object).length() > 0) {
                String string = (String)object;
                int n4 = string.length() - 1;
                if (string.charAt(0) == '\"' && string.charAt(n4) == '\"' && n4 > 0) {
                    string = string.substring(1, n4);
                    this.filterValues[n3] = string;
                }
            }
            ++n3;
        }
    }
}

